/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.editor.PerformRoutineFromFileActionBase;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.run.actions.ExecuteRoutineActionBase;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebugRoutineAction
extends PerformRoutineFromFileActionBase {
    private static final Icon debugProcedureIcon = new LayeredIcon(new Icon[]{DatabaseIcons.Procedure, DatabaseIcons.GreenBugOverlap});
    private static final Icon debugFunctionIcon = new LayeredIcon(new Icon[]{DatabaseIcons.Function, DatabaseIcons.GreenBugOverlap});

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DebugRoutineAction.$$$reportNull$$$0(0);
        }
        Presentation p2 = e.getPresentation();
        if (!e.getPlace().startsWith("Editor")) {
            p2.setEnabledAndVisible(false);
            return;
        }
        ExecuteRoutineActionBase.ActionData actionData = this.getActionData(e);
        SqlDebugSessionRunner.SqlDebugAvailability availability = DebugRoutineAction.checkAvailability(actionData);
        p2.setVisible(availability.visible);
        p2.setEnabled(availability.enabled);
        if (availability.visible) {
            BasicRoutine routine = actionData.routine;
            this.updateActionText(p2, "Debug Routine...", routine);
            p2.setIcon(this.getIcon(e, routine));
        }
    }

    @Override
    @NotNull
    protected ExecuteRoutineActionBase.ActionData getActionData(@NotNull AnActionEvent e) {
        DbRoutine routine;
        BasicRoutine basic;
        if (e == null) {
            DebugRoutineAction.$$$reportNull$$$0(1);
        }
        ExecuteRoutineActionBase.ActionData actionData = (basic = (BasicRoutine)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)(routine = DebugRoutineAction.getDbRoutine(e))), BasicRoutine.class)) != null ? new ExecuteRoutineActionBase.MyData(routine.getDataSource(), basic) : super.getActionData(e);
        if (actionData == null) {
            DebugRoutineAction.$$$reportNull$$$0(2);
        }
        return actionData;
    }

    private static SqlDebugSessionRunner.SqlDebugAvailability checkAvailability(@NotNull ExecuteRoutineActionBase.ActionData actionData) {
        if (actionData == null) {
            DebugRoutineAction.$$$reportNull$$$0(3);
        }
        return SqlDebugSessionRunner.checkDebuggerAvailability((DasDataSource)actionData.dataSource, actionData.routine);
    }

    @Override
    protected Icon getIcon(@NotNull AnActionEvent e, @Nullable BasicRoutine routine) {
        if (e == null) {
            DebugRoutineAction.$$$reportNull$$$0(4);
        }
        if (e.getPlace().endsWith("Toolbar")) {
            DasRoutine.Kind routineKind;
            DasRoutine.Kind kind = routineKind = routine != null ? routine.getRoutineKind() : null;
            if (routineKind == DasRoutine.Kind.PROCEDURE) {
                return debugProcedureIcon;
            }
            if (routineKind == DasRoutine.Kind.FUNCTION) {
                return debugFunctionIcon;
            }
            return DatabaseIcons.GreenBugOverlap;
        }
        return AllIcons.Actions.StartDebugger;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DebugRoutineAction.$$$reportNull$$$0(5);
        }
        if (!e.getPlace().startsWith("Editor")) {
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    @NotNull
    protected ExecuteRoutineActionBase.RequestRunner getExecutor(@NotNull DataRequest.OwnerEx owner, @NotNull ExecuteRoutineActionBase.ActionData actionData) {
        if (owner == null) {
            DebugRoutineAction.$$$reportNull$$$0(6);
        }
        if (actionData == null) {
            DebugRoutineAction.$$$reportNull$$$0(7);
        }
        assert (owner instanceof JdbcConsole) : "Expected the owner is a Console but it's " + owner.getClass().getName();
        JdbcConsole console = (JdbcConsole)owner;
        return new RequestDebugRunner(console, actionData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DebugRoutineAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DebugRoutineAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getActionData";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailability";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestDebugRunner
    implements ExecuteRoutineActionBase.RequestRunner {
        @NotNull
        private final JdbcConsole console;
        @NotNull
        private final ExecuteRoutineActionBase.ActionData actionData;

        private RequestDebugRunner(@NotNull JdbcConsole console, @NotNull ExecuteRoutineActionBase.ActionData actionData) {
            if (console == null) {
                RequestDebugRunner.$$$reportNull$$$0(0);
            }
            if (actionData == null) {
                RequestDebugRunner.$$$reportNull$$$0(1);
            }
            this.console = console;
            this.actionData = actionData;
        }

        @Override
        public void runRequest(@NotNull DataRequest request) {
            if (request == null) {
                RequestDebugRunner.$$$reportNull$$$0(2);
            }
            DbDataSource dbDataSource = this.actionData.dataSource;
            assert (dbDataSource != null);
            Project project = dbDataSource.getProject();
            LocalDataSource dataSource2 = (LocalDataSource)dbDataSource.getDelegate();
            BasicRoutine routine = this.actionData.routine;
            assert (routine != null) : "Cannot debug a routine when this routine doesn't exist";
            String title = "Debug routine " + routine.getName();
            assert (request instanceof DataRequest.CallRequest) : "The request must be an instance of CallRequest but it's " + ((Object)((Object)request)).getClass().getName();
            DataRequest.CallRequest callRequest = (DataRequest.CallRequest)request;
            List<DataRequest.CallRequest.Statement> requestQueries = callRequest.queries;
            assert (requestQueries.size() == 1) : "We can debug exactly one statement but here is " + requestQueries.size();
            String statementText = requestQueries.get((int)0).statement;
            LightVirtualFile virtualFile = new LightVirtualFile(title, (CharSequence)statementText);
            virtualFile.setLanguage((Language)DbSqlUtil.getSqlDialect(dataSource2));
            SqlDebugSessionRunner.startDebugProcess(this.console, this.console.getSession(), false, (VirtualFile)virtualFile, null, request.path, title, model -> DataRequest.newCallRequest(this.console, callRequest.queries, request.path));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/DebugRoutineAction$RequestDebugRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "runRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

