/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DataBus;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.session.LogView;
import com.intellij.database.script.ScriptModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractQueryLanguageConsole<T>
extends UserDataHolderBase
implements DataProvider,
Disposable.Parent,
DataRequest.Owner {
    protected static final Logger LOG = Logger.getInstance(AbstractQueryLanguageConsole.class);
    private final Project myProject;
    private final DataBus.Consuming myMessageBus;
    private final T myTarget;
    private boolean myDisposed;

    public AbstractQueryLanguageConsole(@NotNull Project project, @NotNull T target, @NotNull DataBus.Consuming messageBus) {
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(1);
        }
        if (messageBus == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myTarget = target;
        this.myMessageBus = messageBus.filterFor(this);
        Disposer.register((Disposable)this.getProject(), (Disposable)this);
    }

    @NotNull
    public T getTarget() {
        T t = this.myTarget;
        if (t == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(3);
        }
        return t;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = "console: " + this.getTitle();
        if (string == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public DataBus.Consuming getMessageBus() {
        DataBus.Consuming consuming = this.myMessageBus;
        if (consuming == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(5);
        }
        return consuming;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.isViewValid();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    public abstract String getTitle();

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            AbstractQueryLanguageConsole.$$$reportNull$$$0(7);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.getHelpID();
        }
        return null;
    }

    public void beforeTreeDispose() {
        this.myDisposed = true;
    }

    public void dispose() {
    }

    protected boolean isViewValid() {
        return this.getView().isValid();
    }

    protected final boolean isDisposed() {
        return this.myDisposed;
    }

    public abstract boolean beforeExecuteQueries(@NotNull ScriptModel<?> var1);

    public abstract boolean isIdle();

    @Nullable
    protected abstract String getHelpID();

    @NotNull
    public abstract LogView getView();

    @NotNull
    public abstract ScriptModel<?> getScriptModel();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/AbstractQueryLanguageConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

