/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.ListMultiRef;
import com.intellij.database.util.DasUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicMixinForeignKey
extends DasForeignKey {
    default public boolean isReferencingAnotherSchema() {
        BasicForeignKey self = (BasicForeignKey)this;
        @Nullable BasicMajorObject majorObject = self.getMajorObject();
        if (majorObject == null) {
            return false;
        }
        BasicSchema mySchema = majorObject.getSchema();
        if (mySchema == null) {
            return false;
        }
        String refSchemaName = self.getRefSchemaName();
        if (refSchemaName == null) {
            return false;
        }
        return !refSchemaName.equals(mySchema.getName());
    }

    @Nullable
    default public BasicSchema getRefSchema() {
        BasicForeignKey self = (BasicForeignKey)this;
        @Nullable BasicMajorObject majorObject = self.getMajorObject();
        if (majorObject == null) {
            return null;
        }
        BasicSchema mySchema = majorObject.getSchema();
        String refSchemaName = self.getRefSchemaName();
        if (refSchemaName == null) {
            return mySchema;
        }
        return mySchema != null ? mySchema.getSibling(refSchemaName) : null;
    }

    @Nullable
    default public BasicTableOrView getRefTable() {
        BasicForeignKey self = (BasicForeignKey)this;
        String refTableName = self.getRefTableName();
        if (refTableName == null) {
            return null;
        }
        BasicSchema refSchema = this.getRefSchema();
        return refSchema != null ? refSchema.getTableOrView(refTableName) : null;
    }

    @Nullable
    default public BasicKey getRefKey() {
        BasicForeignKey self = (BasicForeignKey)this;
        BasicTableOrView refTable = this.getRefTable();
        if (refTable == null) {
            return null;
        }
        String refKeyName = self.getRefKeyName();
        if (refKeyName != null && refKeyName.length() > 0) {
            return BasicMixinElement.findChild((BasicElement)refTable, ObjectKind.KEY, refKeyName, BasicKey.class);
        }
        List<String> refColNames = self.getRefColNames();
        int n = refColNames.size();
        if (n > 0) {
            for (BasicKey basicKey : refTable.getKeys()) {
                List keyColNames = basicKey.getColNames();
                if (!keyColNames.equals(refColNames)) continue;
                return basicKey;
            }
            return null;
        }
        return refTable.getPrimaryKey();
    }

    @NotNull
    default public List<? extends BasicLikeColumn> getRefCols() {
        BasicForeignKey self = (BasicForeignKey)this;
        List<String> refColNames = self.getRefColNames();
        if (refColNames.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicMixinForeignKey.$$$reportNull$$$0(0);
            }
            return list;
        }
        BasicTableOrView refTable = this.getRefTable();
        if (refTable == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicMixinForeignKey.$$$reportNull$$$0(1);
            }
            return list;
        }
        Family<@NotNull ? extends BasicElement> columns = refTable.familyOf(ObjectKind.COLUMN);
        if (columns == null) {
            List list = Collections.emptyList();
            if (list == null) {
                BasicMixinForeignKey.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (!1.$assertionsDisabled && !(columns instanceof NamingFamily)) {
            throw new AssertionError();
        }
        List list = ((NamingFamily)columns).get(refColNames);
        if (list == null) {
            BasicMixinForeignKey.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    default public MultiRef<? extends BasicLikeColumn> getRefColumns() {
        return new ListMultiRef<BasicLikeColumn>(this.getRefCols());
    }

    @Deprecated
    default public String getRefTableSchema() {
        return ((BasicForeignKey)this).getRefSchemaName();
    }

    @Deprecated
    default public String getRefTableCatalog() {
        BasicTableOrView refTable = this.getRefTable();
        return DasUtil.getCatalog((DasObject)refTable);
    }

    @Deprecated
    default public DasForeignKey.RuleAction getUpdateRule() {
        return BasicMixinForeignKey.getAction(((BasicForeignKey)this).getOnUpdate());
    }

    @Deprecated
    default public DasForeignKey.RuleAction getDeleteRule() {
        return BasicMixinForeignKey.getAction(((BasicForeignKey)this).getOnDelete());
    }

    @NotNull
    public static DasForeignKey.RuleAction getAction(CascadeRule update2) {
        switch (update2) {
            case restrict: {
                DasForeignKey.RuleAction ruleAction = DasForeignKey.RuleAction.RESTRICT;
                if (ruleAction == null) {
                    BasicMixinForeignKey.$$$reportNull$$$0(4);
                }
                return ruleAction;
            }
            case set_null: {
                DasForeignKey.RuleAction ruleAction = DasForeignKey.RuleAction.SET_NULL;
                if (ruleAction == null) {
                    BasicMixinForeignKey.$$$reportNull$$$0(5);
                }
                return ruleAction;
            }
            case set_default: {
                DasForeignKey.RuleAction ruleAction = DasForeignKey.RuleAction.SET_DEFAULT;
                if (ruleAction == null) {
                    BasicMixinForeignKey.$$$reportNull$$$0(6);
                }
                return ruleAction;
            }
            case cascade: {
                DasForeignKey.RuleAction ruleAction = DasForeignKey.RuleAction.CASCADE;
                if (ruleAction == null) {
                    BasicMixinForeignKey.$$$reportNull$$$0(7);
                }
                return ruleAction;
            }
        }
        DasForeignKey.RuleAction ruleAction = DasForeignKey.RuleAction.NO_ACTION;
        if (ruleAction == null) {
            BasicMixinForeignKey.$$$reportNull$$$0(8);
        }
        return ruleAction;
    }

    @Deprecated
    default public DasForeignKey.Deferrability getDeferrability() {
        BasicForeignKey self = (BasicForeignKey)this;
        return self.isDeferrable() ? (self.isInitiallyDeferred() ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE) : DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/model/basic/BasicMixinForeignKey";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefCols";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAction";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

