/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.fulltextsearch;

import com.intellij.database.Dbms;
import com.intellij.database.actions.FullTextSearchAction;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.fulltextsearch.FtsUtilKt;
import com.intellij.database.fulltextsearch.FullTextSearchOptions;
import com.intellij.database.fulltextsearch.SearchableTargetsSearchResult;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001aH\u0010\u0000\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aH\u0010\u000e\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001aF\u0010\u000f\u001a$\u0012 \u0012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002j\u0002`\u00070\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r\u001a$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r*:\u0010\u0019\"\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00022\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002\u00a8\u0006\u001a"}, d2={"byColumn", "Lkotlin/sequences/Sequence;", "Lkotlin/Triple;", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "Lcom/intellij/database/model/basic/BasicTableOrView;", "Lcom/intellij/database/psi/DbElement;", "Lcom/intellij/database/fulltextsearch/FtsElement;", "tables", "", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "options", "Lcom/intellij/database/fulltextsearch/FullTextSearchOptions;", "byTable", "chooseElementsIterator", "getQueryForFirstNElements", "", "element", "maxElementsCount", "", "tryFindSearchableTargets", "Lcom/intellij/database/fulltextsearch/SearchableTargetsSearchResult;", "targets", "perTargetCheckAtMost", "FtsElement", "intellij.database.impl"})
public final class FtsUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getQueryForFirstNElements(@NotNull DbElement element2, int maxElementsCount, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        DbDataSource dbDataSource = element2.getDataSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"element.dataSource");
        DbDataSource dataSource2 = dbDataSource;
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(dataSource2.getDbms());
        Intrinsics.checkExpressionValueIsNotNull((Object)databaseDialectEx, (String)"DbImplUtil.getDatabaseDialect(dataSource.dbms)");
        DatabaseDialectEx dialect = databaseDialectEx;
        DdlBuilder ddlBuilder = new DdlBuilder().withDialect(dialect).qualifyReferences(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"DdlBuilder().withDialect\u2026).qualifyReferences(true)");
        DdlBuilder builder = ddlBuilder;
        int count2 = 0;
        List<FullTextSearchAction.SearchGroup> groups = new FullTextSearchAction.TableGrouper(CollectionsKt.listOf((Object)element2)).getGroups();
        for (FullTextSearchAction.SearchGroup searchGroup : groups) {
            Set<BasicTableOrView> tables = searchGroup.component1();
            for (Triple triple : FtsUtilKt.chooseElementsIterator((Collection<? extends BasicTableOrView>)tables, dataSource2, options)) {
                void predicates;
                List list = (List)triple.component1();
                BasicTableOrView table = (BasicTableOrView)triple.component2();
                if (predicates.isEmpty()) continue;
                FullTextSearchAction.Companion.searchStatement(builder, table, dataSource2, options, dialect, (List<PredicatesHelper.PredicateProducer>)predicates, true);
                builder.newStatement().newLine();
                if (++count2 < maxElementsCount) continue;
                String comment = "-- first " + maxElementsCount + " queries are shown";
                return comment + "\n\n" + builder.getStatement() + '\n' + comment;
            }
        }
        String string = builder.getStatement();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.statement");
        return string;
    }

    @NotNull
    public static final SearchableTargetsSearchResult tryFindSearchableTargets(@NotNull Collection<? extends DbElement> targets2, int perTargetCheckAtMost, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkParameterIsNotNull(targets2, (String)"targets");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        boolean someTablesAreSkipped = false;
        block0: for (DbElement dbElement : targets2) {
            int count2 = 0;
            List<FullTextSearchAction.SearchGroup> groups = new FullTextSearchAction.TableGrouper(CollectionsKt.listOf((Object)dbElement)).getGroups();
            for (FullTextSearchAction.SearchGroup searchGroup : groups) {
                Set<BasicTableOrView> tables = searchGroup.component1();
                Collection collection = tables;
                DbDataSource dbDataSource = dbElement.getDataSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbDataSource, (String)"target.dataSource");
                Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> it2 = FtsUtilKt.chooseElementsIterator(collection, dbDataSource, options);
                for (Triple triple : it2) {
                    List predicates = (List)triple.component1();
                    Collection collection2 = predicates;
                    boolean bl = false;
                    if (!collection2.isEmpty()) {
                        return SearchableTargetsSearchResult.FOUND;
                    }
                    if (++count2 < perTargetCheckAtMost) continue;
                    someTablesAreSkipped = true;
                    continue block0;
                }
            }
        }
        return someTablesAreSkipped ? SearchableTargetsSearchResult.UNKNOWN : SearchableTargetsSearchResult.NOT_FOUND;
    }

    @NotNull
    public static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> chooseElementsIterator(@NotNull Collection<? extends BasicTableOrView> tables, @NotNull DbDataSource dataSource2, @NotNull FullTextSearchOptions options) {
        Intrinsics.checkParameterIsNotNull(tables, (String)"tables");
        Intrinsics.checkParameterIsNotNull((Object)dataSource2, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Dbms dbms = dataSource2.getDbms();
        return Intrinsics.areEqual((Object)dbms, (Object)Dbms.CASSANDRA) ? FtsUtilKt.byColumn(tables, dataSource2, options) : FtsUtilKt.byTable(tables, dataSource2, options);
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byTable(Collection<? extends BasicTableOrView> tables, DbDataSource dataSource2, FullTextSearchOptions options) {
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)tables), (Function1)((Function1)new Function1<BasicTableOrView, Triple<? extends List<PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbTableImpl>>(dataSource2, options){
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ FullTextSearchOptions $options;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbTableImpl> invoke(@NotNull BasicTableOrView table) {
                void $this$flatMapTo$iv;
                Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                Dbms dbms = this.$dataSource.getDbms();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dataSource.dbms");
                Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> predicates = FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, this.$dataSource.getVersion(), table, this.$options);
                DbElement dbElement = DbImplUtil.findElement(this.$dataSource, table);
                if (!(dbElement instanceof DbTableImpl)) {
                    dbElement = null;
                }
                DbTableImpl dbTableImpl = (DbTableImpl)dbElement;
                if (dbTableImpl == null) {
                    return null;
                }
                DbTableImpl dbElement2 = dbTableImpl;
                Map<ColumnRef, List<PredicatesHelper.PredicateProducer>> map2 = predicates;
                boolean bl = false;
                Collection destination$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                void var8_8 = $this$flatMapTo$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<K, V>> iterator = var8_8.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> it2 = element$iv = iterator.next();
                    boolean bl3 = false;
                    Iterable list$iv = (List)it2.getValue();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                List uniquePredicates = (List)destination$iv;
                ContainerUtil.removeDuplicates((Collection)uniquePredicates);
                return new Triple((Object)uniquePredicates, (Object)table, (Object)((Object)dbElement2));
            }
            {
                this.$dataSource = dbDataSource;
                this.$options = fullTextSearchOptions;
                super(1);
            }
        }));
    }

    private static final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbElement>> byColumn(Collection<? extends BasicTableOrView> tables, DbDataSource dataSource2, FullTextSearchOptions options) {
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)tables), (Function1)((Function1)new Function1<BasicTableOrView, Sequence<? extends Triple<? extends List<? extends PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbColumn>>>(dataSource2, options){
            final /* synthetic */ DbDataSource $dataSource;
            final /* synthetic */ FullTextSearchOptions $options;

            @NotNull
            public final Sequence<Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbColumn>> invoke(@NotNull BasicTableOrView table) {
                Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                Dbms dbms = this.$dataSource.getDbms();
                Intrinsics.checkExpressionValueIsNotNull((Object)dbms, (String)"dataSource.dbms");
                return SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(FullTextSearchAction.Companion.getPredicates$intellij_database_impl(dbms, this.$dataSource.getVersion(), table, this.$options)), (Function1)((Function1)new Function1<Map.Entry<? extends ColumnRef, ? extends List<? extends PredicatesHelper.PredicateProducer>>, Triple<? extends List<? extends PredicatesHelper.PredicateProducer>, ? extends BasicTableOrView, ? extends DbColumn>>(this, table){
                    final /* synthetic */ byColumn.1 this$0;
                    final /* synthetic */ BasicTableOrView $table;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Triple<List<PredicatesHelper.PredicateProducer>, BasicTableOrView, DbColumn> invoke(@NotNull Map.Entry<? extends ColumnRef, ? extends List<PredicatesHelper.PredicateProducer>> $dstr$column$predicates) {
                        void column;
                        Intrinsics.checkParameterIsNotNull($dstr$column$predicates, (String)"<name for destructuring parameter 0>");
                        Object object = $dstr$column$predicates;
                        boolean bl = false;
                        ColumnRef columnRef = object.getKey();
                        object = $dstr$column$predicates;
                        bl = false;
                        List<PredicatesHelper.PredicateProducer> predicates = object.getValue();
                        Object v0 = column;
                        if (!(v0 instanceof DasColumnRef)) {
                            v0 = null;
                        }
                        DasColumnRef dasColumnRef = v0;
                        DasColumnRef dasColumnRef2 = dasColumnRef;
                        if (dasColumnRef == null) return null;
                        object = dasColumnRef2;
                        bl = false;
                        boolean bl2 = false;
                        Object it2 = object;
                        boolean bl3 = false;
                        DbElement dbElement = DbImplUtil.findElement(this.this$0.$dataSource, (DasObject)((DasColumnRef)column).getCol());
                        if (!(dbElement instanceof DbColumn)) {
                            dbElement = null;
                        }
                        DbColumn dbColumn = (DbColumn)dbElement;
                        dasColumnRef2 = dbColumn;
                        if (dbColumn == null) return null;
                        object = dasColumnRef2;
                        bl = false;
                        bl2 = false;
                        it2 = object;
                        boolean bl4 = false;
                        Triple triple = new Triple(predicates, (Object)this.$table, it2);
                        return triple;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$table = basicTableOrView;
                        super(1);
                    }
                }));
            }
            {
                this.$dataSource = dbDataSource;
                this.$options = fullTextSearchOptions;
                super(1);
            }
        }));
    }
}

