/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.extractors.tz.TimeZonedTimestamp;
import com.intellij.database.extractors.tz.TimeZonedValue;
import com.intellij.database.model.DataType;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.helpers.CassJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.remote.jdbc.impl.BitString;
import com.intellij.database.remote.jdbc.impl.ZonedValue;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.containers.ContainerUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectFormatter {
    private static final Logger LOG = Logger.getInstance(ObjectFormatter.class);
    private static final int MIN_IMAGE_BYTES = 100;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final int H2_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final int H2_DEFAULT_PRECISION = 65535;
    private static final Pattern PG_HSTORE_REQUIRES_QUOTATION = Pattern.compile("\\s|,|=|>");
    private final Map<FormatterKey, Formatter> myFormatCache = ContainerUtil.newConcurrentMap((int)10, (float)0.75f, (int)Runtime.getRuntime().availableProcessors());
    private Formatter myDateFormat;
    private Formatter myTimeFormat;
    private Formatter myShortZonedTimeFormat;
    private Formatter myShortZonedTimestampFormat;
    private NumberFormatter myNumberFormat;
    private NumberFormatter myBigIntFormat;
    private static final MyMap<Object> ourToObject = new MyMap();
    private final MyMap<String> myToString = new MyMap();

    public ObjectFormatter() {
        this.myToString.register(String.class, new Converter<String, String>(){

            @Override
            public String convert(String o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return o;
            }
        });
        this.myToString.register(Object[].class, new Converter<Object[], String>(){

            @Override
            public String convert(Object[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(o, column, dbms, forDisplay);
            }
        });
        this.myToString.register(long[].class, new Converter<long[], String>(){

            @Override
            public String convert(long[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column, dbms, forDisplay);
            }
        });
        this.myToString.register(int[].class, new Converter<int[], String>(){

            @Override
            public String convert(int[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column, dbms, forDisplay);
            }
        });
        this.myToString.register(double[].class, new Converter<double[], String>(){

            @Override
            public String convert(double[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.arrayToString(Arrays.stream(o).boxed().toArray(), column, dbms, forDisplay);
            }
        });
        this.myToString.register(byte[].class, new Converter<byte[], String>(){

            @Override
            public String convert(byte[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (forDisplay && ObjectFormatter.isOracleGUID(o, column, dbms)) {
                    return DialectUtils.toHexString(o);
                }
                return ObjectFormatter.this.bytesToStringImpl(o, o.length, dbms, forDisplay);
            }
        });
        this.myToString.register(BitString.class, new Converter<BitString, String>(){

            @Override
            public String convert(BitString o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column);
            }
        });
        this.myToString.register(char[].class, new Converter<char[], String>(){

            @Override
            public String convert(char[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                String text2 = new String(o);
                return ObjectFormatter.charToStringImpl(text2, text2.length(), forDisplay);
            }
        });
        this.myToString.register(Clob.class, new Converter<Clob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Clob o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.charToStringImpl(trimmed > 0 ? o.getSubString(1L, trimmed) : "", length, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Clob)o);
                }
            }
        });
        this.myToString.register(LobInfo.ClobInfo.class, new Converter<LobInfo.ClobInfo, String>(){

            @Override
            public String convert(LobInfo.ClobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dbms, o.length);
                }
                return ObjectFormatter.charToStringImpl(o.data, o.length, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileClobInfo.class, new Converter<LobInfo.FileClobInfo, String>(){

            @Override
            public String convert(LobInfo.FileClobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Blob.class, new Converter<Blob, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String convert(Blob o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                try {
                    long length = o.length();
                    int trimmed = ObjectFormatter.trimToMax(length);
                    String string = ObjectFormatter.this.bytesToStringImpl(o.getBytes(1L, trimmed), length, dbms, forDisplay);
                    return string;
                }
                catch (Exception e) {
                    String string = e.toString();
                    return string;
                }
                finally {
                    LobInfo.freeLob((Blob)o);
                }
            }
        });
        this.myToString.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, String>(){

            @Override
            public String convert(LobInfo.BlobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated() && o.data == null) {
                    return ObjectFormatter.getValueNotLoadedString(column, dbms, o.length);
                }
                return ObjectFormatter.this.bytesToStringImpl(o.data, o.length, dbms, forDisplay);
            }
        });
        this.myToString.register(LobInfo.FileBlobInfo.class, new Converter<LobInfo.FileBlobInfo, String>(){

            @Override
            public String convert(LobInfo.FileBlobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return CharOut.Util.newSink().append(ExtractorsUtil.getPresentableSize(o.length)).append(" [").append(o.file.getPath()).append("]").toString();
            }
        });
        this.myToString.register(Timestamp.class, new Converter<Timestamp, String>(){

            @Override
            public String convert(Timestamp o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getTimestampFormat(column, dbms), o, dbms, column);
            }
        });
        this.myToString.register(Time.class, new Converter<Time, String>(){

            @Override
            public String convert(Time o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getTimeFormat().format(o);
            }
        });
        this.myToString.register(Date.class, new Converter<Date, String>(){

            @Override
            public String convert(Date o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                Formatter format = column == null || column.clazz == null ? ObjectFormatter.this.getDateFormat(column, dbms) : (column.clazz.endsWith("Timestamp") ? ObjectFormatter.this.getTimestampFormat(column, dbms) : (column.clazz.endsWith("Time") ? ObjectFormatter.this.getTimeFormat() : ObjectFormatter.this.getDateFormat(column, dbms)));
                return ObjectFormatter.dateToString(format, o, dbms, column);
            }
        });
        this.myToString.register(BigInteger.class, new Converter<BigInteger, String>(){

            @Override
            public String convert(BigInteger o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getBigIntFormat().format(o);
            }
        });
        this.myToString.register(Number.class, new Converter<Number, String>(){

            @Override
            public String convert(Number o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getDecimalFormat(column).format(o);
            }
        });
        this.myToString.register(ImageInfo.class, new Converter<ImageInfo, String>(){

            @Override
            public String convert(ImageInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (!forDisplay && o.bytes != null) {
                    return ObjectFormatter.this.bytesToStringImpl(o.bytes, o.size, dbms, false);
                }
                return o.width + "x" + o.height + " " + StringUtil.toUpperCase((String)o.format) + " image " + ExtractorsUtil.getPresentableSize(o.size);
            }
        });
        this.myToString.register(TextInfo.class, new Converter<TextInfo, String>(){

            @Override
            public String convert(TextInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return forDisplay ? o.text : ObjectFormatter.bytesToString(o.bytes, dbms, false);
            }
        });
        this.myToString.register(Map.class, new Converter<Map, String>(){

            @Override
            public String convert(Map o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : (ObjectFormatter.isHstore(column) ? ObjectFormatter.hstoreToString(o, forDisplay) : (dbms.isMongo() ? JsonUtilKt.toJson(o, dbms, ObjectFormatter.this, null) : null));
            }
        });
        this.myToString.register(Set.class, new Converter<Set, String>(){

            @Override
            public String convert(Set o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : null;
            }
        });
        this.myToString.register(List.class, new Converter<List, String>(){

            @Override
            public String convert(List o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() ? CassJdbcHelper.toValidLiteral((Object)o) : (dbms.isMongo() ? JsonUtilKt.toJson(o, dbms, ObjectFormatter.this, null) : null);
            }
        });
        this.myToString.register(Boolean.class, new Converter<Boolean, String>(){

            @Override
            public String convert(Boolean o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (forDisplay) {
                    return String.valueOf(o);
                }
                if (dbms.isTransactSql()) {
                    return o != false ? "1" : "0";
                }
                return String.valueOf(o);
            }
        });
        this.myToString.register(TimeZonedTimestamp.class, new Converter<TimeZonedTimestamp, String>(){

            @Override
            public String convert(TimeZonedTimestamp o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.dateToString(ObjectFormatter.this.getShortZonedTimestampFormat(column, dbms), o, dbms, column);
            }
        });
        this.myToString.register(TimeZonedTime.class, new Converter<TimeZonedTime, String>(){

            @Override
            public String convert(TimeZonedTime o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.getShortZonedTimeFormat(column, dbms).format(o);
            }
        });
        this.myToString.register(ZonedValue.class, new Converter<ZonedValue, String>(){

            @Override
            public String convert(ZonedValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (forDisplay) {
                    Object object = ObjectFormatter.objectToObject(o, column, Dbms.UNKNOWN);
                    return ObjectFormatter.this.objectToString(object, column, dbms, true);
                }
                return o.getStringRepresentation();
            }
        });
        this.myToString.register(ReservedCellValue.class, new Converter<ReservedCellValue, String>(){

            @Override
            public String convert(ReservedCellValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return o == null ? null : StringUtil.toLowerCase((String)String.valueOf((Object)o));
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoValue.class, new Converter<MongoJdbcHelper.MongoValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return o == null ? null : ObjectFormatter.this.objectToString(o.unwrap(), column, dbms, forDisplay);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBinaryValue.class, new Converter<MongoJdbcHelper.MongoBinaryValue, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoBinaryValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, o.data.length, column, dbms, forDisplay);
            }
        });
        this.myToString.register(MongoJdbcHelper.MongoBlobInfo.class, new Converter<MongoJdbcHelper.MongoBlobInfo, String>(){

            @Override
            public String convert(MongoJdbcHelper.MongoBlobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.this.convertMongoBinaryValue(o.data, o.type, o.length, column, dbms, forDisplay);
            }
        });
    }

    private String convertMongoBinaryValue(byte[] data, byte type, long wholeLength, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        String string = Base64.getEncoder().encodeToString(data);
        map2.put("base64", (long)data.length == wholeLength || !forDisplay ? string : ObjectFormatter.valueToString(string, data.length, wholeLength));
        String typeStr = Integer.toString(type, 16);
        map2.put("subType", typeStr.length() == 1 ? "0" + typeStr : typeStr);
        return this.objectToString(map2, column, dbms, forDisplay);
    }

    private static boolean isOracleGUID(byte[] o, DataConsumer.Column column, Dbms dbms) {
        return dbms.isOracle() && o != null && o.length == 16 && "RAW".equals(column.typeName);
    }

    public static boolean isHstore(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(0);
        }
        return "hstore".equals(column.typeName) && "java.util.Map".equals(column.clazz);
    }

    public static boolean isJson(@NotNull DataConsumer.Column column, Dbms family) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(1);
        }
        return (family.isMysql() || family.isPostgres()) && StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"json", "jsonb"});
    }

    public static boolean isPostgresArray(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(2);
        }
        return column.type == 2003;
    }

    public static boolean isBinaryTextColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(3);
        }
        return StringUtil.equals((CharSequence)"bytea", (CharSequence)column.typeName);
    }

    public static boolean isPostgresRangeType(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(4);
        }
        return StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"int4range", "int8range", "numrange", "tsrange", "tstzrange", "daterange"});
    }

    private static String hstoreToString(Map<String, String> hstore, boolean forDisplay) {
        StringBuilder sb = new StringBuilder();
        boolean first2 = true;
        for (Map.Entry<String, String> entry : hstore.entrySet()) {
            if (!first2) {
                sb.append(',');
                sb.append(forDisplay ? (char)'\n' : ' ');
            }
            ObjectFormatter.appendHstoreValue(sb, entry.getKey(), !forDisplay, false);
            sb.append(" => ");
            ObjectFormatter.appendHstoreValue(sb, StringUtil.notNullize((String)entry.getValue(), (String)"null"), !forDisplay, false);
            first2 = false;
        }
        return sb.toString();
    }

    public static void appendHstoreValue(StringBuilder sb, String value2, boolean escape, boolean forceQuotation) {
        boolean requiresQuotation;
        boolean bl = requiresQuotation = forceQuotation || PG_HSTORE_REQUIRES_QUOTATION.matcher(value2).find();
        if (requiresQuotation) {
            sb.append('\"');
        }
        sb.append(escape ? StringUtil.escapeQuotes((String)value2) : value2);
        if (requiresQuotation) {
            sb.append('\"');
        }
    }

    private static String dateToString(@NotNull Formatter formatter, @NotNull Object value2, @Nullable Dbms dbms, @Nullable DataConsumer.Column column) {
        String boundaryString;
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            ObjectFormatter.$$$reportNull$$$0(6);
        }
        return (boundaryString = BoundaryValueResolver.getInfinityString(dbms, column, value2)) == null ? formatter.format(value2) : boundaryString;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String charToStringImpl(@NotNull String text2, long wholeLength, boolean bl) {
        void forDisplay;
        if (text2 == null) {
            ObjectFormatter.$$$reportNull$$$0(7);
        }
        String string = forDisplay == false || (long)text2.length() == wholeLength ? text2 : ObjectFormatter.valueToString(text2, text2.length(), wholeLength);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(8);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String bytesToStringImpl(@NotNull byte[] o, long wholeLength, Dbms dbms, boolean bl) {
        void forDisplay;
        String stringValue;
        if (o == null) {
            ObjectFormatter.$$$reportNull$$$0(9);
        }
        boolean truncated = wholeLength != (long)o.length;
        boolean wholeValueLoaded = !truncated && o.length < DatabaseSettings.getSettings().getMaxLobLength();
        String string = stringValue = wholeValueLoaded || forDisplay != false ? ObjectFormatter.tryDecodeString(o, StandardCharsets.UTF_8) : null;
        if (wholeValueLoaded && stringValue != null) {
            String string2 = stringValue;
            if (string2 == null) {
                ObjectFormatter.$$$reportNull$$$0(10);
            }
            return string2;
        }
        if (forDisplay != false) {
            stringValue = stringValue != null ? stringValue : ObjectFormatter.bytesToString(o, dbms, true);
            String string3 = ObjectFormatter.valueToString(stringValue, o.length, wholeLength);
            if (string3 == null) {
                ObjectFormatter.$$$reportNull$$$0(11);
            }
            return string3;
        }
        return ObjectFormatter.bytesToString(o, dbms, false);
    }

    private static String getValueNotLoadedString(DataConsumer.Column column, Dbms dbms, long wholeValueSize) {
        DataType dataType = column.asDataType();
        String type = dbms != null ? DbImplUtil.getDatabaseDialect(dbms).getTypeName(dataType) : StringUtil.notNullize((String)column.typeName, (String)"unknown");
        return "(" + StringUtil.toUpperCase((String)type) + "):" + ExtractorsUtil.getPresentableSize(wholeValueSize);
    }

    private static String valueToString(String value2, long loadedLength, long wholeLength) {
        boolean truncated = wholeLength != loadedLength;
        CharOut out = CharOut.Util.newSink();
        out.append(ExtractorsUtil.getPresentableSize(wholeLength));
        if (!truncated) {
            out.append("\n").append(value2);
        } else {
            out.append(" (").append(ExtractorsUtil.getPresentableSize(loadedLength)).append(" loaded)\n").append(value2).append("...");
        }
        return out.toString();
    }

    @Nullable
    public static Object objectToObject(@Nullable Object o, DataConsumer.Column column, Dbms dbms) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)ourToObject.get(o.getClass());
        Object result = converter != null ? (Object)converter.convert(o, column, dbms, false) : null;
        return result != null ? result : ObjectFormatter.objectToObject(String.valueOf(o), column, dbms);
    }

    public static void convertRows(@NotNull List<DataConsumer.Row> rows, @Nullable List<DataConsumer.Column> columns, @NotNull Dbms dbms) {
        if (rows == null) {
            ObjectFormatter.$$$reportNull$$$0(12);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(13);
        }
        if (columns == null) {
            return;
        }
        for (DataConsumer.Row row : rows) {
            if (row == null || row.values.length != columns.size()) continue;
            for (int i2 = 0; i2 < row.values.length; ++i2) {
                row.values[i2] = ObjectFormatter.objectToObject(row.values[i2], columns.get(i2), dbms);
            }
        }
    }

    @Nullable
    @NonNls
    public String objectToString(@Nullable Object o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
        if (o == null) {
            return null;
        }
        Converter converter = (Converter)this.myToString.get(o.getClass());
        String result = converter != null ? (String)converter.convert(o, column, dbms, forDisplay) : null;
        result = result != null ? result : this.objectToString(String.valueOf(o), column, dbms, forDisplay);
        return Objects.requireNonNull(result);
    }

    @Nullable
    public String getValueLiteral(@Nullable Object value2, @NotNull DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(14);
        }
        return value2 == ReservedCellValue.NULL || value2 == ReservedCellValue.UNSET ? null : this.objectToString(value2, column, dbms, forDisplay);
    }

    @NotNull
    public String getValueLiteralQuoted(@Nullable Object value2, @NotNull DataConsumer.Column column, @NotNull Dbms dbms, @Nullable JdbcHelper helper, boolean forDisplay) {
        String literal;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(15);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(16);
        }
        String string = (literal = this.getValueLiteral(value2, column, dbms, forDisplay)) == null ? "null" : (ObjectFormatter.isStringLiteral(dbms, column, value2, helper) ? DbImplUtil.StringLiteralDecorator.PLAIN.decorate(literal, dbms, helper) : literal);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isStringLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Column column, @Nullable Object value2, @Nullable JdbcHelper helper) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(18);
        }
        return value2 instanceof LobInfo.ClobInfo || column != null && (ObjectFormatter.isCommonLiteral(dbms, column, helper) || ObjectFormatter.isJson(column, dbms) || ObjectFormatter.isPostgresStringLiteral(dbms, column, value2) || ObjectFormatter.isMongoStringLiteral(value2));
    }

    private static boolean isMongoStringLiteral(@Nullable Object value2) {
        if (value2 instanceof Double) {
            double d2 = (Double)value2;
            return Double.isNaN(d2) || Double.isInfinite(d2);
        }
        return value2 instanceof MongoJdbcHelper.MongoValue && !(value2 instanceof MongoJdbcHelper.MongoTimestampValue) && !(value2 instanceof MongoJdbcHelper.MongoRegexpValue) && !(value2 instanceof MongoJdbcHelper.MongoBinaryValue) && !(value2 instanceof MongoJdbcHelper.MongoBlobInfo);
    }

    private static boolean isCommonLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column, @Nullable JdbcHelper helper) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(19);
        }
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(20);
        }
        helper = helper != null ? helper : DbImplUtil.getJdbcHelper(dbms);
        int jdbcType = ExtractorsUtil.guessJdbcType(column);
        return jdbcType == 1 || jdbcType == 12 || jdbcType == -1 || jdbcType == -15 || jdbcType == -9 || jdbcType == -16 || jdbcType == 92 || jdbcType == 91 || jdbcType == 2005 || jdbcType == -8 || jdbcType == 239 || helper.isTimestamp(jdbcType) || helper.isZonedColumn(column.typeName, jdbcType) || ObjectFormatter.isBitString(column) || StringUtil.equalsIgnoreCase((CharSequence)column.typeName, (CharSequence)"uuid");
    }

    private static boolean isPostgresStringLiteral(@NotNull Dbms dbms, @NotNull DataConsumer.Column column, @Nullable Object value2) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(21);
        }
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(22);
        }
        return dbms.isPostgres() && (ObjectFormatter.isHstore(column) || ObjectFormatter.isPostgresRangeType(column) || ObjectFormatter.isPostgresArray(column) || StringUtil.findIgnoreCase((String)column.typeName, (String[])new String[]{"interval", "cird", "circle", "inet", "line", "lseg", "macaddr", "macaddr8", "money", "path", "point", "polygon", "tsquery", "tsvector", "xml"}) || ObjectFormatter.isPgDecodedLiteral(column, value2));
    }

    public static boolean isPgDecodedLiteral(@NotNull DataConsumer.Column column, @Nullable Object value2) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(23);
        }
        return value2 instanceof TextInfo && ObjectFormatter.isBinaryTextColumn(column);
    }

    @NotNull
    public String getPlainValue(@NotNull DataConsumer.Column column, @NotNull DataConsumer.Row row, Dbms dbms) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(24);
        }
        if (row == null) {
            ObjectFormatter.$$$reportNull$$$0(25);
        }
        String string = this.getPlainValue(column.getValue(row), column, dbms);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getPlainValue(@Nullable Object object, @NotNull DataConsumer.Column column, Dbms dbms) {
        String literal;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(27);
        }
        String string = (literal = this.objectToString(object, column, dbms, true)) == null ? "null" : literal;
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    private static Object tryDetectObject(@NotNull byte[] bytes) {
        ImageInfo image;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(29);
        }
        if ((image = ObjectFormatter.tryDetectImage(bytes)) != null) {
            return image;
        }
        TextInfo text2 = ObjectFormatter.tryDetectString(bytes);
        if (text2 != null) {
            return text2;
        }
        return null;
    }

    @Nullable
    public static TextInfo tryDetectString(@NotNull byte[] bytes) {
        String guessed;
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(30);
        }
        return (guessed = LoadTextUtil.getTextFromBytesOrNull((byte[])bytes, (int)0, (int)bytes.length)) == null ? null : new TextInfo(guessed, bytes);
    }

    @Nullable
    private static String tryDecodeString(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (charset == null) {
            ObjectFormatter.$$$reportNull$$$0(31);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(32);
        }
        CharsetDecoder d2 = charset.newDecoder();
        d2.onMalformedInput(CodingErrorAction.REPORT);
        d2.onUnmappableCharacter(CodingErrorAction.REPORT);
        try {
            CharBuffer buf = d2.decode(ByteBuffer.wrap(bytes));
            boolean bad = false;
            int len = buf.length();
            for (int i2 = 0; !bad && i2 < len; ++i2) {
                char c2 = buf.charAt(i2);
                bad = c2 < ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t';
            }
            if (!bad) {
                return buf.toString();
            }
        }
        catch (CharacterCodingException characterCodingException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static ImageInfo tryDetectImage(final @NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(33);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<ImageInfo>(){

            @Override
            public ImageInfo extract(ImageReader reader) throws Exception {
                String format = reader.getFormatName();
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                return new ImageInfo(format, width, height, bytes.length, bytes);
            }
        });
    }

    @Nullable
    private static BufferedImage readImage(@NotNull byte[] bytes) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(34);
        }
        return ObjectFormatter.extractImageData(bytes, new ImageDataExtractor<BufferedImage>(){

            @Override
            public BufferedImage extract(ImageReader reader) throws Exception {
                return reader.read(0, reader.getDefaultReadParam());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T extractImageData(@NotNull byte[] bytes, @NotNull ImageDataExtractor<T> dataExtractor) {
        if (dataExtractor == null) {
            ObjectFormatter.$$$reportNull$$$0(35);
        }
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(36);
        }
        if (bytes.length < 100) {
            return null;
        }
        try {
            ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<Object> readers = stream != null ? ImageIO.getImageReaders(stream) : Collections.emptyIterator();
            ImageReader reader = readers.hasNext() ? (ImageReader)readers.next() : null;
            try {
                if (reader == null) return null;
                reader.setInput(stream, true, true);
                T t = dataExtractor.extract(reader);
                return t;
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Formatter getTimeFormat() {
        this.initFormats();
        return this.myTimeFormat;
    }

    public Formatter getZonedTimeFormat(DataConsumer.Column column, Dbms dbms) {
        FormatterKey key = new FormatterKey(column, TimeZonedTime.class);
        Formatter format = this.myFormatCache.get(key);
        if (format != null) {
            return format;
        }
        CompositeFormatter result = FormatterCreator.newZonedTimeFormat(ObjectFormatter.calculateScale(column, dbms));
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    public Formatter getShortZonedTimeFormat(DataConsumer.Column column, Dbms dbms) {
        if (this.myShortZonedTimeFormat == null) {
            int scale = ObjectFormatter.calculateScale(column, dbms);
            this.myShortZonedTimeFormat = FormatterCreator.newShortZonedTimeFormat(scale);
        }
        return this.myShortZonedTimeFormat;
    }

    public Formatter getShortZonedTimestampFormat(DataConsumer.Column column, Dbms dbms) {
        if (this.myShortZonedTimestampFormat == null) {
            int scale = ObjectFormatter.calculateScale(column, dbms);
            this.myShortZonedTimestampFormat = FormatterCreator.newShortEraZonedTimestampFormat(scale);
        }
        return this.myShortZonedTimestampFormat;
    }

    public Formatter getTimestampFormat(@NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        FormatterKey key;
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(37);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(38);
        }
        if ((format = this.myFormatCache.get(key = new FormatterKey(column, Timestamp.class))) != null) {
            return format;
        }
        Formatter result = dbms.isMongo() ? ObjectFormatter.newDateFormat(column, dbms) : ObjectFormatter.newTimestampFormat(column, dbms);
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    public CompositeFormatter getZonedTimestampFormat(@NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        FormatterKey key;
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(39);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(40);
        }
        if ((format = this.myFormatCache.get(key = new FormatterKey(column, TimeZonedTimestamp.class))) instanceof CompositeFormatter) {
            return (CompositeFormatter)format;
        }
        CompositeFormatter result = FormatterCreator.newZonedTimestampFormat(dbms, column, ObjectFormatter.calculateScale(column, dbms));
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    public Formatter getDateFormat(@Nullable DataConsumer.Column column, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(41);
        }
        if (this.myDateFormat != null) {
            return this.myDateFormat;
        }
        this.myDateFormat = ObjectFormatter.newDateFormat(column, dbms);
        return this.myDateFormat;
    }

    @NotNull
    private <T> String arrayToString(T[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
        if (o.length == 0) {
            return forDisplay ? "{}" : "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int len = Math.min(o.length, forDisplay ? 100 : o.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(this.objectToString(o[i2], column, dbms, true));
        }
        if (len < o.length) {
            sb.append(",...");
        }
        sb.append("}");
        String string = sb.toString();
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static Formatter newTimestampFormat(@NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(43);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(44);
        }
        Formatter formatter = FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraTimestampFormat(dbms, column, ObjectFormatter.calculateScale(column, dbms)) : FormatterCreator.newTimestampFormat(ObjectFormatter.calculateScale(column, dbms));
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(45);
        }
        return formatter;
    }

    @NotNull
    private static Formatter newDateFormat(@Nullable DataConsumer.Column column, @NotNull Dbms dbms) {
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(46);
        }
        Formatter formatter = dbms.isMongo() ? FormatterCreator.newDateFormatWithTime() : (FormatterCreator.supportsEra(dbms) ? FormatterCreator.newEraDateFormatter(dbms, column) : FormatterCreator.newDateFormatter());
        if (formatter == null) {
            ObjectFormatter.$$$reportNull$$$0(47);
        }
        return formatter;
    }

    @NotNull
    private static String bitsToString(@NotNull BitString string, @NotNull DataConsumer.Column column) {
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(48);
        }
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(49);
        }
        long length = string.getLength();
        byte[] bytes = string.getBytes();
        StringBuilder sb = new StringBuilder();
        int j = 0;
        while ((long)j < length) {
            byte b2 = bytes[j / 8];
            sb.append((b2 & 128 >>> j % 8) != 0 ? (char)'1' : '0');
            ++j;
        }
        while (sb.length() > column.precision && sb.length() > 0 && sb.charAt(0) == '0') {
            sb.delete(0, 1);
        }
        String string2 = sb.toString();
        if (string2 == null) {
            ObjectFormatter.$$$reportNull$$$0(50);
        }
        return string2;
    }

    private static int calculateScale(@NotNull DataConsumer.Column column, @NotNull Dbms dbms) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(51);
        }
        if (dbms == null) {
            ObjectFormatter.$$$reportNull$$$0(52);
        }
        int scale = column.scale;
        if (dbms.isMysql() && column.type == 93 && (StringUtil.equalsIgnoreCase((CharSequence)"datetime", (CharSequence)column.typeName) || StringUtil.equalsIgnoreCase((CharSequence)"timestamp", (CharSequence)column.typeName))) {
            scale = column.precision - 20;
        }
        if (dbms.isSqlite()) {
            scale = 3;
        }
        return Math.min(9, Math.max(0, scale));
    }

    public NumberFormatter getDecimalFormat(@NotNull DataConsumer.Column column) {
        FormatterKey key;
        Formatter format;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(53);
        }
        if ((format = this.myFormatCache.get(key = new FormatterKey(column, Number.class))) instanceof NumberFormatter) {
            return (NumberFormatter)format;
        }
        NumberFormatter result = ObjectFormatter.isFloat(column) ? FormatterCreator.newFloatFormat() : FormatterCreator.newDecimalFormat();
        int fractionDigits = column.scale;
        result.setParseBigDecimal(ObjectFormatter.isBigDecimal(column));
        result.setMinimumFractionDigits(ObjectFormatter.isFloatingPoint(column) || ObjectFormatter.isH2DecimalWithUnspecifiedPrecision(column) ? 0 : fractionDigits);
        result.setMaximumFractionDigits(340);
        if (column.attributes.contains((Object)DataConsumer.Column.Attribute.ZERO_PADDING) && column.precision > 0) {
            result.setMinimumIntegerDigits(column.precision);
        }
        this.myFormatCache.putIfAbsent(key, result);
        return result;
    }

    @Nullable
    public static Object unwrap(@Nullable Object o) {
        if (o instanceof LobInfo.ClobInfo) {
            return ((LobInfo.ClobInfo)o).data;
        }
        if (o instanceof LobInfo.BlobInfo) {
            return ((LobInfo.BlobInfo)o).data;
        }
        if (o instanceof TextInfo) {
            return ((TextInfo)o).bytes;
        }
        if (o instanceof ImageInfo) {
            return ((ImageInfo)o).bytes;
        }
        return o;
    }

    @Nullable
    public static Boolean getBooleanValue(@Nullable Object value2) {
        return value2 instanceof Boolean ? (Boolean)value2 : (value2 instanceof Number ? Boolean.valueOf(((Number)value2).intValue() == 1) : (value2 instanceof String ? ObjectFormatter.parseBoolean((String)value2) : null));
    }

    @Nullable
    private static Boolean parseBoolean(@NotNull String value2) {
        if (value2 == null) {
            ObjectFormatter.$$$reportNull$$$0(54);
        }
        return StringUtil.findIgnoreCase((String)value2, (String[])new String[]{"1", "true"}) ? Boolean.TRUE : (StringUtil.findIgnoreCase((String)value2, (String[])new String[]{"0", "false"}) ? Boolean.FALSE : null);
    }

    public static boolean isFloatingPoint(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(55);
        }
        return ObjectFormatter.isFloat(column) || ObjectFormatter.isDouble(column);
    }

    public static boolean isBigDecimal(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(56);
        }
        return BigDecimal.class.getName().equals(column.clazz);
    }

    public static boolean isBooleanColumn(@NotNull DataConsumer.Column column) {
        int type;
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(57);
        }
        return (type = ExtractorsUtil.guessJdbcType(column)) == 16 || (ObjectFormatter.isBit(column.typeName, type) || "java.lang.Boolean".equals(column.clazz)) && column.precision <= 1;
    }

    public static boolean isNumericColumn(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(58);
        }
        int type = ExtractorsUtil.guessJdbcType(column);
        return ArrayUtil.contains((Object)type, (Object[])new Integer[]{4, 5, -6, -5, 7, 6, 8, 3, 2}) || ObjectFormatter.isFloatingPoint(column) || ObjectFormatter.isBigDecimal(column);
    }

    public static boolean isBitString(@NotNull DataConsumer.Column c2) {
        if (c2 == null) {
            ObjectFormatter.$$$reportNull$$$0(59);
        }
        return c2.precision > 1 && ObjectFormatter.isBit(c2.typeName, c2.type);
    }

    private static boolean isBit(@Nullable String typeName, int jdbcType) {
        return jdbcType == -7 || typeName != null && StringUtil.findIgnoreCase((String)typeName, (String[])new String[]{"bit", "bit varying", "varbit"});
    }

    private static boolean isFloat(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(60);
        }
        return Float.class.getName().equals(column.clazz) || "oracle.sql.BINARY_FLOAT".equals(column.clazz);
    }

    private static boolean isDouble(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(61);
        }
        return Double.class.getName().equals(column.clazz) || "oracle.sql.BINARY_DOUBLE".equals(column.clazz);
    }

    private static boolean isH2DecimalWithUnspecifiedPrecision(@NotNull DataConsumer.Column column) {
        if (column == null) {
            ObjectFormatter.$$$reportNull$$$0(62);
        }
        return "DECIMAL".equals(column.typeName) && 65535 == column.precision && Short.MAX_VALUE == column.scale;
    }

    @NotNull
    private static String bytesToString(@NotNull byte[] bytes, Dbms dbms, boolean forDisplay) {
        if (bytes == null) {
            ObjectFormatter.$$$reportNull$$$0(63);
        }
        if (forDisplay) {
            String string = DialectUtils.toPresentableHexString(bytes);
            if (string == null) {
                ObjectFormatter.$$$reportNull$$$0(64);
            }
            return string;
        }
        String string = DbImplUtil.getDatabaseDialect(dbms).getBinaryLiteralString(bytes);
        if (string == null) {
            ObjectFormatter.$$$reportNull$$$0(65);
        }
        return string;
    }

    private void initFormats() {
        if (this.myTimeFormat != null) {
            return;
        }
        this.myTimeFormat = FormatterCreator.newTimeFormat();
        this.myNumberFormat = FormatterCreator.newDecimalFormat();
        this.myNumberFormat.setParseIntegerOnly(true);
        this.myBigIntFormat = FormatterCreator.newDecimalFormat();
        this.myBigIntFormat.setParseIntegerOnly(true);
        this.myBigIntFormat.setParseBigDecimal(true);
    }

    @NotNull
    public Formatter getNumberFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myNumberFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(66);
        }
        return numberFormatter;
    }

    @NotNull
    public Formatter getBigIntFormat() {
        this.initFormats();
        NumberFormatter numberFormatter = this.myBigIntFormat;
        if (numberFormatter == null) {
            ObjectFormatter.$$$reportNull$$$0(67);
        }
        return numberFormatter;
    }

    private static int trimToMax(long length) {
        int maxLobLength = DatabaseSettings.getSettings().getMaxLobLength();
        return (long)maxLobLength < length ? maxLobLength : (int)length;
    }

    static {
        Converter<Object, Object> identity = new Converter<Object, Object>(){

            @Override
            public Object convert(Object o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return o;
            }
        };
        ourToObject.put(Object[].class, identity);
        ourToObject.put(long[].class, identity);
        ourToObject.put(int[].class, identity);
        ourToObject.put(double[].class, identity);
        ourToObject.put(TimeZonedValue.class, identity);
        ourToObject.put(LobInfo.ClobInfo.class, identity);
        ourToObject.put(MongoJdbcHelper.MongoValue.class, identity);
        ourToObject.put(MongoJdbcHelper.MongoBlobInfo.class, identity);
        ourToObject.register(LobInfo.BlobInfo.class, new Converter<LobInfo.BlobInfo, Object>(){

            @Override
            public Object convert(LobInfo.BlobInfo o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (o.isTruncated()) {
                    return o;
                }
                Object detectedObject = ObjectFormatter.tryDetectObject(o.data);
                return ObjectUtils.chooseNotNull((Object)detectedObject, (Object)o);
            }
        });
        ourToObject.put(Boolean.class, identity);
        ourToObject.put(Number.class, identity);
        ourToObject.put(Timestamp.class, identity);
        ourToObject.put(Time.class, identity);
        ourToObject.register(ZonedValue.class, new Converter<ZonedValue, Object>(){

            @Override
            public Object convert(ZonedValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                String stringValue = o.getStringRepresentation();
                int scale = ObjectFormatter.calculateScale(column, dbms);
                ParsePosition position = new ParsePosition(0);
                return ObjectUtils.notNull((Object)(DbImplUtil.isZonedTimeColumn(column, dbms) ? FormatterCreator.newZonedTimeFormat(scale).parse(stringValue, position) : FormatterCreator.newZonedTimestampFormat(dbms, column, scale).parse(stringValue, position)), (Object)stringValue);
            }
        });
        ourToObject.register(BitString.class, new Converter<BitString, Object>(){

            @Override
            public Object convert(BitString o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return ObjectFormatter.bitsToString(o, column);
            }
        });
        ourToObject.register(Date.class, new Converter<Date, Object>(){

            @Override
            public Object convert(Date o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (column != null && column.clazz != null && column.clazz.endsWith("Timestamp")) {
                    return new Timestamp(o.getTime());
                }
                if (column != null && column.clazz != null && column.clazz.endsWith("Time")) {
                    return new Time(o.getTime());
                }
                return o;
            }
        });
        ourToObject.register(byte[].class, new Converter<byte[], Object>(){

            @Override
            public Object convert(byte[] o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                Object detectedObject = ObjectFormatter.tryDetectObject(o);
                return detectedObject != null ? detectedObject : LobInfo.fromByteArray((byte[])o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Clob.class, new Converter<Clob, Object>(){

            @Override
            public Object convert(Clob o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                try {
                    return LobInfo.fromClob((Clob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(Blob.class, new Converter<Blob, Object>(){

            @Override
            public Object convert(Blob o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                try {
                    return LobInfo.fromBlob((Blob)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        ourToObject.register(String.class, new Converter<String, Object>(){

            @Override
            public Object convert(String o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return LobInfo.fromString((String)o, (int)DatabaseSettings.getSettings().getMaxLobLength());
            }
        });
        ourToObject.register(Map.class, new Converter<Map, Object>(){

            @Override
            public Object convert(Map o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() || ObjectFormatter.isHstore(column) || dbms.isMongo() ? o : null;
            }
        });
        ourToObject.register(Set.class, new Converter<Set, Object>(){

            @Override
            public Object convert(Set o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() ? o : null;
            }
        });
        ourToObject.register(List.class, new Converter<List, Object>(){

            @Override
            public Object convert(List o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                return dbms.isCassandra() || dbms.isMongo() ? o : null;
            }
        });
        ourToObject.register(InetAddress.class, new Converter<InetAddress, Object>(){

            @Override
            public Object convert(InetAddress o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                if (!dbms.isCassandra()) {
                    return null;
                }
                String value2 = o.toString();
                return value2.substring(value2.indexOf("/") + 1);
            }
        });
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            ourToObject.register(ReservedCellValue.class, new Converter<ReservedCellValue, Object>(){

                @Override
                public Object convert(ReservedCellValue o, DataConsumer.Column column, Dbms dbms, boolean forDisplay) {
                    return o;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 26: 
            case 28: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 26: 
            case 28: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 6: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 26: 
            case 28: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 38: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataExtractor";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ObjectFormatter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "charToStringImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToStringImpl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueLiteralQuoted";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainValue";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayToString";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "newTimestampFormat";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "newDateFormat";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "bitsToString";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "bytesToString";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIntFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isHstore";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isJson";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresArray";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryTextColumn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresRangeType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "charToStringImpl";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 26: 
            case 28: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "bytesToStringImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertRows";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteral";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getValueLiteralQuoted";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCommonLiteral";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isPostgresStringLiteral";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPgDecodedLiteral";
                break;
            }
            case 24: 
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPlainValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectObject";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectString";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryDecodeString";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectImage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "readImage";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "extractImageData";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTimestampFormat";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getZonedTimestampFormat";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDateFormat";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "newTimestampFormat";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "newDateFormat";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "bitsToString";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "calculateScale";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getDecimalFormat";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "parseBoolean";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isFloatingPoint";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isBigDecimal";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanColumn";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isNumericColumn";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isBitString";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isFloat";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isDouble";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isH2DecimalWithUnspecifiedPrecision";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "bytesToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 26: 
            case 28: 
            case 42: 
            case 45: 
            case 47: 
            case 50: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FormatterKey {
        private final DataConsumer.Column myColumn;
        private final Class<?> myClass;

        FormatterKey(@NotNull DataConsumer.Column column, @NotNull Class<?> aClass) {
            if (column == null) {
                FormatterKey.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                FormatterKey.$$$reportNull$$$0(1);
            }
            this.myColumn = column;
            this.myClass = aClass;
        }

        public int hashCode() {
            return this.myClass.hashCode() + this.myColumn.hashCode() * 31;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatterKey)) {
                return false;
            }
            FormatterKey key = (FormatterKey)obj;
            return this.myClass.equals(key.myClass) && this.myColumn.equals(key.myColumn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$FormatterKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TextInfo {
        public final String text;
        public final byte[] bytes;

        public TextInfo(@NotNull String text2, @NotNull byte[] bytes) {
            if (text2 == null) {
                TextInfo.$$$reportNull$$$0(0);
            }
            if (bytes == null) {
                TextInfo.$$$reportNull$$$0(1);
            }
            this.text = text2;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextInfo info = (TextInfo)o;
            if (!this.text.equals(info.text)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.text.hashCode();
            result = 31 * result + Arrays.hashCode(this.bytes);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "bytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/extractors/ObjectFormatter$TextInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImageInfo {
        public final String format;
        public final int width;
        public final int height;
        public final int size;
        public final byte[] bytes;

        public ImageInfo(@NotNull String format, int width, int height, int size, @Nullable byte[] bytes) {
            if (format == null) {
                ImageInfo.$$$reportNull$$$0(0);
            }
            this.format = format;
            this.width = width;
            this.height = height;
            this.size = size;
            this.bytes = bytes;
        }

        @Nullable
        public BufferedImage createImage() {
            return this.bytes != null ? ObjectFormatter.readImage(this.bytes) : null;
        }

        @NotNull
        public ImageInfo stripBytes() {
            return new ImageInfo(this.format, this.width, this.height, this.size, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo info = (ImageInfo)o;
            if (this.width != info.width) {
                return false;
            }
            if (this.height != info.height) {
                return false;
            }
            if (this.size != info.size) {
                return false;
            }
            if (!this.format.equals(info.format)) {
                return false;
            }
            return Arrays.equals(this.bytes, info.bytes);
        }

        public int hashCode() {
            int result = this.format.hashCode();
            result = 31 * result + this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.size;
            result = 31 * result + (this.bytes != null ? Arrays.hashCode(this.bytes) : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/extractors/ObjectFormatter$ImageInfo", "<init>"));
        }
    }

    private static abstract class ImageDataExtractor<T> {
        private ImageDataExtractor() {
        }

        public abstract T extract(ImageReader var1) throws Exception;
    }

    private static class MyMap<T>
    extends ConcurrentClassMap<Converter<Object, T>> {
        private MyMap() {
        }

        public <X> void register(@NotNull Class<X> aClass, Converter<X, T> value2) {
            if (aClass == null) {
                MyMap.$$$reportNull$$$0(0);
            }
            super.put(aClass, value2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/extractors/ObjectFormatter$MyMap", "register"));
        }
    }

    static interface Converter<X, V> {
        public V convert(X var1, DataConsumer.Column var2, Dbms var3, boolean var4);
    }
}

