/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.CharOut;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatBasedExtractor
extends TranspositionAwareExtractor {
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("[A-Z]{2,}");
    private final CsvFormat myFormat;

    public FormatBasedExtractor(@NotNull CsvFormat format, @NotNull ObjectFormatter formatter) {
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            FormatBasedExtractor.$$$reportNull$$$0(1);
        }
        super(formatter);
        this.myFormat = format;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        String ext = FormatBasedExtractor.getFileExtension(this.myFormat);
        String string = ext != null ? ext : super.getFileExtension();
        if (string == null) {
            FormatBasedExtractor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static String getFileExtension(@NotNull CsvFormat format) {
        Matcher m;
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(3);
        }
        String ext = (m = FILE_EXTENSION_PATTERN.matcher(format.name)).find() ? m.group() : null;
        return StringUtil.isNotEmpty((String)ext) ? StringUtil.toLowerCase((String)ext) : null;
    }

    @NotNull
    private static CsvFormat adjust(@NotNull CsvFormat format, @Nullable Boolean addColumnHeader, @Nullable Boolean addRowHeader) {
        if (format == null) {
            FormatBasedExtractor.$$$reportNull$$$0(4);
        }
        if (format.headerRecord == null && Boolean.TRUE.equals(addColumnHeader)) {
            format = new CsvFormat(format.name, format.dataRecord, format.dataRecord, format.rowNumbers);
        } else if (format.headerRecord != null && Boolean.FALSE.equals(addColumnHeader)) {
            format = new CsvFormat(format.name, format.dataRecord, null, format.rowNumbers);
        }
        if (addRowHeader != null && format.rowNumbers != addRowHeader) {
            format = new CsvFormat(format.name, format.dataRecord, format.headerRecord, addRowHeader);
        }
        CsvFormat csvFormat = format;
        if (csvFormat == null) {
            FormatBasedExtractor.$$$reportNull$$$0(5);
        }
        return csvFormat;
    }

    @Override
    protected TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(CharOut out, final Dbms dbms, List<DataConsumer.Column> allColumns, @NotNull ExtractionConfig config, boolean isTransposedMode, int ... selectedColumns) {
        if (config == null) {
            FormatBasedExtractor.$$$reportNull$$$0(6);
        }
        final CsvFormat format = FormatBasedExtractor.adjust(this.myFormat, config.getAddColumnHeader(), config.getAddRowHeader());
        return new TranspositionAwareExtractor.TranspositionAwareExtraction(out, dbms, config, allColumns, selectedColumns){
            private final CsvFormatter myFormatter;
            {
                super(FormatBasedExtractor.this, output, dbms3, config, allColumns, selectedColumnIndices);
                this.myFormatter = new CsvFormatter(format);
            }

            @Override
            protected void doAppendData(List<DataConsumer.Row> rows) {
                ArrayList columns = new ArrayList();
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    ContainerUtil.addIfNotNull(columns, (Object)columnsMap.get(selectedColumn));
                }
                Object object = rows.iterator();
                while (object.hasNext()) {
                    DataConsumer.Row row = (DataConsumer.Row)object.next();
                    List values2 = ContainerUtil.map(columns, column -> FormatBasedExtractor.this.getValueAsString(row, (DataConsumer.Column)column, dbms, false));
                    if (this.myFormatter.requiresRowNumbers()) {
                        values2 = ContainerUtil.prepend((List)values2, (Object[])new Object[]{this.getRowNumber(row)});
                    }
                    this.myOutput.append(this.myFormatter.formatRecord(values2));
                    this.myOutput.append(this.myFormatter.recordSeparator());
                }
            }

            @Override
            protected void doAppendHeader(boolean appendNewLine) {
                if (format.headerRecord == null) {
                    return;
                }
                ArrayList<String> columnNames = new ArrayList<String>();
                if (this.myFormatter.requiresRowNumbers()) {
                    columnNames.add(this.getRowNumbersColumn().name);
                }
                TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                for (int selectedColumn : ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    DataConsumer.Column column = (DataConsumer.Column)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    columnNames.add(column.name);
                }
                this.myOutput.append(this.myFormatter.formatHeader(columnNames));
                this.myOutput.append(this.myFormatter.recordSeparator());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/FormatBasedExtractor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjust";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjust";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startExtraction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

