/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.diagram.DbDiagramNode;
import com.intellij.database.diagram.DbDiagramProvider;
import com.intellij.database.diagram.DbEdge;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramDataModel
extends DiagramDataModel<DbElement> {
    private final Set<DbElement> myTableSetsAddedByUser = new THashSet();
    private final Map<String, DbTable> myTablesAddedByUser = new THashMap();
    private final Set<DbTable> myTablesRemovedByUser = new THashSet();
    private final Collection<DiagramNode<DbElement>> myNodes = new THashSet();
    private final Collection<DiagramEdge<DbElement>> myEdges = new THashSet();

    public DbDiagramDataModel(Project project, DbElement element2, DiagramProvider<DbElement> provider) {
        super(project, provider);
        this.addElementInner(element2);
        project.getMessageBus().connect((Disposable)this).subscribe(DbPsiFacade.TOPIC, o -> {
            this.refreshDataModel();
            this.getBuilder().updateGraph();
        });
    }

    @NotNull
    public Collection<DiagramNode<DbElement>> getNodes() {
        Collection<DiagramNode<DbElement>> collection = this.myNodes;
        if (collection == null) {
            DbDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<DbElement>> getEdges() {
        Collection<DiagramEdge<DbElement>> collection = this.myEdges;
        if (collection == null) {
            DbDiagramDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @NotNull
    @NonNls
    public String getNodeName(DiagramNode<DbElement> node) {
        DbElement element2 = (DbElement)node.getIdentifyingElement();
        String string = String.format("%s %s", element2.getTypeName(), element2.getName());
        if (string == null) {
            DbDiagramDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void removeNode(DiagramNode<DbElement> node) {
        this.removeElement((DbElement)node.getIdentifyingElement());
    }

    public DiagramNode<DbElement> addElement(DbElement element2) {
        this.addElementInner(element2);
        if (element2 instanceof DbTable) {
            this.myTablesRemovedByUser.remove((DbTable)element2);
        }
        return null;
    }

    private void addElementInner(DbElement element2) {
        if (element2 instanceof DbTable) {
            this.myTablesAddedByUser.put(element2.getName(), (DbTable)element2);
        } else {
            this.myTableSetsAddedByUser.add(element2);
        }
    }

    @NotNull
    private JBIterable<DbDataSource> getDataSources() {
        JBIterable jBIterable = JBIterable.from(this.myTableSetsAddedByUser).append(this.myTablesAddedByUser.values()).map(DbElement::getDataSource).unique();
        if (jBIterable == null) {
            DbDiagramDataModel.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this.getProject());
        if (dbPsiFacade == null) {
            DbDiagramDataModel.$$$reportNull$$$0(4);
        }
        return dbPsiFacade;
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    private boolean isAllowedToShow(DbTable tableElement) {
        if (tableElement == null || !tableElement.isValid()) {
            return false;
        }
        return !this.myTablesRemovedByUser.contains(tableElement);
    }

    public synchronized void updateDataModel() {
        Set<DbTable> tables = this.getAllTables();
        HashMap<DbTable, DbDiagramNode> map2 = new HashMap<DbTable, DbDiagramNode>();
        for (DbTable tableElement : tables) {
            if (!this.isAllowedToShow(tableElement)) continue;
            DbDiagramNode node = new DbDiagramNode(tableElement, (DiagramProvider<DbElement>)this.getProvider());
            map2.put(tableElement, node);
            this.myNodes.add((DiagramNode<DbElement>)node);
        }
        boolean virtualFk = this.getBuilder().getPresentation().isCategoryEnabled(DbDiagramProvider.VIRTUAL_FOREIGN_KEYS);
        for (DbDiagramNode node : map2.values()) {
            DbTable table = node.getIdentifyingElement();
            THashSet uniqueLabels = new THashSet();
            for (DasForeignKey key : virtualFk ? ModelRelationManager.getForeignKeys(this.getProject(), (DasTable)table) : DasUtil.getForeignKeys((DasTable)table)) {
                String name = key.getName();
                DbDiagramNode target = (DbDiagramNode)((Object)map2.get(this.asDbElement(key.getRefTable())));
                if (target == null) continue;
                StringBuilder label1 = new StringBuilder();
                StringBuilder label2 = new StringBuilder();
                Iterator it2 = key.getColumnsRef().names().iterator();
                Iterator refIt = key.getRefColumns().names().iterator();
                while (it2.hasNext() && refIt.hasNext()) {
                    if (label1.length() > 0) {
                        label1.append(", ");
                    }
                    if (label2.length() > 0) {
                        label2.append(", ");
                    }
                    label1.append((String)it2.next());
                    label2.append((String)refIt.next());
                }
                String label = label1 + ":" + label2;
                if (!uniqueLabels.add(label)) continue;
                this.addEdge((DiagramNode<DbElement>)node, (DiagramNode<DbElement>)target, (DiagramRelationshipInfo)new DiagramRelationshipInfoAdapter("REFERENCES", DiagramLineType.SOLID, label){

                    public Shape getStartArrow() {
                        return DELTA;
                    }
                }, name);
            }
        }
    }

    public void addEdge(DiagramNode<DbElement> from, DiagramNode<DbElement> to, DiagramRelationshipInfo relationship, String name) {
        DbDiagramDataModel.addEdge(from, to, relationship, name, this.myEdges);
    }

    private static void addEdge(DiagramNode<DbElement> from, DiagramNode<DbElement> to, DiagramRelationshipInfo relationship, String name, Collection<DiagramEdge<DbElement>> storage) {
        for (DiagramEdge<DbElement> edge : storage) {
            if (edge.getSource() != from || edge.getTarget() != to || edge.getRelationship() != relationship) continue;
            return;
        }
        storage.add((DiagramEdge<DbElement>)new DbEdge(from, to, StringUtil.notNullize((String)name), relationship));
    }

    private Set<DbTable> getAllTables() {
        JBTreeTraverser traverser = new JBTreeTraverser(o -> o.getDasChildren(null));
        HashSet<DbTable> tables = new HashSet<DbTable>();
        LinkedList<DbTable> list = new LinkedList<DbTable>(this.myTablesAddedByUser.values());
        for (DbElement o2 : this.myTableSetsAddedByUser) {
            if (!o2.isValid()) continue;
            for (DbTable object : ((JBTreeTraverser)DbImplUtil.traverseVisibleObjects((DasDataSource)o2.getDataSource()).withRoot((Object)o2)).traverse().filter(DbTable.class)) {
                if (!DbDiagramElementManager.isAcceptedAsNodeImpl(object)) continue;
                this.addTableAndReferences(tables, list, object);
            }
        }
        while (!list.isEmpty()) {
            this.addTableAndReferences(tables, list, list.removeFirst());
        }
        ArrayList<DbTable> temp = new ArrayList<DbTable>(tables.size());
        tables.remove(null);
        for (DbTable table : tables) {
            if (table.isValid()) continue;
            temp.add(table);
        }
        tables.removeAll(this.myTablesRemovedByUser);
        tables.removeAll(temp);
        return tables;
    }

    private void addTableAndReferences(Set<DbTable> tables, List<DbTable> list, DbTable table) {
        if (!tables.add(table)) {
            return;
        }
        if (!table.isValid()) {
            return;
        }
        for (DasForeignKey info : ModelRelationManager.getForeignKeys(this.getProject(), (DasTable)table)) {
            DbTable targetTable = this.asDbElement(info.getRefTable());
            if (targetTable == null || tables.contains(targetTable)) continue;
            list.add(targetTable);
        }
    }

    @Nullable
    private DbTable asDbElement(@Nullable DasTable obj) {
        if (obj == null) {
            return null;
        }
        DbTable element2 = (DbTable)ObjectUtils.tryCast((Object)obj, DbTable.class);
        if (element2 != null) {
            return element2;
        }
        return (DbTable)this.getDataSources().filterMap(ds -> (DbTable)ObjectUtils.tryCast((Object)DbImplUtil.findElement(ds, (DasObject)obj), DbTable.class)).first();
    }

    @Nullable
    public DiagramNode<DbElement> findNode(PsiElement psiElement) {
        for (DiagramNode<DbElement> node : this.myNodes) {
            String fqn = ((DbElement)node.getIdentifyingElement()).getName();
            if (!fqn.equals(((DbTable)psiElement).getName())) continue;
            return node;
        }
        return null;
    }

    public void dispose() {
    }

    public void removeElement(DbElement element2) {
        DiagramNode<DbElement> node = this.findNode((PsiElement)element2);
        if (node == null) {
            this.myTablesAddedByUser.remove(QNameUtil.getQualifiedName(element2));
            return;
        }
        ArrayList<DiagramEdge<DbElement>> edges = new ArrayList<DiagramEdge<DbElement>>();
        for (DiagramEdge<DbElement> edge : this.myEdges) {
            if (edge.getTarget() != node && edge.getSource() != node) continue;
            edges.add(edge);
        }
        this.myEdges.removeAll(edges);
        this.myNodes.remove(node);
        if (element2 instanceof DbTable) {
            this.myTablesRemovedByUser.add((DbTable)element2);
            this.myTablesAddedByUser.remove(element2.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/database/diagram/DbDiagramDataModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

