/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dbimport.ImportErrorHandler;
import com.intellij.database.dbimport.ImportIndicatorUpdater;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTarget;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportHead {
    private static final Logger LOG = Logger.getInstance(ImportHead.class);
    private final ImportInfo myInfo;
    private final Project myProject;
    private final ReaderTask.Input myInput;
    private final ImportErrorHandler myHandler;

    public ImportHead(@NotNull Project project, @NotNull ImportInfo info, @NotNull ReaderTask.Input input) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ImportHead.$$$reportNull$$$0(1);
        }
        if (input == null) {
            ImportHead.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myInput = input;
        this.myHandler = new ImportErrorHandler(project, info);
        this.myInfo = info;
    }

    /*
     * Exception decompiling
     */
    public boolean start(@NotNull ProgressIndicator indicator, @NotNull ImportTarget target, @NotNull ErrorHandler errorHandler) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private Notification createNotification(@NotNull Project project, @Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount, boolean bl) {
        void error2;
        if (project == null) {
            ImportHead.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(7);
        }
        DbDataSource system = this.myInfo.getContext().getDataSource();
        String path = this.myInfo.getErrorTaskInfo().getErrorRecordsPath();
        String content = ImportHead.getContent(this.myInfo, timeSpent, path, updater, importedCount, errorsCount);
        NotificationType type = errorsCount > 0L || error2 != false ? NotificationType.ERROR : NotificationType.INFORMATION;
        return ImportHead.createNotification(project, (DasDataSource)Objects.requireNonNull(system), content, type, errorsCount > 0L ? path : null);
    }

    private static void notifyAboutInputError(@Nullable String error2, @NotNull Project project) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(8);
        }
        if (error2 != null) {
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(error2, NotificationType.ERROR).notify(project);
        }
    }

    @NotNull
    private static String getContent(@NotNull ImportInfo info, @Nullable Long timeSpent, @Nullable String path, @NotNull ImportIndicatorUpdater updater, @Nullable Long importedCount, long errorsCount) {
        if (info == null) {
            ImportHead.$$$reportNull$$$0(9);
        }
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(10);
        }
        String string = ImportHead.getTitle(info) + ImportHead.getInsertedCount(importedCount) + ImportHead.getStatistics(timeSpent, updater) + ImportHead.getErrorsCount(path, errorsCount);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private static String getTitle(@NotNull ImportInfo info) {
        if (info == null) {
            ImportHead.$$$reportNull$$$0(12);
        }
        String string = String.format("%s imported to %s", info.getProducerName(), info.getTableName());
        if (string == null) {
            ImportHead.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getStatistics(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(14);
        }
        String time = ImportHead.getTimeSpent(timeSpent);
        String speed = ImportHead.getSpeed(timeSpent, updater);
        boolean isTimeEmpty = StringUtil.isEmpty((String)time);
        boolean isSpeedEmpty = StringUtil.isEmpty((String)speed);
        String string = isTimeEmpty && isSpeedEmpty ? "" : (isTimeEmpty || isSpeedEmpty ? String.format(" (%s)", isTimeEmpty ? speed : time) : String.format(" (%s, %s)", time, speed));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getInsertedCount(@Nullable Long importedCount) {
        String string = importedCount == null ? "" : String.format(": %s %s", String.valueOf(importedCount), ImportUtil.pluralizeRows(importedCount));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getErrorsCount(@Nullable String path, long errorsCount) {
        return errorsCount > 0L ? ImportHead.getErrorNotification(path, errorsCount) : "";
    }

    @NotNull
    private static String getErrorNotification(@Nullable String path, long errorsCount) {
        String errors = ImportUtil.pluralize("error", errorsCount);
        String string = String.format(path == null ? "\n%s %s occurred" : "\n%s %s saved to", errorsCount, errors);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static String getTimeSpent(@Nullable Long timeSpent) {
        String string = timeSpent == null ? "" : StringUtil.formatDuration((long)timeSpent);
        if (string == null) {
            ImportHead.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getSpeed(@Nullable Long timeSpent, @NotNull ImportIndicatorUpdater updater) {
        if (updater == null) {
            ImportHead.$$$reportNull$$$0(19);
        }
        if (timeSpent == null || timeSpent / 1000L == 0L) {
            return "";
        }
        String string = StringUtil.notNullize((String)updater.calculateSpeed(timeSpent / 1000L));
        if (string == null) {
            ImportHead.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    private static Notification createNotification(@NotNull Project project, @NotNull DasDataSource system, @NotNull String content, @NotNull NotificationType type, @Nullable String path) {
        if (project == null) {
            ImportHead.$$$reportNull$$$0(21);
        }
        if (system == null) {
            ImportHead.$$$reportNull$$$0(22);
        }
        if (content == null) {
            ImportHead.$$$reportNull$$$0(23);
        }
        if (type == null) {
            ImportHead.$$$reportNull$$$0(24);
        }
        Notification notification = path == null ? DbUIUtil.createNotification(system, content, type) : DbUIUtil.createFileLinkNotification(project, system, content, type, path);
        if (notification == null) {
            ImportHead.$$$reportNull$$$0(25);
        }
        return notification;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportHead";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistics";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertedCount";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorNotification";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeSpent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpeed";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 6: 
            case 7: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutInputError";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getStatistics";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSpeed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

