/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandleErrorTask
implements Runnable {
    public static final List<ErrorRecord> POISON = ContainerUtil.emptyList();
    private final Project myProject;
    private final BlockingQueue<List<ErrorRecord>> myErrorQueue;
    private final ImportInfo myInfo;
    private boolean myInit;
    private Writer myWriter;
    private volatile boolean myStopped;

    public HandleErrorTask(@NotNull Project project, @NotNull BlockingQueue<List<ErrorRecord>> errorQueue, @NotNull ImportInfo info) {
        if (project == null) {
            HandleErrorTask.$$$reportNull$$$0(0);
        }
        if (errorQueue == null) {
            HandleErrorTask.$$$reportNull$$$0(1);
        }
        if (info == null) {
            HandleErrorTask.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myErrorQueue = errorQueue;
        this.myInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            List<ErrorRecord> records;
            while ((records = this.getNextError()) != POISON) {
                if (!this.init()) {
                    return;
                }
                ContainerUtil.sort(records);
                for (ErrorRecord record : records) {
                    this.myWriter.append(record.getMessage().trim()).append(System.lineSeparator());
                }
            }
            this.stop();
        }
        catch (IOException e) {
            DbUIUtil.createNotification((DasDataSource)Objects.requireNonNull(this.myInfo.getContext().getDataSource()), "Can't access file while processing error records.", NotificationType.ERROR).notify(this.myProject);
        }
        finally {
            this.closeWriter();
            this.finish();
        }
    }

    protected void closeWriter() {
        try {
            if (this.myWriter != null) {
                this.myWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void finish() {
        if (this.isStopped()) {
            return;
        }
        this.stop();
        this.myErrorQueue.clear();
    }

    private void stop() {
        this.myStopped = true;
    }

    @NotNull
    private List<ErrorRecord> getNextError() {
        List<ErrorRecord> list;
        try {
            list = this.myErrorQueue.take();
        }
        catch (InterruptedException e) {
            List<ErrorRecord> list2 = POISON;
            if (list2 == null) {
                HandleErrorTask.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (list == null) {
            HandleErrorTask.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean isStopped() {
        return this.myStopped;
    }

    private boolean init() throws IOException {
        if (this.myInit) {
            return true;
        }
        this.myInit = true;
        Writer writer = this.myInfo.getErrorTaskInfo().getErrorRecordsWriter();
        if (writer == null) {
            return false;
        }
        this.myWriter = new BufferedWriter(writer);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorQueue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/HandleErrorTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/HandleErrorTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ErrorTaskInfo {
        private final ThrowableComputable<Writer, IOException> myErrorRecordsWriterComputable;
        private final String myErrorRecordsPath;

        public ErrorTaskInfo(@NotNull ThrowableComputable<Writer, IOException> errorRecordsComputable, @Nullable String path) {
            if (errorRecordsComputable == null) {
                ErrorTaskInfo.$$$reportNull$$$0(0);
            }
            this.myErrorRecordsWriterComputable = errorRecordsComputable;
            this.myErrorRecordsPath = path;
        }

        @Nullable
        public String getErrorRecordsPath() {
            return this.myErrorRecordsPath;
        }

        @Nullable
        public Writer getErrorRecordsWriter() throws IOException {
            return (Writer)this.myErrorRecordsWriterComputable.compute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorRecordsComputable", "com/intellij/database/dbimport/HandleErrorTask$ErrorTaskInfo", "<init>"));
        }
    }
}

