/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GridSortingModelImpl<Row, Column>
implements GridSortingModel<Row, Column> {
    private boolean mySortingEnabled;
    private List<RowSortOrder<ModelIndex<Column>>> myOrdering = ContainerUtil.emptyList();
    private final EventDispatcher<GridSortingModel.Listener> myEventDispatcher = EventDispatcher.create(GridSortingModel.Listener.class);

    @Override
    public boolean isSortingEnabled() {
        return this.mySortingEnabled;
    }

    @Override
    public void setSortingEnabled(boolean enabled) {
        this.mySortingEnabled = enabled;
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    @Override
    public void setOrdering(@NotNull List<RowSortOrder<ModelIndex<Column>>> ordering) {
        if (ordering == null) {
            GridSortingModelImpl.$$$reportNull$$$0(0);
        }
        this.myOrdering = new ArrayList<RowSortOrder<ModelIndex<Column>>>(ordering);
        ((GridSortingModel.Listener)this.myEventDispatcher.getMulticaster()).orderingChanged();
    }

    @Override
    @NotNull
    public List<RowSortOrder<ModelIndex<Column>>> getOrdering() {
        return this.isSortingEnabled() ? new ArrayList<RowSortOrder<ModelIndex<Column>>>(this.myOrdering) : new SmartList();
    }

    @Override
    public void addListener(@NotNull GridSortingModel.Listener l, @NotNull Disposable disposable2) {
        if (l == null) {
            GridSortingModelImpl.$$$reportNull$$$0(1);
        }
        if (disposable2 == null) {
            GridSortingModelImpl.$$$reportNull$$$0(2);
        }
        this.myEventDispatcher.addListener((EventListener)l, disposable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ordering";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/GridSortingModelImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setOrdering";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

