/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.Disposable;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridListModelBase<Row, Column>
implements GridModel<Row, Column> {
    private final EventDispatcher<GridModel.Listener> myDispatcher = EventDispatcher.create(GridModel.Listener.class);
    private List<Column> myColumns;
    private final List<Row> myRows;
    private boolean myUpdatingNow;

    public GridListModelBase() {
        this(new ArrayList(), new ArrayList());
    }

    public GridListModelBase(List<Column> columns, List<Row> rows) {
        this.myColumns = columns;
        this.myRows = rows;
    }

    @Override
    @Nullable
    public Object getValueAt(ModelIndex<Row> rowIdx, ModelIndex<Column> columnIdx) {
        Row row = this.getRow(rowIdx);
        Column column = this.getColumn(columnIdx);
        return row != null && column != null ? this.getValueAt(row, column) : null;
    }

    @Override
    @Nullable
    public Row getRow(@NotNull ModelIndex<Row> row) {
        if (row == null) {
            GridListModelBase.$$$reportNull$$$0(0);
        }
        return this.getRow(row.asInteger());
    }

    @Override
    @Nullable
    public Column getColumn(@NotNull ModelIndex<Column> column) {
        if (column == null) {
            GridListModelBase.$$$reportNull$$$0(1);
        }
        return this.getColumn(column.asInteger());
    }

    @Override
    @NotNull
    public List<Row> getRows(@NotNull ModelIndexSet<Row> rows) {
        if (rows == null) {
            GridListModelBase.$$$reportNull$$$0(2);
        }
        ArrayList<Row> result = new ArrayList<Row>(rows.size());
        for (int rowIndex : rows.asArray()) {
            result.add(this.getRow(rowIndex));
        }
        ArrayList<Row> arrayList = result;
        if (arrayList == null) {
            GridListModelBase.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Column> getColumns(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(4);
        }
        List list = this.getColumnsAsIterable(columns).toList();
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public JBIterable<Column> getColumnsAsIterable(@NotNull ModelIndexSet<Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(6);
        }
        JBIterable jBIterable = columns.asIterable().transform(this::getColumn);
        if (jBIterable == null) {
            GridListModelBase.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBIterable<Column> getColumnsAsIterable() {
        JBIterable jBIterable = JBIterable.from((Iterable)ContainerUtil.immutableList(this.myColumns));
        if (jBIterable == null) {
            GridListModelBase.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<Column> getColumns() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myColumns);
        if (immutableList == null) {
            GridListModelBase.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public List<Row> getRows() {
        ImmutableList immutableList = ContainerUtil.immutableList(this.myRows);
        if (immutableList == null) {
            GridListModelBase.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public ModelIndexSet<Column> getColumnIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forColumns(this, GridListModelBase.range(0, this.getColumnCount()));
        if (modelIndexSet == null) {
            GridListModelBase.$$$reportNull$$$0(11);
        }
        return modelIndexSet;
    }

    @Override
    @NotNull
    public ModelIndexSet<Row> getRowIndices() {
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows(this, GridListModelBase.range(0, this.getRowCount()));
        if (modelIndexSet == null) {
            GridListModelBase.$$$reportNull$$$0(12);
        }
        return modelIndexSet;
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.size();
    }

    @Override
    public int getRowCount() {
        return this.myRows.size();
    }

    @Override
    public boolean isUpdatingNow() {
        return this.myUpdatingNow;
    }

    @Override
    public boolean isValidRowIdx(@NotNull ModelIndex<Row> rowIdx) {
        if (rowIdx == null) {
            GridListModelBase.$$$reportNull$$$0(13);
        }
        return GridListModelBase.isValidIdx(this.myRows, rowIdx.asInteger());
    }

    @Override
    public boolean isValidColumnIdx(@NotNull ModelIndex<Column> columnIdx) {
        if (columnIdx == null) {
            GridListModelBase.$$$reportNull$$$0(14);
        }
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx.asInteger());
    }

    @Override
    public void addListener(@NotNull GridModel.Listener<Row, Column> l, @NotNull Disposable disposable2) {
        if (l == null) {
            GridListModelBase.$$$reportNull$$$0(15);
        }
        if (disposable2 == null) {
            GridListModelBase.$$$reportNull$$$0(16);
        }
        this.myDispatcher.addListener(l, disposable2);
    }

    @Nullable
    protected abstract Object getValueAt(@NotNull Row var1, @NotNull Column var2);

    protected abstract void setValueAt(@NotNull Row var1, @NotNull Column var2, @Nullable Object var3);

    protected abstract boolean rowsEqual(@NotNull Row var1, @NotNull Row var2);

    void setUpdatingNow(boolean updatingNow) {
        this.myUpdatingNow = updatingNow;
    }

    void setValueAt(@NotNull ModelIndexSet<Row> rowIndices, @NotNull ModelIndexSet<Column> columnIndices, @Nullable Object value2) {
        if (rowIndices == null) {
            GridListModelBase.$$$reportNull$$$0(17);
        }
        if (columnIndices == null) {
            GridListModelBase.$$$reportNull$$$0(18);
        }
        int[] rows = rowIndices.asArray();
        int[] columns = columnIndices.asArray();
        if (!GridListModelBase.areAllIndicesValid(this.myRows, rows) || !GridListModelBase.areAllIndicesValid(this.myColumns, columns)) {
            return;
        }
        for (int row : rows) {
            for (int column : columns) {
                this.setValueAt(Objects.requireNonNull(this.getRow(row)), Objects.requireNonNull(this.getColumn(column)), value2);
            }
        }
        this.cellsUpdated(rows, columns);
    }

    void setValueAt(@NotNull ModelIndex<Row> row, @NotNull ModelIndex<Column> column, @Nullable Object value2) {
        if (row == null) {
            GridListModelBase.$$$reportNull$$$0(19);
        }
        if (column == null) {
            GridListModelBase.$$$reportNull$$$0(20);
        }
        int rowId = row.asInteger();
        int colId = column.asInteger();
        if (!GridListModelBase.areAllIndicesValid(this.myRows, rowId) || !GridListModelBase.areAllIndicesValid(this.myColumns, colId)) {
            return;
        }
        this.setValueAt(Objects.requireNonNull(this.getRow(rowId)), Objects.requireNonNull(this.getColumn(colId)), value2);
        this.cellUpdated(rowId, colId);
    }

    void setRows(int firstRowIndex, @NotNull List<? extends Row> rows) {
        if (rows == null) {
            GridListModelBase.$$$reportNull$$$0(21);
        }
        int firstChangedRowIndex = -1;
        int rowsUpdated = 0;
        for (int i2 = firstRowIndex; i2 < this.myRows.size() && rowsUpdated < rows.size(); ++i2, ++rowsUpdated) {
            Row oldRow = this.myRows.get(i2);
            Row newRow = rows.get(rowsUpdated);
            this.myRows.set(i2, newRow);
            if (this.rowsEqual(oldRow, newRow)) {
                if (firstChangedRowIndex != -1) {
                    this.cellsUpdated(GridListModelBase.range(firstChangedRowIndex, i2 - firstChangedRowIndex), GridListModelBase.range(0, this.getColumnCount()));
                }
                firstChangedRowIndex = -1;
                continue;
            }
            if (firstChangedRowIndex != -1) continue;
            firstChangedRowIndex = i2;
        }
        if (firstChangedRowIndex != -1) {
            this.cellsUpdated(GridListModelBase.range(firstChangedRowIndex, firstRowIndex + rowsUpdated - firstChangedRowIndex), GridListModelBase.range(0, this.getColumnCount()));
        }
        this.addRows(ContainerUtil.subList(rows, (int)rowsUpdated));
        this.afterRowsAdded();
    }

    private void afterRowsAdded() {
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).afterRowsAdded();
    }

    void addRows(@NotNull List<? extends Row> rows) {
        if (rows == null) {
            GridListModelBase.$$$reportNull$$$0(22);
        }
        int firstRow = this.myRows.size();
        this.myRows.addAll(rows);
        this.rowsAdded(GridListModelBase.range(firstRow, rows.size()));
    }

    void removeRows(@NotNull ModelIndexSet<Row> rowIndices) {
        if (rowIndices == null) {
            GridListModelBase.$$$reportNull$$$0(23);
        }
        GridListModelBase.remove(this.myRows, rowIndices, (Consumer<int[]>)((Consumer)this::rowsRemoved));
    }

    void removeRows(int firstRowIndex, int rowCount) {
        GridListModelBase.removeRange(this.myRows, firstRowIndex, rowCount);
        this.rowsRemoved(GridListModelBase.range(firstRowIndex, rowCount));
    }

    void setColumns(@NotNull List<? extends Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(24);
        }
        int oldColumnCount = this.getColumnCount();
        int newColumnCount = columns.size();
        this.myColumns = new ArrayList<Column>(newColumnCount);
        this.columnsRemoved(GridListModelBase.range(0, oldColumnCount));
        this.myColumns.addAll(columns);
        this.columnsAdded(GridListModelBase.range(0, newColumnCount));
    }

    void setColumns(int firstColumnIndex, @NotNull List<? extends Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(25);
        }
        this.removeColumns(firstColumnIndex, Math.min(this.myColumns.size() - firstColumnIndex, columns.size()));
        this.addColumns(columns);
    }

    void removeColumns(@NotNull ModelIndexSet<Column> columnIndices) {
        if (columnIndices == null) {
            GridListModelBase.$$$reportNull$$$0(26);
        }
        GridListModelBase.remove(this.myColumns, columnIndices, (Consumer<int[]>)((Consumer)this::columnsRemoved));
    }

    void removeColumns(int firstColumnIndex, int columnCount) {
        GridListModelBase.removeRange(this.myColumns, firstColumnIndex, columnCount);
        this.columnsRemoved(GridListModelBase.range(firstColumnIndex, columnCount));
    }

    void addColumns(@NotNull List<? extends Column> columns) {
        if (columns == null) {
            GridListModelBase.$$$reportNull$$$0(27);
        }
        int oldColumnCount = this.getColumnCount();
        this.myColumns.addAll(columns);
        this.columnsAdded(GridListModelBase.range(oldColumnCount, columns.size()));
    }

    private void cellUpdated(int row, int column) {
        this.cellsUpdated(new int[]{row}, new int[]{column});
    }

    private void cellsUpdated(int[] rows, int[] columns) {
        if (rows.length == 0 || columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).cellsUpdated(ModelIndexSet.forRows(this, rows), ModelIndexSet.forColumns(this, columns));
    }

    private void rowsAdded(int ... rows) {
        if (rows.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsAdded(ModelIndexSet.forRows(this, rows));
    }

    private void rowsRemoved(int ... rows) {
        if (rows.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).rowsRemoved(ModelIndexSet.forRows(this, rows));
    }

    private void columnsAdded(int ... columns) {
        if (columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsAdded(ModelIndexSet.forColumns(this, columns));
    }

    private void columnsRemoved(int ... columns) {
        if (columns.length == 0) {
            return;
        }
        ((GridModel.Listener)this.myDispatcher.getMulticaster()).columnsRemoved(ModelIndexSet.forColumns(this, columns));
    }

    private Row getRow(int rowIdx) {
        return GridListModelBase.isValidIdx(this.myRows, rowIdx) ? (Row)this.myRows.get(rowIdx) : null;
    }

    private Column getColumn(int columnIdx) {
        return GridListModelBase.isValidIdx(this.myColumns, columnIdx) ? (Column)this.myColumns.get(columnIdx) : null;
    }

    private static boolean isValidIdx(@NotNull List<?> list, int idx) {
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(28);
        }
        return idx > -1 && idx < list.size();
    }

    private static boolean areAllIndicesValid(@NotNull List<?> list, int ... indices) {
        if (list == null) {
            GridListModelBase.$$$reportNull$$$0(29);
        }
        for (int idx : indices) {
            if (GridListModelBase.isValidIdx(list, idx)) continue;
            return false;
        }
        return true;
    }

    private static int[] range(int first2, int length) {
        int[] range = new int[length];
        for (int i2 = 0; i2 < length; ++i2) {
            range[i2] = first2 + i2;
        }
        return range;
    }

    private static void removeRange(List<?> list, int firstIdx, int count2) {
        for (int i2 = 0; i2 < count2; ++i2) {
            list.remove(firstIdx + count2 - i2 - 1);
        }
    }

    private static void remove(List<?> items, ModelIndexSet<?> indexSet, Consumer<int[]> removedRangeConsumer) {
        int[] indicesArray = indexSet.asArray();
        Arrays.sort(indicesArray);
        int contiguousRangeEndIdx = indicesArray.length;
        for (int i2 = indicesArray.length - 2; i2 >= -1; --i2) {
            int contiguousRangeStartIdx = i2 + 1;
            int firstInRange = indicesArray[contiguousRangeStartIdx];
            if (i2 >= 0 && indicesArray[i2] + 1 == firstInRange) continue;
            int count2 = contiguousRangeEndIdx - contiguousRangeStartIdx;
            GridListModelBase.removeRange(items, firstInRange, count2);
            removedRangeConsumer.consume((Object)GridListModelBase.range(firstInRange, count2));
            contiguousRangeEndIdx = contiguousRangeStartIdx;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridListModelBase";
                break;
            }
            case 4: 
            case 6: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIdx";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowIndices";
                break;
            }
            case 18: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIndices";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridListModelBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnsAsIterable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnIndices";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getColumn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getColumnsAsIterable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidRowIdx";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isValidColumnIdx";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setValueAt";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setRows";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeRows";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeColumns";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addColumns";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isValidIdx";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "areAllIndicesValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

