/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.connection.audit.AdvancedAuditService;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteSavepoint;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.Version;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseConnection {
    @NotNull
    public ConnectionRequestor getRequestor();

    @NotNull
    public AdvancedAuditService getAuditService();

    @NotNull
    public DatabaseConnectionPoint getConnectionPoint();

    @Nullable
    public RemoteDatabaseMetaData getRemoteMetaData() throws SQLException;

    @NotNull
    public RemoteConnection getRemoteConnection();

    @NotNull
    public ConsoleRunConfiguration getConfiguration();

    public void setAutoCommit(boolean var1) throws SQLException;

    public boolean getAutoCommit() throws SQLException;

    public void setReadOnly(boolean var1) throws SQLException;

    public boolean isReadOnly() throws SQLException;

    public void rollback() throws SQLException;

    public void rollback(@NotNull RemoteSavepoint var1) throws SQLException;

    public void releaseSavepoint(@NotNull RemoteSavepoint var1);

    public RemoteSavepoint setSavepoint() throws SQLException;

    @NotNull
    public Dbms getDbms();

    @NotNull
    public Version getVersion();

    @NotNull
    public Version getDriverVersion();

    public void commit() throws SQLException;
}

