/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceSshPanel;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DataSourceTestConnectionPanel;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshSslPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final DataSourceConfigurable myDialog;
    private JBScrollPane myRoot;
    private JBCheckBox myUseSSLJBCheckBox;
    private JPanel mySslPanel;
    private LinkLabel<?> mySslCopyFrom;
    private TextFieldWithBrowseButton myCaCertFileField;
    private TextFieldWithBrowseButton myClientCertFileField;
    private TextFieldWithBrowseButton myClientKeyFileField;
    private DataSourceSshPanel mySshPanel;
    private DataSourceTestConnectionPanel myTestConnectionPanel;
    private ComboBox<JdbcSettings.SslMode> myModeBox;

    public DataSourceSshSslPanel(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull DataSourceConfigurable dialog2) {
        if (project == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(1);
        }
        if (dialog2 == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource2;
        this.myDialog = dialog2;
        this.$$$setupUI$$$();
        this.myModeBox.setModel((ComboBoxModel)new CollectionComboBoxModel(Arrays.asList(JdbcSettings.SslMode.values())));
        this.myModeBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JdbcSettings.SslMode>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JdbcSettings.SslMode> list, JdbcSettings.SslMode value2, int index2, boolean selected, boolean hasFocus) {
                SimpleTextAttributes attrs;
                JdbcHelper helper;
                Object[] supportedModes;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean isSupported = (supportedModes = (helper = DbImplUtil.getJdbcHelper(DataSourceSshSslPanel.this.myDataSource.getDbms())).supportedSslModes()) != null && ArrayUtil.contains((Object)value2, (Object[])supportedModes);
                SimpleTextAttributes simpleTextAttributes = attrs = isSupported && DataSourceSshSslPanel.this.myModeBox.isEnabled() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
                if (value2 == JdbcSettings.SslMode.REQUIRE) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.require", (Object[])new Object[0]), attrs);
                } else if (value2 == JdbcSettings.SslMode.VERIFY_CA) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.verify.ca", (Object[])new Object[0]), attrs);
                } else if (value2 == JdbcSettings.SslMode.VERIFY_FULL) {
                    this.append(DatabaseBundle.message((String)"ssl.mode.full", (Object[])new Object[0]), attrs);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/DataSourceSshSslPanel$1", "customizeCellRenderer"));
            }
        });
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        this.reset(this.myDataSource);
        this.myUseSSLJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshSslPanel.this.updateSslPanel();
            }
        });
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.ca", (Object[])new Object[0]), this.myCaCertFileField);
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.cert", (Object[])new Object[0]), this.myClientCertFileField);
        this.addActionListener(DatabaseBundle.message((String)"ssl.choose.key", (Object[])new Object[0]), this.myClientKeyFileField);
        this.updateSslPanel();
    }

    public void updateSslPanel() {
        UIUtil.setEnabled((Component)this.mySslPanel, (boolean)this.myUseSSLJBCheckBox.isSelected(), (boolean)true);
        this.mySslCopyFrom.setVisible(this.myUseSSLJBCheckBox.isSelected());
    }

    private void addActionListener(String title, TextFieldWithBrowseButton field) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, false, false);
        field.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(title, "", (ComponentWithBrowseButton)field, null, descriptor, (TextComponentAccessor)new TextComponentAccessor<JTextField>(){

            public String getText(JTextField component) {
                String text2 = TEXT_FIELD_WHOLE_TEXT.getText((Component)component);
                return StringUtil.isEmpty((String)text2) ? DataSourceSshSslPanel.this.getDefaultText() : text2;
            }

            public void setText(JTextField component, @NotNull String text2) {
                if (text2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                TEXT_FIELD_WHOLE_TEXT.setText((Component)component, text2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/DataSourceSshSslPanel$3", "setText"));
            }
        }));
    }

    private String getDefaultText() {
        String text2 = this.myCaCertFileField.getText();
        if (StringUtil.isEmpty((String)text2)) {
            text2 = this.myClientCertFileField.getText();
        }
        if (StringUtil.isEmpty((String)text2)) {
            text2 = this.myClientKeyFileField.getText();
        }
        return text2;
    }

    @NotNull
    protected JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myRoot;
        if (jBScrollPane == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(3);
        }
        return jBScrollPane;
    }

    @NotNull
    public DataSourceTestConnectionPanel getTestConnectionPanel() {
        DataSourceTestConnectionPanel dataSourceTestConnectionPanel = this.myTestConnectionPanel;
        if (dataSourceTestConnectionPanel == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(4);
        }
        return dataSourceTestConnectionPanel;
    }

    private void createUIComponents() {
        this.myTestConnectionPanel = new DataSourceTestConnectionPanel(this.myDialog);
        this.mySshPanel = new DataSourceSshPanel(this.myProject, this.myDataSource, this.myDialog){

            @Override
            protected LocalDataSource getActualDataSource(LocalDataSource dataSource2) {
                DataSourceConfigurable configurable = DataSourceSshSslPanel.this.myDialog.getController().getConfigurable(dataSource2, false, DataSourceConfigurable.class);
                return configurable != null ? configurable.getTempDataSourceForConnection() : super.getActualDataSource(dataSource2);
            }

            @Override
            @Nullable
            protected Pair<String, String> getActualHostPort() {
                String url = DataSourceSshSslPanel.this.myDialog.getUrl();
                DatabaseDriver driver = DataSourceSshSslPanel.this.myDialog.getDriver();
                return url == null || driver == null ? null : JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), url, null);
            }
        };
        this.mySslCopyFrom = DataSourceSshPanel.createLabel(this.myProject, (Condition<LocalDataSource>)((Condition)ds -> ds != this.myDataSource && ds.getSslCfg() != null), (Consumer<? super LocalDataSource>)((Consumer)dataSource2 -> {
            DataSourceSslConfiguration ssl = dataSource2.getSslCfg();
            if (ssl == null) {
                return;
            }
            DataSourceSslConfiguration cfg = new DataSourceSslConfiguration(ssl.myCaCertPath, ssl.myClientCertPath, ssl.myClientKeyPath, true, ssl.myMode);
            this.setupFromSslCfg(cfg);
        }), "No data sources with SSL");
    }

    private void setupFromSslCfg(@Nullable DataSourceSslConfiguration ssl) {
        if (ssl == null) {
            return;
        }
        this.myUseSSLJBCheckBox.setSelected(ssl.myEnabled);
        this.myCaCertFileField.setText(ssl.myCaCertPath);
        this.myClientCertFileField.setText(ssl.myClientCertPath);
        this.myClientKeyFileField.setText(ssl.myClientKeyPath);
        this.myModeBox.setSelectedItem((Object)ssl.myMode);
    }

    public void reset(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(5);
        }
        this.mySshPanel.reset(ds);
        this.setupFromSslCfg(ds.getSslCfg());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean enforceCredentials) {
        if (ds == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(6);
        }
        this.mySshPanel.saveData(ds, enforceCredentials);
        DataSourceSslConfiguration newSsl = this.getSslCfg();
        if (ds.getSslCfg() != null || !newSsl.isEmpty()) {
            ds.setSslCfg(newSsl.isEmpty() ? null : newSsl);
        }
    }

    @NotNull
    public DataSourceSslConfiguration getSslCfg() {
        return new DataSourceSslConfiguration(this.getCaCertFilePath(), this.getClientCertFilePath(), this.getClientKeyFilePath(), this.getUseSsl(), this.getMode());
    }

    @NotNull
    public String getCaCertFilePath() {
        String string = this.myCaCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getClientCertFilePath() {
        String string = this.myClientCertFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getClientKeyFilePath() {
        String string = this.myClientKeyFileField.getText();
        if (string == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean getUseSsl() {
        return this.myUseSSLJBCheckBox.isSelected();
    }

    @NotNull
    public JdbcSettings.SslMode getMode() {
        JdbcSettings.SslMode sslMode = (JdbcSettings.SslMode)ObjectUtils.notNull((Object)((JdbcSettings.SslMode)this.myModeBox.getSelectedItem()), (Object)JdbcSettings.SslMode.VERIFY_CA);
        if (sslMode == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(10);
        }
        return sslMode;
    }

    @NotNull
    public DataSourceSshPanel getSshPanel() {
        DataSourceSshPanel dataSourceSshPanel = this.mySshPanel;
        if (dataSourceSshPanel == null) {
            DataSourceSshSslPanel.$$$reportNull$$$0(11);
        }
        return dataSourceSshPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBScrollPane jBScrollPane;
        this.createUIComponents();
        this.myRoot = jBScrollPane = new JBScrollPane();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel2);
        TitledSeparator titledSeparator = new TitledSeparator();
        jPanel2.add((Component)titledSeparator, new GridConstraints(1, 0, 1, 4, 0, 1, 3, 0, null, null, null, 0, true));
        this.myUseSSLJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.use.ssl.label"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.mySslPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.ca.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.cert.label"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myCaCertFileField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        this.myClientCertFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        this.myClientKeyFileField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 3, 0, 1, 6, 0, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.key.label"));
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshSslPanel.class).getString("data.source.ssl.mode.label"));
        jPanel.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, true));
        this.myModeBox = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(3, 1, 1, 3, 8, 0, 2, 0, null, null, null));
        LinkLabel<?> linkLabel = this.mySslCopyFrom;
        linkLabel.setText("Copy from...");
        linkLabel.setVerticalAlignment(1);
        jPanel2.add((Component)linkLabel, new GridConstraints(2, 1, 1, 3, 4, 0, 0, 0, null, null, null, 0, true));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        jPanel2.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 4, 0, 1, 3, 0, null, null, null, 0, true));
        DataSourceSshPanel dataSourceSshPanel = this.mySshPanel;
        JComponent jComponent = dataSourceSshPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(0, 0, 1, 4, 0, 3, 7, 0, null, null, null));
        DataSourceTestConnectionPanel dataSourceTestConnectionPanel = this.myTestConnectionPanel;
        JComponent jComponent2 = dataSourceTestConnectionPanel.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent2, new GridConstraints(5, 0, 1, 4, 0, 3, 3, 7, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton3);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel3.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshSslPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestConnectionPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaCertFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientCertFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientKeyFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSshPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

