/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.session;

import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSessionLogView;
import com.intellij.database.console.session.DatabaseSessionStateListener;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.audit.AuditService;
import com.intellij.database.dataSource.srcStorage.DbSrcExtensions;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.TxMarkerAuditor;
import com.intellij.database.run.session.LogViewOwner;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.messages.Topic;
import icons.DatabaseIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\bf\u0018\u0000 .2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007:\u0002./J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH&J\u0010\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH&J\u0018\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0000H&R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0012\u0010\u0018\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017R\u0012\u0010\u0019\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u001fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010\"\u001a\u00020#X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00060"}, d2={"Lcom/intellij/database/console/session/DatabaseSession;", "Lcom/intellij/database/run/session/VisibleSession;", "Lcom/intellij/database/dataSource/LocalDataSource;", "Lcom/intellij/database/console/session/DatabaseSessionLogView;", "Lcom/intellij/database/datagrid/DataRequest$TxIsolationOwner;", "Lcom/intellij/database/run/TxMarkerAuditor$TxMarkerHolder;", "Lcom/intellij/database/run/session/LogViewOwner;", "Lcom/intellij/openapi/util/UserDataHolder;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/AuditService;", "getAuditService", "()Lcom/intellij/database/dataSource/connection/audit/AuditService;", "clients", "", "Lcom/intellij/database/console/client/DatabaseSessionClient;", "getClients", "()[Lcom/intellij/database/console/client/DatabaseSessionClient;", "clientsWithFile", "Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "getClientsWithFile", "()[Lcom/intellij/database/console/client/DatabaseSessionClientWithFile;", "isConnected", "", "()Z", "isInternal", "isService", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/database/console/session/DatabaseSession$State;", "getState", "()Lcom/intellij/database/console/session/DatabaseSession$State;", "title", "", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "attach", "", "client", "detach", "exchange", "to", "Companion", "State", "intellij.database.impl"})
public interface DatabaseSession
extends VisibleSession<LocalDataSource, DatabaseSession, DatabaseSessionLogView>,
DataRequest.TxIsolationOwner,
TxMarkerAuditor.TxMarkerHolder,
LogViewOwner,
UserDataHolder {
    public static final Companion Companion = com.intellij.database.console.session.DatabaseSession$Companion.$$INSTANCE;

    @NotNull
    public AuditService getAuditService();

    @NotNull
    public DatabaseSessionClient[] getClients();

    @NotNull
    public DatabaseSessionClientWithFile[] getClientsWithFile();

    @NotNull
    public Project getProject();

    public boolean isInternal();

    public boolean isService();

    public boolean isConnected();

    @NotNull
    public State getState();

    @NotNull
    public String getTitle();

    public void setTitle(@NotNull String var1);

    public void attach(@NotNull DatabaseSessionClient var1);

    public void detach(@NotNull DatabaseSessionClient var1);

    public void exchange(@NotNull DatabaseSessionClient var1, @NotNull DatabaseSession var2);

    @NotNull
    public static Topic<DatabaseSessionStateListener> getTopic() {
        return Companion.getTopic();
    }

    @JvmStatic
    @NotNull
    public static Icon getIcon(@NotNull DatabaseSession session2) {
        return Companion.getIcon(session2);
    }

    @JvmStatic
    @NotNull
    public static Icon getIcon(boolean connected) {
        return Companion.getIcon(connected);
    }

    @JvmStatic
    @NotNull
    public static String getTitle(@NotNull Project project, @NotNull VirtualFile file) {
        return Companion.getTitle(project, file);
    }

    @JvmStatic
    @NotNull
    public static String getClientTitle(@NotNull Project project, @NotNull VirtualFile file) {
        return Companion.getClientTitle(project, file);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0004\u0019\u001a\u001b\u001cJ\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000eH&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0004R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$State;", "", "isEmpty", "", "()Z", "isFinalized", "isIdle", "startTime", "", "getStartTime", "()J", "timeSpentMs", "getTimeSpentMs", "work", "", "Lcom/intellij/database/console/session/DatabaseSession$State$Work;", "getWork", "()Ljava/util/List;", "getMostRecentWork", "requests", "Lcom/intellij/database/datagrid/DataRequest;", "getWorkFor", "request", "owner", "Lcom/intellij/database/datagrid/DataRequest$Owner;", "Work", "WorkState", "WorkStatus", "WorkStatusType", "intellij.database.impl"})
    public static interface State {
        public boolean isIdle();

        public boolean isEmpty();

        public long getStartTime();

        @NotNull
        public List<Work> getWork();

        public long getTimeSpentMs();

        public boolean isFinalized();

        @Nullable
        public Work getWorkFor(@NotNull DataRequest.Owner var1);

        @Nullable
        public Work getWorkFor(@NotNull DataRequest var1);

        @Nullable
        public Work getMostRecentWork(@NotNull List<? extends DataRequest> var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$State$Work;", "", "request", "Lcom/intellij/database/datagrid/DataRequest;", "getRequest", "()Lcom/intellij/database/datagrid/DataRequest;", "state", "Lcom/intellij/database/console/session/DatabaseSession$State$WorkState;", "getState", "()Lcom/intellij/database/console/session/DatabaseSession$State$WorkState;", "status", "Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatus;", "getStatus", "()Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatus;", "timeSpentMs", "", "getTimeSpentMs", "()J", "intellij.database.impl"})
        public static interface Work {
            public long getTimeSpentMs();

            @NotNull
            public DataRequest getRequest();

            @NotNull
            public WorkState getState();

            @NotNull
            public WorkStatus getStatus();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$State$WorkState;", "", "(Ljava/lang/String;I)V", "SUBMITTED", "RUNNING", "FINISHED", "intellij.database.impl"})
        public static final class WorkState
        extends Enum<WorkState> {
            public static final /* enum */ WorkState SUBMITTED;
            public static final /* enum */ WorkState RUNNING;
            public static final /* enum */ WorkState FINISHED;
            private static final /* synthetic */ WorkState[] $VALUES;

            static {
                WorkState[] workStateArray = new WorkState[3];
                WorkState[] workStateArray2 = workStateArray;
                workStateArray[0] = SUBMITTED = new WorkState();
                workStateArray[1] = RUNNING = new WorkState();
                workStateArray[2] = FINISHED = new WorkState();
                $VALUES = workStateArray;
            }

            public static WorkState[] values() {
                return (WorkState[])$VALUES.clone();
            }

            public static WorkState valueOf(String string) {
                return Enum.valueOf(WorkState.class, string);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatusType;", "", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;ILjavax/swing/Icon;)V", "getIcon", "()Ljavax/swing/Icon;", "SUCCESS", "WARNING", "ERROR", "UNKNOWN", "intellij.database.impl"})
        public static final class WorkStatusType
        extends Enum<WorkStatusType> {
            public static final /* enum */ WorkStatusType SUCCESS;
            public static final /* enum */ WorkStatusType WARNING;
            public static final /* enum */ WorkStatusType ERROR;
            public static final /* enum */ WorkStatusType UNKNOWN;
            private static final /* synthetic */ WorkStatusType[] $VALUES;
            @Nullable
            private final Icon icon;

            static {
                WorkStatusType[] workStatusTypeArray = new WorkStatusType[4];
                WorkStatusType[] workStatusTypeArray2 = workStatusTypeArray;
                workStatusTypeArray[0] = SUCCESS = new WorkStatusType(AllIcons.RunConfigurations.TestPassed);
                workStatusTypeArray[1] = WARNING = new WorkStatusType(AllIcons.General.Warning);
                workStatusTypeArray[2] = ERROR = new WorkStatusType(AllIcons.RunConfigurations.TestError);
                workStatusTypeArray[3] = UNKNOWN = new WorkStatusType(null);
                $VALUES = workStatusTypeArray;
            }

            @Nullable
            public final Icon getIcon() {
                return this.icon;
            }

            private WorkStatusType(Icon icon) {
                this.icon = icon;
            }

            public static WorkStatusType[] values() {
                return (WorkStatusType[])$VALUES.clone();
            }

            public static WorkStatusType valueOf(String string) {
                return Enum.valueOf(WorkStatusType.class, string);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatus;", "", "description", "", "getDescription", "()Ljava/lang/String;", "errorNavigator", "Lcom/intellij/database/datagrid/DataRequest$CoupledWithEditor$ErrorNavigator;", "getErrorNavigator", "()Lcom/intellij/database/datagrid/DataRequest$CoupledWithEditor$ErrorNavigator;", "type", "Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatusType;", "getType", "()Lcom/intellij/database/console/session/DatabaseSession$State$WorkStatusType;", "intellij.database.impl"})
        public static interface WorkStatus {
            @NotNull
            public WorkStatusType getType();

            @Nullable
            public String getDescription();

            @Nullable
            public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0004H\u0002J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/session/DatabaseSession$Companion;", "", "()V", "connectedIcon", "Ljavax/swing/Icon;", "icon", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/console/session/DatabaseSessionStateListener;", "topic$annotations", "getTopic", "()Lcom/intellij/util/messages/Topic;", "getClientTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "session", "Lcom/intellij/database/console/session/DatabaseSession;", "connected", "", "getProgressIcon", "getTitle", "trimExtension", "intellij.database.impl"})
    public static final class Companion {
        @NotNull
        private static final Topic<DatabaseSessionStateListener> topic;
        private static final Icon icon;
        private static final Icon connectedIcon;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        public static /* synthetic */ void topic$annotations() {
        }

        @NotNull
        public final Topic<DatabaseSessionStateListener> getTopic() {
            return topic;
        }

        @JvmStatic
        @NotNull
        public final Icon getIcon(@NotNull DatabaseSession session2) {
            Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
            return SessionsUtil.needToShowProgress(session2) ? this.getProgressIcon() : this.getIcon(session2.isConnected());
        }

        @JvmStatic
        @NotNull
        public final Icon getIcon(boolean connected) {
            return connected ? connectedIcon : icon;
        }

        @JvmStatic
        @NotNull
        public final String getTitle(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.getTitle(project, file, true);
        }

        @JvmStatic
        @NotNull
        public final String getClientTitle(@NotNull Project project, @NotNull VirtualFile file) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return this.getTitle(project, file, false);
        }

        private final String getTitle(Project project, VirtualFile file, boolean trimExtension) {
            String string;
            if (DbConsoleRootType.isConsoleFile(file)) {
                String string2 = file.getNameWithoutExtension();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.nameWithoutExtension");
            } else if (DbSrcUtils.isDbSrcFile(file)) {
                string = DbSrcExtensions.FilePresentation.getEditorTabTitle(project, file, false);
                if (string == null) {
                    String string3 = file.getName();
                    string = string3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"file.name");
                }
            } else if (file instanceof DatabaseElementVirtualFileImpl) {
                String string4 = DatabaseElementVirtualFileImpl.getEditorTabTitleImpl(project, (DatabaseElementVirtualFileImpl)file, false);
                string = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"DatabaseElementVirtualFi\u2026mpl(project, file, false)");
            } else {
                String string5 = JdbcConsole.getTitle(project, file);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"JdbcConsole.getTitle(project, file)");
                String title = string5;
                String string6 = trimExtension ? FileUtilRt.getNameWithoutExtension((String)title) : title;
                string = string6;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"if (trimExtension) FileU\u2026tension(title) else title");
            }
            return string;
        }

        private final Icon getProgressIcon() {
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)animatedIcon, (String)"AnimatedIcon.Default.INSTANCE");
            return (Icon)animatedIcon;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            Topic topic = Topic.create((String)"database session state topic", DatabaseSessionStateListener.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)topic, (String)"Topic.create(\"database s\u2026tateListener::class.java)");
            com.intellij.database.console.session.DatabaseSession$Companion.topic = topic;
            Icon icon = DatabaseIcons.Connector;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"DatabaseIcons.Connector");
            com.intellij.database.console.session.DatabaseSession$Companion.icon = icon;
            Icon icon2 = ExecutionUtil.getLiveIndicator((Icon)com.intellij.database.console.session.DatabaseSession$Companion.icon);
            Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"ExecutionUtil.getLiveIndicator(icon)");
            connectedIcon = icon2;
        }
    }
}

