/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.runConfiguration;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationOptions;
import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfigurationType;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfigurationScriptProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/database/console/runConfiguration/DatabaseScriptRunConfiguration;", "()V", "createConfigurationFromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "findExistingConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getSelectedFiles", "", "", "isConfigurationFromContext", "", "configuration", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij.database.impl"})
public final class DatabaseScriptRunConfigurationScriptProducer
extends LazyRunConfigurationProducer<DatabaseScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return DatabaseScriptRunConfigurationType.Companion.getInstance().getConfigurationFactories()[0];
    }

    @Nullable
    public ConfigurationFromContext createConfigurationFromContext(@NotNull ConfigurationContext context) {
        ConfigurationFromContext configurationFromContext;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ConfigurationFromContext configurationFromContext2 = super.createConfigurationFromContext(context);
        if (configurationFromContext2 != null) {
            ConfigurationFromContext configurationFromContext3 = configurationFromContext2;
            boolean bl = false;
            boolean bl2 = false;
            ConfigurationFromContext $this$apply = configurationFromContext3;
            boolean bl3 = false;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = $this$apply.getConfigurationSettings();
            Intrinsics.checkExpressionValueIsNotNull((Object)runnerAndConfigurationSettings, (String)"configurationSettings");
            runnerAndConfigurationSettings.setEditBeforeRun(true);
            configurationFromContext = configurationFromContext3;
        } else {
            configurationFromContext = null;
        }
        return configurationFromContext;
    }

    protected boolean setupConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
            List<String> list = this.getSelectedFiles(context);
            if (list == null) {
                return false;
            }
            List<String> selectedFiles = list;
            DatabaseScriptRunConfigurationOptions databaseScriptRunConfigurationOptions = configuration.getOptions();
            boolean bl = false;
            boolean bl2 = false;
            DatabaseScriptRunConfigurationOptions $this$apply = databaseScriptRunConfigurationOptions;
            boolean bl3 = false;
            $this$apply.setMode(DatabaseScriptRunConfigurationOptions.Mode.FILE);
            $this$apply.setFiles(CollectionsKt.toMutableList((Collection)selectedFiles));
            configuration.setGeneratedName();
            PsiElement psiElement = (PsiElement)sourceElement.get();
            if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) break block1;
            databaseScriptRunConfigurationOptions = psiElement;
            bl = false;
            bl2 = false;
            DatabaseScriptRunConfigurationOptions it2 = databaseScriptRunConfigurationOptions;
            boolean bl4 = false;
            sourceElement.set((Object)it2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getSelectedFiles(ConfigurationContext context) {
        List files;
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] data;
        Condition<VirtualFile> condition = DbSqlUtil.SQL_FILE_FILTER(context.getProject());
        Intrinsics.checkExpressionValueIsNotNull(condition, (String)"DbSqlUtil.SQL_FILE_FILTER(context.project)");
        Condition<VirtualFile> isSql = condition;
        VirtualFile[] virtualFileArray = (VirtualFile[])LangDataKeys.VIRTUAL_FILE_ARRAY.getData(context.getDataContext());
        if (virtualFileArray == null) {
            return null;
        }
        VirtualFile[] $this$mapNotNull$iv = data = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var12_12 = $this$forEach$iv$iv$iv;
        int n = ((void)var12_12).length;
        for (int j = 0; j < n; ++j) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var12_12[j];
            boolean bl = false;
            void file = element$iv$iv;
            boolean bl2 = false;
            void var20_20 = file;
            Condition<VirtualFile> condition2 = isSql;
            boolean bl3 = false;
            boolean bl4 = false;
            void p1 = var20_20;
            boolean bl5 = false;
            Object object = condition2.value((Object)p1) ? var20_20 : null;
            if ((object != null ? object.getPath() : null) == null) continue;
            string = string;
            boolean bl6 = false;
            boolean bl7 = false;
            String it$iv$iv = string;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = files = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl9 = false;
        List it2 = list;
        boolean bl10 = false;
        Collection collection = it2;
        boolean bl11 = false;
        return !collection.isEmpty() ? list : null;
    }

    public boolean isConfigurationFromContext(@NotNull DatabaseScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        DatabaseScriptRunConfigurationOptions options = configuration.getOptions();
        List<String> list = this.getSelectedFiles(context);
        if (list == null) {
            return false;
        }
        List<String> selectedFiles = list;
        return options.getMode() == DatabaseScriptRunConfigurationOptions.Mode.FILE && selectedFiles.size() == options.getFiles().size() && selectedFiles.containsAll((Collection)options.getFiles());
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull ConfigurationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Project project = context.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.Companion.getInstance(project).getSelectedConfiguration();
        if (runnerAndConfigurationSettings != null) {
            DatabaseScriptRunConfiguration rc;
            RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
            boolean bl = false;
            boolean bl2 = false;
            RunnerAndConfigurationSettings cur = runnerAndConfigurationSettings2;
            boolean bl3 = false;
            RunConfiguration runConfiguration = cur.getConfiguration();
            if (!(runConfiguration instanceof DatabaseScriptRunConfiguration)) {
                runConfiguration = null;
            }
            if ((rc = (DatabaseScriptRunConfiguration)runConfiguration) != null && this.isConfigurationFromContext(rc, context)) {
                return cur;
            }
        }
        return super.findExistingConfiguration(context);
    }
}

