/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.Dbms;
import com.intellij.database.console.ConnectionTimer;
import com.intellij.database.console.ConnectionTimerLauncher;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeepAliveActionDescriptor
implements ConnectionTimer.ActionDescriptor {
    private final Map<Dbms, String> myQueries = new HashMap<Dbms, String>();

    @Override
    public long getTimeout(@NotNull ConnectionTimerLauncher launcher) {
        if (launcher == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(0);
        }
        return (long)launcher.getDataSource().getKeepAliveTimeout() * 1000L;
    }

    @Override
    public boolean isEnabled(@NotNull ConnectionTimerLauncher launcher) {
        if (launcher == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(1);
        }
        return launcher.getDataSource().isKeepAlive();
    }

    @Override
    @NotNull
    public Runnable action(@NotNull ConnectionTimerLauncher launcher) {
        if (launcher == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(2);
        }
        return new KeepAliveAction(launcher, this.myQueries);
    }

    @NotNull
    public static String getKeepAliveQuery(@NotNull Project project, @NotNull LocalDataSource source) {
        String configuredQuery;
        if (project == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(3);
        }
        if (source == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(4);
        }
        String string = StringUtil.isEmptyOrSpaces((String)(configuredQuery = KeepAliveActionDescriptor.getConfiguredQuery(source))) ? KeepAliveActionDescriptor.generateQuery(project, source) : configuredQuery;
        if (string == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static String getConfiguredQuery(@NotNull LocalDataSource source) {
        DatabaseDriverImpl driver;
        if (source == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(6);
        }
        return (driver = (DatabaseDriverImpl)source.getDatabaseDriver()) == null ? null : driver.getKeepAliveQuery();
    }

    @NotNull
    private static String generateQuery(@NotNull Project project, @NotNull LocalDataSource source) {
        if (project == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(7);
        }
        if (source == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(8);
        }
        String string = ((ExecutionEnvironmentHelper)ExecutionEnvironmentHelper.EP.forDbms(source.getDbms())).getKeepAliveQuery(project, source);
        if (string == null) {
            KeepAliveActionDescriptor.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/KeepAliveActionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/KeepAliveActionDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeepAliveQuery";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTimeout";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "action";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeepAliveQuery";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredQuery";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateQuery";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class KeepAliveAction
    implements Runnable {
        private final ConnectionTimerLauncher myLauncher;
        private final Map<Dbms, String> myQueries;

        KeepAliveAction(@NotNull ConnectionTimerLauncher launcher, @NotNull Map<Dbms, String> queries) {
            if (launcher == null) {
                KeepAliveAction.$$$reportNull$$$0(0);
            }
            if (queries == null) {
                KeepAliveAction.$$$reportNull$$$0(1);
            }
            this.myLauncher = launcher;
            this.myQueries = queries;
        }

        @Override
        public void run() {
            DatabaseConnection connection2 = this.myLauncher.getConnection();
            if (connection2 == null) {
                return;
            }
            String query = this.getKeepAliveQuery();
            try {
                SmartStatements.poweredBy(connection2).simple(Configuration.sourced(SmartStatements.Source.SYSTEM)).barren().quiet().execute(query);
            }
            finally {
                this.myLauncher.launch();
            }
        }

        @NotNull
        private String getKeepAliveQuery() {
            LocalDataSource dataSource2 = this.myLauncher.getDataSource();
            String query = KeepAliveActionDescriptor.getConfiguredQuery(dataSource2);
            if (!StringUtil.isEmptyOrSpaces((String)query)) {
                String string = query;
                if (string == null) {
                    KeepAliveAction.$$$reportNull$$$0(2);
                }
                return string;
            }
            Dbms dbms = dataSource2.getDbms();
            String string = this.myQueries.computeIfAbsent(dbms, d2 -> {
                Project project = this.myLauncher.getProject();
                return KeepAliveActionDescriptor.generateQuery(project, dataSource2);
            });
            if (string == null) {
                KeepAliveAction.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "launcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queries";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/KeepAliveActionDescriptor$KeepAliveAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/KeepAliveActionDescriptor$KeepAliveAction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeepAliveQuery";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

