/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import icons.DatabaseIcons;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbConsoleRootType
extends ConsoleRootType {
    private static final String FILE_PREFIX = "console";

    DbConsoleRootType() {
        super("db", "Database Consoles");
    }

    @NotNull
    public static DbConsoleRootType getInstance() {
        DbConsoleRootType dbConsoleRootType = (DbConsoleRootType)DbConsoleRootType.findByClass(DbConsoleRootType.class);
        if (dbConsoleRootType == null) {
            DbConsoleRootType.$$$reportNull$$$0(0);
        }
        return dbConsoleRootType;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource2;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(1);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(2);
        }
        return (dataSource2 = DbConsoleRootType.getDataSource(project, file)) != null ? (DbConsoleRootType.isMongo(project, file) ? (Language)ObjectUtils.notNull((Object)ScriptModelUtil.getJSLanguage(), (Object)PlainTextLanguage.INSTANCE) : DbSqlUtil.getSqlDialect((DbElement)dataSource2)) : null;
    }

    public static boolean isMongo(@NotNull Project project, @NotNull VirtualFile file) {
        DbDataSource dataSource2;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(3);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(4);
        }
        return (dataSource2 = DbConsoleRootType.getDataSource(project, file)) != null && dataSource2.getDbms().isMongo();
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(5);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(6);
        }
        DbDataSource dataSource2 = DbConsoleRootType.getDataSource(project, file);
        if (file.isDirectory() && !Comparing.equal((Object)file, (Object)DbConsoleRootType.getDataSourceRoot(file))) {
            return null;
        }
        return dataSource2 != null ? dataSource2.getIcon() : DatabaseIcons.Sql;
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(7);
        }
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(8);
        }
        String name = file.isDirectory() ? file.getName() : file.getNameWithoutExtension();
        DbDataSource dataSource2 = DbConsoleRootType.getDataSource(project, file);
        if (dataSource2 == null) {
            return null;
        }
        String uniqueId = Objects.requireNonNull(dataSource2.getUniqueId());
        if (file.isDirectory()) {
            return name.equals(uniqueId) ? dataSource2.getName() : name;
        }
        String rootPath = this.getContentRootPath(uniqueId);
        String relativeDir = StringUtil.trimStart((String)PathUtil.getParentPath((String)file.getPath()), (String)rootPath);
        String s1 = FileUtilRt.toSystemDependentName((String)StringUtil.trimStart((String)StringUtil.trimEnd((String)(relativeDir + "/" + FileUtilRt.getNameWithoutExtension((String)file.getName()).replace(uniqueId, dataSource2.getName()).replace("/console_", "/").replace("/console", "/")), (String)"/"), (String)"/"));
        return s1.isEmpty() ? dataSource2.getName() : s1 + " [" + dataSource2.getName() + "]";
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DbConsoleRootType.$$$reportNull$$$0(10);
        }
    }

    public void fileClosed(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            DbConsoleRootType.$$$reportNull$$$0(11);
        }
        if (source == null) {
            DbConsoleRootType.$$$reportNull$$$0(12);
        }
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element2) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(13);
        }
        if (element2 == null) {
            DbConsoleRootType.$$$reportNull$$$0(14);
        }
        return DbConsoleRootType.getDataSource(project, element2) == null;
    }

    public void registerTreeUpdater(@NotNull Project project, @NotNull Disposable disposable2, @NotNull Runnable onUpdate) {
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(15);
        }
        if (disposable2 == null) {
            DbConsoleRootType.$$$reportNull$$$0(16);
        }
        if (onUpdate == null) {
            DbConsoleRootType.$$$reportNull$$$0(17);
        }
        project.getMessageBus().connect(disposable2).subscribe(DbPsiFacade.TOPIC, o -> onUpdate.run());
    }

    @NotNull
    public String getEntrySeparator() {
        return "\n;-- -. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(18);
        }
        String string = id + "/" + FILE_PREFIX;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getContentRootPath(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(20);
        }
        String string = ScratchFileService.getInstance().getRootPath((RootType)this) + "/" + id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id) {
        if (id == null) {
            DbConsoleRootType.$$$reportNull$$$0(22);
        }
        String string = id;
        if (string == null) {
            DbConsoleRootType.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getDefaultFileExtension() {
        return "sql";
    }

    @Nullable
    public static VirtualFile getDataSourceRoot(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            DbConsoleRootType.$$$reportNull$$$0(24);
        }
        ScratchFileService service = ScratchFileService.getInstance();
        DbConsoleRootType rootType = DbConsoleRootType.getInstance();
        VirtualFile o1 = null;
        VirtualFile o2 = null;
        for (VirtualFile o = virtualFile; o != null; o = o.getParent()) {
            if (service.getRootType(o) != rootType) {
                return o2;
            }
            o2 = o1;
            o1 = o;
        }
        return null;
    }

    @Nullable
    public static DbDataSource getDataSource(@NotNull Project project, @NotNull VirtualFile original) {
        String uuid;
        if (project == null) {
            DbConsoleRootType.$$$reportNull$$$0(25);
        }
        if (original == null) {
            DbConsoleRootType.$$$reportNull$$$0(26);
        }
        return (uuid = DbConsoleRootType.getDataSourceId(original)) == null ? null : DbPsiFacade.getInstance((Project)project).findDataSource(uuid);
    }

    @Nullable
    public static String getDataSourceId(@NotNull VirtualFile original) {
        VirtualFile rootDir;
        if (original == null) {
            DbConsoleRootType.$$$reportNull$$$0(27);
        }
        if ((rootDir = DbConsoleRootType.getDataSourceRoot(original)) == null) {
            return null;
        }
        String name = rootDir.getNameWithoutExtension();
        return name.substring(0, Math.min(36, name.length()));
    }

    public static boolean isConsoleFile(@Nullable VirtualFile file) {
        return ScratchFileService.findRootType((VirtualFile)file) instanceof DbConsoleRootType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onUpdate";
                break;
            }
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/DbConsoleRootType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPathName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryPathName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "substituteLanguage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMongo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "substituteName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileClosed";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerTreeUpdater";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getContentPathName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContentRootPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getHistoryPathName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceRoot";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getDataSource";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

