/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.pg;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.PgConfigurationBase;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.restore.pg.PsqlArguments;
import com.intellij.database.cli.restore.pg.PsqlArgumentsGroup;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsqlConfiguration
extends PgConfigurationBase {
    public static final PsqlConfiguration INSTANCE = new PsqlConfiguration();

    private PsqlConfiguration() {
        super(PsqlArgumentsGroup.values(), CommonPgArguments.FILE, "PSQL_RESTORE_CONFIGURATION", "psql");
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        return "psql";
    }

    @Override
    @Nullable
    public String getDefaultSearchPath() {
        String path = super.getDefaultSearchPath();
        return path == null ? null : path + File.separator + "psql";
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map2 = super.getInfoMap();
        PsqlConfiguration.put(map2, "Zero byte for record separator", PsqlArguments.RECORD_SEPARATOR_ZERO);
        PsqlConfiguration.put(map2, "Zero byte for field separator", PsqlArguments.FIELD_SEPARATOR_ZERO);
        PsqlConfiguration.put(map2, "Print all queries", PsqlArguments.ECHO_QUERIES);
        PsqlConfiguration.put(map2, "Single-step mode", PsqlArguments.SINGLE_STEP);
        PsqlConfiguration.put(map2, "Show help", PsqlArguments.HELP);
        PsqlConfiguration.put(map2, "Single-line mode", PsqlArguments.SINGLE_LINE);
        PsqlConfiguration.put(map2, "Print queries generated by backslash commands", PsqlArguments.ECHO_HIDDEN);
        PsqlConfiguration.put(map2, "Do not use readline", PsqlArguments.NO_READLINE);
        PsqlConfiguration.put(map2, "Don't print columns, row count, etc", PsqlArguments.TUPLES_ONLY);
        PsqlConfiguration.put(map2, "Don't read start-up file", PsqlArguments.NO_PSQLRC);
        PsqlConfiguration.put(map2, "Print all input lines", PsqlArguments.ECHO_ALL);
        PsqlConfiguration.put(map2, "Unaligned output", PsqlArguments.NO_ALIGN);
        PsqlConfiguration.put(map2, "Expanded formatting mode", PsqlArguments.EXPANDED);
        PsqlConfiguration.put(map2, "Quiet mode", PsqlArguments.QUIET);
        PsqlConfiguration.put(map2, "Html output", PsqlArguments.HTML);
        PsqlConfiguration.put(map2, "List all databases", PsqlArguments.LIST);
        PsqlConfiguration.put(map2, "Record separator", PsqlArguments.RECORD_SEPARATOR);
        PsqlConfiguration.put(map2, "Field separator", PsqlArguments.FIELD_SEPARATOR);
        PsqlConfiguration.put(map2, "Options for <table> tag", PsqlArguments.TABLE_ATTRIBUTES);
        PsqlConfiguration.put(map2, "Echo failed commands", PsqlArguments.ECHO_ERRORS);
        PsqlConfiguration.put(map2, "Variable assignment", PsqlArguments.VARIABLE);
        PsqlConfiguration.put(map2, "Additionally write output into file", PsqlArguments.LOG_FILE);
        PsqlConfiguration.put(map2, "Command to execute", PsqlArguments.COMMAND);
        PsqlConfiguration.put(map2, "Write output into file", PsqlArguments.OUTPUT);
        PsqlConfiguration.put(map2, "Printing options", PsqlArguments.PSET);
        Map<String, String> map3 = map2;
        if (map3 == null) {
            PsqlConfiguration.$$$reportNull$$$0(0);
        }
        return map3;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        return new SimpleCliDialogValidator(CommonPgArguments.FILE, CommonPgArguments.PASSWORD);
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.RESTORE;
        if (operation == null) {
            PsqlConfiguration.$$$reportNull$$$0(1);
        }
        return operation;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().filter((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource || e.getKind() == ObjectKind.DATABASE)).requireNotEmpty().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            PsqlConfiguration.$$$reportNull$$$0(2);
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            PsqlConfiguration.$$$reportNull$$$0(3);
        }
        return new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/restore/pg/PsqlConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsPreparer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/restore/pg/PsqlConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCliBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName) {
            if (processor == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            if (operation == null) {
                MyBuilder.$$$reportNull$$$0(2);
            }
            if (name == null) {
                MyBuilder.$$$reportNull$$$0(3);
            }
            if (envName == null) {
                MyBuilder.$$$reportNull$$$0(4);
            }
            super(processor, project, operation, name, envName, null);
        }

        @Override
        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            if (parameterizable == null) {
                MyBuilder.$$$reportNull$$$0(5);
            }
            if (command == null) {
                MyBuilder.$$$reportNull$$$0(6);
            }
            ArrayList<CliLexeme> rawLexemes = new ArrayList<CliLexeme>(DbCliUtil.rawLexemes(command));
            List lexemes = ContainerUtil.subList(DbCliUtil.filteredLexemes(command, parameterizable), (int)1);
            CliLexeme dbLexeme = (CliLexeme)ContainerUtil.find((Iterable)lexemes, l -> l.isParameter());
            if (dbLexeme == null) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    MyBuilder.$$$reportNull$$$0(7);
                }
                return list;
            }
            CliLexeme lexeme = (CliLexeme)ContainerUtil.find(rawLexemes, (Object)dbLexeme);
            CliLexeme last = (CliLexeme)ContainerUtil.getLastItem(rawLexemes);
            if (last == null || lexeme == null || !rawLexemes.remove(lexeme)) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    MyBuilder.$$$reportNull$$$0(8);
                }
                return list;
            }
            rawLexemes.add(DbCliUtil.createLexeme((!last.isWhitespace() ? " " : "") + lexeme.getText(), false));
            List<String> list = super.getArguments(parameterizable, DbCliUtil.joinLexemes(rawLexemes));
            if (list == null) {
                MyBuilder.$$$reportNull$$$0(9);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameterizable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

