/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.CommonPgCliArguments;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PgConfigurationBase
extends CliConfigurationBase {
    protected PgConfigurationBase(CliArgumentGroup<? extends CliArgument> @NotNull [] groups, String @NotNull [] fileArgs, @NotNull String propertyKey, @NotNull String name) {
        if (propertyKey == null) {
            PgConfigurationBase.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PgConfigurationBase.$$$reportNull$$$0(1);
        }
        if (groups == null) {
            PgConfigurationBase.$$$reportNull$$$0(2);
        }
        if (fileArgs == null) {
            PgConfigurationBase.$$$reportNull$$$0(3);
        }
        super(groups, CommonPgArguments.HOST, CommonPgArguments.PORT, CommonPgArguments.USER, CommonPgArguments.PASSWORD, fileArgs, "PGPASSWORD", propertyKey, name);
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        PgConfigurationBase.put(map2, "Require names matching", CommonPgArguments.STRICT_NAMES);
        PgConfigurationBase.put(map2, "Database name", CommonPgArguments.DB_NAME);
        PgConfigurationBase.put(map2, "Concurrent jobs count", CommonPgArguments.JOBS);
        PgConfigurationBase.put(map2, "Output for generated data", CommonPgArguments.FILE);
        PgConfigurationBase.put(map2, "Off ownership commands", CommonPgArguments.NO_OWNER);
        PgConfigurationBase.put(map2, "Obsolete", CommonPgArguments.NO_RECONNECT);
        PgConfigurationBase.put(map2, "Superuser user name", CommonPgArguments.SUPERUSER);
        PgConfigurationBase.put(map2, "Verbose mode", CommonPgArguments.VERBOSE);
        PgConfigurationBase.put(map2, "Print version", CommonPgArguments.VERSION);
        PgConfigurationBase.put(map2, "Turn off grant/revoke", CommonPgArguments.NO_PRIVILEGES);
        PgConfigurationBase.put(map2, "Don't select tablespaces", "--no-tablespaces");
        PgConfigurationBase.put(map2, "Output SET SESSION AUTHORIZATION", "--use-set-session-authorization");
        PgConfigurationBase.put(map2, "Show help", CommonPgArguments.HELP);
        PgConfigurationBase.put(map2, "Host name", CommonPgArguments.HOST);
        PgConfigurationBase.put(map2, "TCP port", CommonPgArguments.PORT);
        PgConfigurationBase.put(map2, "User name", CommonPgArguments.USER);
        PgConfigurationBase.put(map2, "Restore in single transaction", CommonPgArguments.SINGLE_TX);
        PgConfigurationBase.put(map2, "Never issue a password prompt", CommonPgArguments.NO_PASSWORD);
        PgConfigurationBase.put(map2, "Force prompt password", CommonPgArguments.NO_PASSWORD);
        PgConfigurationBase.put(map2, "Role name", CommonPgArguments.ROLE);
        PgConfigurationBase.put(map2, "Set on row_security", "--enable-row-security");
        HashMap<String, String> hashMap = map2;
        if (hashMap == null) {
            PgConfigurationBase.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public LexemeIndicators getPasswordIndicators() {
        return new LexemeIndicators(CommonPgArguments.NO_PASSWORD, false, true);
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            PgConfigurationBase.$$$reportNull$$$0(5);
        }
        ContainerUtil.removeAll(variants, (Object[])CommonPgArguments.PASSWORD);
        List<String> list = variants;
        if (list == null) {
            PgConfigurationBase.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static String windowsArg(@NotNull String arg) {
        if (arg == null) {
            PgConfigurationBase.$$$reportNull$$$0(7);
        }
        Matcher matcher = Pattern.compile("(\\\\+)($|\")").matcher(arg);
        String string = matcher.replaceAll("$1$1$2");
        if (string == null) {
            PgConfigurationBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List<String> list = Arrays.asList("-f", "-F", "-j", "-n", "-S", "-t", "-T", "-d", "-h", "-p", "-U");
        if (list == null) {
            PgConfigurationBase.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @NotNull
    public CliConfiguration.CliParameterProcessor getParameterProcessor() {
        MyProcessor myProcessor = MyProcessor.INSTANCE;
        if (myProcessor == null) {
            PgConfigurationBase.$$$reportNull$$$0(10);
        }
        return myProcessor;
    }

    @Override
    @NotNull
    protected StringCliArgument getDatabaseArgument() {
        StringCliArgument stringCliArgument = CommonPgCliArguments.DATABASE;
        if (stringCliArgument == null) {
            PgConfigurationBase.$$$reportNull$$$0(11);
        }
        return stringCliArgument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileArgs";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/PgConfigurationBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/PgConfigurationBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "tweakAutocompletion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "windowsArg";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizableArguments";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tweakAutocompletion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "windowsArg";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessor
    extends CliConfigurationBase.CliParameterProcessorBase {
        static final MyProcessor INSTANCE = new MyProcessor();

        private MyProcessor() {
        }

        @Override
        @NotNull
        public String process(@NotNull CliLexeme lexeme, @NotNull String parameter) {
            if (lexeme == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            String text2 = lexeme.getText();
            boolean isTable = ArrayUtil.contains((String)text2, (String[])CommonPgArguments.TABLE);
            boolean isSchema = ArrayUtil.contains((String)text2, (String[])CommonPgArguments.SCHEMA);
            String string = isTable ? MyProcessor.processTable(parameter) : (isSchema ? MyProcessor.processSimple(super.process(lexeme, parameter)) : super.process(lexeme, parameter));
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        private static String processTable(@NotNull String parameter) {
            List list;
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(3);
            }
            if ((list = StringUtil.splitHonorQuotes((String)DbCliUtil.unescapeAll(parameter), (char)'.')).size() != 2) {
                return MyProcessor.processSimple(parameter);
            }
            String string = MyProcessor.processSimple((String)list.get(0)) + "." + MyProcessor.processSimple((String)list.get(1));
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static String processSimple(@NotNull String parameter) {
            if (parameter == null) {
                MyProcessor.$$$reportNull$$$0(5);
            }
            String unquoted = StringUtil.unquoteString((String)parameter).replaceAll("\"", "\"\"");
            String processed = SystemInfo.isWindows ? PgConfigurationBase.windowsArg(unquoted) : unquoted;
            String string = StringUtil.isQuotedString((String)parameter) || !StringUtil.equals((CharSequence)parameter, (CharSequence)StringUtil.toLowerCase((String)parameter)) ? StringUtil.wrapWithDoubleQuote((String)processed) : processed;
            if (string == null) {
                MyProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lexeme";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/cli/PgConfigurationBase$MyProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/cli/PgConfigurationBase$MyProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processTable";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processSimple";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processTable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processSimple";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

