/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.csv.CsvFileType;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.AbstractDataInputType;
import com.intellij.database.dbimport.CachedDataInputType;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportDialog;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvInputType;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.SchemaEditor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportAction
extends DumbAwareAction {
    private static final int CHAR_COUNT = 0x100000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ImportAction.$$$reportNull$$$0(0);
        }
        DbElement item = (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).single();
        e.getPresentation().setEnabledAndVisible(item != null && ImportUtil.canBeConsumer(item));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DbElement item;
        if (e == null) {
            ImportAction.$$$reportNull$$$0(1);
        }
        if ((item = (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).single()) == null) {
            return;
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, true, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, file -> ImportAction.showDialog(project, item, file));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element2, @NotNull VirtualFile file) {
        if (project == null) {
            ImportAction.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            ImportAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ImportAction.$$$reportNull$$$0(4);
        }
        VirtualFile realFile = ImportAction.getFile(file);
        FileDocumentManager.getInstance().saveAllDocuments();
        ImportAction.showDialog(project, element2, realFile.getName(), new CsvInputType(realFile, 0x100000));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element2, @NotNull String name, @NotNull InputType type) {
        if (project == null) {
            ImportAction.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            ImportAction.$$$reportNull$$$0(6);
        }
        if (name == null) {
            ImportAction.$$$reportNull$$$0(7);
        }
        if (type == null) {
            ImportAction.$$$reportNull$$$0(8);
        }
        ImportAction.showDialog(project, new ImportInfo.Builder().producerName(name).inputType(type), element2);
    }

    public static void showDialog(@NotNull Project project, @NotNull ImportInfo.Builder builder, @NotNull DbElement element2) {
        if (project == null) {
            ImportAction.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            ImportAction.$$$reportNull$$$0(10);
        }
        if (element2 == null) {
            ImportAction.$$$reportNull$$$0(11);
        }
        ErrorHandler handler = new ErrorHandler();
        Dbms dbms = DbImplUtil.getDbms(element2);
        try {
            ImportAction.showPreviewDialog(builder, dbms, element2);
        }
        catch (Exception ex) {
            handler.addError(null, ex);
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(DatabaseBundle.message((String)"action.DatabaseView.Import.title", (Object[])new Object[0]), handler.getSummary(), NotificationType.ERROR, null).notify(project);
        }
    }

    public static void showPreviewDialog(@NotNull ImportInfo.Builder builder, @NotNull Dbms dbms, @NotNull DbElement consumer2) throws Exception {
        if (builder == null) {
            ImportAction.$$$reportNull$$$0(12);
        }
        if (dbms == null) {
            ImportAction.$$$reportNull$$$0(13);
        }
        if (consumer2 == null) {
            ImportAction.$$$reportNull$$$0(14);
        }
        Disposable disposable2 = Disposer.newDisposable();
        ImportType type = ImportType.of((DasObject)consumer2);
        DatabaseEditorContext editorContext = DbRefactoringHelper.createContext((DasObject)consumer2, null, false);
        if (editorContext == null) {
            return;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        DasModel dasModel = consumer2.getDataSource().getModel();
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtil.unwrap((DasObject)DbImplUtil.getTopSingleNamespace((DasObject)consumer2)), BasicNamespace.class);
        if (namespace == null) {
            namespace = (BasicNamespace)ObjectUtils.tryCast((Object)dasModel.getCurrentRootNamespace(), BasicNamespace.class);
        }
        DeNamespace deNamespace = ImportAction.getNamespace(model, dasModel, namespace);
        boolean created = Objects.requireNonNull(type).isTableCreated();
        DatabaseEditorCapabilities.TableEditorCaps caps = SchemaEditor.forDbms(dbms).getDbEditorCaps().getTableEditorCaps(created);
        builder.importType(Objects.requireNonNull(type));
        ImportEditorContext context = new ImportEditorContext(editorContext, caps, builder, consumer2, model, disposable2, deNamespace);
        ImportPanel panel2 = builder.getInputType().getImportPanel(context);
        ImportDialog dialog2 = new ImportDialog(context, panel2);
        Disposer.register((Disposable)disposable2, (Disposable)dialog2.getDisposable());
        dialog2.show();
    }

    @NotNull
    private static VirtualFile getFile(@NotNull VirtualFile file) {
        VirtualFile root2;
        if (file == null) {
            ImportAction.$$$reportNull$$$0(15);
        }
        if ((root2 = JarFileSystem.getInstance().getJarRootForLocalFile(file)) == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                ImportAction.$$$reportNull$$$0(16);
            }
            return virtualFile;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{root2});
        VirtualFile realFile = ImportAction.find(root2.getChildren(), "csv", "txt");
        VirtualFile virtualFile = realFile == null ? file : realFile;
        if (virtualFile == null) {
            ImportAction.$$$reportNull$$$0(17);
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile find(VirtualFile @Nullable [] files, String ... extensions) {
        if (extensions == null) {
            ImportAction.$$$reportNull$$$0(18);
        }
        if (files == null) {
            return null;
        }
        for (String extension : extensions) {
            VirtualFile fileWithExtension = (VirtualFile)ContainerUtil.find((Object[])files, file -> StringUtil.equalsIgnoreCase((CharSequence)file.getExtension(), (CharSequence)extension));
            if (fileWithExtension == null || fileWithExtension.isDirectory()) continue;
            return fileWithExtension;
        }
        return (VirtualFile)ContainerUtil.find((Object[])files, file -> !file.isDirectory());
    }

    @Nullable
    private static DeNamespace getNamespace(@NotNull DeModel model, @NotNull DasModel dasModel, @Nullable BasicNamespace namespace) {
        if (model == null) {
            ImportAction.$$$reportNull$$$0(19);
        }
        if (dasModel == null) {
            ImportAction.$$$reportNull$$$0(20);
        }
        return namespace == null ? null : (DeNamespace)model.getExportHelper().exportDeep(dasModel, namespace, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportAction";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportAction";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showPreviewDialog";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ImportFileToDatabaseAction
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ImportFileToDatabaseAction.$$$reportNull$$$0(0);
            }
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            e.getPresentation().setEnabledAndVisible(file != null && file.getFileType() == CsvFileType.INSTANCE);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile realFile;
            if (e == null) {
                ImportFileToDatabaseAction.$$$reportNull$$$0(1);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            VirtualFile virtualFile = realFile = file == null ? null : ImportAction.getFile(file);
            if (realFile == null || project == null) {
                return;
            }
            ImportUtil.ChooseTargetDialog dialog2 = new ImportUtil.ChooseTargetDialog(project, null);
            if (!dialog2.showAndGet()) {
                return;
            }
            DbElement element2 = dialog2.getChosenElement();
            if (element2 == null) {
                return;
            }
            FileDocumentManager.getInstance().saveAllDocuments();
            ImportAction.showDialog(project, element2, realFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/ImportAction$ImportFileToDatabaseAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CopyTable
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyTable.$$$reportNull$$$0(0);
            }
            DbElement item = (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).single();
            e.getPresentation().setEnabledAndVisible(ImportUtil.canBeProducer(item));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbElement item;
            if (e == null) {
                CopyTable.$$$reportNull$$$0(1);
            }
            if ((item = (DbElement)DatabaseView.getSelectedElementsNoGroups(e.getDataContext(), true).single()) == null) {
                return;
            }
            DbTable producer = (DbTable)item;
            DbDataSource source = producer.getDataSource();
            LocalDataSource delegate = Objects.requireNonNull(DbImplUtil.getMaybeLocalDataSource((DasDataSource)source));
            ImportInfo.Builder builder = new ImportInfo.Builder().producerName(producer.getName()).inputType(new DatabaseInputType(delegate, source, (DasTable)producer, producer.getProject()));
            ImportUtil.ChooseTargetDialog dialog2 = new ImportUtil.ChooseTargetDialog(producer.getProject(), (DbElement)producer);
            if (!dialog2.showAndGet()) {
                return;
            }
            DbElement element2 = dialog2.getChosenElement();
            if (element2 == null) {
                return;
            }
            ImportAction.showDialog(producer.getProject(), builder, element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/actions/ImportAction$CopyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ImportTable
    extends DumbAwareAction {
        public void update(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                ImportTable.$$$reportNull$$$0(0);
            }
            String name = (grid = DataGridUtil.getDataGrid(e.getDataContext())) == null ? null : ImportTable.getProducerName(e);
            InputType type = grid == null ? null : ImportTable.getInputType(e, false);
            boolean isEmpty = grid != null && grid.getDataModel(DataAccessType.DATABASE_DATA).getColumnCount() == 0;
            boolean hasFormatIfNeeded = !(type instanceof CsvInputType) || ImportTable.getFormat(grid) != null;
            e.getPresentation().setEnabled(!isEmpty && name != null && type != null && hasFormatIfNeeded);
            e.getPresentation().setVisible(true);
            e.getPresentation().setText(type instanceof AbstractDataInputType ? DatabaseBundle.message((String)"action.Console.TableResult.ImportTable.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.FileEditor.ImportToDatabase.text", (Object[])new Object[0]));
            e.getPresentation().setDescription(type instanceof AbstractDataInputType ? DatabaseBundle.message((String)"action.Console.TableResult.ImportTable.description", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.FileEditor.ImportToDatabase.description", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DataGrid grid;
            if (e == null) {
                ImportTable.$$$reportNull$$$0(1);
            }
            if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null) {
                return;
            }
            List<DataConsumer.Column> cols = ImportUtil.getColumns(grid);
            String name = ImportTable.getProducerName(e);
            InputType type = ImportTable.getInputType(e, true);
            if (name == null || type == null) {
                return;
            }
            ImportInfo.Builder builder = new ImportInfo.Builder().producers(cols).visibleProducers(ImportUtil.getVisibleColumns(grid)).rows(ImportUtil.getRows(grid)).inputType(type).producerName(name).csvFormat(ImportTable.getFormat(grid));
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            ImportUtil.ChooseTargetDialog dialog2 = new ImportUtil.ChooseTargetDialog(Objects.requireNonNull(e.getProject()), (DbElement)ObjectUtils.tryCast((Object)table, DbElement.class));
            if (!dialog2.showAndGet()) {
                return;
            }
            DbElement element2 = dialog2.getChosenElement();
            if (element2 == null) {
                return;
            }
            ImportAction.showDialog(Objects.requireNonNull(e.getProject()), builder, element2);
        }

        @Nullable
        private static CsvFormat getFormat(@NotNull DataGrid grid) {
            CsvDocumentDataHookUp hookup;
            if (grid == null) {
                ImportTable.$$$reportNull$$$0(2);
            }
            return (hookup = (CsvDocumentDataHookUp)ObjectUtils.tryCast(grid.getDataHookup(), CsvDocumentDataHookUp.class)) == null ? null : hookup.getFormat();
        }

        @Nullable
        private static InputType getInputType(final @NotNull AnActionEvent e, final boolean allowCache) {
            if (e == null) {
                ImportTable.$$$reportNull$$$0(3);
            }
            return ImportTable.compute(e, new Computable<InputType>(){

                @Override
                public InputType csv(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new CsvInputType(file, 0x100000);
                }

                @Override
                @Nullable
                public InputType database(@Nullable DbTable table, @NotNull DataGrid grid, @Nullable JdbcConsole console) {
                    if (grid == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DbDataSource source = DataGridUtil.getDatabaseSystem(grid);
                    LocalDataSource delegate = DbImplUtil.getMaybeLocalDataSource((DasDataSource)source);
                    if (source == null || delegate == null) {
                        return null;
                    }
                    GridDataHookUp hookup = grid.getDataHookup();
                    DatabaseGridDataHookUp databaseHookUp = (DatabaseGridDataHookUp)hookup;
                    String text2 = databaseHookUp.getUnlimitedQueryText(true);
                    SearchPath path = hookup instanceof DataRequest.CustomSearchPathOwner ? ((DataRequest.CustomSearchPathOwner)((Object)hookup)).getSearchPath() : null;
                    String name = DataGridUtil.getResultSetName(e);
                    GridPagingModel pageModel = grid.getDataHookup().getPageModel();
                    GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
                    return text2 == null || name == null ? null : (allowCache && pageModel.isFirstPage() && pageModel.isLastPage() && !DumpHandler.GridHandler.hasTruncatedData(model.getColumns(), model.getRows()) ? new CachedDataInputType(source, delegate, name, this.rows(grid), (DasTable)table) : new DatabaseInputType(delegate, source, name, text2, source.getProject(), path, (DasTable)table));
                }

                @NotNull
                private List<Object[]> rows(@NotNull DataGrid grid) {
                    if (grid == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    GridModel model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
                    List rows = model.getRows();
                    List columns = model.getColumns();
                    List list = ContainerUtil.map(rows, row -> ContainerUtil.map((Collection)columns, col -> col.getValue((DataConsumer.Row)row)).toArray());
                    if (list == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "grid";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/actions/ImportAction$ImportTable$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/actions/ImportAction$ImportTable$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "rows";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "csv";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "database";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "rows";
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }

        @Nullable
        private static String getProducerName(final @NotNull AnActionEvent e) {
            if (e == null) {
                ImportTable.$$$reportNull$$$0(4);
            }
            return ImportTable.compute(e, new Computable<String>(){

                @Override
                public String csv(@NotNull VirtualFile file) {
                    if (file == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return file.getName();
                }

                @Override
                public String database(@Nullable DbTable table, @NotNull DataGrid grid, @Nullable JdbcConsole console) {
                    if (grid == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return DataGridUtil.getResultSetName(e);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "file";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "grid";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/actions/ImportAction$ImportTable$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "csv";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "database";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Nullable
        private static <T> T compute(@NotNull AnActionEvent e, @NotNull Computable<T> computable) {
            DataGrid grid;
            if (e == null) {
                ImportTable.$$$reportNull$$$0(5);
            }
            if (computable == null) {
                ImportTable.$$$reportNull$$$0(6);
            }
            if ((grid = DataGridUtil.getDataGrid(e.getDataContext())) == null || !grid.isReady()) {
                return null;
            }
            GridDataHookUp hookup = grid.getDataHookup();
            if (hookup instanceof CsvDocumentDataHookUp) {
                Document document = ((CsvDocumentDataHookUp)hookup).getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                return file == null ? null : (T)computable.csv(file);
            }
            if (!(hookup instanceof DatabaseGridDataHookUp)) {
                return null;
            }
            DbTable table = (DbTable)ObjectUtils.tryCast((Object)DataGridUtil.getDatabaseTable(grid), DbTable.class);
            JdbcConsole console = JdbcConsole.findConsole(e);
            return console == null && table == null ? null : (T)computable.database(table, grid, console);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "computable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/ImportAction$ImportTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFormat";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInputType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProducerName";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static interface Computable<T> {
            @Nullable
            public T csv(@NotNull VirtualFile var1);

            @Nullable
            public T database(@Nullable DbTable var1, @NotNull DataGrid var2, @Nullable JdbcConsole var3);
        }
    }

    public static class ImportEditorContext
    extends DatabaseEditorContext {
        private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
        private final ImportManager myManager;
        private final ImportInfo.Builder myBuilder;
        private final DbElement myElement;
        private final DeModel myDeModel;
        private final Disposable myDisposable;
        private final DeNamespace myNamespace;
        private final List<DbTable> myTables;
        private String myTableName;

        public ImportEditorContext(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull ImportInfo.Builder builder, @NotNull DbElement element2, @NotNull DeModel deModel, @NotNull Disposable disposable2, @Nullable DeNamespace namespace) {
            if (context == null) {
                ImportEditorContext.$$$reportNull$$$0(0);
            }
            if (caps == null) {
                ImportEditorContext.$$$reportNull$$$0(1);
            }
            if (builder == null) {
                ImportEditorContext.$$$reportNull$$$0(2);
            }
            if (element2 == null) {
                ImportEditorContext.$$$reportNull$$$0(3);
            }
            if (deModel == null) {
                ImportEditorContext.$$$reportNull$$$0(4);
            }
            if (disposable2 == null) {
                ImportEditorContext.$$$reportNull$$$0(5);
            }
            super(context.getProject(), context.getDbms(), context.getModel(), context.getDataSource(), context.getSearchPath(), context.getVirtualFile(), null);
            this.myCaps = caps;
            this.myManager = ImportManager.of(context.getDbms(), DbImplUtil.getDatabaseVersion((DasDataSource)this.getDataSource()));
            this.myBuilder = builder;
            this.myElement = element2;
            this.myDeModel = deModel;
            this.myDisposable = disposable2;
            this.myNamespace = namespace;
            this.myTables = this.getContextTables();
            builder.editorContext(this);
        }

        @NotNull
        public ImportInfo.Builder getBuilder() {
            ImportInfo.Builder builder = this.myBuilder;
            if (builder == null) {
                ImportEditorContext.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public DbElement getElement() {
            DbElement dbElement = this.myElement;
            if (dbElement == null) {
                ImportEditorContext.$$$reportNull$$$0(7);
            }
            return dbElement;
        }

        @NotNull
        public DeModel getDeModel() {
            DeModel deModel = this.myDeModel;
            if (deModel == null) {
                ImportEditorContext.$$$reportNull$$$0(8);
            }
            return deModel;
        }

        @Nullable
        public DeNamespace getNamespace() {
            return this.myNamespace;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable2 = this.myDisposable;
            if (disposable2 == null) {
                ImportEditorContext.$$$reportNull$$$0(9);
            }
            return disposable2;
        }

        @NotNull
        public ImportManager getManager() {
            ImportManager importManager = this.myManager;
            if (importManager == null) {
                ImportEditorContext.$$$reportNull$$$0(10);
            }
            return importManager;
        }

        @NotNull
        public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
            DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
            if (tableEditorCaps == null) {
                ImportEditorContext.$$$reportNull$$$0(11);
            }
            return tableEditorCaps;
        }

        @NotNull
        public String getTableName() {
            String string = this.myTableName == null ? (this.myTableName = this.getTableNameInternal()) : this.myTableName;
            if (string == null) {
                ImportEditorContext.$$$reportNull$$$0(12);
            }
            return string;
        }

        public boolean isTableExists(@NotNull String name) {
            if (name == null) {
                ImportEditorContext.$$$reportNull$$$0(13);
            }
            return ContainerUtil.exists(this.myTables, (Condition)DasUtil.byName((String)name));
        }

        @NotNull
        private String getTableNameInternal() {
            String name;
            if (this.myBuilder.getImportType().isTableCreated()) {
                String string = this.myElement.getName();
                if (string == null) {
                    ImportEditorContext.$$$reportNull$$$0(14);
                }
                return string;
            }
            String result = name = FileUtilRt.getNameWithoutExtension((String)this.myBuilder.getProducerName());
            int index2 = 1;
            while (this.isTableExists(result)) {
                result = name + "_" + index2++;
            }
            String string = result;
            if (string == null) {
                ImportEditorContext.$$$reportNull$$$0(15);
            }
            return string;
        }

        @NotNull
        private List<DbTable> getContextTables() {
            DasNamespace namespace = DbImplUtil.getTopSingleNamespace((DasObject)this.myElement);
            if (namespace == null || this.myElement instanceof DbTable) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    ImportEditorContext.$$$reportNull$$$0(16);
                }
                return list;
            }
            List list = ((JBTreeTraverser)DbImplUtil.traverseVisibleObjects((DasDataSource)this.myElement.getDataSource()).withRoot((Object)namespace)).filter(DbTable.class).toList();
            if (list == null) {
                ImportEditorContext.$$$reportNull$$$0(17);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caps";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deModel";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/actions/ImportAction$ImportEditorContext";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/actions/ImportAction$ImportEditorContext";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuilder";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeModel";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisposable";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManager";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCaps";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableName";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTableNameInternal";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContextTables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "isTableExists";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface InputType {
        @NotNull
        public ReaderTask.Input createInput(@NotNull ImportInfo var1) throws IOException;

        @NotNull
        default public ImportPanel getImportPanel(@NotNull ImportEditorContext context) throws Exception {
            if (context == null) {
                InputType.$$$reportNull$$$0(0);
            }
            ImportInfo.Builder builder = context.getBuilder();
            List components = ContainerUtil.filter(this.getComponents(context), component -> component.isVisible(builder));
            return new ImportPanel(components, context);
        }

        @NotNull
        public List<ImportComponent<?, ?>> getComponents(@NotNull ImportEditorContext var1) throws Exception;

        @Nullable
        public DasDataSource getProducerSystem();

        @NotNull
        public String getDialogTitle();

        @NotNull
        public Dbms getDbms();

        @NotNull
        public DeTable createNewTable(@NotNull ImportEditorContext var1, @NotNull List<? extends ColumnDescriptor> var2, @Nullable List<DataConsumer.Row> var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$InputType", "getImportPanel"));
        }
    }
}

