/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.ChangeListData;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceChangeList
implements CommittedChangeList {
    private static final Logger LOG = Logger.getInstance(PerforceChangeList.class);
    private Date myDate;
    private long myNumber;
    private String myDescription;
    private String myUser;
    private String myClient;
    private final Project myProject;
    private final P4Connection myConnection;
    private List<Change> myIdeaChanges;
    private final PerforceChangeCache myChangeCache;

    public PerforceChangeList(@NotNull ChangeListData data, Project project, @NotNull P4Connection connection, PerforceChangeCache changeCache) {
        if (data == null) {
            PerforceChangeList.$$$reportNull$$$0(0);
        }
        if (connection == null) {
            PerforceChangeList.$$$reportNull$$$0(1);
        }
        this.myChangeCache = changeCache;
        this.myUser = data.USER;
        try {
            this.myDate = data.DATE.indexOf(58) >= 0 ? ChangeListData.DATE_FORMAT.parse(data.DATE) : ChangeListData.DATE_ONLY_FORMAT.parse(data.DATE);
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
            this.myDate = new Date();
        }
        this.myNumber = data.NUMBER;
        this.myDescription = data.DESCRIPTION;
        this.myClient = data.CLIENT;
        this.myProject = project;
        this.myConnection = connection;
    }

    public PerforceChangeList(Project project, @NotNull DataInput stream, @NotNull P4Connection connection, PerforceClient perforceClient, PerforceChangeCache changeCache) throws IOException {
        if (stream == null) {
            PerforceChangeList.$$$reportNull$$$0(2);
        }
        if (connection == null) {
            PerforceChangeList.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myChangeCache = changeCache;
        this.myConnection = connection;
        this.readFromStream(stream, perforceClient);
    }

    public String getCommitterName() {
        return this.myUser;
    }

    public Date getCommitDate() {
        return this.myDate;
    }

    public Collection<Change> getChanges() {
        if (this.myIdeaChanges == null) {
            this.myIdeaChanges = this.getChangesUnder(null);
        }
        return this.myIdeaChanges;
    }

    public List<Change> getChangesUnder(@Nullable VirtualFile root) {
        ArrayList<Change> ideaChanges = new ArrayList<Change>();
        for (PerforceChange path : this.myChangeCache.getChanges(this.myConnection, this.myNumber, root)) {
            int type = path.getType();
            PerforceContentRevision beforeRevision = type == 0 || type == 5 ? null : this.createRevision(path.getDepotPath(), path.getRevision() - 1L);
            PerforceContentRevision afterRevision = type == 1 || type == 6 ? null : this.createRevision(path.getDepotPath(), path.getRevision());
            ideaChanges.add(new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision));
        }
        return ideaChanges;
    }

    private PerforceContentRevision createRevision(String depotPath, long revision) {
        return PerforceContentRevision.create(this.myProject, this.myConnection, depotPath, revision, -1L);
    }

    @NotNull
    public String getName() {
        String string = this.myDescription;
        if (string == null) {
            PerforceChangeList.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getComment() {
        return this.myDescription;
    }

    public long getNumber() {
        return this.myNumber;
    }

    @Nullable
    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return PerforceVcs.getInstance(this.myProject);
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myDescription = newMessage;
    }

    public String getClient() {
        return this.myClient;
    }

    public String toString() {
        return this.myDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceChangeList that = (PerforceChangeList)o;
        if (this.myNumber != that.myNumber) {
            return false;
        }
        if (this.myClient != null ? !this.myClient.equals(that.myClient) : that.myClient != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        return !(this.myUser != null ? !this.myUser.equals(that.myUser) : that.myUser != null);
    }

    public int hashCode() {
        int result = this.myDate != null ? this.myDate.hashCode() : 0;
        result = 31 * result + (int)(this.myNumber ^ this.myNumber >>> 32);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myUser != null ? this.myUser.hashCode() : 0);
        result = 31 * result + (this.myClient != null ? this.myClient.hashCode() : 0);
        return result;
    }

    public void writeToStream(@NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            PerforceChangeList.$$$reportNull$$$0(5);
        }
        stream.writeLong(this.myNumber);
        stream.writeLong(this.myDate.getTime());
        stream.writeUTF(this.myUser);
        stream.writeUTF(this.myClient);
        IOUtil.writeUTFTruncated((DataOutput)stream, (String)this.myDescription);
        this.myConnection.getId().writeToStream(stream);
        Collection<Change> changes = this.getChanges();
        stream.writeInt(changes.size());
        for (Change change : changes) {
            PerforceContentRevision revision = (PerforceContentRevision)change.getAfterRevision();
            if (revision == null) {
                stream.writeByte(0);
                revision = (PerforceContentRevision)change.getBeforeRevision();
                assert (revision != null);
            } else {
                stream.writeByte(change.getBeforeRevision() != null ? 1 : 2);
            }
            stream.writeLong(revision.getRevision());
            stream.writeUTF(revision.getDepotPath());
        }
    }

    private void readFromStream(@NotNull DataInput stream, PerforceClient perforceClient) throws IOException {
        if (stream == null) {
            PerforceChangeList.$$$reportNull$$$0(6);
        }
        this.myNumber = stream.readLong();
        this.myDate = new Date(stream.readLong());
        this.myUser = stream.readUTF();
        this.myClient = stream.readUTF();
        this.myDescription = stream.readUTF();
        ConnectionId.readFromStream(stream);
        int count = stream.readInt();
        this.myIdeaChanges = new ArrayList<Change>(count);
        VcsContextFactory pathService = VcsContextFactory.SERVICE.getInstance();
        for (int i = 0; i < count; ++i) {
            byte type = stream.readByte();
            long revision = stream.readLong();
            String depotPath = stream.readUTF();
            Change change = null;
            FilePath filePath = PerforceChangeList.createFilePath(depotPath, perforceClient, pathService);
            switch (type) {
                case 0: {
                    change = new Change((ContentRevision)PerforceContentRevision.create(this.myProject, depotPath, filePath, revision), null);
                    break;
                }
                case 1: {
                    change = new Change((ContentRevision)PerforceContentRevision.create(this.myProject, depotPath, filePath, revision - 1L), (ContentRevision)PerforceContentRevision.create(this.myProject, depotPath, filePath, revision));
                    break;
                }
                case 2: {
                    change = new Change(null, (ContentRevision)PerforceContentRevision.create(this.myProject, depotPath, filePath, revision));
                    break;
                }
                default: {
                    assert (false) : "Unknown p4 change type " + type;
                    break;
                }
            }
            this.myIdeaChanges.add(change);
        }
    }

    private static FilePath createFilePath(String depotPath, PerforceClient client, VcsContextFactory pathService) {
        try {
            File file = PerforceManager.getFileByDepotName(depotPath, client);
            if (file != null) {
                return pathService.createFilePathOn(file, false);
            }
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        return pathService.createFilePathOnNonLocal(depotPath, false);
    }

    @NotNull
    public P4Connection getConnection() {
        P4Connection p4Connection = this.myConnection;
        if (p4Connection == null) {
            PerforceChangeList.$$$reportNull$$$0(7);
        }
        return p4Connection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/perforce/PerforceChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/perforce/PerforceChangeList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeToStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readFromStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

