/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.PerforceAbstractChange;

public class PerforceChange
extends PerforceAbstractChange {
    private static final Logger LOG = Logger.getInstance(PerforceChange.class);
    private final String myDepotPath;
    private long myRevision;
    private final long myChangeListNumber;
    private final String myChangeListDescription;

    @Nullable
    public static PerforceChange createOn(String fileString, PerforceClient client) throws VcsException {
        return PerforceChange.createOn(fileString, client, -1L, null);
    }

    @Nullable
    public static PerforceChange createOn(String fileString, PerforceClient client, long changeListNumber, @Nullable String changeListDescription) throws VcsException {
        int typeIndex = (fileString = fileString.trim()).indexOf("#");
        if (typeIndex < 0) {
            throw new VcsException("Cannot parse change line: " + fileString);
        }
        String depotPath = fileString.substring(0, typeIndex - 1);
        File localFile = PerforceManager.getFileByDepotName(depotPath, client);
        if (localFile != null) {
            String type = fileString.substring(typeIndex + 1).trim();
            return new PerforceChange(PerforceAbstractChange.convertToType((String)type), localFile, depotPath, -1L, changeListNumber, changeListDescription);
        }
        return null;
    }

    public PerforceChange(int type, File localFile, String depotPath, long revision, long changeListNumber, String changeListDescription) {
        this.myChangeListNumber = changeListNumber;
        this.myChangeListDescription = changeListDescription;
        this.myDepotPath = depotPath;
        this.myRevision = revision;
        this.setFile(localFile);
        this.myType = type;
    }

    public long getChangeList() {
        return this.myChangeListNumber;
    }

    public String getDepotPath() {
        return this.myDepotPath;
    }

    public String getChangeListDescription() {
        return this.myChangeListDescription;
    }

    public long getRevision() {
        if (this.myRevision == -1L) {
            File file = this.getFile();
            LOG.info(new Throwable("revision == -1, type: " + this.myType + " path: " + (file == null ? null : file.getAbsolutePath())));
        }
        return this.myRevision;
    }

    @NonNls
    public String toString() {
        return "PerforceChange[" + this.myDepotPath + "," + this.myType + "]";
    }

    public void setRevision(long revision) {
        this.myRevision = revision;
    }
}

