/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.operations.P4RevertOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public class PerforceRollbackEnvironment
implements RollbackEnvironment {
    private static final Logger LOG = Logger.getInstance(PerforceRollbackEnvironment.class);
    private final Project myProject;
    private final PerforceRunner myRunner;

    public PerforceRollbackEnvironment(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    public String getRollbackOperationName() {
        String string = PerforceBundle.message((String)"operation.name.revert", (Object[])new Object[0]);
        if (string == null) {
            PerforceRollbackEnvironment.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void rollbackChanges(List<Change> changes, List<VcsException> vcsExceptions, @NotNull RollbackProgressListener listener) {
        if (listener == null) {
            PerforceRollbackEnvironment.$$$reportNull$$$0(1);
        }
        Map<Long, P4Connection> lists2Delete = this.getChangeListsToDelete(changes, vcsExceptions);
        ArrayList<VcsOperation> operations = new ArrayList<VcsOperation>();
        for (Change change : changes) {
            operations.add(new P4RevertOperation(change));
        }
        if (!VcsOperationLog.getInstance(this.myProject).runOperations(operations, "Revert", PerformInBackgroundOption.ALWAYS_BACKGROUND, vcsExceptions)) {
            return;
        }
        boolean listsChanged = false;
        for (Map.Entry<Long, P4Connection> entry : lists2Delete.entrySet()) {
            long id = entry.getKey();
            try {
                if (!this.myRunner.deleteChangeList(entry.getValue(), id, true, true, true)) continue;
                listsChanged = true;
            }
            catch (VcsException e) {
                vcsExceptions.add(e);
            }
        }
        if (listsChanged) {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }
    }

    private Map<Long, P4Connection> getChangeListsToDelete(List<Change> changes, List<VcsException> vcsExceptions) {
        LinkedHashMap<Long, P4Connection> lists2Delete = new LinkedHashMap<Long, P4Connection>();
        block2: for (LocalChangeList list : ChangeListManager.getInstance((Project)this.myProject).getChangeListsCopy()) {
            Collection reverted = list.getChanges();
            if (reverted.isEmpty() || !changes.containsAll(reverted)) continue;
            for (Change c : reverted) {
                P4Connection connection;
                FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
                if (afterPath == null || (connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(afterPath.getIOFile())) == null) continue;
                try {
                    PerforceManager.ensureValidClient(this.myProject, connection);
                }
                catch (VcsException e) {
                    vcsExceptions.add(e);
                }
                ConnectionKey key = connection.getConnectionKey();
                Long number = PerforceNumberNameSynchronizer.getInstance(this.myProject).getNumber(key, list.getName());
                if (number == null) continue block2;
                lists2Delete.put(number, connection);
                continue block2;
            }
        }
        return lists2Delete;
    }

    public void rollbackMissingFileDeletion(List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        for (FilePath file : files) {
            listener.accept(file);
            try {
                FStat fStat;
                P4File p4file = P4File.create(file);
                try {
                    fStat = p4file.getFstat(this.myProject, true);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                    continue;
                }
                if (fStat.local == FStat.LOCAL_CHECKED_OUT || fStat.local == FStat.LOCAL_INTEGRATING || fStat.local == FStat.LOCAL_ADDING) {
                    this.myRunner.revert(p4file, false);
                } else {
                    this.myRunner.sync(p4file, true);
                }
                VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(file);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    public void rollbackModifiedWithoutCheckout(List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(files, this.myProject);
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<String> paths = new ArrayList<String>();
            ArrayList<P4File> p4Files = new ArrayList<P4File>();
            for (VirtualFile file : (Collection)entry.getValue()) {
                P4File p4File = P4File.create(file);
                p4Files.add(p4File);
                paths.add(p4File.getEscapedPath());
            }
            P4Connection connection = (P4Connection)entry.getKey();
            try {
                this.myRunner.editAll(p4Files, -1L, false, connection);
                this.myRunner.revertAll(paths, connection);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    public void rollbackIfUnchanged(VirtualFile file) {
    }

    public Collection<? extends AnAction> createCustomRollbackActions() {
        return Collections.singleton(ActionManager.getInstance().getAction("RevertUnchanged"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceRollbackEnvironment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackOperationName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceRollbackEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "rollbackChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

