/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

@State(name="LastSuccessfulUpdateTracker", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class LastSuccessfulUpdateTracker
implements PersistentStateComponent<ChangesUpdateResult> {
    private final Project myProject;
    private ChangesUpdateResult myResult = new ChangesUpdateResult();
    private boolean myUpdateSuccessful;

    public static LastSuccessfulUpdateTracker getInstance(Project project) {
        return (LastSuccessfulUpdateTracker)ServiceManager.getService((Project)project, LastSuccessfulUpdateTracker.class);
    }

    public LastSuccessfulUpdateTracker(Project project) {
        this.myProject = project;
        project.getMessageBus().connect().subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
    }

    public ChangesUpdateResult getState() {
        return this.myResult;
    }

    public void loadState(@NotNull ChangesUpdateResult state) {
        if (state == null) {
            LastSuccessfulUpdateTracker.$$$reportNull$$$0(0);
        }
        this.myResult = state;
    }

    public void updateStarted() {
        this.myUpdateSuccessful = false;
    }

    public void updateSuccessful() {
        this.myUpdateSuccessful = true;
    }

    public List<PersistentChangeList> getChangeLists() {
        return this.myResult.changeLists;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/idea/perforce/application/LastSuccessfulUpdateTracker", "loadState"));
    }

    private class MyChangeListListener
    extends ChangeListAdapter {
        private MyChangeListListener() {
        }

        public void changeListUpdateDone() {
            if (LastSuccessfulUpdateTracker.this.myUpdateSuccessful && PerforceSettings.getSettings((Project)((LastSuccessfulUpdateTracker)LastSuccessfulUpdateTracker.this).myProject).ENABLED) {
                ArrayList<PersistentChangeList> results = new ArrayList<PersistentChangeList>();
                List changeLists = ChangeListManager.getInstance((Project)LastSuccessfulUpdateTracker.this.myProject).getChangeLists();
                for (LocalChangeList changeList : changeLists) {
                    PersistentChangeList persistentList = new PersistentChangeList();
                    persistentList.name = changeList.getName();
                    persistentList.files = new ArrayList<ChangedFile>();
                    results.add(persistentList);
                    for (Change c : changeList.getChanges()) {
                        ContentRevision afterRevision;
                        ChangedFile f = new ChangedFile();
                        ContentRevision beforeRevision = c.getBeforeRevision();
                        if (beforeRevision != null) {
                            f.beforePath = beforeRevision.getFile().getPath();
                        }
                        f.afterPath = (afterRevision = c.getAfterRevision()) == null ? null : afterRevision.getFile().getPath();
                        persistentList.files.add(f);
                    }
                }
                ((LastSuccessfulUpdateTracker)LastSuccessfulUpdateTracker.this).myResult.changeLists = results;
            }
        }
    }

    public static class ChangesUpdateResult {
        public List<PersistentChangeList> changeLists = new ArrayList<PersistentChangeList>();
    }

    public static class PersistentChangeList {
        public String name;
        public List<ChangedFile> files = new ArrayList<ChangedFile>();
    }

    public static class ChangedFile {
        @Attribute(value="beforePath")
        public String beforePath;
        @Attribute(value="afterPath")
        public String afterPath;
    }
}

