/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lang.Language;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.base.psi.SqlCodeBlockElementTypeImpl;
import com.intellij.sql.dialects.base.psi.SqlFunctionBodyInjector;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlLazyElementTypeImpl;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class PgGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static TokenSet create_token_set_(IElementType ... tokenTypes_) {
        TokenSet set = SqlGeneratedParserUtil.create_token_set_(tokenTypes_);
        if (set.contains((IElementType)SqlCompositeElementTypes.SQL_STATEMENT)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT})});
        } else if (set.contains((IElementType)SqlCompositeElementTypes.SQL_TABLE_EXPRESSION)) {
            set = TokenSet.orSet((TokenSet[])new TokenSet[]{set, TokenSet.create((IElementType[])new IElementType[]{SqlCompositeElementTypes.SQL_FUNCTION_CALL})});
        }
        return set;
    }

    public static boolean anyOperatorRef(PsiBuilder builder, int level) {
        PgGeneratedParserUtil.addVariant((PsiBuilder)builder, (String)"<operator>");
        SqlParser parser = PgGeneratedParserUtil.getParser(builder);
        PsiBuilder.Marker m = builder.mark();
        PgGeneratedParserUtil.parseOperatorReferenceQualifier(builder, parser, true);
        if (PgGeneratedParserUtil.getParser(builder).parseCustomOperator(builder, null, false)) {
            GeneratedParserUtilBase.ErrorState state2 = GeneratedParserUtilBase.ErrorState.get((PsiBuilder)builder);
            if (state2.currentFrame != null && state2.currentFrame.elementType != SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE) {
                m.done((IElementType)SqlCompositeElementTypes.SQL_OPERATOR_REFERENCE);
            } else {
                m.drop();
            }
            return true;
        }
        m.drop();
        return false;
    }

    private static boolean parseOperatorReferenceQualifier(PsiBuilder builder, SqlParser parser, boolean first2) {
        PsiBuilder.Marker m = builder.mark();
        if (first2 && !PgGeneratedParserUtil.parseOperatorReferenceQualifier(builder, parser, false)) {
            m.rollbackTo();
            return false;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SqlTokens.SQL_ASTERISK) && parser.parseIdentifier(builder, true) && SqlParserUtil.nextTokenIs(builder, (IElementType)SqlTokens.SQL_PERIOD)) {
            m.done((IElementType)SqlCompositeElementTypes.SQL_REFERENCE);
            SqlParserUtil.consumeToken(builder, (IElementType)SqlTokens.SQL_PERIOD);
            return true;
        }
        m.drop();
        return false;
    }

    public static boolean isPl(PsiBuilder builder, int level) {
        PgParserBase pgParser = (PgParserBase)ObjectUtils.tryCast((Object)PgGeneratedParserUtil.getParser(builder), PgParserBase.class);
        return pgParser != null && pgParser.isPlSql();
    }

    public static boolean parseSchemaPath(PsiBuilder builder, int level, boolean strict) {
        return PgGeneratedParserUtil.parseSchemaPathImpl(builder, level, strict) && PgGeneratedParserUtil.remapStatementType(builder, level, (IElementType)SqlCompositeElementTypes.SQL_USE_SCHEMA_STATEMENT);
    }

    private static boolean parseSchemaPathImpl(PsiBuilder builder, int level, boolean strict) {
        if (strict) {
            IElementType type = builder.getTokenType();
            if (type == SqlTokens.SQL_STRING_TOKEN) {
                return SqlParserUtil.advanceAsRefExpression(builder, SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE);
            }
            if (type == SqlTokens.SQL_DEFAULT) {
                return true;
            }
        } else if ("search_path".equalsIgnoreCase(Objects.requireNonNull(builder.getLatestDoneMarker()).toString().trim())) {
            return PgGeneratedParserUtil.parsePathAsSchemaList(builder, level);
        }
        return false;
    }

    public static boolean parseCodeBlockLazy(PsiBuilder builder, int level) {
        PsiBuilder.Marker m = PgGeneratedParserUtil.enter_section_((PsiBuilder)builder, (int)level, (int)0, null, null);
        PsiBuilder.Marker mm = builder.mark();
        boolean result2 = PgGeneratedParserUtil.parseCodeBodyImmediately(builder, level + 1);
        if (result2) {
            mm.collapse(PgElementTypes.Misc.PG_LAZY_CODE_BLOCK_PARENT);
        } else {
            mm.drop();
        }
        PgGeneratedParserUtil.exit_section_((PsiBuilder)builder, (int)level, (PsiBuilder.Marker)m, (boolean)result2, (boolean)result2, null);
        return result2;
    }

    public static boolean parseCodeBodyImmediately(PsiBuilder builder, int level) {
        boolean result2;
        SqlLanguageDialect dialect = PgGeneratedParserUtil.getLazyDialect(SqlLazyElementTypeImpl.getContextElement((PsiBuilder)builder));
        boolean isSqlChameleonExpand = dialect != null;
        PgParserBase p = (PgParserBase)PgGeneratedParserUtil.getParser(builder);
        IElementType lazyBlockType = p.getLazyCodeBlockType();
        boolean bl = result2 = isSqlChameleonExpand && lazyBlockType != null && PgGeneratedParserUtil.parseLazyBody(builder, level, lazyBlockType);
        if (!result2) {
            result2 = PgGeneratedParserUtil.parseString(builder, level);
        }
        return result2;
    }

    @Nullable
    public static SqlLanguageDialect getLazyDialect(PsiElement context) {
        PsiElement element;
        PsiElement cbp = SqlLazyElementTypeImpl.getContextElement((PsiElement)context);
        if (!(PsiUtilCore.getElementType((PsiElement)cbp) instanceof SqlCodeBlockElementTypeImpl)) {
            cbp = null;
        }
        cbp = PsiUtilCore.getElementType((PsiElement)cbp) instanceof SqlCodeBlockElementTypeImpl.DollarQuoted ? cbp.getParent() : cbp;
        PsiElement parent = cbp == null ? null : cbp.getParent();
        PsiElement clause = parent == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)parent.getFirstChild(), (IElementType)SqlCompositeElementTypes.SQL_LANGUAGE_CLAUSE, null);
        PsiElement psiElement = element = clause == null ? null : clause.getLastChild();
        String lang = element == null ? null : (element instanceof SqlNameElement ? ((SqlNameElement)element).getName() : (element instanceof SqlStringLiteralExpression ? ((SqlStringLiteralExpression)element).getValue() : element.getText()));
        Pair<Language, String> spec = SqlFunctionBodyInjector.getBlockByLangSpec(lang, context, (Language)SqlImplUtil.getSqlDialectSafe((PsiElement)context));
        return spec != null ? (SqlLanguageDialect)ObjectUtils.tryCast((Object)spec.first, SqlLanguageDialect.class) : null;
    }

    public static boolean parseScriptDefault(PsiBuilder builder, int level) {
        PgGeneratedParserUtil.getParser(builder).parseScriptDefault(builder);
        return true;
    }

    public static boolean parseCustomOpQuestion(PsiBuilder builder, int level) {
        return PgGeneratedParserUtil.getParser(builder).parseCustomOperator(builder, (IElementType)SqlCompositeElementTypes.SQL_REFERENCE, true);
    }

    public static boolean remapColTo(PsiBuilder builder, int level, SqlReferenceElementType ref) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker != null && marker.getTokenType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE) {
            ((PsiBuilderImpl.ProductionMarker)marker).remapTokenType((IElementType)ref);
        }
        return true;
    }

    public static boolean attachedQuestion(PsiBuilder builder, int level) {
        return PgGeneratedParserUtil.withoutSpace(builder, level) && PgGeneratedParserUtil.consumeToken((PsiBuilder)builder, (String)"?") && PgGeneratedParserUtil.getParser(builder).mergeOperatorWithQuestionMark(builder);
    }
}

