/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.code;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlDocumentationProvider;
import com.intellij.sql.dialects.oracle.actions.OraNavigationHelper;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements2, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements2 == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(2);
        }
        OraNavigationHelper navHelper = OraNavigationHelper.getInstance();
        for (PsiElement element : elements2) {
            Pair<String, JBIterable<? extends PsiObject>> defs;
            SqlDefinition def;
            if (!(element instanceof SqlReferenceExpression) || (def = (SqlDefinition)ObjectUtils.tryCast((Object)element.getParent(), SqlDefinition.class)) == null || def.getNameElement() != element) continue;
            Pair<String, JBIterable<? extends PsiObject>> supers = navHelper.findSuperDefinitions((PsiObject)def, true);
            if (supers != null) {
                result2.add(this.createSuperNavigatable(navHelper, def, (String)supers.first));
            }
            if ((defs = navHelper.findDefinitions((PsiObject)def, true)) == null) continue;
            result2.add(this.createDefsNavigatable(navHelper, def, (String)defs.first));
        }
    }

    @NotNull
    protected LineMarkerInfo<PsiElement> createSuperNavigatable(OraNavigationHelper navHelper, SqlDefinition def, String name2) {
        String actionId = "GotoSuperMethod";
        String tooltip = OraLineMarkerProvider.composeText(name2, actionId);
        SqlElement target2 = (SqlElement)ObjectUtils.notNull((Object)def.getNameElement(), (Object)def);
        LineMarkerInfo info = new LineMarkerInfo(PsiTreeUtil.getDeepestFirst((PsiElement)target2), target2.getTextRange(), AllIcons.Gutter.ImplementingMethod, Functions.constant((Object)tooltip), (e, identifier) -> {
            SqlDefinition tgt = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlDefinition.class);
            if (tgt == null) {
                return;
            }
            Pair<String, JBIterable<? extends PsiObject>> tgtSupers = navHelper.findSuperDefinitions((PsiObject)tgt, false);
            if (tgtSupers == null) {
                return;
            }
            JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])((NavigatablePsiElement[])((JBIterable)tgtSupers.second).filter(NavigatablePsiElement.class).toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY)), (String)((String)tgtSupers.first), null, (ListCellRenderer)new DefaultPsiElementCellRenderer(), null);
            if (popup != null) {
                popup.showInScreenCoordinates(e.getComponent(), e.getPoint());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)name2, (String)actionId);
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(3);
        }
        return lineMarkerInfo;
    }

    @NotNull
    protected LineMarkerInfo<PsiElement> createDefsNavigatable(OraNavigationHelper navHelper, SqlDefinition def, String name2) {
        String actionId = "GotoImplementation";
        String tooltip = OraLineMarkerProvider.composeText(name2, actionId);
        SqlElement target2 = (SqlElement)ObjectUtils.notNull((Object)def.getNameElement(), (Object)def);
        LineMarkerInfo info = new LineMarkerInfo(PsiTreeUtil.getDeepestFirst((PsiElement)target2), target2.getTextRange(), AllIcons.Gutter.ImplementedMethod, Functions.constant((Object)tooltip), (e, identifier) -> {
            SqlDefinition tgt = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlDefinition.class);
            if (tgt == null) {
                return;
            }
            Pair<String, JBIterable<? extends PsiObject>> defs = navHelper.findDefinitions((PsiObject)tgt, false);
            if (defs == null) {
                return;
            }
            JBPopup popup = PsiElementListNavigator.navigateOrCreatePopup((NavigatablePsiElement[])((NavigatablePsiElement[])((JBIterable)defs.second).filter(NavigatablePsiElement.class).toArray((Object[])NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY)), (String)((String)defs.first), null, (ListCellRenderer)new DefaultPsiElementCellRenderer(), null);
            if (popup != null) {
                popup.showInScreenCoordinates(e.getComponent(), e.getPoint());
            }
        }, GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)name2, (String)actionId);
        LineMarkerInfo lineMarkerInfo = info;
        if (lineMarkerInfo == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(4);
        }
        return lineMarkerInfo;
    }

    private static boolean isPackageOrType(SqlDefinition o) {
        ObjectKind kind = o.getKind();
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE || kind == ObjectKind.BODY;
    }

    @Nullable
    private static LineMarkerInfo<?> getNavigationMarker(@NotNull SqlIdentifier identifier, @NotNull SqlDefinition psiPackage) {
        if (identifier == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (psiPackage == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(6);
        }
        boolean hasTarget = false;
        boolean isBody = psiPackage.getKind() == ObjectKind.BODY;
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
        ObjectKind targetKind = ref == null ? psiPackage.getKind() : ref.getReferenceElementType().getTargetKind();
        for (DbElement o : SqlDocumentationProvider.findRelatedDbElements((PsiElement)psiPackage, (boolean)true)) {
            if (isBody) {
                DbElement pkg = o.getDasParent();
                hasTarget = targetKind == ObjectKind.BODY || pkg == null ? pkg != null : pkg.getDasChildren(targetKind).filter(DbSqlUtil.byName((String)identifier.getName(), (boolean)DbSqlUtil.isQuoted((SqlNameElement)identifier), null, (CasingProvider)pkg.getDataSource().getModel())).isNotEmpty();
            } else {
                hasTarget = o.getDasChildren(ObjectKind.BODY).isNotEmpty();
            }
            if (!hasTarget) continue;
            break;
        }
        if (!hasTarget) {
            return null;
        }
        Icon icon = isBody ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.ImplementedMethod;
        String text = isBody ? "Go to specification" : "Go to implementation";
        String actionId = isBody ? "GotoSuperMethod" : "GotoImplementation";
        String tooltip = OraLineMarkerProvider.composeText(text, actionId);
        LineMarkerInfo info = new LineMarkerInfo(PsiTreeUtil.getDeepestFirst((PsiElement)identifier), identifier.getTextRange(), icon, Functions.constant((Object)tooltip), (GutterIconNavigationHandler)new MyNavHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)info, (String)text, (String)actionId);
        return info;
    }

    @NotNull
    private static String composeText(@NotNull String start2, @NotNull String actionId) {
        if (start2 == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(7);
        }
        if (actionId == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(8);
        }
        Object[] shortcuts = ActionManager.getInstance().getAction(actionId).getShortcutSet().getShortcuts();
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcuts);
        String postfix = "<br><div style='margin-top: 5px'><font size='2'>Click";
        if (shortcut != null) {
            postfix = postfix + " or press " + KeymapUtil.getShortcutText((Shortcut)shortcut);
        }
        postfix = postfix + " to navigate</font></div>";
        String string = "<html><body>" + start2 + postfix + "</body></html>";
        if (string == null) {
            OraLineMarkerProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/code/OraLineMarkerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/code/OraLineMarkerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuperNavigatable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefsNavigatable";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "composeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationMarker";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "composeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNavHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private MyNavHandler() {
        }

        public void navigate(MouseEvent e, PsiElement identifier) {
            SqlDefinition definition = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlDefinition.class, (boolean)false);
            SqlCreateStatement psiPackage = (SqlCreateStatement)PsiTreeUtil.getParentOfType((PsiElement)definition, SqlCreateStatement.class, (boolean)false);
            if (psiPackage == null) {
                return;
            }
            boolean isBody = psiPackage.getKind() == ObjectKind.BODY;
            DbElement fileTarget = null;
            for (DbElement o : SqlDocumentationProvider.findRelatedDbElements((PsiElement)psiPackage, (boolean)true)) {
                fileTarget = isBody ? o.getDasParent() : (DbElement)o.getDasChildren(ObjectKind.BODY).first();
                if (fileTarget == null) continue;
                break;
            }
            if (fileTarget == null) {
                return;
            }
            VirtualFile file = DbImplUtil.findSourceVirtualFile(fileTarget, (boolean)true);
            if (file != null) {
                int offset = DatabaseTargetElementEvaluator.calcTargetOffset((Project)fileTarget.getProject(), (VirtualFile)file, (DasObject)definition);
                PsiNavigationSupport.getInstance().createNavigatable(fileTarget.getProject(), file, offset).navigate(true);
            }
        }
    }
}

