/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.cassandra.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlValuesParameterInfoHandler;
import com.intellij.sql.dialects.cassandra.psi.CassArrayLiteral;
import com.intellij.sql.dialects.cassandra.psi.CassSetOrMapLiteral;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlSetClause;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlDmlInstructionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CassCollectionLiteral
extends SqlLiteralExpressionImpl {
    public CassCollectionLiteral(@NotNull IElementType elementType) {
        if (elementType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            CassCollectionLiteral.$$$reportNull$$$0(1);
        }
        if (state2 == null) {
            CassCollectionLiteral.$$$reportNull$$$0(2);
        }
        if (place == null) {
            CassCollectionLiteral.$$$reportNull$$$0(3);
        }
        if (!this.isInsideLiteral(place)) {
            return true;
        }
        SqlTableType sqlTableType = (SqlTableType)ObjectUtils.tryCast((Object)this.getExpectedSqlType(), SqlTableType.class);
        if (sqlTableType == null) {
            return false;
        }
        SqlImplUtil.processDeclarationsInType((SqlTableType)sqlTableType, (PsiScopeProcessor)processor, (ResolveState)state2, (PsiElement)place);
        return false;
    }

    protected boolean isInsideLiteral(PsiElement place) {
        PsiElement parent = place.getParent();
        return parent == this;
    }

    @NotNull
    public SqlType getExpectedSqlType() {
        PsiElement parent = this.getParent();
        SqlSetAssignment setAssignment = null;
        if (parent instanceof SqlSetAssignment) {
            setAssignment = (SqlSetAssignment)parent;
            parent = setAssignment.getParent();
        }
        if (parent instanceof CassSetOrMapLiteral) {
            return CassCollectionLiteral.unwrapFrozenType(this.getExpectedTypeInSetOrMapLiteral((CassSetOrMapLiteral)parent, setAssignment));
        }
        if (parent instanceof CassArrayLiteral && setAssignment == null) {
            return this.getExpectedTypeInArrayLiteral((CassArrayLiteral)parent);
        }
        if (parent instanceof SqlParenthesizedExpression) {
            String colName = this.getExpectedTypeNameInParenExpr();
            if (colName != null) {
                return this.getExpectedTypeInDmlInstruction(colName);
            }
        } else if (parent instanceof SqlSetClause && setAssignment != null) {
            String name2 = setAssignment.getLValue().getName();
            if (name2 != null) {
                return this.getExpectedTypeInDmlInstruction(name2);
            }
        } else if (parent instanceof SqlBinaryExpression) {
            SqlExpression lOperand = ((SqlBinaryExpression)parent).getLOperand();
            if (!(lOperand instanceof SqlReferenceExpression)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(4);
                }
                return sqlPrimitiveType;
            }
            String colName = lOperand.getName();
            if (colName == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(5);
                }
                return sqlPrimitiveType;
            }
            if (this.getParentOfType(SqlDmlInstructionImpl.class) != null) {
                return this.getExpectedTypeInDmlInstruction(colName);
            }
            return this.getExpectedTypeInTableExpression(colName);
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(6);
        }
        return sqlPrimitiveType;
    }

    private <T extends PsiElement> T getParentOfType(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CassCollectionLiteral.$$$reportNull$$$0(7);
        }
        return (T)PsiTreeUtil.getParentOfType((PsiElement)this, aClass);
    }

    @NotNull
    private SqlType getExpectedTypeInSetOrMapLiteral(@NotNull CassSetOrMapLiteral parent, @Nullable SqlSetAssignment setAssignment) {
        SqlType parentLiteralType;
        if (parent == null) {
            CassCollectionLiteral.$$$reportNull$$$0(8);
        }
        if ((parentLiteralType = parent.getExpectedSqlType()) instanceof SqlParametrizedType && ((SqlParametrizedType)parentLiteralType).getTypeParametersCount() > 0) {
            String specification = parentLiteralType.getDataType().getSpecification();
            SqlParametrizedType parametrizedType = (SqlParametrizedType)parentLiteralType;
            if (StringUtil.startsWithIgnoreCase((String)specification, (String)"map<")) {
                if (setAssignment == null) {
                    SqlType sqlType = parametrizedType.getTypeParameter(0);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(9);
                    }
                    return sqlType;
                }
                if (setAssignment.getLValue() == this) {
                    SqlType sqlType = parametrizedType.getTypeParameter(0);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(10);
                    }
                    return sqlType;
                }
                if (setAssignment.getRValue() == this && parametrizedType.getTypeParametersCount() > 1) {
                    SqlType sqlType = parametrizedType.getTypeParameter(1);
                    if (sqlType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(11);
                    }
                    return sqlType;
                }
            } else if (parentLiteralType.getCategory() == SqlType.Category.SETOF) {
                SqlType sqlType = parametrizedType.getTypeParameter(0);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(12);
                }
                return sqlType;
            }
        } else if (parentLiteralType instanceof SqlTableType && setAssignment != null) {
            SqlTableType tableType = (SqlTableType)parentLiteralType;
            String columnName = setAssignment.getLValue().getName();
            if (columnName == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(13);
                }
                return sqlPrimitiveType;
            }
            return CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(14);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private SqlType getExpectedTypeInArrayLiteral(@NotNull CassArrayLiteral parent) {
        SqlType parentLiteralType;
        if (parent == null) {
            CassCollectionLiteral.$$$reportNull$$$0(15);
        }
        if ((parentLiteralType = parent.getExpectedSqlType()) instanceof SqlParametrizedType && ((SqlParametrizedType)parentLiteralType).getTypeParametersCount() > 0) {
            String specification = parentLiteralType.getDataType().getSpecification();
            SqlParametrizedType parametrizedType = (SqlParametrizedType)parentLiteralType;
            if (parentLiteralType.getCategory() == SqlType.Category.ARRAY) {
                SqlType sqlType = parametrizedType.getTypeParameter(0);
                if (sqlType == null) {
                    CassCollectionLiteral.$$$reportNull$$$0(16);
                }
                return sqlType;
            }
            if (StringUtil.startsWithIgnoreCase((String)specification, (String)"tuple<")) {
                List expressions = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent, SqlExpression.class);
                for (int i2 = 0; i2 < expressions.size(); ++i2) {
                    if (expressions.get(i2) != this) continue;
                    if (i2 < parametrizedType.getTypeParametersCount()) {
                        SqlType sqlType = parametrizedType.getTypeParameter(i2);
                        if (sqlType == null) {
                            CassCollectionLiteral.$$$reportNull$$$0(17);
                        }
                        return sqlType;
                    }
                    SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                    if (sqlPrimitiveType == null) {
                        CassCollectionLiteral.$$$reportNull$$$0(18);
                    }
                    return sqlPrimitiveType;
                }
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(19);
        }
        return sqlPrimitiveType;
    }

    @Nullable
    private String getExpectedTypeNameInParenExpr() {
        SqlExpressionList list = SqlValuesParameterInfoHandler.findExpressions((PsiElement)this);
        if (list == null) {
            return null;
        }
        int offset = this.getStartOffset();
        int index2 = SqlValuesParameterInfoHandler.getCurrentParameterIndex((SqlExpressionList)list, (int)offset);
        SqlDmlInstruction instruction = this.getParentOfType(SqlDmlInstruction.class);
        if (instruction == null || index2 < 0) {
            return null;
        }
        SqlTableType tableType = instruction.getTargetType();
        if (index2 >= tableType.getColumnCount()) {
            return null;
        }
        return tableType.getColumnName(index2);
    }

    @NotNull
    private SqlType getExpectedTypeInDmlInstruction(@NotNull String columnName) {
        SqlDmlInstructionImpl instruction;
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(20);
        }
        if ((instruction = this.getParentOfType(SqlDmlInstructionImpl.class)) == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(21);
            }
            return sqlPrimitiveType;
        }
        SqlTableType tableType = instruction.getTargetType();
        if (tableType == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(22);
            }
            return sqlPrimitiveType;
        }
        return CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
    }

    @NotNull
    private SqlType getExpectedTypeInTableExpression(@NotNull String columnName) {
        SqlTableExpression tableExpression;
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(23);
        }
        if ((tableExpression = this.getParentOfType(SqlTableExpression.class)) == null) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(24);
            }
            return sqlPrimitiveType;
        }
        SqlTableType tableType = tableExpression.getSqlType();
        return CassCollectionLiteral.getExpectedSqlType(tableType, columnName);
    }

    @NotNull
    private static SqlType getExpectedSqlType(@NotNull SqlTableType parentType, @NotNull String columnName) {
        if (parentType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(25);
        }
        if (columnName == null) {
            CassCollectionLiteral.$$$reportNull$$$0(26);
        }
        for (int i2 = 0; i2 < parentType.getColumnCount(); ++i2) {
            if (!columnName.equals(parentType.getColumnName(i2))) continue;
            return CassCollectionLiteral.unwrapFrozenType(parentType.getColumnType(i2));
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            CassCollectionLiteral.$$$reportNull$$$0(27);
        }
        return sqlPrimitiveType;
    }

    @NotNull
    private static SqlType unwrapFrozenType(SqlType type) {
        if (!(type instanceof SqlParametrizedType)) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(28);
            }
            return sqlType;
        }
        String specification = type.getDataType().getSpecification();
        if (!StringUtil.startsWithIgnoreCase((String)specification, (String)"frozen<")) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(29);
            }
            return sqlType;
        }
        SqlParametrizedType parametrizedType = (SqlParametrizedType)type;
        if (parametrizedType.getTypeParametersCount() < 1) {
            SqlType sqlType = type;
            if (sqlType == null) {
                CassCollectionLiteral.$$$reportNull$$$0(30);
            }
            return sqlType;
        }
        SqlType typeParameter = parametrizedType.getTypeParameter(0);
        return CassCollectionLiteral.unwrapFrozenType(typeParameter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/cassandra/psi/CassCollectionLiteral";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/cassandra/psi/CassCollectionLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedSqlType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInSetOrMapLiteral";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInArrayLiteral";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInDmlInstruction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTypeInTableExpression";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFrozenType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentOfType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInSetOrMapLiteral";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInArrayLiteral";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInDmlInstruction";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeInTableExpression";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedSqlType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

