/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;
import com.intellij.database.data.types.domain.UnknownDomain;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertDomains
extends DomainRegistry {
    private static final int MAX_FRACTION = 6;
    private static final double MAX_REAL = 1.0E37;
    private static final double MIN_REAL = -1.0E37;
    private static final double MIN_DOUBLE = -1.0E307;
    private static final double MAX_DOUBLE = 1.0E308;
    private static final int MAX_CHAR = 65000;
    private static final int MAX_LONG_VARBINARY = 32000000;
    private static final int MAX_PRECISION = 1024;

    public VertDomains() {
        this.add((Domain)new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 1024, 1024, true));
        this.add((Domain)new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, 1024, 1024, true));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add((Domain)new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add((Domain)new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 65000L, 1L, true, OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new TextDomain("bpchar", ConversionPoint.CHAR, 65000L, 1L, true, OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new TextDomain("character", ConversionPoint.CHAR, 65000L, 1L, true, OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 65000L, -1L, true, OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new TextDomain("character varying", ConversionPoint.VARCHAR, 65000L, -1L, true, OperationSupport.SUPPORTS_FTS));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new BooleanDomain("bool", ConversionPoint.BOOLEAN));
        this.add((Domain)new BinaryDomain("binary", ConversionPoint.BINARY, 65000L, -1L, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new BinaryDomain("varbinary", ConversionPoint.VARBINARY, 65000L, -1L, true, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new BinaryDomain("long varbinary", ConversionPoint.VARBINARY, 32000000L, -1L, true));
        this.add((Domain)new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new BinaryDomain("raw", ConversionPoint.BLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("long varchar", ConversionPoint.VARCHAR, 32000000L, -1L, true, OperationSupport.SUPPORTS_EQUALS));
        this.add((Domain)new MyZonedDomain(new FractionDomain("timetz", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true), "TIME"));
        this.add((Domain)new MyZonedDomain(new FractionDomain("timestamptz", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true), "timestamp"));
        this.add((Domain)new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, 6, true));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add((Domain)new MyTextLikeDomain("interval day to second", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new MyTextLikeDomain("interval year to month", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new MyTextLikeDomain("geometry", ConversionPoint.GEOMETRY, PhysicalDomainType.TEXT));
        this.add((Domain)new MyTextLikeDomain("geography", ConversionPoint.GEOGRAPHY, PhysicalDomainType.TEXT));
        this.add((Domain)new FloatDomain("float", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new UnknownDomain("interval"));
    }

    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || productVersion.less(new int[]{9});
    }

    protected static class MyTextLikeDomain
    extends TextLikeDomain {
        public MyTextLikeDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type) {
            if (name2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyTextLikeDomain.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyTextLikeDomain.$$$reportNull$$$0(2);
            }
            super(name2, descriptor, type);
        }

        public MyTextLikeDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type, @NotNull OperationSupport operationSupport) {
            if (name2 == null) {
                MyTextLikeDomain.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyTextLikeDomain.$$$reportNull$$$0(4);
            }
            if (type == null) {
                MyTextLikeDomain.$$$reportNull$$$0(5);
            }
            if (operationSupport == null) {
                MyTextLikeDomain.$$$reportNull$$$0(6);
            }
            super(name2, descriptor, type, operationSupport);
        }

        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                MyTextLikeDomain.$$$reportNull$$$0(7);
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full((Cardinality)this.cardinality(), (LogicalType)domain.getLogicType(), (LogicalType)this.getLogicType()) : Compatibility.incompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                MyTextLikeDomain.$$$reportNull$$$0(8);
            }
            return compatibility;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operationSupport";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/vertica/VertDomains$MyTextLikeDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/vertica/VertDomains$MyTextLikeDomain";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompatibility";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getCompatibility";
                    break;
                }
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                MyZonedDomain.$$$reportNull$$$0(1);
            }
            super(domain.simpleName(), domain.getPoint(), domain.getDomainType(), domain.getMax(), domain.getDefaultValue(), domain.isNarrowable());
            this.myPrefix = prefix;
        }

        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                MyZonedDomain.$$$reportNull$$$0(2);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
        }

        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                MyZonedDomain.$$$reportNull$$$0(3);
            }
            return new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
        }

        @NotNull
        public String name() {
            String string = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (string == null) {
                MyZonedDomain.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "domain";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/vertica/VertDomains$MyZonedDomain";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/vertica/VertDomains$MyZonedDomain";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "narrow";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class V9
    extends VertDomains {
        public V9() {
            this.add((Domain)new MyTextLikeDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.TEXT));
        }

        @Override
        public boolean isSuitable(@Nullable Version productVersion) {
            return productVersion == null || productVersion.isOrGreater(new int[]{9});
        }
    }
}

