/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.sqlite.model.SqliteCheck;
import com.intellij.database.dialects.sqlite.model.SqliteIndex;
import com.intellij.database.dialects.sqlite.model.SqliteKey;
import com.intellij.database.dialects.sqlite.model.SqliteRoot;
import com.intellij.database.dialects.sqlite.model.SqliteTable;
import com.intellij.database.dialects.sqlite.model.SqliteTableColumn;
import com.intellij.database.dialects.sqlite.model.SqliteTrigger;
import com.intellij.database.dialects.sqlite.model.SqliteVirtualTable;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModCheck;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTrigger;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.SqliteOnConflictAlgorithm;
import com.intellij.database.script.CompositeText;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.database.SqlObjectBuilder;
import com.intellij.sql.dialects.sqlite.SqliteTypes;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.SqlWhereClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020!2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\"\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010$\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020%2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J1\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H'0,H\u0002\u00a2\u0006\u0002\u0010-J \u0010.\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,H\u0002J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00020*\u0018\u0001002\u0006\u00101\u001a\u000202H\u0002J\u0014\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000102H\u0002J\u0012\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u000209H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010@\u001a\u00020=2\u0006\u0010\u0005\u001a\u00020AH\u0002J\u0014\u0010B\u001a\u0004\u0018\u0001022\b\u00101\u001a\u0004\u0018\u000102H\u0002\u00a8\u0006C"}, d2={"Lcom/intellij/database/dialects/sqlite/SqliteObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/sql/database/SqlObjectBuilder$Context;", "buildCheck", "Lcom/intellij/database/model/basic/BasicModCheck;", "buildCheckFromConstraintDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteCheck;", "Lcom/intellij/sql/psi/SqlConstraintDefinition;", "buildColumn", "Lcom/intellij/database/dialects/sqlite/model/SqliteTableColumn;", "buildIndex", "Lcom/intellij/database/model/basic/BasicModIndex;", "buildIndexFromCreateIndex", "Lcom/intellij/database/dialects/sqlite/model/SqliteIndex;", "Lcom/intellij/sql/psi/SqlCreateIndexStatement;", "buildKey", "Lcom/intellij/database/model/basic/BasicModKey;", "buildKeyFromTableKeyDefinition", "Lcom/intellij/database/dialects/sqlite/model/SqliteKey;", "Lcom/intellij/sql/psi/SqlTableKeyDefinition;", "buildTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteTable;", "buildTrigger", "Lcom/intellij/database/model/basic/BasicModTrigger;", "buildTriggerFromCreateTrigger", "Lcom/intellij/sql/psi/SqlCreateTriggerStatement;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "buildVirtualTable", "Lcom/intellij/database/dialects/sqlite/model/SqliteVirtualTable;", "findObject", "T", "Lcom/intellij/database/model/basic/BasicElement;", "name", "", "src", "Lcom/intellij/database/model/families/Family;", "(Ljava/lang/String;Lcom/intellij/database/model/families/Family;)Lcom/intellij/database/model/basic/BasicElement;", "fixName", "getColumns", "", "el", "Lcom/intellij/psi/PsiElement;", "getConflictResolution", "Lcom/intellij/database/model/properties/SqliteOnConflictAlgorithm;", "def", "getEvent", "Lcom/intellij/database/model/TrigEvent;", "type", "Lcom/intellij/psi/tree/IElementType;", "getTurn", "Lcom/intellij/database/model/TrigTurn;", "isDesc", "", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "isIdentity", "Lcom/intellij/sql/psi/SqlColumnDefinition;", "skipUnsignificant", "intellij.database.dialects.sqlite"})
public final class SqliteObjectBuilder
extends SqlObjectBuilderImpl {
    @Override
    public void build(@NotNull BasicModElement obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicModElement basicModElement = obj2;
        if (basicModElement instanceof SqliteTable) {
            this.buildTable((SqliteTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTableColumn) {
            this.buildColumn((SqliteTableColumn)obj2, source, context);
        } else if (basicModElement instanceof SqliteVirtualTable) {
            this.buildVirtualTable((SqliteVirtualTable)obj2, source, context);
        } else if (basicModElement instanceof SqliteTrigger) {
            this.buildTrigger((BasicModTrigger)obj2, source, context);
        } else {
            super.build(obj2, source, context);
        }
    }

    private final void buildTable(SqliteTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, source, context);
        }
        if (source instanceof SqlCreateTableStatement) {
            PsiElement psiElement = (PsiElement)source;
            IElementType iElementType = SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_WITHOUT_ROWID_CLAUSE");
            obj2.setWithoutRowId(this.findChild(psiElement, iElementType) != null);
        }
    }

    @Override
    protected void buildViewSource(@NotNull BasicModView obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (context.withSource()) {
            ((BasicModModel)obj2.getModel()).writeSources(new Runnable(this, obj2, source){
                final /* synthetic */ SqliteObjectBuilder this$0;
                final /* synthetic */ BasicModView $obj;
                final /* synthetic */ DasObject $source;

                public final void run() {
                    Object object;
                    DasObject dasObject = this.$source;
                    if (!(dasObject instanceof SqlCreateViewStatement)) {
                        dasObject = null;
                    }
                    this.$obj.setSourceText((CompositeText)((object = (SqlCreateViewStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null));
                }
                {
                    this.this$0 = sqliteObjectBuilder;
                    this.$obj = basicModView;
                    this.$source = dasObject;
                }
            });
        }
    }

    @Override
    protected void buildCheck(@NotNull BasicModCheck obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteCheck) || !(source instanceof SqlConstraintDefinition)) {
            super.buildCheck(obj2, source, context);
            return;
        }
        this.buildCheckFromConstraintDefinition((SqliteCheck)obj2, (SqlConstraintDefinition)source, context);
    }

    private final void buildCheckFromConstraintDefinition(SqliteCheck obj2, SqlConstraintDefinition source, SqlObjectBuilder.Context context) {
        if (!context.isIntrospector()) {
            super.buildCheck(obj2, (DasObject)source, context);
        }
        obj2.setOnConflict(this.getConflictResolution((PsiElement)source));
    }

    private final void buildColumn(SqliteTableColumn obj2, DasObject source, SqlObjectBuilder.Context context) {
        block8: {
            Object object;
            SqliteTableColumn sqliteTableColumn;
            block10: {
                String collationName;
                block9: {
                    if (!context.isIntrospector()) {
                        this.buildTyped((BasicModTypedElement)obj2, source, context);
                    }
                    if (!(source instanceof SqlColumnDefinition)) break block8;
                    collationName = null;
                    SqlObjectBuilderImpl this_$iv = this;
                    boolean $i$f$forEachChild = false;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl = this_$iv;
                    PsiElement first$iv$iv = ((PsiElement)source).getFirstChild();
                    boolean $i$f$forEachSibling = false;
                    for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                        PsiElement it = tmp$iv$iv;
                        boolean bl = false;
                        if (!(it instanceof SqlConstraintDefinition)) continue;
                        IElementType type = PsiTreeUtilKt.getElementType((PsiElement)it);
                        if (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_COLLATE_CONSTRAINT_DEFINITION)) {
                            SqlExpression collationRef;
                            SqlExpression sqlExpression = collationRef = (SqlExpression)((SqlConstraintDefinition)it).getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
                            collationName = sqlExpression != null ? sqlExpression.getText() : null;
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_NULLABLE_CONSTRAINT_DEFINITION)) continue;
                        obj2.setOnNullConflict(this.getConflictResolution(it));
                    }
                    if (StringsKt.equals((String)"binary", (String)collationName, (boolean)true)) {
                        collationName = null;
                    }
                    sqliteTableColumn = obj2;
                    object = (BasicModModel)obj2.getModel();
                    if (object == null) break block9;
                    BasicModModel basicModModel = object;
                    SqliteTableColumn sqliteTableColumn2 = sqliteTableColumn;
                    boolean bl = false;
                    boolean bl2 = false;
                    BasicModModel it = basicModModel;
                    boolean bl3 = false;
                    BasicModModel basicModModel2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicModModel2, (String)"it");
                    BasicRoot basicRoot = basicModModel2.getRoot();
                    if (basicRoot == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.dialects.sqlite.model.SqliteRoot");
                    }
                    SqliteRoot sqliteRoot = (SqliteRoot)basicRoot;
                    Object object2 = sqliteRoot != null ? sqliteRoot.getCollations() : null;
                    Intrinsics.checkExpressionValueIsNotNull(object2, (String)"(it.root as SqliteRoot)?.collations");
                    String string = this.fixName(collationName, (Family)object2);
                    sqliteTableColumn = sqliteTableColumn2;
                    object = string;
                    if (object != null) break block10;
                }
                object = collationName;
            }
            sqliteTableColumn.setCollation((String)object);
            obj2.setSequenceIdentity((SequenceIdentity)(this.isIdentity((SqlColumnDefinition)source) ? SequenceIdentity.UNKNOWN : null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIdentity(SqlColumnDefinition obj2) {
        List refs;
        SqlReferenceList refList;
        PsiElement psiElement;
        block7: {
            void this_$iv;
            PsiElement psiElement2;
            block6: {
                void this_$iv2;
                PsiElement psiElement3 = (PsiElement)obj2;
                SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
                Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
                if (this.findChild(psiElement3, (IElementType)sqlCompositeElementType) != null) {
                    return true;
                }
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                PsiElement el$iv = obj2.getParent();
                boolean $i$f$findChild2 = false;
                void var7_8 = this_$iv2;
                PsiElement psiElement4 = el$iv;
                PsiElement element$iv$iv = psiElement4 != null ? psiElement4.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlTableKeyDefinition)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block6;
                }
                psiElement2 = null;
            }
            PsiElement el$iv = (PsiElement)((SqlTableKeyDefinition)psiElement2);
            boolean $i$f$findChild = false;
            void $i$f$findChild2 = this_$iv;
            PsiElement psiElement5 = el$iv;
            PsiElement element$iv$iv = psiElement5 != null ? psiElement5.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlReferenceList)) continue;
                psiElement = tmp$iv$iv;
                break block7;
            }
            psiElement = null;
        }
        SqlReferenceList sqlReferenceList = refList = (SqlReferenceList)psiElement;
        List list = refs = sqlReferenceList != null ? sqlReferenceList.getReferenceList() : null;
        if (refs == null || refs.size() != 1) {
            return false;
        }
        PsiElement psiElement6 = (PsiElement)refs.get(0);
        SqlCompositeElementType sqlCompositeElementType = SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlCompositeElementType, (String)"SqlCompositeElementTypes\u2026ERATED_AS_IDENTITY_CLAUSE");
        if (this.findSibling(psiElement6, (IElementType)sqlCompositeElementType) == null) {
            return false;
        }
        Object e = refs.get(0);
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"refs[0]");
        String string = this.extractName((PsiElement)e);
        if (string == null) {
            string = "";
        }
        return StringsKt.equals((String)string, (String)obj2.getName(), (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildVirtualTable(SqliteVirtualTable obj2, DasObject source, SqlObjectBuilder.Context context) {
        if (!context.isIntrospector()) {
            this.buildNamedElement((BasicModNamedElement)obj2, source, context);
        }
        if (source instanceof SqlCreateStatement) {
            List list;
            SqlClause moduleClause = (SqlClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlClause.class);
            SqlReferenceExpression moduleRef = (SqlReferenceExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)moduleClause), SqlReferenceExpression.class);
            SqlClause[] moduleArguments = (SqlClause[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)moduleClause), SqlClause.class);
            SqliteVirtualTable sqliteVirtualTable = obj2;
            if (moduleArguments != null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SqlClause[] sqlClauseArray = moduleArguments;
                SqliteVirtualTable sqliteVirtualTable2 = sqliteVirtualTable;
                boolean $i$f$map = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                void var12_13 = $this$mapTo$iv$iv;
                int n = ((void)var12_13).length;
                for (int j = 0; j < n; ++j) {
                    void it;
                    void item$iv$iv;
                    void var16_17 = item$iv$iv = var12_13[j];
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                    String string = v1.getText();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                sqliteVirtualTable = sqliteVirtualTable2;
                list = collection;
            } else {
                list = CollectionsKt.emptyList();
            }
            sqliteVirtualTable.setArguments(list);
            SqlReferenceExpression sqlReferenceExpression = moduleRef;
            obj2.setModule(sqlReferenceExpression != null ? sqlReferenceExpression.getName() : null);
        }
    }

    @Override
    protected void buildKey(@NotNull BasicModKey obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(source instanceof SqlTableKeyDefinition) || !(obj2 instanceof SqliteKey)) {
            super.buildKey(obj2, source, context);
            return;
        }
        this.buildKeyFromTableKeyDefinition((SqliteKey)obj2, (SqlTableKeyDefinition)source, context);
    }

    private final void buildKeyFromTableKeyDefinition(SqliteKey obj2, SqlTableKeyDefinition source, SqlObjectBuilder.Context context) {
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, (DasObject)source, context);
        }
        if (!context.isStubBuilder()) {
            obj2.setPrimary(source.isPrimary());
            obj2.setOnConflict(this.getConflictResolution((PsiElement)source));
        }
    }

    @Override
    protected void buildTrigger(@NotNull BasicModTrigger obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteTrigger)) {
            super.buildTrigger(obj2, source, context);
            return;
        }
        if (source instanceof SqlCreateTriggerStatement) {
            this.buildTriggerFromCreateTrigger(obj2, (SqlCreateTriggerStatement)source, context);
        }
        if (context.withSource()) {
            ((BasicModModel)((SqliteTrigger)obj2).getModel()).writeSources(new Runnable(this, obj2, source){
                final /* synthetic */ SqliteObjectBuilder this$0;
                final /* synthetic */ BasicModTrigger $obj;
                final /* synthetic */ DasObject $source;

                public final void run() {
                    Object object;
                    SqliteTrigger sqliteTrigger = (SqliteTrigger)this.$obj;
                    DasObject dasObject = this.$source;
                    if (!(dasObject instanceof SqlCreateTriggerStatement)) {
                        dasObject = null;
                    }
                    sqliteTrigger.setSourceText((CompositeText)((object = (SqlCreateTriggerStatement)dasObject) != null && (object = object.getText()) != null ? SqlObjectBuilderImpl.asComposite$default(this.this$0, (String)object, null, 1, null) : null));
                }
                {
                    this.this$0 = sqliteObjectBuilder;
                    this.$obj = basicModTrigger;
                    this.$source = dasObject;
                }
            });
        }
    }

    private final void buildTriggerFromCreateTrigger(BasicModTrigger obj2, SqlCreateTriggerStatement source, SqlObjectBuilder.Context context) {
        SqlExpression whenExpr;
        SqlWhenClause whenClause;
        PsiElement element;
        SqlNameElement name2;
        if (!context.isIntrospector()) {
            this.buildBasicElement((BasicModElement)obj2, (DasObject)source, context);
        }
        TrigTurn turn = null;
        TrigEvent event = null;
        List<String> cols2 = null;
        SqlNameElement sqlNameElement = name2 = source.getNameElement();
        PsiElement afterName = this.skipUnsignificant((PsiElement)(sqlNameElement != null ? sqlNameElement.getNextSibling() : null));
        if (afterName instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)afterName).getFirstChild())) != null) {
            ASTNode aSTNode = element.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"element.node");
            IElementType iElementType = aSTNode.getElementType();
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"element.node.elementType");
            IElementType type = iElementType;
            event = this.getEvent(type);
            if (event == null) {
                turn = this.getTurn(type);
                PsiElement nextClause = this.skipUnsignificant(((SqlClause)afterName).getNextSibling());
                if (nextClause instanceof SqlClause && (element = this.skipUnsignificant(((SqlClause)nextClause).getFirstChild())) != null) {
                    ASTNode aSTNode2 = element.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"element.node");
                    IElementType iElementType2 = aSTNode2.getElementType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iElementType2, (String)"element.node.elementType");
                    event = this.getEvent(iElementType2);
                    cols2 = this.getColumns(nextClause);
                }
            } else {
                cols2 = this.getColumns(afterName);
            }
        }
        turn = turn == null ? TrigTurn.BEFORE_ROW : turn;
        SqlWhenClause sqlWhenClause = whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhenClause.class);
        SqlExpression sqlExpression = whenExpr = sqlWhenClause != null ? sqlWhenClause.getExpression() : null;
        obj2.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
        obj2.setTurn(turn);
        List<String> list = cols2;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        obj2.setColNames(list);
        obj2.setEvents(event == null ? SetsKt.emptySet() : SetsKt.setOf((Object)event));
    }

    @Override
    protected void buildIndex(@NotNull BasicModIndex obj2, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)obj2, (String)"obj");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!(obj2 instanceof SqliteIndex)) {
            super.buildIndex(obj2, source, context);
            return;
        }
        if (source instanceof SqlCreateIndexStatement) {
            this.buildIndexFromCreateIndex((SqliteIndex)obj2, (SqlCreateIndexStatement)source, context);
        }
    }

    private final void buildIndexFromCreateIndex(SqliteIndex obj2, SqlCreateIndexStatement source, SqlObjectBuilder.Context context) {
        block7: {
            SqlTableColumnsList columnsList;
            SqlReferenceExpression tableRef;
            SqlExpression whereExpr;
            if (!context.isIntrospector()) {
                this.buildNamedElement((BasicModNamedElement)obj2, (DasObject)source, context);
            }
            if (context.isStubBuilder()) {
                return;
            }
            SqlWhereClause where = (SqlWhereClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)source), SqlWhereClause.class);
            SqlExpression sqlExpression = whereExpr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)where), SqlExpression.class);
            obj2.setCondition(sqlExpression != null ? sqlExpression.getText() : null);
            SqlReferenceExpression sqlReferenceExpression = tableRef = source.getTargetReference();
            Object object = sqlReferenceExpression != null ? sqlReferenceExpression.getParent() : null;
            if (!(object instanceof SqlTableColumnsList)) {
                object = null;
            }
            SqlTableColumnsList sqlTableColumnsList = columnsList = (SqlTableColumnsList)object;
            Object columns = sqlTableColumnsList != null ? sqlTableColumnsList.getColumnsReferenceList() : null;
            SqlExpression[] columnExprs = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)columns), SqlExpression.class);
            if (columnExprs == null) break block7;
            ArrayList<Object> newNames = new ArrayList<Object>(columnExprs.length);
            boolean bl = false;
            LinkedHashSet newRev = new LinkedHashSet();
            for (SqlExpression expr : columnExprs) {
                boolean curRev;
                block11: {
                    block8: {
                        Object object2;
                        ArrayList<Object> arrayList;
                        block10: {
                            block9: {
                                curRev = false;
                                if (!(expr instanceof SqlReferenceExpression)) break block8;
                                arrayList = newNames;
                                object2 = obj2.getTable();
                                if (object2 == null || (object2 = object2.getColumns()) == null) break block9;
                                ModPositioningNamingFamily<? extends SqliteTableColumn> modPositioningNamingFamily = object2;
                                ArrayList<Object> arrayList2 = arrayList;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                ModPositioningNamingFamily<? extends SqliteTableColumn> it = modPositioningNamingFamily;
                                boolean bl4 = false;
                                String string = ((SqlReferenceExpression)expr).getName();
                                ModPositioningNamingFamily<? extends SqliteTableColumn> modPositioningNamingFamily2 = it;
                                Intrinsics.checkExpressionValueIsNotNull(modPositioningNamingFamily2, (String)"it");
                                String string2 = this.fixName(string, (Family)modPositioningNamingFamily2);
                                arrayList = arrayList2;
                                object2 = string2;
                                if (object2 != null) break block10;
                            }
                            object2 = ((SqlReferenceExpression)expr).getName();
                        }
                        arrayList.add(object2);
                        curRev = this.isDesc((SqlReferenceExpression)expr);
                        break block11;
                    }
                    SqlExpression sqlExpression2 = expr;
                    Intrinsics.checkExpressionValueIsNotNull((Object)sqlExpression2, (String)"expr");
                    newNames.add(sqlExpression2.getText());
                }
                if (!curRev) continue;
                newRev.add(newNames.get(newNames.size() - 1));
            }
            obj2.setColNames(newNames);
            obj2.setReverseColNames(newRev);
        }
    }

    private final boolean isDesc(SqlReferenceExpression expr) {
        for (PsiElement tmp = expr.getNextSibling(); tmp != null && !(tmp instanceof SqlExpression); tmp = tmp.getNextSibling()) {
            IElementType type = PsiTreeUtilKt.getElementType((PsiElement)tmp);
            if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_ASC)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DESC)) continue;
            return true;
        }
        return false;
    }

    private final String fixName(String name2, Family<?> src) {
        Object object = this.findObject(name2, src);
        if (object == null || (object = object.getName()) == null) {
            object = name2;
        }
        return object;
    }

    private final <T extends BasicElement> T findObject(String name2, Family<T> src) {
        Object v1;
        block2: {
            if (name2 == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = (Iterable)src;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BasicElement it = (BasicElement)element$iv;
                boolean bl = false;
                BasicElement basicElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"it");
                if (!StringsKt.equals((String)name2, (String)basicElement.getName(), (boolean)true)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return (T)((BasicElement)v1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getColumns(PsiElement el) {
        List list;
        SqlReferenceExpression[] sqlReferenceExpressionArray = (SqlReferenceExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)el, SqlReferenceExpression.class);
        if (sqlReferenceExpressionArray != null) {
            void $this$mapTo$iv$iv;
            SqlReferenceExpression[] $this$map$iv = sqlReferenceExpressionArray;
            boolean $i$f$map = false;
            SqlReferenceExpression[] sqlReferenceExpressionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[j];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                String string = v1.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final TrigEvent getEvent(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSERT)) {
            return TrigEvent.INSERT;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_DELETE)) {
            return TrigEvent.DELETE;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_UPDATE) ? TrigEvent.UPDATE : null;
    }

    private final TrigTurn getTurn(IElementType type) {
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_BEFORE)) {
            return TrigTurn.BEFORE_ROW;
        }
        if (Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_AFTER)) {
            return TrigTurn.AFTER_ROW;
        }
        return Intrinsics.areEqual((Object)type, (Object)SqliteTypes.SQLITE_INSTEAD) ? TrigTurn.INSTEAD_OF : null;
    }

    private final PsiElement skipUnsignificant(PsiElement el) {
        PsiElement tmp = el;
        while (tmp instanceof PsiWhiteSpace || tmp instanceof PsiComment) {
            tmp = tmp.getNextSibling();
        }
        return tmp;
    }

    private final SqliteOnConflictAlgorithm getConflictResolution(PsiElement def) {
        SqliteOnConflictAlgorithm algo;
        block3: {
            SqliteOnConflictAlgorithm sqliteOnConflictAlgorithm;
            IElementType iElementType = SqliteTypes.SQLITE_CONFLICT_CLAUSE;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"SqliteTypes.SQLITE_CONFLICT_CLAUSE");
            PsiElement psiElement = this.findChild(def, iElementType);
            if (psiElement == null) {
                return null;
            }
            PsiElement onConflict = psiElement;
            PsiElement psiElement2 = PsiTreeUtil.getDeepestLast((PsiElement)onConflict);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.getDeepestLast(onConflict)");
            PsiElement how = psiElement2;
            String text = how.getText();
            SqliteOnConflictAlgorithm[] $this$firstOrNull$iv = SqliteOnConflictAlgorithm.values();
            boolean $i$f$firstOrNull = false;
            SqliteOnConflictAlgorithm[] sqliteOnConflictAlgorithmArray = $this$firstOrNull$iv;
            int n = sqliteOnConflictAlgorithmArray.length;
            for (int j = 0; j < n; ++j) {
                SqliteOnConflictAlgorithm element$iv;
                SqliteOnConflictAlgorithm it = element$iv = sqliteOnConflictAlgorithmArray[j];
                boolean bl = false;
                if (!StringsKt.equals((String)it.toString(), (String)text, (boolean)true)) continue;
                sqliteOnConflictAlgorithm = element$iv;
                break block3;
            }
            sqliteOnConflictAlgorithm = algo = null;
        }
        if (algo == SqliteOnConflictAlgorithm.ABORT) {
            return null;
        }
        return algo;
    }
}

