/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.model;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.postgresbase.model.PgBaseCatalogObject;
import com.intellij.database.dialects.postgresbase.model.PgBaseDatabase;
import com.intellij.database.dialects.postgresbase.model.PgBaseForeignKey;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectEditorFactory;
import com.intellij.database.dialects.postgresbase.model.PgBaseSchema;
import com.intellij.database.dialects.postgresbase.model.PgBaseTable;
import com.intellij.database.dialects.postgresbase.model.PgBaseTableColumn;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "oef", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseObjectEditorFactory;", "findTableByObjectId", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseTable;", "database", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseDatabase;", "id", "", "preferredSchema", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseSchema;", "schema", "getDocumentationLink", "Lcom/intellij/openapi/util/Pair;", "", "element", "Lcom/intellij/database/model/basic/BasicElement;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "resolveReference", "", "key", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseForeignKey;", "intellij.database.dialects.postgresbase"})
public abstract class PgBaseModelHelper
extends ModelHelper {
    private final PgBaseObjectEditorFactory oef = new PgBaseObjectEditorFactory();

    /*
     * WARNING - void declaration
     */
    public final void resolveReference(@NotNull PgBaseForeignKey key2) {
        BasicKey refKey;
        void $this$mapNotNullTo$iv$iv;
        PgBaseTable refTable;
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        PgBaseCatalogObject pgBaseCatalogObject = key2.getMajorObject();
        if (pgBaseCatalogObject == null || (pgBaseCatalogObject = (PgBaseSchema)pgBaseCatalogObject.getSchema()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseCatalogObject, (String)"key.majorObject?.schema ?: return");
        PgBaseCatalogObject schema = pgBaseCatalogObject;
        PgBaseDatabase pgBaseDatabase = schema.getDatabase();
        if (pgBaseDatabase == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseDatabase, (String)"schema.database ?: return");
        PgBaseDatabase database = pgBaseDatabase;
        PgBaseTable pgBaseTable = refTable = this.findTableByObjectId(database, key2.getRefTableId(), (PgBaseSchema)schema);
        PgBaseSchema refSchema = pgBaseTable != null ? (PgBaseSchema)pgBaseTable.getSchema() : null;
        key2.setRefSchemaName(refSchema != null && Intrinsics.areEqual((Object)refSchema, (Object)schema) ^ true ? refSchema.getRealName() : null);
        PgBaseTable pgBaseTable2 = refTable;
        key2.setRefTableName(pgBaseTable2 != null ? pgBaseTable2.getRealName() : null);
        if (refTable == null) {
            return;
        }
        List<Short> list = key2.getRefColPositions();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"key.refColPositions");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Short p = (Short)element$iv$iv;
            boolean bl2 = false;
            ModPositioningNamingFamily<? extends PgBaseTableColumn> modPositioningNamingFamily = refTable.getColumns();
            Short s = p;
            Intrinsics.checkExpressionValueIsNotNull((Object)s, (String)"p");
            PgBaseTableColumn pgBaseTableColumn = (PgBaseTableColumn)modPositioningNamingFamily.getByNaturalPosition(s.shortValue());
            if ((pgBaseTableColumn != null ? pgBaseTableColumn.getName() : null) == null) continue;
            string = string;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List columnNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        key2.setRefColNames(columnNames);
        BasicTableOrView basicTableOrView = (BasicTableOrView)refTable;
        List list2 = key2.getRefColNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"key.refColNames");
        BasicKey basicKey = refKey = ModelFun.findKey((BasicTableOrView)basicTableOrView, (List)list2);
        key2.setRefKeyName(basicKey != null ? basicKey.getRealName() : null);
    }

    @Nullable
    public PgBaseTable findTableByObjectId(@NotNull PgBaseSchema schema, long id) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return (PgBaseTable)schema.getTables().getByObjectId(id);
    }

    private final PgBaseTable findTableByObjectId(PgBaseDatabase database, long id, PgBaseSchema preferredSchema) {
        PgBaseTable table = null;
        if (preferredSchema != null) {
            table = this.findTableByObjectId(preferredSchema, id);
        }
        if (table != null) {
            return table;
        }
        table = (PgBaseTable)database.getSchemas().jbi().filter((Condition)new Condition<PgBaseSchema>(preferredSchema){
            final /* synthetic */ PgBaseSchema $preferredSchema;

            public final boolean value(PgBaseSchema s) {
                return Intrinsics.areEqual((Object)s, (Object)this.$preferredSchema) ^ true;
            }
            {
                this.$preferredSchema = pgBaseSchema;
            }
        }).transform(new Function<E, T>(this, id){
            final /* synthetic */ PgBaseModelHelper this$0;
            final /* synthetic */ long $id;

            @Nullable
            public final PgBaseTable fun(PgBaseSchema s) {
                PgBaseSchema pgBaseSchema = s;
                Intrinsics.checkExpressionValueIsNotNull((Object)pgBaseSchema, (String)"s");
                return this.this$0.findTableByObjectId(pgBaseSchema, this.$id);
            }
            {
                this.this$0 = pgBaseModelHelper;
                this.$id = l;
            }
        }).filter((Condition)findTableByObjectId.3.INSTANCE).first();
        return table;
    }

    static /* synthetic */ PgBaseTable findTableByObjectId$default(PgBaseModelHelper pgBaseModelHelper, PgBaseDatabase pgBaseDatabase, long l, PgBaseSchema pgBaseSchema, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findTableByObjectId");
        }
        if ((n & 4) != 0) {
            pgBaseSchema = null;
        }
        return pgBaseModelHelper.findTableByObjectId(pgBaseDatabase, l, pgBaseSchema);
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Pair<String, String> getDocumentationLink(@NotNull BasicElement element) {
        Pair pair;
        String string;
        Object object;
        Version root2;
        Version version;
        Object object2;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        BasicSchema basicSchema = element.getSchema();
        Object object3 = basicSchema;
        if (basicSchema == null) return null;
        String string2 = object3.getName();
        object3 = string2;
        if (string2 == null) return null;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"element.schema?.name ?: return null");
        Object schemaName = object3;
        BasicModel basicModel = element.getModel();
        if (basicModel != null && (basicModel = basicModel.getRoot()) != null) {
            BasicModel basicModel2 = basicModel;
            boolean bl2 = false;
            bl = false;
            BasicModel it = basicModel2;
            boolean bl3 = false;
            BasicModel basicModel3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)basicModel3, (String)"it");
            object2 = Intrinsics.areEqual((Object)basicModel3.getDbms(), (Object)Dbms.POSTGRES) ? basicModel2 : null;
        } else {
            object2 = null;
        }
        if ((version = (root2 = object2)) != null && (version = version.getServerVersion()) != null) {
            Version version2 = version;
            bl = false;
            boolean it = false;
            Version it2 = version2;
            boolean bl4 = false;
            object = it2.isOrGreater(new int[]{7, 1}) ? version2 : null;
        } else {
            object = null;
        }
        Version ver = object;
        if (ver == null) {
            string = "current";
        } else if (ver.isOrGreater(new int[]{10})) {
            String string = ver.toString(1, 1);
            string = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ver.toString(1, 1)");
        } else {
            String string = ver.toString(2, 2);
            string = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"ver.toString(2, 2)");
        }
        String versionRef = string;
        String p = "https://www.postgresql.org/docs/" + versionRef + "/static";
        ObjectKind objectKind = element.getKind();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectKind, (String)"element.kind");
        ObjectKind kind = objectKind;
        String kindName = kind.code();
        String string5 = element.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"element.name");
        String name2 = string5;
        if (ModelSerializationFun.startsWith((String)name2, (char)'_')) {
            return null;
        }
        String name22 = StringsKt.replace$default((String)name2, (char)'_', (char)'-', (boolean)false, (int)4, null);
        Object object4 = schemaName;
        switch (((String)object4).hashCode()) {
            case 762369044: {
                if (!((String)object4).equals("information_schema")) return null;
                break;
            }
            case 895036881: {
                if (!((String)object4).equals("pg_catalog")) return null;
                ObjectKind objectKind2 = kind;
                if (Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.VIEW)) {
                    pair = PgBaseModelHelper.access$link$s1827920919(kindName + ' ' + name2, p + "/catalog-" + name22 + ".html");
                    return pair;
                } else {
                    if (!Intrinsics.areEqual((Object)objectKind2, (Object)ObjectKind.SCHEMA)) return null;
                    pair = PgBaseModelHelper.access$link$s1827920919("System Catalog", p + "/catalogs.html");
                }
                return pair;
            }
        }
        ObjectKind objectKind3 = kind;
        if (Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.TABLE) || Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.VIEW)) {
            pair = PgBaseModelHelper.access$link$s1827920919(kindName + ' ' + name2, p + "/infoschema-" + name22 + ".html");
            return pair;
        } else {
            if (!Intrinsics.areEqual((Object)objectKind3, (Object)ObjectKind.SCHEMA)) return null;
            pair = PgBaseModelHelper.access$link$s1827920919("Information Schema", p + "/information-schema.html");
        }
        return pair;
        return null;
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return this.oef;
    }

    public static final /* synthetic */ Pair access$link$s1827920919(String p0, String p1) {
        return ModelHelper.link((String)p0, (String)p1);
    }
}

