/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.postgresbase.model.PgBaseRole;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0016J,\u0010\u0006\u001a\u00060\u0007R\u00020\b2\n\u0010\t\u001a\u00060\u0007R\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\u000f\u001a\u00060\u0007R\u00020\b*\u00060\u0007R\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/dialects/postgresbase/generator/producers/PgBaseRoleHelper;", "", "()V", "attributes", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/model/meta/BasicMetaProperty;", "generateImpl", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "coding", "r", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseRole;", "attr", "roleKind", "", "generate", "intellij.database.dialects.postgresbase"})
public class PgBaseRoleHelper {
    @NotNull
    public String roleKind(@NotNull PgBaseRole r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        return "user";
    }

    @NotNull
    public JBIterable<BasicMetaProperty<?>> attributes() {
        JBIterable jBIterable = JBIterable.of((Object[])new BasicMetaProperty[]{PgBaseRole.SUPER_ROLE, PgBaseRole.CREATE_DB, PgBaseRole.CONNECTION_LIMIT, PgBaseRole.VALID_UNTIL});
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.of(\n    PgBas\u2026gBaseRole.VALID_UNTIL\n  )");
        return jBIterable;
    }

    @NotNull
    public final ScriptingContext.NewCodingAdapter generate(@NotNull ScriptingContext.NewCodingAdapter $this$generate, @NotNull PgBaseRole r, @NotNull BasicMetaProperty<?> attr) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generate, (String)"$this$generate");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull(attr, (String)"attr");
        return this.generateImpl($this$generate, r, attr);
    }

    @NotNull
    protected ScriptingContext.NewCodingAdapter generateImpl(@NotNull ScriptingContext.NewCodingAdapter coding, @NotNull PgBaseRole r, @NotNull BasicMetaProperty<?> attr) {
        ScriptingContext.NewCodingAdapter newCodingAdapter;
        Intrinsics.checkParameterIsNotNull((Object)coding, (String)"coding");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull(attr, (String)"attr");
        boolean bl = false;
        boolean bl2 = false;
        ScriptingContext.NewCodingAdapter $this$with = coding;
        boolean bl3 = false;
        BasicMetaProperty<?> basicMetaProperty = attr;
        if (Intrinsics.areEqual(basicMetaProperty, PgBaseRole.SUPER_ROLE)) {
            newCodingAdapter = r.isSuperRole() ? $this$with.unaryPlus("superuser") : $this$with.unaryPlus("nosuperuser");
        } else if (Intrinsics.areEqual(basicMetaProperty, PgBaseRole.CREATE_DB)) {
            newCodingAdapter = r.isCreateDb() ? $this$with.unaryPlus("createdb") : $this$with.unaryPlus("nocreatedb");
        } else if (Intrinsics.areEqual(basicMetaProperty, PgBaseRole.CONNECTION_LIMIT)) {
            long l = r.getConnectionLimit();
            long l2 = -1L;
            StringBuilder stringBuilder = new StringBuilder().append("connection limit ");
            ScriptingContext.NewCodingAdapter newCodingAdapter2 = $this$with;
            boolean bl4 = false;
            long l3 = Math.max(l, l2);
            newCodingAdapter = newCodingAdapter2.unaryPlus(stringBuilder.append(l3).toString());
        } else if (Intrinsics.areEqual(basicMetaProperty, PgBaseRole.VALID_UNTIL)) {
            ScriptingContext.NewCodingAdapter newCodingAdapter3 = $this$with.unaryPlus("valid until");
            String string = r.getValidUntil();
            if (string == null) {
                string = "infinity";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(r.validUntil ?: \"infinity\")");
            newCodingAdapter = $this$with.plus(newCodingAdapter3, ScriptGeneratorHelperKt.getSqlString(string));
        } else {
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            if (_Assertions.ENABLED) {
                boolean bl8 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            newCodingAdapter = $this$with;
        }
        return newCodingAdapter;
    }
}

