/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.ThreeState;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper;", "Lcom/intellij/database/dialects/base/BaseExecutionEnvironmentHelper;", "()V", "getSslState", "Lcom/intellij/util/ThreeState;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "getTimeZoneManager", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "PgBaseTimeZoneManager", "intellij.database.dialects.postgresbase"})
public class PgBaseExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @Override
    @Nullable
    public ThreeState getSslState(@NotNull DatabaseConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        if (Intrinsics.areEqual((Object)connection.getDbms(), (Object)Dbms.COCKROACH) || !connection.getVersion().isOrGreater(new int[]{9, 5})) {
            return null;
        }
        ExecutionMode executionMode = (ExecutionMode)StandardExecutionMode.QUERY;
        String string = "select ssl from pg_stat_ssl where pid = pg_backend_pid()";
        SimpleSmartStatement simpleSmartStatement = SmartStatements.Companion.poweredBy(connection).simple();
        boolean $i$f$first = false;
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = (ResultsProducer.VoidReadyProcessor)new ResultsProducer.VoidReadyProcessor<Boolean>(){

            public Boolean empty() {
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public Boolean results(@NotNull RemoteResultSet resultSet, int index2) {
                Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
                RemoteResultSet rs = resultSet.next() ? resultSet : null;
                boolean bl = false;
                RemoteResultSet remoteResultSet = rs;
                return remoteResultSet != null ? Boolean.valueOf(remoteResultSet.getBoolean(1)) : null;
            }

            public Boolean parameterResults(@NotNull List<? extends OutParameter<?>> parameters2, @NotNull Function1<? super OutParameter<?>, ? extends Object> retriever, int index2) {
                Intrinsics.checkParameterIsNotNull(parameters2, (String)"parameters");
                Intrinsics.checkParameterIsNotNull(retriever, (String)"retriever");
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }

            public Boolean updateCount(int count, int index2) {
                RemoteResultSet rs = null;
                boolean bl = false;
                return null;
            }
        };
        Either isSsl = simpleSmartStatement.execute((Object)string, executionMode, voidReadyProcessor);
        Boolean bl = (Boolean)isSsl.rightOr(null);
        return Intrinsics.areEqual((Object)bl, (Object)true) ? ThreeState.YES : (Intrinsics.areEqual((Object)bl, (Object)false) ? ThreeState.NO : ThreeState.UNSURE);
    }

    @Override
    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        return PgBaseTimeZoneManager.INSTANCE;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/postgresbase/PgBaseExecutionEnvironmentHelper$PgBaseTimeZoneManager;", "Lcom/intellij/database/console/ExecutionEnvironmentHelper$TimeZoneManager;", "()V", "canChange", "", "changeTimeZone", "", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "timeZone", "", "intellij.database.dialects.postgresbase"})
    private static final class PgBaseTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        public static final PgBaseTimeZoneManager INSTANCE;

        public boolean canChange() {
            return true;
        }

        public void changeTimeZone(@NotNull DatabaseConnection connection, @NotNull String timeZone) {
            Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
            Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "set timezone = '%s'";
            Object[] objectArray = new Object[]{timeZone};
            BarrenStatement.QuietBarrenStatement quietBarrenStatement = SmartStatements.Companion.poweredBy(connection).simple(Configuration.Companion.sourced(SmartStatements.Source.SYSTEM)).barren().quiet();
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            quietBarrenStatement.execute((Object)string3);
        }

        private PgBaseTimeZoneManager() {
        }

        static {
            PgBaseTimeZoneManager pgBaseTimeZoneManager;
            INSTANCE = pgBaseTimeZoneManager = new PgBaseTimeZoneManager();
        }
    }
}

