/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.plan;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.postgres.plan.PgRawPlanData;
import com.intellij.database.dialects.postgresbase.plan.PgBasePlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgPlanModelBuilder
extends AbstractPlanModelBuilder<PgRawPlanData, JSONObject> {
    private static final Map<String, PlanModel.NodeType> MODIFICATION_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Set<String> HANDLED_KEYS = ImmutableSet.of((Object)"Plans", (Object)"Startup Cost", (Object)"Total Cost", (Object)"Plan Rows", (Object)"Relation Name", (Object)"CTE Name", (Object[])new String[]{"Index Name", "Node Type", "Actual Startup Time", "Actual Total Time", "Actual Rows", "Plan"});

    public PgPlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public PgRawPlanData createData() {
        return new PgRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot(((PgRawPlanData)this.myData).json);
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONArray data;
        if (json == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            data = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned invalid JSON", (Throwable)e);
        }
        if (data.length() == 0) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        if (data.length() > 1) {
            throw new PlanRetrievalException("Database returned multiple plans");
        }
        try {
            this.openNode(null);
            this.parseStatement(data.getJSONObject(0));
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned plan in unknown format", (Throwable)e);
        }
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(1);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String str;
            String key2 = (String)it.next();
            if (HANDLED_KEYS.contains(key2) || (str = object.optString(key2, null)) == null) continue;
            desc.append(key2).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        String rel;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(3);
        }
        if ((rel = object.optString("Relation Name", null)) == null) {
            rel = object.optString("CTE Name", null);
        }
        return rel;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return PgPlanModelBuilder.optBig(object, "Plan Rows", null);
    }

    @Override
    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return PgPlanModelBuilder.optBig(object, "Actual Rows", null);
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return object.optString("Index Name", null);
    }

    private static int getNumSubPlans(@Nullable JSONObject object) {
        JSONArray plans = PgPlanModelBuilder.getSubPlans(object);
        return plans == null ? 0 : plans.length();
    }

    @Nullable
    private static JSONArray getSubPlans(@Nullable JSONObject object) {
        return object == null ? null : object.optJSONArray("Plans");
    }

    @Nullable
    private static String getNodeType(@Nullable JSONObject object) {
        return object == null ? null : object.optString("Node Type");
    }

    @Override
    protected void parseSubPlans(@NotNull JSONObject object) {
        JSONArray plans;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((plans = PgPlanModelBuilder.getSubPlans(object)) != null) {
            JSONObject subPlan;
            if (plans.length() == 1 && "Append".equals(PgPlanModelBuilder.getNodeType(subPlan = plans.optJSONObject(0)))) {
                this.parseSubPlans(subPlan);
                return;
            }
            for (int i2 = 0; i2 < plans.length(); ++i2) {
                JSONObject subPlan2 = plans.optJSONObject(i2);
                if (subPlan2 == null) {
                    this.unsupportedFormat();
                }
                this.parsePlan(subPlan2);
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull JSONObject root2) {
        if (root2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.openNode(null);
        JSONObject object = root2.optJSONObject("Plan");
        if (object == null) {
            this.unsupportedFormat("No root plan");
        }
        this.myActual = root2.optString("Execution Time", null) != null || root2.optString("Total Runtime", null) != null;
        String nodeType = object.optString("Node Type");
        PlanModel.NodeType type = PlanModel.NodeType.SELECT;
        if (nodeType.equals("ModifyTable")) {
            type = MODIFICATION_MAPPING.get(object.optString("Operation"));
            if (type == null) {
                type = PlanModel.NodeType.STATEMENT;
            }
            this.parseSubPlans(object);
        } else {
            this.parsePlan(object);
        }
        this.closeNode(this.createNode(root2, type, type == PlanModel.NodeType.STATEMENT ? nodeType : null));
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return PgPlanModelBuilder.optDouble(object, "Total Cost", null);
    }

    @Override
    @Nullable
    protected Double parseActualTotalTime(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return PgPlanModelBuilder.optDouble(object, "Actual Total Time", null);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return PgPlanModelBuilder.optDouble(object, "Startup Cost", null);
    }

    @Override
    @Nullable
    protected Double parseActualStartupTime(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return PgPlanModelBuilder.optDouble(object, "Actual Startup Time", null);
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull JSONObject state2) {
        if (state2 == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(15);
        }
        if (PgPlanModelBuilder.getNumSubPlans(state2) == 1 && "Result".equals(PgPlanModelBuilder.getNodeType(state2))) {
            this.parseSubPlans(state2);
            return;
        }
        this.openNode(null);
        this.parseSubPlans(state2);
        String nodeType = state2.optString("Node Type");
        PlanModel.NodeType type = PgBasePlanModelBuilder.TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        if (type == PlanModel.NodeType.SET_OP) {
            String com = state2.optString("Command");
            if ("Intersect".equals(com)) {
                type = PlanModel.NodeType.INTERSECT;
            } else if ("Except".equals(com)) {
                type = PlanModel.NodeType.EXCEPT;
            }
        }
        PlanModel.GenericNode node = this.createNode(state2, type, nodeType);
        this.closeNode(node);
    }

    static {
        MODIFICATION_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        MODIFICATION_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        MODIFICATION_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseActualTotalTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseActualStartupTime";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

