/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres;

import com.intellij.database.dialects.postgres.model.PgModelHelper;
import com.intellij.database.dialects.postgres.model.PgSchema;
import com.intellij.database.dialects.postgres.model.PgTable;
import com.intellij.database.dialects.postgresgreenplumbase.PgGPlumBaseViewStructureProvider;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgDatabaseViewStructureProvider
extends PgGPlumBaseViewStructureProvider {
    private static final ObjectKind TABLE_PARTITION = new ObjectKind("PARTITION");
    private static final ObjectKind FOREIGN_TABLE_PARTITION = new ObjectKind("FOREIGN PARTITION");

    @Override
    @NotNull
    public JBIterable<? extends BasicElement> getChildren(@NotNull BasicElement element, @Nullable ObjectKind kind) {
        if (element == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(0);
        }
        JBIterable<? extends BasicElement> result2 = super.getChildren(element, kind);
        if (element instanceof PgSchema) {
            JBIterable jBIterable = result2.filter(e -> {
                PgTable table = PgDatabaseViewStructureProvider.asTable(e);
                return table == null || !table.isPartition() || PgDatabaseViewStructureProvider.getParentTable(table) == null;
            });
            if (jBIterable == null) {
                PgDatabaseViewStructureProvider.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        PgTable table = PgDatabaseViewStructureProvider.asTable(element);
        if (table == null || kind != FOREIGN_TABLE_PARTITION && kind != TABLE_PARTITION && kind != ObjectKind.NONE || !table.isPartitioned()) {
            JBIterable<? extends BasicElement> jBIterable = result2;
            if (jBIterable == null) {
                PgDatabaseViewStructureProvider.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }
        Set<PgGPlumBaseTable> successors = PgModelHelper.INSTANCE.getSuccessors(table);
        List pgTables = ContainerUtil.filterIsInstance(successors, PgTable.class);
        List children2 = kind == ObjectKind.NONE ? pgTables : ContainerUtil.filter((Collection)pgTables, t -> kind == FOREIGN_TABLE_PARTITION && t.getKind() == ObjectKind.FOREIGN_TABLE || kind == TABLE_PARTITION && t.getKind() == ObjectKind.TABLE);
        JBIterable jBIterable = JBIterable.of((Object[])new BasicElement[0]).append(result2).append((Iterable)children2);
        if (jBIterable == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public List<ObjectKind> getFamilyKinds(@NotNull BasicElement element) {
        if (element == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(4);
        }
        PgTable table = PgDatabaseViewStructureProvider.asTable(element);
        List kinds = super.getFamilyKinds(element);
        List list = table == null || !table.isPartitioned() ? kinds : JBIterable.from(kinds).append((Object)TABLE_PARTITION).append((Object)FOREIGN_TABLE_PARTITION).toList();
        if (list == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public BasicElement getParent(@NotNull BasicElement element) {
        PgTable table;
        if (element == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(6);
        }
        if ((table = PgDatabaseViewStructureProvider.asTable(element)) == null || !table.isPartition()) {
            return super.getParent(element);
        }
        PgTable parent = PgDatabaseViewStructureProvider.getParentTable(table);
        return parent != null ? parent : super.getParent(element);
    }

    @Override
    public int getWeight(@NotNull BasicElement element) {
        if (element == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(7);
        }
        return element instanceof PgTable && ((PgTable)element).isPartition() ? DbPresentation.getWeight((ObjectKind)ObjectKind.PARTITION, (int)0) : super.getWeight(element);
    }

    @Override
    @NotNull
    public DatabaseStructure.Provider.PresentationToModelConverter getConverter() {
        DatabaseStructure.Provider.PresentationToModelConverter presentationToModelConverter = PgPresentationToModelConverter.INSTANCE;
        if (presentationToModelConverter == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(8);
        }
        return presentationToModelConverter;
    }

    @Nullable
    private static PgTable getParentTable(@NotNull PgTable table) {
        List<PgGPlumBaseTable> ancestors;
        if (table == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(9);
        }
        return (ancestors = PgModelHelper.INSTANCE.getAncestors(table)).size() != 1 ? null : PgDatabaseViewStructureProvider.asTable((BasicElement)Objects.requireNonNull(ContainerUtil.getFirstItem(ancestors)));
    }

    @Nullable
    private static PgTable asTable(@NotNull BasicElement element) {
        if (element == null) {
            PgDatabaseViewStructureProvider.$$$reportNull$$$0(10);
        }
        return (PgTable)ObjectUtils.tryCast((Object)element, PgTable.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/PgDatabaseViewStructureProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/PgDatabaseViewStructureProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWeight";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentTable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "asTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PgPresentationToModelConverter
    extends PgGPlumBaseViewStructureProvider.Converter {
        static final DatabaseStructure.Provider.PresentationToModelConverter INSTANCE = new PgPresentationToModelConverter();

        private PgPresentationToModelConverter() {
        }

        @Override
        @NotNull
        public BasicElement toModelParent(@NotNull BasicElement presentationParent) {
            if (presentationParent == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(0);
            }
            PgTable table = PgDatabaseViewStructureProvider.asTable(presentationParent);
            BasicElement parent = super.toModelParent(presentationParent);
            BasicElement basicElement = table == null || !table.isPartitioned() ? parent : (BasicElement)ObjectUtils.notNull((Object)presentationParent.getParent(), (Object)parent);
            if (basicElement == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(1);
            }
            return basicElement;
        }

        @Override
        @NotNull
        public JBIterable<? extends DbElement> pickOnlyGroupChildren(@NotNull BasicElement presentationParent, @NotNull JBIterable<? extends DbElement> children2, @NotNull ObjectKind kidKind) {
            if (presentationParent == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(2);
            }
            if (children2 == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(3);
            }
            if (kidKind == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(4);
            }
            PgTable table = PgDatabaseViewStructureProvider.asTable(presentationParent);
            JBIterable filtered = super.pickOnlyGroupChildren(presentationParent, children2, kidKind);
            JBIterable jBIterable = table == null || !table.isPartitioned() ? filtered : filtered.filter(element -> {
                BasicElement delegate = (BasicElement)ObjectUtils.tryCast((Object)element.getDelegate(), BasicElement.class);
                PgTable localTable = delegate == null ? null : PgDatabaseViewStructureProvider.asTable(delegate);
                return localTable == null || localTable.isPartition() && PgDatabaseViewStructureProvider.getParentTable(localTable) == table;
            });
            if (jBIterable == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind toModelObjectKind(@NotNull ObjectKind kind) {
            if (kind == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(6);
            }
            ObjectKind objectKind = kind == TABLE_PARTITION ? ObjectKind.TABLE : (kind == FOREIGN_TABLE_PARTITION ? ObjectKind.FOREIGN_TABLE : super.toModelObjectKind(kind));
            if (objectKind == null) {
                PgPresentationToModelConverter.$$$reportNull$$$0(7);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationParent";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/postgres/PgDatabaseViewStructureProvider$PgPresentationToModelConverter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kidKind";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/postgres/PgDatabaseViewStructureProvider$PgPresentationToModelConverter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toModelParent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pickOnlyGroupChildren";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toModelObjectKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toModelParent";
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "pickOnlyGroupChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "toModelObjectKind";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

