/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraObjectEditorFactory;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ui.LayeredIcon;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/oracle/model/OraModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "exportApplyColumn", "", "helper", "Lcom/intellij/database/schemaEditor/SchemaApplyHelper;", "from", "Lcom/intellij/database/schemaEditor/model/DeColumn;", "to", "Lcom/intellij/database/model/basic/BasicModTableColumn;", "exportLightExport", "Lcom/intellij/database/schemaEditor/SchemaExporters$BasicSchemaExportHelper;", "Lcom/intellij/database/model/basic/BasicTableColumn;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "getIcon", "Ljavax/swing/Icon;", "c", "Lcom/intellij/database/model/DasObject;", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "handleRoutineComment", "procedure", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "comment", "invalidateIntrospectionCache", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "intellij.database.dialects.oracle"})
public final class OraModelHelper
extends ModelHelper {
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        super.exportApplyColumn(helper, from, to);
        if (to instanceof OraTableColumn) {
            boolean autoInc = from.flags.contains(DeColumn.Flag.AUTO_INC);
            ((OraTableColumn)to).setAutoInc(autoInc);
        }
    }

    public void exportLightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
        Intrinsics.checkParameterIsNotNull((Object)helper, (String)"helper");
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        if (from instanceof OraTableColumn && from.isAutoInc()) {
            to.flags.add(DeColumn.Flag.AUTO_INC);
        }
    }

    @Nullable
    public String handleRoutineComment(@NotNull BasicModNamedElement procedure, @Nullable String comment) {
        Intrinsics.checkParameterIsNotNull((Object)procedure, (String)"procedure");
        return procedure instanceof OraSingleRoutine && comment != null && StringsKt.startsWith$default((String)comment, (String)"Standalone", (boolean)false, (int)2, null) ? null : comment;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars);
        if (e instanceof OraCluster) {
            OraClusterColumn col = (OraClusterColumn)((OraCluster)e).getColumns().createNewOne();
            this.setTemplateName(col, "cluster_column");
            OraClusterColumn oraClusterColumn = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)oraClusterColumn, (String)"col");
            oraClusterColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("cluster_column", "cluster_column int");
        }
        if (e instanceof OraCollectionType) {
            ((OraCollectionType)e).setElementType(DataTypeFactory.of((String)"varchar"));
            vars.put("element_type", "varchar");
        }
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c) {
        BasicElement element;
        BasicElement basicElement;
        Icon originalIcon;
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Icon icon = originalIcon = super.getIcon(c);
        DasObject dasObject = c;
        if (!(dasObject instanceof BasicElement)) {
            dasObject = null;
        }
        if ((basicElement = (BasicElement)dasObject) == null) {
            basicElement = element = DbImplUtil.getMaybeBasicElement((DasObject)c);
        }
        if (element instanceof OraSourceAware && ((OraSourceAware)element).isWithDebugInfo()) {
            icon = (Icon)new LayeredIcon(new Icon[]{originalIcon, DatabaseIcons.GreenBugOverlap});
        }
        return icon;
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return OraObjectEditorFactory.INSTANCE;
    }

    public void invalidateIntrospectionCache(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        BasicModModel basicModModel = model;
        if (!(basicModModel instanceof OraModel)) {
            basicModModel = null;
        }
        OraModel oraModel = (OraModel)basicModModel;
        if (oraModel == null) {
            return;
        }
        OraModel m = oraModel;
        OraRoot oraRoot = m.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)oraRoot, (String)"m.root");
        oraRoot.setCatalogAccessMode(null);
    }
}

