/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dialects.oracle.debugger.OraLineBreakpointProperties;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraProgram;
import com.intellij.database.dialects.oracle.debugger.OraProgramFile;
import com.intellij.database.dialects.oracle.debugger.OraProgramLineMapper;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPositionFile;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.ProblematicResult;
import com.intellij.database.dialects.oracle.debugger.Result;
import com.intellij.database.dialects.oracle.debugger.ResultKt;
import com.intellij.database.dialects.oracle.debugger.SuccessfulResult;
import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001f\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010\u00a2\u0006\u0002\u0010\u0011\u001a0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00012\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a(\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00012\u0010\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\u00160\u0015j\u0002`\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0000*\u0016\u0010\u001a\"\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a8\u0006\u001b"}, d2={"findOraPositionByVirtualFileLine", "Lcom/intellij/database/dialects/oracle/debugger/Result;", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramPositionFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "mapper", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramLineMapper;", "findOraProgramByVirtualFile", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramFile;", "inReadAction", "X", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "prepareProgramLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/OraRealLineBreakpoint;", "xbp", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/database/dialects/oracle/debugger/OraLineBreakpointProperties;", "Lcom/intellij/database/dialects/oracle/debugger/OraXLineBreakpoint;", "prepareScriptLineBreakpoint", "scriptFirstLineNr", "OraXLineBreakpoint", "intellij.database.dialects.oracle"})
@JvmName(name="OracleDebugHelper")
public final class OracleDebugHelper {
    @NotNull
    public static final Result<OraRealLineBreakpoint> prepareScriptLineBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> xbp, int scriptFirstLineNr) {
        Intrinsics.checkParameterIsNotNull(xbp, (String)"xbp");
        OraScriptPosition position = new OraScriptPosition(xbp.getLine() - scriptFirstLineNr + 1);
        OraRealLineBreakpoint rbp = new OraRealLineBreakpoint(xbp, position, null, 0, false, false, null, 120, null);
        return ResultKt.success(rbp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result<OraRealLineBreakpoint> prepareProgramLineBreakpoint(@NotNull XLineBreakpoint<OraLineBreakpointProperties> xbp, @NotNull Project project, @NotNull OraProgramLineMapper mapper) {
        Result result2;
        void $this$transform$iv;
        Result<OraProgramPositionFile> pf;
        Intrinsics.checkParameterIsNotNull(xbp, (String)"xbp");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        String fileUrl = xbp.getFileUrl();
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (virtualFile == null) {
            return ResultKt.problem("Preparing breakpoint: file not found (URL: " + fileUrl + ')');
        }
        VirtualFile file = virtualFile;
        Result<OraProgramPositionFile> result3 = pf = OracleDebugHelper.findOraPositionByVirtualFileLine(file, xbp.getLine(), project, mapper);
        String description$iv = "Preparing breakpoint";
        boolean $i$f$transform = false;
        void var9_9 = $this$transform$iv;
        if (var9_9 instanceof SuccessfulResult) {
            OraProgramPositionFile it = (OraProgramPositionFile)((SuccessfulResult)$this$transform$iv).getValue();
            boolean bl = false;
            result2 = ResultKt.success(new OraRealLineBreakpoint(xbp, it.getPosition(), it.getModelElement(), 0, false, false, null, 120, null));
        } else if (var9_9 instanceof ProblematicResult) {
            result2 = ResultKt.problem(description$iv + ": " + ((ProblematicResult)$this$transform$iv).getProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    @NotNull
    public static final Result<OraProgramPositionFile> findOraPositionByVirtualFileLine(@NotNull VirtualFile file, int line, @NotNull Project project, @NotNull OraProgramLineMapper mapper) {
        Result result2;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        Result<OraProgramFile> $this$transform$iv = OracleDebugHelper.findOraProgramByVirtualFile(file, project);
        boolean $i$f$transform = false;
        Result<OraProgramFile> result3 = $this$transform$iv;
        if (result3 instanceof SuccessfulResult) {
            OraProgramFile it = (OraProgramFile)((SuccessfulResult)$this$transform$iv).getValue();
            boolean bl = false;
            result2 = ResultKt.success(new OraProgramPositionFile(new OraProgramPosition(it.getProgram(), mapper.mapFileToOra((BasicSourceAware)it.getModelElement(), line)), it.getModelElement(), it.getVirtualFile()));
        } else if (result3 instanceof ProblematicResult) {
            result2 = ResultKt.problem(((ProblematicResult)$this$transform$iv).getProblem());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    @NotNull
    public static final Result<OraProgramFile> findOraProgramByVirtualFile(@NotNull VirtualFile file, @NotNull Project project) {
        OraNamespace oraNamespace;
        DbElement dbElement;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        DbElement dbElement2 = DbImplUtil.findElement((Project)project, (VirtualFile)file);
        if (dbElement2 == null) {
            return ResultKt.problem("Cannot find a model element for file: " + file);
        }
        Object element = dbElement2;
        if (element instanceof DbElement) {
            Object object = element.getDelegate();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"element.delegate");
            element = object;
        }
        if (!((dbElement = element) instanceof OraSourceAware)) {
            dbElement = null;
        }
        OraSourceAware oraSourceAware = (OraSourceAware)dbElement;
        if (oraSourceAware == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " is not source-aware (the element class is " + element.getClass() + ')');
        }
        OraSourceAware sao = oraSourceAware;
        Object object = sao.getSchema();
        if (object == null || (object = object.getRealName()) == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " has no schema");
        }
        Object schemaName = object;
        String string = sao.getRealName();
        if (string == null) {
            return ResultKt.problem("The model element corresponded to file " + file + " has no name");
        }
        String programName = string;
        OraSourceAware oraSourceAware2 = sao;
        if (oraSourceAware2 instanceof OraRoutine) {
            oraNamespace = OraNamespace.NS_TOP;
        } else if (oraSourceAware2 instanceof OraModule) {
            oraNamespace = OraNamespace.NS_TOP;
        } else if (oraSourceAware2 instanceof OraBody) {
            oraNamespace = OraNamespace.NS_BODY;
        } else if (oraSourceAware2 instanceof OraTrigger) {
            oraNamespace = OraNamespace.NS_TRIGGER;
        } else {
            return ResultKt.problem("The model element corresponded to file " + file + " is not supported (the element kind " + ((OraSourceAware)element).getKind().code() + ')');
        }
        OraNamespace namespace = oraNamespace;
        OraProgram program = new OraProgram(namespace, (String)schemaName, programName);
        return ResultKt.success(new OraProgramFile(program, sao, file));
    }

    public static final <X> X inReadAction(@NotNull Function0<? extends X> f) {
        Intrinsics.checkParameterIsNotNull(f, (String)"f");
        return (X)ApplicationManager.getApplication().runReadAction(new Computable<X>(f){
            final /* synthetic */ Function0 $f;

            public final X compute() {
                return (X)this.$f.invoke();
            }
            {
                this.$f = function0;
            }
        });
    }
}

