/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.oracle.debugger.CodeFlowFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.ColumnFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.FragmentInfo;
import com.intellij.database.dialects.oracle.debugger.OraFragmentAnalyzerKt;
import com.intellij.database.dialects.oracle.debugger.ScalarExpressionFragmentInfo;
import com.intellij.database.dialects.oracle.debugger.UnknownFragmentInfo;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0015H\u0002J\u000e\u0010\u001e\u001a\u00020\u001d*\u0004\u0018\u00010\u0015H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer;", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/util/SearchPath;)V", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getProject", "()Lcom/intellij/openapi/project/Project;", "analyze", "Lcom/intellij/database/dialects/oracle/debugger/FragmentInfo;", "fragment", "", "parse", "Lcom/intellij/sql/psi/SqlFile;", "text", "parseFragment", "Lcom/intellij/psi/PsiElement;", "candidateTemplate", "offset", "", "tryCodeFlow", "tryColumn", "tryExpression", "hasErrors", "", "syntaxCorrect", "Companion", "intellij.database.dialects.oracle"})
public final class OraFragmentAnalyzer {
    @NotNull
    private final Project project;
    @Nullable
    private final LocalDataSource dataSource;
    private final SearchPath searchPath;
    @NotNull
    public static final String expressionCandidateText = "begin ? := (  @  ); end;";
    @NotNull
    public static final String columnCandidateText = "select ( @ ) bulk collect into ? from dual";
    @NotNull
    public static final String codeFlowCandidateText = "begin\n@\nend;";
    private static final int expressionCandidateOffset;
    private static final int columnCandidateOffset;
    private static final int codeFlowCandidateOffset;
    private static final Logger log;
    @Deprecated
    public static final Companion Companion;

    @NotNull
    public final FragmentInfo analyze(@NotNull String fragment) {
        FragmentInfo fragmentInfo;
        FragmentInfo fragmentInfo2;
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        FragmentInfo fragmentInfo3 = this.tryExpression(fragment);
        if (fragmentInfo3 == null) {
            fragmentInfo3 = fragmentInfo2 = this.tryColumn(fragment);
        }
        if (fragmentInfo3 == null) {
            fragmentInfo2 = fragmentInfo = this.tryCodeFlow(fragment);
        }
        if (fragmentInfo2 == null) {
            fragmentInfo = UnknownFragmentInfo.INSTANCE;
        }
        return fragmentInfo;
    }

    private final FragmentInfo tryExpression(String fragment) {
        PsiElement psiElement = this.parseFragment(fragment, expressionCandidateText, expressionCandidateOffset);
        if (psiElement == null) {
            return null;
        }
        PsiElement fragmentElement = psiElement;
        PsiElement psiElement2 = fragmentElement;
        if (!(psiElement2 instanceof SqlExpression)) {
            psiElement2 = null;
        }
        SqlExpression sqlExpression = (SqlExpression)psiElement2;
        if (sqlExpression == null) {
            return null;
        }
        SqlExpression sqlExpression2 = sqlExpression;
        SqlType sqlType = sqlExpression2.getSqlType();
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlType, (String)"sqlExpression.sqlType");
        SqlType sqlType2 = sqlType;
        return new ScalarExpressionFragmentInfo(sqlType2);
    }

    private final FragmentInfo tryColumn(String fragment) {
        PsiElement fragmentElement = this.parseFragment(fragment, columnCandidateText, columnCandidateOffset);
        return fragmentElement instanceof SqlExpression && this.syntaxCorrect(fragmentElement) ? (FragmentInfo)new ColumnFragmentInfo(((SqlExpression)fragmentElement).getSqlType()) : null;
    }

    private final FragmentInfo tryCodeFlow(String fragment) {
        String text;
        SqlFile file;
        String string = fragment;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String f = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.endsWith$default((CharSequence)f, (char)';', (boolean)false, (int)2, null)) {
            f = f + ';';
        }
        return this.syntaxCorrect((PsiElement)(file = this.parse(text = OraFragmentAnalyzerKt.replace(codeFlowCandidateText, codeFlowCandidateOffset, codeFlowCandidateOffset + 1, f)))) ? (FragmentInfo)new CodeFlowFragmentInfo() : null;
    }

    private final PsiElement parseFragment(String fragment, String candidateTemplate, int offset) {
        String text = OraFragmentAnalyzerKt.replace(candidateTemplate, offset, offset + 1, fragment);
        SqlFile sqlFile = this.parse(text);
        if (sqlFile == null) {
            return null;
        }
        SqlFile file = sqlFile;
        if (this.hasErrors((PsiElement)file)) {
            return null;
        }
        PsiElement psiElement = file.findElementAt(expressionCandidateOffset);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(expre\u2026ateOffset) ?: return null");
        PsiElement element = psiElement;
        while (element.getParent() != null) {
            PsiElement p;
            int offset2 = p.getTextOffset();
            if (offset2 != expressionCandidateOffset) break;
            element = p;
        }
        return this.syntaxCorrect(element) ? element : null;
    }

    private final SqlFile parse(String text) {
        try {
            SqlFile sqlFile = SqlPsiElementFactory.createROFileFromText((String)"EvaluatingFragment.sql", (CharSequence)text, (SqlLanguageDialect)((SqlLanguageDialect)OraDialect.INSTANCE), (Project)this.project, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)sqlFile, (String)"SqlPsiElementFactory.cre\u2026.INSTANCE, project, null)");
            SqlFile f = sqlFile;
            if (this.dataSource != null) {
                DbDataSource dbds = DbImplUtil.getDbDataSource((Project)this.project, (DasDataSource)((DasDataSource)this.dataSource));
                f.putUserData(DatabaseDataKeys.DATA_SOURCE_KEY, (Object)dbds);
                f.putUserData(DatabaseDataKeys.SEARCH_PATH_KEY, (Object)this.searchPath);
            }
            return f;
        }
        catch (Exception e) {
            log.trace("Exception when attempted to parse the code fragment: \n----8<----\n" + text + "\n---->8----\nException " + e.getClass().getSimpleName() + ": " + e.getMessage());
            return null;
        }
    }

    private final boolean syntaxCorrect(@Nullable PsiElement $this$syntaxCorrect) {
        return $this$syntaxCorrect != null && !this.hasErrors($this$syntaxCorrect);
    }

    private final boolean hasErrors(@NotNull PsiElement $this$hasErrors) {
        return PsiTreeUtil.hasErrorElements((PsiElement)$this$hasErrors);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final LocalDataSource getDataSource() {
        return this.dataSource;
    }

    public OraFragmentAnalyzer(@NotNull Project project, @Nullable LocalDataSource dataSource, @Nullable SearchPath searchPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.dataSource = dataSource;
        this.searchPath = searchPath;
    }

    static {
        Companion = new Companion(null);
        expressionCandidateOffset = StringsKt.indexOf$default((CharSequence)expressionCandidateText, (char)'@', (int)0, (boolean)false, (int)6, null);
        columnCandidateOffset = StringsKt.indexOf$default((CharSequence)columnCandidateText, (char)'@', (int)0, (boolean)false, (int)6, null);
        codeFlowCandidateOffset = StringsKt.indexOf$default((CharSequence)codeFlowCandidateText, (char)'@', (int)0, (boolean)false, (int)6, null);
        Logger logger = Logger.getInstance(OraFragmentAnalyzer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(OraFr\u2026mentAnalyzer::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraFragmentAnalyzer$Companion;", "", "()V", "codeFlowCandidateOffset", "", "codeFlowCandidateText", "", "columnCandidateOffset", "columnCandidateText", "expressionCandidateOffset", "expressionCandidateText", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.database.dialects.oracle"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

