/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.IndexedOutParameter;
import com.intellij.database.dataSource.connection.statements.OutParameter;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StringOutParam;
import com.intellij.database.debugger.SqlDebugFunKt;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableKt;
import com.intellij.database.debugger.SqlVariableValue;
import com.intellij.database.dialects.oracle.debugger.ApiResult;
import com.intellij.database.dialects.oracle.debugger.CallDefinition;
import com.intellij.database.dialects.oracle.debugger.CallParams;
import com.intellij.database.dialects.oracle.debugger.DebugCommand;
import com.intellij.database.dialects.oracle.debugger.DebugContinuationCommand;
import com.intellij.database.dialects.oracle.debugger.DebugGracefulResumingCommand;
import com.intellij.database.dialects.oracle.debugger.DebugImmediateCommand;
import com.intellij.database.dialects.oracle.debugger.DebugNativeResumingCommand;
import com.intellij.database.dialects.oracle.debugger.DeregisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.EvaluateExpressionCommand;
import com.intellij.database.dialects.oracle.debugger.ExecuteFragmentCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulResumeCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInProgramCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulRunToPositionInScriptCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOutCommand;
import com.intellij.database.dialects.oracle.debugger.GracefulStepOverCommand;
import com.intellij.database.dialects.oracle.debugger.IterateImmediateCommand;
import com.intellij.database.dialects.oracle.debugger.OraBaseSession;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugException;
import com.intellij.database.dialects.oracle.debugger.OraDebugExecutionResult;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerEnumsKt;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSession$WhenMappings;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSessionQueries;
import com.intellij.database.dialects.oracle.debugger.OraExecutingSession;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraRealLineBreakpoint;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OraStringArrayOutParameter;
import com.intellij.database.dialects.oracle.debugger.OraUnknownPosition;
import com.intellij.database.dialects.oracle.debugger.PauseCommand;
import com.intellij.database.dialects.oracle.debugger.PauseReason;
import com.intellij.database.dialects.oracle.debugger.ProcessState;
import com.intellij.database.dialects.oracle.debugger.RegisterBreakpointCommand;
import com.intellij.database.dialects.oracle.debugger.RetrieveVariablesCommand;
import com.intellij.database.dialects.oracle.debugger.RunToPositionCommand;
import com.intellij.database.dialects.oracle.debugger.StepOutCommand;
import com.intellij.database.dialects.oracle.debugger.StopCommand;
import com.intellij.database.dialects.oracle.debugger.TransferHolder;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.psi.SqlType;
import com.intellij.util.text.StringKt;
import java.rmi.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u00ca\u00012\u00020\u0001:\u0002\u00ca\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010c\u001a\u00020\u0018J\b\u0010d\u001a\u00020\u0018H\u0002J\b\u0010e\u001a\u00020\u0018H\u0002JM\u0010f\u001a\u0002Hg\"\b\b\u0000\u0010h*\u00020i\"\u0004\b\u0001\u0010g2\u0006\u0010j\u001a\u0002Hh2\u0012\u0010k\u001a\n\u0012\u0006\b\u0001\u0012\u00020m0l\"\u00020m2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u0002Hg0\u0016H\u0014\u00a2\u0006\u0002\u0010pJ\u0017\u0010q\u001a\u0004\u0018\u00010\u00072\u0006\u0010r\u001a\u00020RH\u0002\u00a2\u0006\u0002\u0010sJ\b\u0010t\u001a\u00020\u0018H\u0016J\u0006\u0010u\u001a\u00020\u0018J\b\u0010v\u001a\u00020\u0018H\u0002J\b\u0010w\u001a\u00020\u0018H\u0002J$\u0010x\u001a\u00020\u00182\u0006\u0010y\u001a\u00020R2\u0012\u0010n\u001a\u000e\u0012\u0004\u0012\u00020K\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\b\u0010z\u001a\u00020\u0018H\u0002J\b\u0010{\u001a\u00020\u0018H\u0002J\u0010\u0010|\u001a\u00020\u00182\u0006\u0010}\u001a\u00020~H\u0002J\u001e\u0010|\u001a\u00020\u00182\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u000b\b\u0002\u0010}\u001a\u0005\u0018\u00010\u0081\u0001H\u0002J\u0012\u0010\u0082\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0083\u0001H\u0002J\u0012\u0010\u0084\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0085\u0001H\u0002J\u0012\u0010\u0086\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0087\u0001H\u0002J\u0012\u0010\u0088\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0089\u0001H\u0002J\t\u0010\u008a\u0001\u001a\u00020\u0018H\u0002J\u0012\u0010\u008b\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u008c\u0001H\u0002J\u0012\u0010\u008d\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u008e\u0001H\u0002J\u0012\u0010\u008f\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0090\u0001H\u0002J\u0012\u0010\u0091\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0092\u0001H\u0002J\t\u0010\u0093\u0001\u001a\u00020\u0018H\u0002J\u0013\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020\u0017H\u0002J\u0007\u0010\u0097\u0001\u001a\u00020\u0007J\u0018\u0010\u0098\u0001\u001a\u00020\u00182\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fH\u0002J\u0013\u0010\u009a\u0001\u001a\u00020\u00182\b\u0010\u009b\u0001\u001a\u00030\u009c\u0001H\u0002J6\u0010\u009d\u0001\u001a\u00020\u00182\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u000f\u0010\u00a0\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020m0l2\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002\u00a2\u0006\u0003\u0010\u00a2\u0001J\u0089\u0001\u0010\u00a3\u0001\u001a\u00020\u00182\u0007\u0010\u00a4\u0001\u001a\u00020\u00072\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a6\u00012\u0007\u0010\u00a8\u0001\u001a\u00020R2\u0007\u0010\u00a9\u0001\u001a\u00020R2\u0006\u0010S\u001a\u00020R2\b\u0010\u00aa\u0001\u001a\u00030\u0080\u00012\t\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\u00172\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\u00172\t\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u00172\u0007\u0010\u00ae\u0001\u001a\u00020\u00072\u0007\u0010\u00af\u0001\u001a\u00020\u00072\n\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u0081\u0001H\u0002J\t\u0010\u00b0\u0001\u001a\u00020\u0018H\u0016J\u0010\u0010\u00b1\u0001\u001a\u00020\u00182\u0007\u0010}\u001a\u00030\u0081\u0001J2\u0010\u00b2\u0001\u001a\u00020 2\b\u0010\u00aa\u0001\u001a\u00030\u0080\u00012\t\u0010\u00ab\u0001\u001a\u0004\u0018\u00010\u00172\t\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\u00172\u0007\u0010\u00a8\u0001\u001a\u00020RH\u0002J\t\u0010\u00b3\u0001\u001a\u00020\u0018H\u0002J\u0007\u0010\u00b4\u0001\u001a\u00020\u0018J\t\u0010\u00b5\u0001\u001a\u00020\u0018H\u0002J\u0007\u0010\u00b6\u0001\u001a\u00020\u0018J\t\u0010\u00b7\u0001\u001a\u00020\u0018H\u0002JK\u0010\u00b8\u0001\u001a\u00020\u00182\u0007\u0010\u00b9\u0001\u001a\u00020 27\u0010n\u001a3\u0012\u0014\u0012\u00120K\u00a2\u0006\r\b!\u0012\t\b\"\u0012\u0005\b\b(\u00ba\u0001\u0012\u0013\u0012\u00110R\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(y\u0012\u0004\u0012\u00020\u00180\u001eH\u0002J\t\u0010\u00bb\u0001\u001a\u00020\u0018H\u0002J\t\u0010\u00bc\u0001\u001a\u00020\u0018H\u0002J\u0007\u0010\u00bd\u0001\u001a\u00020\u0018J\t\u0010\u00be\u0001\u001a\u00020\u0018H\u0002J\u001e\u0010\u00bf\u0001\u001a\u00020\u00182\u0013\u0010\u00c0\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\t\u0010\u00c1\u0001\u001a\u00020\u0018H\u0002J\t\u0010\u00c2\u0001\u001a\u00020\u0018H\u0002J\u0019\u0010\u00c3\u0001\u001a\u00020\u00182\u0006\u00104\u001a\u00020$2\u0006\u00105\u001a\u00020$H\u0002J \u0010\u00c4\u0001\u001a\t\u0012\u0005\u0012\u00030\u00c5\u00010\u001f*\u000e\u0012\u0005\u0012\u00030\u00c5\u00010\u001fj\u0003`\u00c6\u0001H\u0002J\u001f\u0010\u00c7\u0001\u001a\u00020\u0018*\u00030\u00c5\u00012\u000f\u0010\u00c8\u0001\u001a\n\u0012\u0005\u0012\u00030\u00c5\u00010\u00c9\u0001H\u0002R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cRP\u0010\u001d\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R \u0010*\u001a\b\u0012\u0004\u0012\u00020\u00180+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R5\u00100\u001a\u001d\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020\u00180\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u001a\"\u0004\b2\u0010\u001cRJ\u00103\u001a2\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(4\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020\u00180\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010'\"\u0004\b7\u0010)R\u001c\u00108\u001a\u0004\u0018\u000109X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u001a\u0010>\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u000b\"\u0004\b@\u0010\rR\u000e\u0010A\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010H\u001a\u00020G2\u0006\u0010F\u001a\u00020G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u001e\u0010L\u001a\u00020K2\u0006\u0010F\u001a\u00020K@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010\u000bR*\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020 0\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bP\u0010QR\u001e\u0010S\u001a\u00020R2\u0006\u0010F\u001a\u00020R@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bT\u0010UR$\u0010%\u001a\u00020$2\u0006\u00105\u001a\u00020$8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020$0[X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010^\u001a\u00020]2\u0006\u0010\\\u001a\u00020]@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b_\u0010`R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010b\u00a8\u0006\u00cb\u0001"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;", "Lcom/intellij/database/dialects/oracle/debugger/OraBaseSession;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "target", "Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "scriptIsMeaningful", "", "(Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;Z)V", "attached", "getAttached", "()Z", "setAttached", "(Z)V", "commandHolder", "Lcom/intellij/database/dialects/oracle/debugger/TransferHolder;", "Lcom/intellij/database/dialects/oracle/debugger/DebugContinuationCommand;", "commandQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/database/dialects/oracle/debugger/DebugImmediateCommand;", "dataPending", "dbmsOutputConsumer", "Lkotlin/Function1;", "", "", "getDbmsOutputConsumer", "()Lkotlin/jvm/functions/Function1;", "setDbmsOutputConsumer", "(Lkotlin/jvm/functions/Function1;)V", "onEventInfo", "Lkotlin/Function2;", "", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "Lkotlin/ParameterName;", "name", "stack", "Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "state", "getOnEventInfo$intellij_database_dialects_oracle", "()Lkotlin/jvm/functions/Function2;", "setOnEventInfo$intellij_database_dialects_oracle", "(Lkotlin/jvm/functions/Function2;)V", "onGoodTimeToRetrieveAdditionalData", "Lkotlin/Function0;", "getOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle", "()Lkotlin/jvm/functions/Function0;", "setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle", "(Lkotlin/jvm/functions/Function0;)V", "onMainLoopIteration", "getOnMainLoopIteration$intellij_database_dialects_oracle", "setOnMainLoopIteration$intellij_database_dialects_oracle", "onStateTransition", "oldState", "newState", "getOnStateTransition$intellij_database_dialects_oracle", "setOnStateTransition$intellij_database_dialects_oracle", "probeVersion", "Lcom/intellij/database/util/Version;", "getProbeVersion", "()Lcom/intellij/database/util/Version;", "setProbeVersion", "(Lcom/intellij/database/util/Version;)V", "processIsActive", "getProcessIsActive", "setProcessIsActive", "processIsInsideGracefulLoop", "processIsInsideMainLoop", "processIsRunning", "processIsTerminated", "processIsWaiting", "<set-?>", "Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "reason", "getReason", "()Lcom/intellij/database/dialects/oracle/debugger/PauseReason;", "Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "result", "getResult", "()Lcom/intellij/database/dialects/oracle/debugger/ApiResult;", "getScriptIsMeaningful", "getStack", "()Ljava/util/List;", "", "stackDepth", "getStackDepth", "()I", "getState", "()Lcom/intellij/database/dialects/oracle/debugger/ProcessState;", "setState", "(Lcom/intellij/database/dialects/oracle/debugger/ProcessState;)V", "stateHolder", "Ljava/util/concurrent/atomic/AtomicReference;", "value", "", "stoppingMoment", "setStoppingMoment", "(J)V", "getTarget", "()Lcom/intellij/database/dialects/oracle/debugger/OraExecutingSession;", "abortTheProcess", "attachToTargetSession", "buckUpTheLoop", "call", "R", "D", "Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;", "definition", "parameters", "", "", "handler", "Lcom/intellij/database/dataSource/connection/statements/ResultsProducer;", "(Lcom/intellij/database/dialects/oracle/debugger/CallDefinition;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "checkSessionActivity", "sessionId", "(I)Ljava/lang/Boolean;", "close", "completeTheProcess", "connectionBroken", "deregisterAllBreakpoints", "deregisterLineBreakpoint", "id", "detachFromTargetSession", "disconnectTargetSessionHard", "doContinue", "command", "Lcom/intellij/database/dialects/oracle/debugger/DebugNativeResumingCommand;", "breakFlags", "", "Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;", "doDeregisterLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/DeregisterBreakpointCommand;", "doEvaluateExpression", "Lcom/intellij/database/dialects/oracle/debugger/EvaluateExpressionCommand;", "doExecuteFragment", "Lcom/intellij/database/dialects/oracle/debugger/ExecuteFragmentCommand;", "doGracefulResume", "Lcom/intellij/database/dialects/oracle/debugger/DebugGracefulResumingCommand;", "doPause", "doRegisterLineBreakpoint", "Lcom/intellij/database/dialects/oracle/debugger/RegisterBreakpointCommand;", "doRetrieveVariables", "Lcom/intellij/database/dialects/oracle/debugger/RetrieveVariablesCommand;", "doRunToPosition", "Lcom/intellij/database/dialects/oracle/debugger/RunToPositionCommand;", "doStepOut", "Lcom/intellij/database/dialects/oracle/debugger/StepOutCommand;", "doSynchronize", "executeAndFetchResult", "Lcom/intellij/database/dialects/oracle/debugger/OraDebugExecutionResult;", "block", "goingToRelax", "handleStack", "listing", "handleSyncException", "thrownException", "", "handleSyncOrContinue", "proc", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;", "params", "lastCommand", "(Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries$SyncLikeProc;[Ljava/lang/Object;Lcom/intellij/database/dialects/oracle/debugger/DebugCommand;)V", "handleSyncResult", "graceful", "resultCode", "", "reasonCode", "lineNr", "breakpoint", "namespaceCode", "programSchema", "programName", "entryPointName", "terminated", "isProcedure", "initRemote", "issueCommand", "makeFrame", "markProcessTerminated", "performFinishLoop", "performImmediateCommands", "performMainLoop", "printListing", "registerLineBreakpoint", "position", "r", "resetProcessState", "resetResult", "resetState", "retrieveData", "retrieveDbmsOutput", "consumer", "retrieveIntermediateData", "retrieveStack", "stateChanged", "flatten", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "flattenTo", "container", "", "Companion", "intellij.database.dialects.oracle"})
public final class OraDebuggingSession
extends OraBaseSession {
    @NotNull
    private Function1<? super String, Unit> dbmsOutputConsumer;
    @Nullable
    private Version probeVersion;
    private boolean attached;
    private boolean processIsActive;
    private boolean processIsInsideMainLoop;
    private boolean processIsInsideGracefulLoop;
    private boolean processIsRunning;
    private boolean processIsWaiting;
    private boolean processIsTerminated;
    private int stackDepth;
    @NotNull
    private List<? extends OraPosition> stack;
    @NotNull
    private PauseReason reason;
    @NotNull
    private ApiResult result;
    private final AtomicReference<ProcessState> stateHolder;
    private final TransferHolder<DebugContinuationCommand> commandHolder;
    private final ConcurrentLinkedQueue<DebugImmediateCommand> commandQueue;
    private long stoppingMoment;
    private boolean dataPending;
    @NotNull
    private Function2<? super ProcessState, ? super ProcessState, Unit> onStateTransition;
    @NotNull
    private Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit> onEventInfo;
    @NotNull
    private Function1<? super ProcessState, Unit> onMainLoopIteration;
    @NotNull
    private Function0<Unit> onGoodTimeToRetrieveAdditionalData;
    @NotNull
    private final OraExecutingSession target;
    private final boolean scriptIsMeaningful;
    public static final byte stopOnReturnWhenStepOut = 0;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Function1<String, Unit> getDbmsOutputConsumer() {
        return this.dbmsOutputConsumer;
    }

    public final void setDbmsOutputConsumer(@NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.dbmsOutputConsumer = function1;
    }

    @Nullable
    public final Version getProbeVersion() {
        return this.probeVersion;
    }

    public final void setProbeVersion(@Nullable Version version) {
        this.probeVersion = version;
    }

    public final boolean getAttached() {
        return this.attached;
    }

    public final void setAttached(boolean bl) {
        this.attached = bl;
    }

    public final boolean getProcessIsActive() {
        return this.processIsActive;
    }

    public final void setProcessIsActive(boolean bl) {
        this.processIsActive = bl;
    }

    public final int getStackDepth() {
        return this.stackDepth;
    }

    @NotNull
    public final List<OraPosition> getStack() {
        return this.stack;
    }

    @NotNull
    public final PauseReason getReason() {
        return this.reason;
    }

    @NotNull
    public final ApiResult getResult() {
        return this.result;
    }

    @NotNull
    public final ProcessState getState() {
        ProcessState processState = this.stateHolder.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)processState), (String)"stateHolder.get()");
        return processState;
    }

    private final void setState(ProcessState newState) {
        ProcessState oldState = this.stateHolder.getAndSet(newState);
        if (oldState != newState) {
            ProcessState processState = oldState;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)processState), (String)"oldState");
            this.stateChanged(processState, newState);
        }
    }

    private final void setStoppingMoment(long value) {
        this.stoppingMoment = value;
    }

    @NotNull
    public final Function2<ProcessState, ProcessState, Unit> getOnStateTransition$intellij_database_dialects_oracle() {
        return this.onStateTransition;
    }

    public final void setOnStateTransition$intellij_database_dialects_oracle(@NotNull Function2<? super ProcessState, ? super ProcessState, Unit> function2) {
        Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
        this.onStateTransition = function2;
    }

    @NotNull
    public final Function2<List<? extends OraPosition>, ProcessState, Unit> getOnEventInfo$intellij_database_dialects_oracle() {
        return this.onEventInfo;
    }

    public final void setOnEventInfo$intellij_database_dialects_oracle(@NotNull Function2<? super List<? extends OraPosition>, ? super ProcessState, Unit> function2) {
        Intrinsics.checkParameterIsNotNull(function2, (String)"<set-?>");
        this.onEventInfo = function2;
    }

    @NotNull
    public final Function1<ProcessState, Unit> getOnMainLoopIteration$intellij_database_dialects_oracle() {
        return this.onMainLoopIteration;
    }

    public final void setOnMainLoopIteration$intellij_database_dialects_oracle(@NotNull Function1<? super ProcessState, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.onMainLoopIteration = function1;
    }

    @NotNull
    public final Function0<Unit> getOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle() {
        return this.onGoodTimeToRetrieveAdditionalData;
    }

    public final void setOnGoodTimeToRetrieveAdditionalData$intellij_database_dialects_oracle(@NotNull Function0<Unit> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.onGoodTimeToRetrieveAdditionalData = function0;
    }

    @Override
    public void initRemote() {
        super.initRemote();
        this.trace("The session id: " + this.getSessionId());
        boolean bl = this.getSessionId() != 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-OraDebuggingSession$initRemote$32 = false;
            String $i$a$-assert-OraDebuggingSession$initRemote$32 = "The debugging session Id is zero";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OraDebuggingSession$initRemote$32));
        }
        bl = this.target.getSessionId() != 0;
        bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The target session Id is zero";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (this.getSessionId() == this.target.getSessionId()) {
            String errorMessage = "The target and debug sessions are the same one. Impossible to debug.";
            this.getLog().error(errorMessage);
            throw (Throwable)new IllegalStateException(errorMessage);
        }
        this.attachToTargetSession();
    }

    private final void attachToTargetSession() {
        this.resetResult();
        this.attached = false;
        try {
            Boolean targetIsActive = this.checkSessionActivity(this.target.getSessionId());
            if (targetIsActive == null) {
                String message = "Cannot attach to the target session: the session " + this.getSessionId() + " doesn't exist";
                throw (Throwable)new OraDebugException(message);
            }
        }
        catch (SQLException sqle) {
            int errorCode = sqle.getErrorCode();
            String string = sqle.getMessage();
            if (string == null) {
                string = "Error " + errorCode;
            }
            String errorMessage = string;
            String message = null;
            message = errorCode == 6550 && StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"ORA-00942", (boolean)false, (int)2, null) ? "Cannot access the SYS.V_$SESSION table, debugging is not possible." : "Cannot check the target session status: Error " + errorCode + ": " + errorMessage;
            this.trace(message);
            throw (Throwable)new OraDebugException(message, sqle);
        }
        catch (Exception e) {
            String message = "Cannot check the target session status: Exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
            this.trace(message);
            throw (Throwable)new OraDebugException(message, e);
        }
        String string = this.target.getDebugId();
        if (string == null) {
            throw (Throwable)new OraDebugException("Cannot attach to the session that is not debuggable yet.");
        }
        String debugId = string;
        try {
            this.call((CallDefinition)OraDebuggingSessionQueries.AttachProc.INSTANCE, new Object[]{debugId}, (Function1)new Function1<ResultsProducer, Unit>(this){
                final /* synthetic */ OraDebuggingSession this$0;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    int major = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.AttachProc.INSTANCE.getVersionMajor())).intValue();
                    int minor = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.AttachProc.INSTANCE.getVersionMinor())).intValue();
                    this.this$0.setProbeVersion(Version.of((int[])new int[]{major, minor}));
                }
                {
                    this.this$0 = oraDebuggingSession;
                    super(1);
                }
            });
            this.trace("Attached to the target session");
            this.attached = true;
        }
        catch (Exception e) {
            this.attached = false;
            String message = "Failed to attach: " + e.getClass().getSimpleName() + ": " + e.getMessage();
            this.trace(message);
            throw (Throwable)new OraDebugException(message, e);
        }
    }

    private final void detachFromTargetSession() {
        this.resetResult();
        if (this.attached) {
            try {
                this.callProcedure("sys.dbms_debug.detach_session", new Object[0]);
                this.trace("Detached from the target session");
            }
            catch (ConnectException rmiConnectException) {
                this.trace("Connection broken");
            }
            this.attached = false;
        }
    }

    @Override
    protected <D extends CallDefinition, R> R call(@NotNull D definition, @NotNull Object[] parameters2, @NotNull Function1<? super ResultsProducer, ? extends R> handler) {
        Intrinsics.checkParameterIsNotNull(definition, (String)"definition");
        Intrinsics.checkParameterIsNotNull((Object)parameters2, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
        try {
            Object[] objectArray = Arrays.copyOf(parameters2, parameters2.length);
            Function1<? super ResultsProducer, ? extends R> function1 = handler;
            return super.call(definition, objectArray, function1);
        }
        catch (ConnectException rmiConnectException) {
            if (this.getState().compareTo((Enum)ProcessState.STATE_STARTING_UP) >= 0) {
                this.setState(ProcessState.STATE_BROKEN);
            }
            throw (Throwable)rmiConnectException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Boolean checkSessionActivity(int sessionId) {
        void statusStr;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        this.call((CallDefinition)OraDebuggingSessionQueries.CheckSessionActivityProc.INSTANCE, new Object[]{sessionId}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ObjectRef)statusStr){
            final /* synthetic */ Ref.ObjectRef $statusStr;

            public final void invoke(@NotNull ResultsProducer producer) {
                Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                this.$statusStr.element = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.CheckSessionActivityProc.INSTANCE.getStatus());
            }
            {
                this.$statusStr = objectRef;
                super(1);
            }
        });
        String string = (String)statusStr.element;
        return string != null ? Boolean.valueOf(ModelSerializationFun.startsWith((String)string, (char)'A')) : null;
    }

    public final void issueCommand(@NotNull DebugCommand command2) {
        block1: {
            DebugCommand debugCommand;
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)command2, (String)"command");
                debugCommand = command2;
                if (!(debugCommand instanceof DebugImmediateCommand)) break block0;
                this.commandQueue.offer((DebugImmediateCommand)command2);
                if (this.processIsInsideGracefulLoop) break block1;
                this.buckUpTheLoop();
                break block1;
            }
            if (!(debugCommand instanceof DebugContinuationCommand)) break block1;
            this.commandHolder.offer((DebugContinuationCommand)command2);
        }
    }

    public final boolean goingToRelax() {
        return this.commandHolder.isEmpty();
    }

    private final void buckUpTheLoop() {
        if (this.processIsInsideMainLoop) {
            this.commandHolder.offerIfEmpty(IterateImmediateCommand.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performMainLoop() {
        this.processIsTerminated = false;
        this.trace("Entering the Main Loop");
        this.setState(ProcessState.STATE_KICKED_OFF);
        try {
            this.processIsInsideMainLoop = true;
            this.doSynchronize();
            boolean bl = this.target.getExecuting();
            if (bl) {
                this.setState(ProcessState.STATE_STARTING_UP);
                this.performImmediateCommands();
                this.dataPending = true;
            } else if (!bl) {
                this.trace("execution failed");
                this.setState(ProcessState.STATE_FAIL);
                this.onMainLoopIteration.invoke((Object)this.getState());
            }
            while (this.target.getExecuting() && !this.processIsTerminated && this.getState().compareTo((Enum)ProcessState.STATE_COMPLETED) < 0) {
                try {
                    if (!this.target.getUnderDebug()) {
                        this.markProcessTerminated();
                        this.setState(ProcessState.STATE_COMPLETED);
                        break;
                    }
                    this.onMainLoopIteration.invoke((Object)this.getState());
                    if (this.dataPending && this.getState().isInteractive() && this.goingToRelax()) {
                        this.retrieveData();
                    }
                    if (SqlDebugFunKt.elapsedTime((long)this.stoppingMoment) > 3000L) {
                        this.disconnectTargetSessionHard();
                    }
                    Object object = this.commandQueue;
                    int n = 0;
                    if (!object.isEmpty()) {
                        object = (Comparable)((Object)this.getState());
                        if (object.compareTo((Comparable)((Object)ProcessState.STATE_RESUMING)) >= 0 && object.compareTo((Comparable)((Object)ProcessState.STATE_RUNNING)) <= 0) {
                            this.setState(ProcessState.STATE_RELAXING);
                        }
                        this.performImmediateCommands();
                        continue;
                    }
                    DebugContinuationCommand command2 = this.commandHolder.take(this.getState().isInteractive() ? 1000L : 0L);
                    if (command2 != null) {
                        this.trace("Took command " + command2);
                        DebugContinuationCommand debugContinuationCommand = command2;
                        if (debugContinuationCommand instanceof IterateImmediateCommand) continue;
                        if (debugContinuationCommand instanceof DebugGracefulResumingCommand) {
                            this.doGracefulResume((DebugGracefulResumingCommand)command2);
                        } else if (debugContinuationCommand instanceof PauseCommand) {
                            this.doPause();
                        } else if (debugContinuationCommand instanceof StepOutCommand) {
                            this.doStepOut((StepOutCommand)command2);
                        } else if (debugContinuationCommand instanceof RunToPositionCommand) {
                            this.doRunToPosition((RunToPositionCommand)command2);
                        } else if (debugContinuationCommand instanceof StopCommand) {
                            this.setStoppingMoment(System.currentTimeMillis());
                            this.doContinue((DebugNativeResumingCommand)command2);
                        } else if (debugContinuationCommand instanceof DebugNativeResumingCommand) {
                            this.doContinue((DebugNativeResumingCommand)command2);
                        }
                        this.dataPending = this.result == ApiResult.RESULT_OK;
                        continue;
                    }
                    switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$0[this.getState().ordinal()]) {
                        case 1: {
                            n = 2;
                            int n2 = 32;
                            OraDebuggingSession oraDebuggingSession = this;
                            boolean bl2 = false;
                            short s = (short)(n | n2);
                            n = s;
                            n2 = 12;
                            bl2 = false;
                            s = (short)(n | n2);
                            OraDebuggingSession.doContinue$default(oraDebuggingSession, s, null, 2, null);
                            break;
                        }
                        case 2: {
                            this.doSynchronize();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            OraDebuggingSession.doContinue$default(this, (short)0, null, 2, null);
                            break;
                        }
                        default: {
                            OraDebuggingSession.doContinue$default(this, (short)2, null, 2, null);
                            break;
                        }
                    }
                }
                catch (InterruptedException i2) {
                    this.trace("InterruptedException \u2014\u00a0attempting to stop the executing process");
                    this.commandHolder.offer(StopCommand.INSTANCE);
                }
                catch (SQLException e) {
                    int errorCode = e.getErrorCode();
                    this.trace("Error " + errorCode + " state " + e.getSQLState() + ": " + e.getMessage());
                    if (errorCode != 17008) continue;
                    this.connectionBroken();
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.processIsInsideMainLoop = false;
            this.commandHolder.clear();
            this.commandQueue.clear();
            this.trace("Leaving the Main Loop");
        }
    }

    private final void performImmediateCommands() {
        if (this.commandQueue.isEmpty()) {
            return;
        }
        while (this.commandQueue.poll() != null) {
            DebugImmediateCommand command2;
            DebugImmediateCommand debugImmediateCommand = command2;
            if (debugImmediateCommand instanceof RegisterBreakpointCommand) {
                this.doRegisterLineBreakpoint((RegisterBreakpointCommand)command2);
                continue;
            }
            if (debugImmediateCommand instanceof DeregisterBreakpointCommand) {
                this.doDeregisterLineBreakpoint((DeregisterBreakpointCommand)command2);
                continue;
            }
            if (debugImmediateCommand instanceof RetrieveVariablesCommand) {
                this.doRetrieveVariables((RetrieveVariablesCommand)command2);
                continue;
            }
            if (debugImmediateCommand instanceof EvaluateExpressionCommand) {
                this.doEvaluateExpression((EvaluateExpressionCommand)command2);
                continue;
            }
            if (!(debugImmediateCommand instanceof ExecuteFragmentCommand)) continue;
            this.doExecuteFragment((ExecuteFragmentCommand)command2);
        }
    }

    public final void completeTheProcess() {
        if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) < 0) {
            this.setState(ProcessState.STATE_COMPLETING);
        }
    }

    public final void abortTheProcess() {
        this.issueCommand(StopCommand.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void performFinishLoop() {
        this.commandHolder.clear();
        int targetSessionId = this.target.getSessionId();
        Boolean targetIsActive = this.checkSessionActivity(targetSessionId);
        if (targetIsActive == null) {
            this.trace("Target session " + targetSessionId + " disappeared unexpectedly. Stopping the debugger.");
            this.setState(ProcessState.STATE_BROKEN);
            this.markProcessTerminated();
            return;
        }
        long t1 = System.currentTimeMillis();
        while (this.target.getUnderDebug() && !this.target.getTurningDebugOFF()) {
            if (SqlDebugFunKt.elapsedTime((long)t1) > 3000L) {
                this.trace("Target session " + targetSessionId + " seems hung. Disconnecting.");
                this.target.disconnectAndAbandonConnection();
                this.setState(ProcessState.STATE_BROKEN);
                this.markProcessTerminated();
                return;
            }
            Thread.sleep(250L);
        }
        this.processIsTerminated = false;
        this.trace("Entering the Finishing Loop");
        this.setState(ProcessState.STATE_FINISHING);
        try {
            this.doSynchronize();
            this.deregisterAllBreakpoints();
            this.retrieveDbmsOutput(this.dbmsOutputConsumer);
            while (this.target.getTurningDebugOFF() && !this.processIsTerminated && !this.getState().isTerminated()) {
                try {
                    OraDebuggingSession.doContinue$default(this, (short)0, null, 2, null);
                }
                catch (ConnectException rmiConnectException) {
                    this.trace("Connection broken");
                    break;
                }
                catch (Throwable e) {
                    this.trace("Exception " + e.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        finally {
            this.trace("Leaving the Finishing Loop");
        }
    }

    private final void doPause() {
        if (this.getState() == ProcessState.STATE_RESUMING || this.getState() == ProcessState.STATE_RUNNING) {
            int n = 2;
            int n2 = 12;
            boolean bl = false;
            n = (short)(n | n2);
            n2 = 16;
            bl = false;
            n = (short)(n | n2);
            n2 = 32;
            bl = false;
            n = (short)(n | n2);
            n2 = 512;
            bl = false;
            short breakFlags = (short)(n | n2);
            this.trace("doContinue with flags = " + breakFlags + " for pausing");
            this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, new Number[]{breakFlags}, null);
        }
    }

    private final void doSynchronize() {
        this.resetResult();
        this.trace("doSynchronize");
        OraDebuggingSessionQueries.SyncLikeProc syncLikeProc = OraDebuggingSessionQueries.SynchronizeProc.INSTANCE;
        OraDebuggingSession oraDebuggingSession = this;
        Object[] objectArray = new Object[]{};
        oraDebuggingSession.handleSyncOrContinue(syncLikeProc, objectArray, null);
    }

    private final void doContinue(DebugNativeResumingCommand command2) {
        this.doContinue(command2.getBreakFlags(), command2);
    }

    private final void doContinue(short breakFlags, DebugCommand command2) {
        this.resetResult();
        this.trace("doContinue with flags = " + breakFlags);
        this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, new Number[]{breakFlags}, command2);
    }

    static /* synthetic */ void doContinue$default(OraDebuggingSession oraDebuggingSession, short s, DebugCommand debugCommand, int n, Object object) {
        if ((n & 2) != 0) {
            debugCommand = null;
        }
        oraDebuggingSession.doContinue(s, debugCommand);
    }

    private final void doStepOut(StepOutCommand command2) {
        this.resetResult();
        int depth = command2.getDepth();
        short bf = command2.getBreakFlags();
        this.trace("doStepOut with stack depth = " + depth + " and flags = " + bf);
        this.handleSyncOrContinue(OraDebuggingSessionQueries.StepOutProc.INSTANCE, new Number[]{depth, bf, (byte)0}, command2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doRunToPosition(RunToPositionCommand command2) {
        void breakpointId;
        void breakpointResult;
        OraPosition position = command2.getPosition();
        this.trace("doRunToPosition " + position);
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = ApiResult.RESULT_UNRECOGNIZED;
        this.registerLineBreakpoint(position, (Function2<? super ApiResult, ? super Integer, Unit>)((Function2)new Function2<ApiResult, Integer, Unit>((Ref.ObjectRef)breakpointResult, (Ref.IntRef)breakpointId){
            final /* synthetic */ Ref.ObjectRef $breakpointResult;
            final /* synthetic */ Ref.IntRef $breakpointId;

            public final void invoke(@NotNull ApiResult r, int id) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)r), (String)"r");
                this.$breakpointResult.element = r;
                this.$breakpointId.element = id;
            }
            {
                this.$breakpointResult = objectRef;
                this.$breakpointId = intRef;
                super(2);
            }
        }));
        if ((ApiResult)((Object)breakpointResult.element) != ApiResult.RESULT_OK) {
            this.trace("Cannot run to position " + position + ": failed to register breakpoint: " + (Object)((Object)((ApiResult)((Object)breakpointResult.element))));
            return;
        }
        try {
            this.handleSyncOrContinue(OraDebuggingSessionQueries.ContinueProc.INSTANCE, new Number[]{command2.getBreakFlags()}, command2);
            this.deregisterLineBreakpoint(breakpointId.element, (Function1<? super ApiResult, Unit>)((Function1)new Function1<ApiResult, Unit>(this, (Ref.IntRef)breakpointId){
                final /* synthetic */ OraDebuggingSession this$0;
                final /* synthetic */ Ref.IntRef $breakpointId;

                public final void invoke(@NotNull ApiResult r) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)r), (String)"r");
                    if (r != ApiResult.RESULT_OK) {
                        this.this$0.trace("Failed to deregister temporary breakpoint " + this.$breakpointId.element + " after running to position");
                    }
                }
                {
                    this.this$0 = oraDebuggingSession;
                    this.$breakpointId = intRef;
                    super(1);
                }
            }));
        }
        catch (Throwable throwable) {
            this.deregisterLineBreakpoint(breakpointId.element, (Function1<? super ApiResult, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleSyncOrContinue(OraDebuggingSessionQueries.SyncLikeProc proc, Object[] params, DebugCommand lastCommand) {
        boolean bl = proc.getSkip() == params.length;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22 = false;
            String $i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22 = "Input parameters number mismatch: skip number is " + proc.getSkip() + " but passed " + params.length;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-OraDebuggingSession$handleSyncOrContinue$22));
        }
        CallableStatementBasis basis = new CallableStatementBasis(proc.getText(), Integer.MAX_VALUE, proc.getOutParams());
        CallableStatementData csd = new CallableStatementData(basis, OraConnectionHelperKt.decorateInParameters(params));
        CallableSmartStatement executor = SmartStatements.Companion.poweredBy(this.getConnection()).call();
        this.trace("\texecuting\u2026");
        Ref.ByteRef byteRef = new Ref.ByteRef();
        byteRef.element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.ByteRef byteRef2 = new Ref.ByteRef();
        byteRef2.element = PauseReason.REASON_UNEXPECTED.getCode();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        Ref.IntRef intRef3 = new Ref.IntRef();
        intRef3.element = 0;
        Ref.ShortRef shortRef = new Ref.ShortRef();
        shortRef.element = OraNamespace.NS_NONE.code;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        if (this.getState().isInteractive()) {
            this.setState(ProcessState.STATE_RESUMING);
        }
        try {
            void isProcedure;
            void terminated;
            void entryPointName;
            void programName;
            void programSchema;
            void namespaceCode;
            void stackDepth;
            void breakpoint;
            void lineNr;
            void reasonCode;
            void resultCode;
            executor.noisy().execute((Object)csd, (ExecutionMode)StandardExecutionMode.GENERIC, (Function1)new Function1<ResultsProducer, Unit>((Ref.ByteRef)resultCode, proc, (Ref.ByteRef)reasonCode, (Ref.IntRef)lineNr, (Ref.IntRef)breakpoint, (Ref.IntRef)stackDepth, (Ref.ShortRef)namespaceCode, (Ref.ObjectRef)programSchema, (Ref.ObjectRef)programName, (Ref.ObjectRef)entryPointName, (Ref.BooleanRef)terminated, (Ref.BooleanRef)isProcedure){
                final /* synthetic */ Ref.ByteRef $resultCode;
                final /* synthetic */ OraDebuggingSessionQueries.SyncLikeProc $proc;
                final /* synthetic */ Ref.ByteRef $reasonCode;
                final /* synthetic */ Ref.IntRef $lineNr;
                final /* synthetic */ Ref.IntRef $breakpoint;
                final /* synthetic */ Ref.IntRef $stackDepth;
                final /* synthetic */ Ref.ShortRef $namespaceCode;
                final /* synthetic */ Ref.ObjectRef $programSchema;
                final /* synthetic */ Ref.ObjectRef $programName;
                final /* synthetic */ Ref.ObjectRef $entryPointName;
                final /* synthetic */ Ref.BooleanRef $terminated;
                final /* synthetic */ Ref.BooleanRef $isProcedure;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    this.$resultCode.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getResult())).byteValue();
                    this.$reasonCode.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getReason())).byteValue();
                    this.$lineNr.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getLineNr())).intValue();
                    this.$breakpoint.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getBreakpoint())).intValue();
                    this.$stackDepth.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getStackDepth())).intValue();
                    this.$namespaceCode.element = ((Number)producer.getParameterValue((OutParameter)this.$proc.getNamespaceCode())).shortValue();
                    this.$programSchema.element = (String)producer.getParameterValue((OutParameter)this.$proc.getProgramSchema());
                    this.$programName.element = (String)producer.getParameterValue((OutParameter)this.$proc.getProgramName());
                    this.$entryPointName.element = (String)producer.getParameterValue((OutParameter)this.$proc.getEntryPointName());
                    this.$terminated.element = (Boolean)producer.getParameterValue((OutParameter)this.$proc.getTerminated());
                    this.$isProcedure.element = (Boolean)producer.getParameterValue((OutParameter)this.$proc.isProcedure());
                }
                {
                    this.$resultCode = byteRef;
                    this.$proc = syncLikeProc;
                    this.$reasonCode = byteRef2;
                    this.$lineNr = intRef;
                    this.$breakpoint = intRef2;
                    this.$stackDepth = intRef3;
                    this.$namespaceCode = shortRef;
                    this.$programSchema = objectRef;
                    this.$programName = objectRef2;
                    this.$entryPointName = objectRef3;
                    this.$terminated = booleanRef;
                    this.$isProcedure = booleanRef2;
                    super(1);
                }
            });
            this.handleSyncResult(false, resultCode.element, reasonCode.element, lineNr.element, breakpoint.element, stackDepth.element, namespaceCode.element, (String)programSchema.element, (String)programName.element, (String)entryPointName.element, terminated.element, isProcedure.element, lastCommand);
        }
        catch (Throwable exception) {
            this.handleSyncException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doGracefulResume(DebugGracefulResumingCommand command2) {
        void isProcedure;
        void terminated;
        void entryPointName;
        void programName;
        void programSchema;
        void namespaceCode;
        void stackDepth;
        void breakpoint;
        void lineNr;
        void reasonCode;
        void resultCode;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = OraDebuggingSessionQueries.GracefulResumeProc.INSTANCE;
        byte stepCmd = 0;
        int stepDepth = 0;
        int stepLine = 0;
        short stepPrgNsp = 0;
        String stepPrgName = "";
        DebugGracefulResumingCommand debugGracefulResumingCommand = command2;
        if (debugGracefulResumingCommand instanceof GracefulStepOverCommand) {
            stepCmd = 2;
            stepDepth = ((GracefulStepOverCommand)command2).getDepth();
            stepLine = ((GracefulStepOverCommand)command2).getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulStepOutCommand) {
            stepCmd = 3;
            stepDepth = ((GracefulStepOutCommand)command2).getDepth();
        } else if (debugGracefulResumingCommand instanceof GracefulRunToPositionInProgramCommand) {
            stepCmd = 4;
            stepPrgNsp = ((GracefulRunToPositionInProgramCommand)command2).getPosition().getNamespace().code;
            String string = ((GracefulRunToPositionInProgramCommand)command2).getPosition().getProgramName();
            if (string == null) {
                string = "";
            }
            stepPrgName = string;
            stepLine = ((GracefulRunToPositionInProgramCommand)command2).getPosition().getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulRunToPositionInScriptCommand) {
            stepCmd = 5;
            stepLine = ((GracefulRunToPositionInScriptCommand)command2).getLineNr();
        } else if (debugGracefulResumingCommand instanceof GracefulResumeCommand) {
            stepCmd = 6;
        }
        debugGracefulResumingCommand = new Ref.ByteRef();
        ((Ref.ByteRef)debugGracefulResumingCommand).element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.ByteRef byteRef = new Ref.ByteRef();
        byteRef.element = PauseReason.REASON_UNEXPECTED.getCode();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        Ref.IntRef intRef3 = new Ref.IntRef();
        intRef3.element = 0;
        Ref.ShortRef shortRef = new Ref.ShortRef();
        shortRef.element = OraNamespace.NS_NONE.code;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        Ref.ObjectRef objectRef4 = new Ref.ObjectRef();
        objectRef4.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        Ref.IntRef intRef4 = new Ref.IntRef();
        intRef4.element = 0;
        Ref.BooleanRef booleanRef3 = new Ref.BooleanRef();
        booleanRef3.element = false;
        this.setState(ProcessState.STATE_RUNNING);
        long t1 = System.nanoTime();
        int totalStepsDone = 0;
        try {
            try {
                void coffeeBreak;
                this.processIsInsideGracefulLoop = true;
                do {
                    String string;
                    OraDebuggingSession oraDebuggingSession;
                    StringBuilder stringBuilder;
                    Object[] objectArray;
                    void stepsDone;
                    try {
                        void proc;
                        this.call((CallDefinition)((OraDebuggingSessionQueries.GracefulResumeProc)proc.element), new Object[]{stepCmd, stepDepth, stepLine, stepPrgNsp, stepPrgName}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ByteRef)resultCode, (Ref.ObjectRef)proc, (Ref.ByteRef)reasonCode, (Ref.IntRef)lineNr, (Ref.IntRef)breakpoint, (Ref.IntRef)stackDepth, (Ref.ShortRef)namespaceCode, (Ref.ObjectRef)programSchema, (Ref.ObjectRef)programName, (Ref.ObjectRef)entryPointName, (Ref.BooleanRef)terminated, (Ref.BooleanRef)isProcedure, (Ref.IntRef)stepsDone, (Ref.BooleanRef)coffeeBreak){
                            final /* synthetic */ Ref.ByteRef $resultCode;
                            final /* synthetic */ Ref.ObjectRef $proc;
                            final /* synthetic */ Ref.ByteRef $reasonCode;
                            final /* synthetic */ Ref.IntRef $lineNr;
                            final /* synthetic */ Ref.IntRef $breakpoint;
                            final /* synthetic */ Ref.IntRef $stackDepth;
                            final /* synthetic */ Ref.ShortRef $namespaceCode;
                            final /* synthetic */ Ref.ObjectRef $programSchema;
                            final /* synthetic */ Ref.ObjectRef $programName;
                            final /* synthetic */ Ref.ObjectRef $entryPointName;
                            final /* synthetic */ Ref.BooleanRef $terminated;
                            final /* synthetic */ Ref.BooleanRef $isProcedure;
                            final /* synthetic */ Ref.IntRef $stepsDone;
                            final /* synthetic */ Ref.BooleanRef $coffeeBreak;

                            public final void invoke(@NotNull ResultsProducer producer) {
                                Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                                this.$resultCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getResult())).byteValue();
                                this.$reasonCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getReason())).byteValue();
                                this.$lineNr.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getLineNr())).intValue();
                                this.$breakpoint.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getBreakpoint())).intValue();
                                this.$stackDepth.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getStackDepth())).intValue();
                                this.$namespaceCode.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getNamespaceCode())).shortValue();
                                this.$programSchema.element = (String)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getProgramSchema());
                                this.$programName.element = (String)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getProgramName());
                                this.$entryPointName.element = (String)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getEntryPointName());
                                this.$terminated.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getTerminated());
                                this.$isProcedure.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).isProcedure());
                                this.$stepsDone.element = ((Number)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getStepsDone())).intValue();
                                this.$coffeeBreak.element = (Boolean)producer.getParameterValue((OutParameter)((OraDebuggingSessionQueries.GracefulResumeProc)this.$proc.element).getCoffeeBreak());
                            }
                            {
                                this.$resultCode = byteRef;
                                this.$proc = objectRef;
                                this.$reasonCode = byteRef2;
                                this.$lineNr = intRef;
                                this.$breakpoint = intRef2;
                                this.$stackDepth = intRef3;
                                this.$namespaceCode = shortRef;
                                this.$programSchema = objectRef2;
                                this.$programName = objectRef3;
                                this.$entryPointName = objectRef4;
                                this.$terminated = booleanRef;
                                this.$isProcedure = booleanRef2;
                                this.$stepsDone = intRef4;
                                this.$coffeeBreak = booleanRef3;
                                super(1);
                            }
                        });
                    }
                    catch (Throwable t2) {
                        long t22 = System.nanoTime();
                        float elapsed = (float)(t22 - t1) / 1.0E9f;
                        objectArray = "%.3f";
                        Object[] objectArray2 = new Object[]{Float.valueOf(elapsed)};
                        stringBuilder = new StringBuilder().append("Graceful running: ").append(totalStepsDone += stepsDone.element).append(" steps done in ");
                        oraDebuggingSession = this;
                        boolean bl = false;
                        String string2 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
                        string = string2;
                        oraDebuggingSession.trace(stringBuilder.append(string).append(" s").toString());
                        throw t2;
                    }
                    long t2 = System.nanoTime();
                    float elapsed = (float)(t2 - t1) / 1.0E9f;
                    String string3 = "%.3f";
                    objectArray = new Object[]{Float.valueOf(elapsed)};
                    stringBuilder = new StringBuilder().append("Graceful running: ").append(totalStepsDone += stepsDone.element).append(" steps done in ");
                    oraDebuggingSession = this;
                    boolean bl = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                    oraDebuggingSession.trace(stringBuilder.append(string).append(" s").toString());
                    if (resultCode.element != 0) break;
                    if (terminated.element) {
                        break;
                    }
                    if (reasonCode.element == PauseReason.REASON_STARTED.getCode()) {
                        coffeeBreak.element = true;
                    }
                    if (stackDepth.element == 1 && !this.scriptIsMeaningful) {
                        coffeeBreak.element = true;
                    }
                    if (!coffeeBreak.element) continue;
                    this.performImmediateCommands();
                    this.retrieveIntermediateData();
                } while (coffeeBreak.element && this.commandHolder.isEmpty());
            }
            finally {
                this.processIsInsideGracefulLoop = false;
            }
        }
        catch (Throwable exception) {
            this.handleSyncException(exception);
        }
        this.handleSyncResult(true, resultCode.element, reasonCode.element, lineNr.element, breakpoint.element, stackDepth.element, namespaceCode.element, (String)programSchema.element, (String)programName.element, (String)entryPointName.element, terminated.element, isProcedure.element, null);
    }

    private final void handleSyncResult(boolean graceful, byte resultCode, byte reasonCode, int lineNr, int breakpoint, int stackDepth, short namespaceCode, String programSchema, String programName, String entryPointName, boolean terminated, boolean isProcedure, DebugCommand lastCommand) {
        Comparable comparable;
        ApiResult apiResult;
        this.trace("\thandling\u2026");
        PauseReason pauseReason = OraDebuggerEnumsKt.getPAUSE_REASONS().get(reasonCode);
        if (pauseReason == null) {
            pauseReason = this.reason = PauseReason.REASON_UNEXPECTED;
        }
        if ((apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(resultCode)) == null) {
            apiResult = ApiResult.RESULT_UNEXPECTED;
        }
        this.result = apiResult;
        this.stackDepth = stackDepth;
        OraNamespace namespace = OraNamespace.Companion.byCode(namespaceCode);
        if (this.result == ApiResult.RESULT_OK) {
            this.trace("\t\tsync: " + (Object)((Object)this.reason) + " \u2014\u00a0namespace " + (Object)((Object)namespace) + ", program " + programSchema + '.' + programName + " at line " + lineNr + ", proc " + SqlUtilFun.toInt((boolean)isProcedure) + ", breakpoint " + breakpoint + ", stack depth " + stackDepth);
        } else if (!(this.getState() != ProcessState.STATE_RESUMING && this.getState() != ProcessState.STATE_RUNNING || terminated)) {
            this.trace("\t\tsync: running, stack depth = " + stackDepth);
        } else if (terminated) {
            this.trace("\t\tsync: the process is terminated");
        } else {
            this.trace("\t\tsync: problem " + (Object)((Object)this.result));
        }
        switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$1[this.result.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setState(ProcessState.STATE_BROKEN);
                break;
            }
            default: {
                return;
            }
        }
        this.processIsTerminated = terminated;
        if (this.processIsTerminated) {
            this.trace("Terminated");
            this.setStoppingMoment(0L);
            this.commandHolder.clear();
            switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$2[this.getState().ordinal()]) {
                case 1: {
                    this.setState(ProcessState.STATE_COMPLETED);
                    break;
                }
                case 2: {
                    this.setState(ProcessState.STATE_FINISHED);
                    break;
                }
            }
            this.markProcessTerminated();
        } else if (graceful) {
            this.processIsActive = true;
            this.processIsRunning = false;
            this.processIsWaiting = true;
            comparable = (Comparable)((Object)this.getState());
            if (comparable.compareTo((Comparable)((Object)ProcessState.STATE_RESUMING)) >= 0 && comparable.compareTo((Comparable)((Object)ProcessState.STATE_RUNNING)) <= 0) {
                this.setState(ProcessState.STATE_RELAXING);
            }
        } else {
            this.processIsActive = true;
            this.processIsRunning = this.reason == PauseReason.REASON_NONE;
            this.processIsWaiting = !this.processIsRunning;
            comparable = (Comparable)((Object)this.getState());
            if (comparable.compareTo((Comparable)((Object)ProcessState.STATE_RESUMING)) >= 0 && comparable.compareTo((Comparable)((Object)ProcessState.STATE_RUNNING)) <= 0 && this.reason.getRelaxing()) {
                this.setState(ProcessState.STATE_RELAXING);
            }
        }
        block9 : switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$4[this.reason.ordinal()]) {
            case 1: {
                switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$3[this.getState().ordinal()]) {
                    case 1: {
                        DebugContinuationCommand lc;
                        DebugCommand debugCommand = lastCommand;
                        if (!(debugCommand instanceof DebugContinuationCommand)) {
                            debugCommand = null;
                        }
                        if ((lc = (DebugContinuationCommand)debugCommand) == null) break block9;
                        this.commandHolder.offerIfEmpty(lc);
                        break block9;
                    }
                }
                break;
            }
            case 2: {
                if (stackDepth > 0) break;
                this.trace("Leaving the Debugging level (reason " + (Object)((Object)this.reason) + ')');
                this.setState(terminated ? ProcessState.STATE_COMPLETED : ProcessState.STATE_COMPLETING);
                break;
            }
            case 3: 
            case 4: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) > 0) break;
                this.setState(terminated ? ProcessState.STATE_COMPLETED : ProcessState.STATE_COMPLETING);
                break;
            }
            case 5: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) >= 0) break;
                this.setState(ProcessState.STATE_RUNNING);
                break;
            }
            case 6: 
            case 7: {
                if (this.getState().compareTo((Enum)ProcessState.STATE_COMPLETING) >= 0) break;
                this.setState(ProcessState.STATE_RELAXING);
                break;
            }
        }
    }

    private final void handleSyncException(Throwable thrownException) {
        block5: {
            Throwable throwable;
            block4: {
                Throwable e = OraConnectionHelperKt.unwrapException(thrownException);
                String message = OraConnectionHelperKt.prepareGoodMessage(e, "debugger sync fail");
                this.trace(message);
                throwable = e;
                if (!(throwable instanceof SQLException)) break block4;
                switch (((SQLException)e).getErrorCode()) {
                    case 17009: {
                        this.setState(ProcessState.STATE_FINISHED);
                        this.markProcessTerminated();
                        break;
                    }
                    case 17008: {
                        this.setState(ProcessState.STATE_BROKEN);
                        this.markProcessTerminated();
                        break;
                    }
                }
                break block5;
            }
            if (!(throwable instanceof ConnectException)) break block5;
            this.setState(ProcessState.STATE_BROKEN);
        }
    }

    private final void markProcessTerminated() {
        this.processIsActive = false;
        this.processIsRunning = false;
        this.processIsWaiting = false;
        this.stack = CollectionsKt.emptyList();
        this.setStoppingMoment(0L);
    }

    private final void retrieveData() {
        this.dataPending = false;
        if (this.stackDepth > 0) {
            this.retrieveStack();
        } else {
            this.stack = CollectionsKt.emptyList();
        }
        this.onEventInfo.invoke(this.stack, (Object)this.getState());
        this.retrieveIntermediateData();
        this.onGoodTimeToRetrieveAdditionalData.invoke();
    }

    private final void retrieveIntermediateData() {
        this.retrieveDbmsOutput(this.dbmsOutputConsumer);
    }

    private final void retrieveStack() {
        try {
            Object[] objectArray = new Object[]{};
            Function1 function1 = retrieveStack.listing.1.INSTANCE;
            List listing2 = (List)this.call((CallDefinition)OraDebuggingSessionQueries.ObtainBacktraceProc.INSTANCE, objectArray, function1);
            this.handleStack(listing2);
        }
        catch (SQLException e) {
            this.trace("Error during obtaining stack trace: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during obtaining stack trace: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final void handleStack(List<String> listing2) {
        ArrayList newStack = new ArrayList(listing2.size());
        for (String frameLine : CollectionsKt.asReversed(listing2)) {
            List frameElements = StringsKt.split$default((CharSequence)frameLine, (char[])new char[]{'\u0001'}, (boolean)false, (int)0, (int)6, null);
            OraPosition frame = null;
            if (frameElements.size() >= 4) {
                Short s = StringsKt.toShortOrNull((String)((String)frameElements.get(0)));
                short namespaceCode = s != null ? s : OraNamespace.NS_NONE.code;
                String programSchema = StringKt.nullize$default((String)((String)frameElements.get(1)), (boolean)false, (int)1, null);
                String programName = StringKt.nullize$default((String)((String)frameElements.get(2)), (boolean)false, (int)1, null);
                Integer n = StringsKt.toIntOrNull((String)((String)frameElements.get(3)));
                int lineNr = n != null ? n : 0;
                frame = this.makeFrame(namespaceCode, programSchema, programName, lineNr);
            } else {
                frame = new OraUnknownPosition(OraNamespace.NS_NONE, null, frameLine, 0);
            }
            Collection collection = newStack;
            boolean bl = false;
            collection.add(frame);
        }
        this.stack = newStack;
    }

    private final OraPosition makeFrame(short namespaceCode, String programSchema, String programName, int lineNr) {
        OraNamespace namespace = OraNamespace.Companion.byCode(namespaceCode);
        return programSchema != null && programName != null ? (OraPosition)new OraProgramPosition(namespace, programSchema, programName, lineNr) : (namespace == OraNamespace.NS_CURSOR && lineNr > 0 ? (OraPosition)new OraScriptPosition(lineNr) : (OraPosition)new OraUnknownPosition(namespace, programSchema, programName, lineNr));
    }

    /*
     * WARNING - void declaration
     */
    private final void doRetrieveVariables(RetrieveVariablesCommand command2) {
        void numberOfCorrect;
        void numberOfErrors;
        void numberOfNotInScope;
        String packageNameLit;
        List<SqlVariable> variables = command2.getVariables();
        List<SqlVariable> entries = this.flatten(variables);
        int n = entries.size();
        if (n == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        block3: for (SqlVariable v2 : entries) {
            String nameLit = "'" + v2.getQname() + "'";
            switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$5[v2.getRootKind().ordinal()]) {
                case 1: {
                    String string;
                    String schemaNameLit;
                    String string2;
                    if (v2.getSchemaName() != null) {
                        StringBuilder stringBuilder = new StringBuilder().append("'");
                        String string3 = v2.getSchemaName();
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        string2 = stringBuilder.append(string3).append("'").toString();
                    } else {
                        string2 = schemaNameLit = "null";
                    }
                    if (v2.getPackageName() != null) {
                        StringBuilder stringBuilder = new StringBuilder().append("'");
                        String string4 = v2.getPackageName();
                        if (string4 == null) {
                            Intrinsics.throwNpe();
                        }
                        string = stringBuilder.append(string4).append("'").toString();
                    } else {
                        string = "null";
                    }
                    packageNameLit = string;
                    b.append("\t? := getFieldValue(" + schemaNameLit + ", " + packageNameLit + ", " + nameLit + ");\n");
                    continue block3;
                }
            }
            b.append("\t? := getVarValue(" + command2.getFrameLevel() + ", " + nameLit + ");\n");
        }
        String string = Companion.getPeekVariablesTemplate$intellij_database_dialects_oracle();
        String string5 = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"b.toString()");
        String statementText = StringsKt.replace$default((String)string, (String)"@", (String)string5, (boolean)false, (int)4, null);
        List resultParams = new ArrayList(n);
        CallDefinition cmd2 = new CallDefinition(n, resultParams, statementText, statementText){
            final /* synthetic */ int $n;
            final /* synthetic */ List $resultParams;
            final /* synthetic */ String $statementText;
            {
                this.$n = $captured_local_variable$0;
                this.$resultParams = $captured_local_variable$1;
                this.$statementText = $captured_local_variable$2;
                super($super_call_param$3);
                int n = 0;
                int n2 = $captured_local_variable$0;
                while (n < n2) {
                    void i2;
                    Collection collection = $captured_local_variable$1;
                    StringOutParam stringOutParam = CallParams.registerString$default(this, (int)(i2 + true), Short.MAX_VALUE, null, 4, null);
                    boolean bl = false;
                    collection.add(stringOutParam);
                    ++i2;
                }
            }
        };
        HashMap result2 = new HashMap(n);
        packageNameLit = new Ref.IntRef();
        ((Ref.IntRef)packageNameLit).element = 0;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        Ref.IntRef intRef2 = new Ref.IntRef();
        intRef2.element = 0;
        Object[] objectArray = new Object[]{};
        Function1 function1 = (Function1)new Function1<ResultsProducer, Unit>(n, resultParams, (Ref.IntRef)numberOfNotInScope, (Ref.IntRef)numberOfErrors, (Ref.IntRef)numberOfCorrect, entries, result2){
            final /* synthetic */ int $n;
            final /* synthetic */ List $resultParams;
            final /* synthetic */ Ref.IntRef $numberOfNotInScope;
            final /* synthetic */ Ref.IntRef $numberOfErrors;
            final /* synthetic */ Ref.IntRef $numberOfCorrect;
            final /* synthetic */ List $entries;
            final /* synthetic */ HashMap $result;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultsProducer producer) {
                Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                int n = 0;
                int n2 = this.$n;
                while (n < n2) {
                    int n3;
                    void i2;
                    String string = (String)producer.getParameterValue((OutParameter)this.$resultParams.get((int)i2));
                    if (string == null) {
                        string = "null";
                    }
                    String value = string;
                    if (Intrinsics.areEqual((Object)value, (Object)"\u001a")) {
                        value = SqlVariableKt.getNOT_ASSIGNED();
                        n3 = this.$numberOfNotInScope.element;
                        this.$numberOfNotInScope.element = n3 + 1;
                    } else if (ModelSerializationFun.startsWith((String)value, (char)'\u001b')) {
                        String string2 = value;
                        int n4 = 1;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.substring(n4);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        value = string4;
                        n3 = this.$numberOfErrors.element;
                        this.$numberOfErrors.element = n3 + 1;
                    } else {
                        n3 = this.$numberOfCorrect.element;
                        this.$numberOfCorrect.element = n3 + 1;
                    }
                    SqlVariable v2 = (SqlVariable)this.$entries.get((int)i2);
                    ((Map)this.$result).put(v2, new SqlVariableValue(v2, value));
                    ++i2;
                }
            }
            {
                this.$n = n;
                this.$resultParams = list;
                this.$numberOfNotInScope = intRef;
                this.$numberOfErrors = intRef2;
                this.$numberOfCorrect = intRef3;
                this.$entries = list2;
                this.$result = hashMap;
                super(1);
            }
        };
        this.call((CallDefinition)cmd2, objectArray, function1);
        this.trace("Retrieved variables from frame " + command2.getFrameLevel() + ": " + numberOfCorrect.element + " ok, " + numberOfNotInScope.element + " not in the scope, " + numberOfErrors.element + " errors");
        command2.getConsumer().invoke(result2);
    }

    private final List<SqlVariable> flatten(@NotNull List<SqlVariable> $this$flatten) {
        ArrayList container = new ArrayList($this$flatten.size());
        for (SqlVariable variable : $this$flatten) {
            this.flattenTo(variable, container);
        }
        return container;
    }

    private final void flattenTo(@NotNull SqlVariable $this$flattenTo, List<SqlVariable> container) {
        List fields = $this$flattenTo.getFields();
        if (fields == null) {
            container.add($this$flattenTo);
        } else {
            Iterable $this$forEach$iv = fields;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlVariable it = (SqlVariable)element$iv;
                boolean bl = false;
                this.flattenTo(it, container);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doEvaluateExpression(EvaluateExpressionCommand command2) {
        String string;
        void value;
        void error;
        SqlType sqlType = command2.getInfo().getType();
        String template = (sqlType != null ? sqlType.getCategory() : null) == SqlType.Category.BOOLEAN ? Companion.getEvaluateScalarExpressionFragmentBoolean$intellij_database_dialects_oracle() : Companion.getEvaluateScalarExpressionFragment$intellij_database_dialects_oracle();
        String block = StringsKt.replace$default((String)template, (String)"@", (String)command2.getExpression(), (boolean)false, (int)4, null);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = "???";
        this.call((CallDefinition)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE, new Object[]{block}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ObjectRef)error, (Ref.ObjectRef)value){
            final /* synthetic */ Ref.ObjectRef $error;
            final /* synthetic */ Ref.ObjectRef $value;

            public final void invoke(@NotNull ResultsProducer producer) {
                Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                this.$error.element = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getError());
                this.$value.element = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getValue());
            }
            {
                this.$error = objectRef;
                this.$value = objectRef2;
                super(1);
            }
        });
        Function1<String, Unit> function1 = command2.getConsumer();
        String string2 = (String)error.element;
        if (string2 == null) {
            string2 = string = (String)value.element;
        }
        if (string2 == null) {
            string = "null";
        }
        function1.invoke((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    private final void doExecuteFragment(ExecuteFragmentCommand command2) {
        void error;
        String string = command2.getFragment();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String f = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (!StringsKt.endsWith$default((CharSequence)f, (char)';', (boolean)false, (int)2, null)) {
            f = f + ';';
        }
        String block = StringsKt.replace$default((String)Companion.getExecuteFragmentTemplate$intellij_database_dialects_oracle(), (String)"@", (String)f, (boolean)false, (int)4, null);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            this.call((CallDefinition)OraDebuggingSessionQueries.ExecuteFragmentStatement.INSTANCE, new Object[]{block}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ObjectRef)error){
                final /* synthetic */ Ref.ObjectRef $error;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    this.$error.element = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.EvaluateScalarExpression.INSTANCE.getError());
                }
                {
                    this.$error = objectRef;
                    super(1);
                }
            });
        }
        catch (SQLException e) {
            error.element = "SQL error " + e.getErrorCode() + ": " + e.getMessage();
        }
        catch (Exception e) {
            error.element = "Exception " + e.getClass().getSimpleName() + ": " + e.getMessage();
        }
        if ((String)error.element != null) {
            Function1<String, Unit> function1 = command2.getConsumer();
            String string3 = (String)error.element;
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            function1.invoke((Object)string3);
            return;
        }
        StringBuilder b = new StringBuilder();
        this.retrieveDbmsOutput((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(b){
            final /* synthetic */ StringBuilder $b;

            public final void invoke(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                this.$b.append(s).append('\n');
            }
            {
                this.$b = stringBuilder;
                super(1);
            }
        }));
        CharSequence charSequence = b;
        boolean bl2 = false;
        if (charSequence.length() > 0) {
            Function1<String, Unit> function1 = command2.getConsumer();
            String string4 = b.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"b.toString()");
            function1.invoke((Object)string4);
        } else {
            command2.getConsumer().invoke((Object)"Performed successfully");
        }
    }

    private final void retrieveDbmsOutput(Function1<? super String, Unit> consumer) {
        if (!this.target.getUnderDebug()) {
            return;
        }
        int iterationsLimit = 15;
        try {
            OraDebugExecutionResult r;
            do {
                r = this.executeAndFetchResult(Companion.getRetrieveDbmsOutputBlock$intellij_database_dialects_oracle());
                Collection collection = r.getResult();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    Iterable $this$forEach$iv = r.getResult();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        consumer.invoke(element$iv);
                    }
                }
                if (r.getError() == null) continue;
                this.trace("Failed to fetch dbms_output lines: " + r.getError());
            } while (r.getResult().size() >= Companion.getRetrieveDbmsOutputPortionSize$intellij_database_dialects_oracle() && --iterationsLimit > 0);
        }
        catch (SQLException e) {
            this.trace("Error during dbms_output lines fetching: error " + e.getErrorCode() + " state " + e.getSQLState() + ": " + e.getMessage());
        }
        catch (Exception e) {
            this.trace("Exception during dbms_output lines fetching: " + e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private final OraDebugExecutionResult executeAndFetchResult(String block) {
        Pair p = OraConnectionHelperKt.call(this.getConnection(), "{ call sys.dbms_debug.execute(?, -1, 1, ?, ?) }", (IndexedOutParameter)new OraStringArrayOutParameter(2, "SYS.DBMS_DEBUG_VC2COLL"), (IndexedOutParameter)new StringOutParam(3, 4000, null, 4, null), new Object[]{block});
        return new OraDebugExecutionResult((List)p.getFirst(), (String)p.getSecond());
    }

    private final void doRegisterLineBreakpoint(RegisterBreakpointCommand command2) {
        OraRealLineBreakpoint bp = command2.getBp();
        Function2<ApiResult, Integer, Unit> $fun$handleLineBreakpointRegistration$1 = new Function2<ApiResult, Integer, Unit>(this, bp, command2){
            final /* synthetic */ OraDebuggingSession this$0;
            final /* synthetic */ OraRealLineBreakpoint $bp;
            final /* synthetic */ RegisterBreakpointCommand $command;

            public final void invoke(@NotNull ApiResult r, int id) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)r), (String)"r");
                switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$6[r.ordinal()]) {
                    case 1: {
                        this.$bp.setId(id);
                        this.$bp.setAppropriate(true);
                        this.$bp.setActive(true);
                        this.$bp.setProblem(null);
                        this.this$0.trace("Set breakpoint " + this.$bp + ": successfully");
                        break;
                    }
                    case 2: {
                        this.$bp.setId(0);
                        this.$bp.setAppropriate(false);
                        this.$bp.setActive(false);
                        this.$bp.setProblem(null);
                        this.this$0.trace("Set breakpoint " + this.$bp + ": wrong line");
                        break;
                    }
                    default: {
                        this.$bp.setId(0);
                        this.$bp.setAppropriate(false);
                        this.$bp.setActive(false);
                        this.$bp.setProblem(r.name());
                        this.this$0.trace("Set breakpoint " + this.$bp + ": " + this.$bp.getProblem());
                    }
                }
                this.$command.getHandled().invoke();
            }
            {
                this.this$0 = oraDebuggingSession;
                this.$bp = oraRealLineBreakpoint;
                this.$command = registerBreakpointCommand;
                super(2);
            }
        };
        if (bp.getId() > 0) {
            this.deregisterLineBreakpoint(bp.getId(), (Function1<? super ApiResult, Unit>)((Function1)doRegisterLineBreakpoint.2.INSTANCE));
        }
        this.registerLineBreakpoint(bp.getPosition(), (Function2<? super ApiResult, ? super Integer, Unit>)((Function2)new Function2<ApiResult, Integer, Unit>($fun$handleLineBreakpointRegistration$1){
            final /* synthetic */ doRegisterLineBreakpoint.1 $handleLineBreakpointRegistration$1;

            public final void invoke(@NotNull ApiResult p1, int p2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)p1), (String)"p1");
                this.$handleLineBreakpointRegistration$1.invoke(p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "handleLineBreakpointRegistration";
            }

            public final String getSignature() {
                return "invoke(Lcom/intellij/database/dialects/oracle/debugger/ApiResult;I)V";
            }
            {
                this.$handleLineBreakpointRegistration$1 = var1_1;
                super(2);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void registerLineBreakpoint(OraPosition position, Function2<? super ApiResult, ? super Integer, Unit> handler) {
        ApiResult apiResult;
        void id;
        void rc;
        Ref.ByteRef byteRef = new Ref.ByteRef();
        byteRef.element = ApiResult.RESULT_UNEXPECTED.getCode();
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        OraPosition oraPosition = position;
        if (oraPosition instanceof OraScriptPosition) {
            this.call((CallDefinition)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE, new Object[]{position.getLineNr()}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ByteRef)rc, (Ref.IntRef)id){
                final /* synthetic */ Ref.ByteRef $rc;
                final /* synthetic */ Ref.IntRef $id;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    this.$rc.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE.getResult())).byteValue();
                    this.$id.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterScriptLineBreakpointBlock.INSTANCE.getId())).intValue();
                }
                {
                    this.$rc = byteRef;
                    this.$id = intRef;
                    super(1);
                }
            });
        } else if (oraPosition instanceof OraProgramPosition) {
            this.call((CallDefinition)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE, new Object[]{position.getNamespace().code, ((OraProgramPosition)position).getSchemaName(), ((OraProgramPosition)position).getProgramName(), position.getLineNr()}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ByteRef)rc, (Ref.IntRef)id){
                final /* synthetic */ Ref.ByteRef $rc;
                final /* synthetic */ Ref.IntRef $id;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    this.$rc.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE.getResult())).byteValue();
                    this.$id.element = ((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.RegisterProgramLineBreakpointBlock.INSTANCE.getId())).intValue();
                }
                {
                    this.$rc = byteRef;
                    this.$id = intRef;
                    super(1);
                }
            });
        }
        if ((apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(rc.element)) == null) {
            apiResult = ApiResult.RESULT_UNEXPECTED;
        }
        ApiResult r = apiResult;
        handler.invoke((Object)r, (Object)id.element);
    }

    private final void doDeregisterLineBreakpoint(DeregisterBreakpointCommand command2) {
        OraRealLineBreakpoint bp = command2.getBp();
        int id = bp.getId();
        if (id <= 0) {
            return;
        }
        this.deregisterLineBreakpoint(id, (Function1<? super ApiResult, Unit>)((Function1)new Function1<ApiResult, Unit>(this, bp, command2){
            final /* synthetic */ OraDebuggingSession this$0;
            final /* synthetic */ OraRealLineBreakpoint $bp;
            final /* synthetic */ DeregisterBreakpointCommand $command;

            public final void invoke(@NotNull ApiResult r) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)r), (String)"r");
                switch (OraDebuggingSession$WhenMappings.$EnumSwitchMapping$7[r.ordinal()]) {
                    case 1: {
                        this.this$0.trace("Remove breakpoint " + this.$bp + ": successfully");
                        this.$bp.setId(0);
                        this.$bp.setActive(false);
                        this.$bp.setProblem(null);
                        break;
                    }
                    case 2: {
                        this.this$0.trace("Remove breakpoint " + this.$bp + ": no such breakpoint");
                        this.$bp.setId(0);
                        this.$bp.setActive(false);
                        this.$bp.setAppropriate(false);
                        this.$bp.setProblem(null);
                        break;
                    }
                    case 3: {
                        this.this$0.trace("Remove breakpoint " + this.$bp + ": cannot delete an unused breakpoint");
                        this.$bp.setId(0);
                        this.$bp.setActive(false);
                        this.$bp.setAppropriate(false);
                        this.$bp.setProblem(null);
                        break;
                    }
                    default: {
                        this.$bp.setProblem(r.name());
                        this.this$0.trace("Remove breakpoint " + this.$bp + ": " + this.$bp.getProblem());
                        this.$bp.setId(0);
                        this.$bp.setActive(false);
                        this.$bp.setAppropriate(false);
                    }
                }
                this.$command.getHandled().invoke();
            }
            {
                this.this$0 = oraDebuggingSession;
                this.$bp = oraRealLineBreakpoint;
                this.$command = deregisterBreakpointCommand;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final void deregisterLineBreakpoint(int id, Function1<? super ApiResult, Unit> handler) {
        Ref.ByteRef byteRef = new Ref.ByteRef();
        byteRef.element = ApiResult.RESULT_UNEXPECTED.getCode();
        try {
            void rc;
            this.call((CallDefinition)OraDebuggingSessionQueries.DeregisterLineBreakpointBlock.INSTANCE, new Object[]{id}, (Function1)new Function1<ResultsProducer, Unit>((Ref.ByteRef)rc){
                final /* synthetic */ Ref.ByteRef $rc;

                public final void invoke(@NotNull ResultsProducer producer) {
                    Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                    this.$rc.element = (byte)((Number)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.DeregisterLineBreakpointBlock.INSTANCE.getResult())).intValue();
                }
                {
                    this.$rc = byteRef;
                    super(1);
                }
            });
            ApiResult apiResult = OraDebuggerEnumsKt.getAPI_RESULTS().get(rc.element);
            if (apiResult == null) {
                apiResult = ApiResult.RESULT_UNEXPECTED;
            }
            ApiResult r = apiResult;
            handler.invoke((Object)r);
        }
        catch (Exception e) {
            this.trace(OraConnectionHelperKt.prepareGoodMessage(OraConnectionHelperKt.unwrapException(e), "Failed to remove the breakpoint " + id));
        }
    }

    private final void deregisterAllBreakpoints() {
        try {
            OraConnectionHelperKt.perform(this.getConnection(), Companion.getDeregisterAllBreakpointsStatement$intellij_database_dialects_oracle(), new Object[0]);
        }
        catch (Exception e) {
            this.trace(OraConnectionHelperKt.prepareGoodMessage(OraConnectionHelperKt.unwrapException(e), "Failed to remove breakpoints"));
        }
    }

    private final void printListing() {
        Object[] objectArray = new Object[]{};
        Function1 function1 = (Function1)new Function1<ResultsProducer, Unit>(this){
            final /* synthetic */ OraDebuggingSession this$0;

            public final void invoke(@NotNull ResultsProducer producer) {
                Intrinsics.checkParameterIsNotNull((Object)producer, (String)"producer");
                String listing2 = (String)producer.getParameterValue((OutParameter)OraDebuggingSessionQueries.PrintBacktraceProc.INSTANCE.getListing());
                this.this$0.trace("Listing:\n" + listing2);
            }
            {
                this.this$0 = oraDebuggingSession;
                super(1);
            }
        };
        this.call((CallDefinition)OraDebuggingSessionQueries.PrintBacktraceProc.INSTANCE, objectArray, function1);
    }

    private final void connectionBroken() {
        this.setState(ProcessState.STATE_BROKEN);
        this.resetProcessState();
        this.processIsTerminated = true;
    }

    private final void resetResult() {
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
    }

    private final void resetProcessState() {
        this.processIsActive = false;
        this.processIsRunning = false;
        this.processIsWaiting = false;
        this.setStoppingMoment(0L);
    }

    public final void resetState() {
        this.setState(ProcessState.STATE_ASLEEP);
        this.resetResult();
        this.resetProcessState();
    }

    private final void stateChanged(ProcessState oldState, ProcessState newState) {
        this.trace("state transition: " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState));
        this.onStateTransition.invoke((Object)oldState, (Object)newState);
    }

    private final void disconnectTargetSessionHard() {
        this.target.disconnectHard();
        this.connectionBroken();
    }

    @Override
    public void close() {
        this.silently((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ OraDebuggingSession this$0;

            public final void invoke() {
                OraDebuggingSession.access$detachFromTargetSession(this.this$0);
            }
            {
                this.this$0 = oraDebuggingSession;
                super(0);
            }
        }));
        super.close();
    }

    @NotNull
    public final OraExecutingSession getTarget() {
        return this.target;
    }

    public final boolean getScriptIsMeaningful() {
        return this.scriptIsMeaningful;
    }

    public OraDebuggingSession(@NotNull DatabaseConnection connection, @NotNull OraExecutingSession target2, boolean scriptIsMeaningful) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)target2, (String)"target");
        super(connection);
        this.target = target2;
        this.scriptIsMeaningful = scriptIsMeaningful;
        this.dbmsOutputConsumer = (Function1)new Function1<String, Unit>(this.getLog()){

            public final void invoke(String p1) {
                ((Logger)this.receiver).info(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Logger.class);
            }

            public final String getName() {
                return "info";
            }

            public final String getSignature() {
                return "info(Ljava/lang/String;)V";
            }
        };
        this.stack = CollectionsKt.emptyList();
        this.reason = PauseReason.REASON_NONE;
        this.result = ApiResult.RESULT_OK;
        this.stateHolder = new AtomicReference<ProcessState>(ProcessState.STATE_ASLEEP);
        this.commandHolder = new TransferHolder();
        this.commandQueue = new ConcurrentLinkedQueue();
        this.onStateTransition = onStateTransition.1.INSTANCE;
        this.onEventInfo = onEventInfo.1.INSTANCE;
        this.onMainLoopIteration = onMainLoopIteration.1.INSTANCE;
        this.onGoodTimeToRetrieveAdditionalData = onGoodTimeToRetrieveAdditionalData.1.INSTANCE;
    }

    public static final /* synthetic */ void access$detachFromTargetSession(OraDebuggingSession $this) {
        $this.detachFromTargetSession();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession$Companion;", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSessionQueries;", "()V", "stopOnReturnWhenStepOut", "", "intellij.database.dialects.oracle"})
    private static final class Companion
    extends OraDebuggingSessionQueries {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

