/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.debugger.SqlDebugController;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraConnectionHelperKt;
import com.intellij.database.dialects.oracle.debugger.OraDebugController;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerFacade;
import com.intellij.database.dialects.oracle.debugger.OraDebuggerSettings;
import com.intellij.database.dialects.oracle.model.OraObjectTypeRoutine;
import com.intellij.database.dialects.oracle.model.OraRoutine;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.psi.SqlStatement;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JK\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerFacade;", "Lcom/intellij/database/debugger/SqlDebuggerFacade;", "()V", "canDebug", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "createController", "Lcom/intellij/database/debugger/SqlDebugController;", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "consoleRequestOwner", "Lcom/intellij/database/datagrid/DataRequest$OwnerEx;", "scriptIsMeaningful", "scriptVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "isApplicableToDebugRoutine", "routine", "Lcom/intellij/database/model/basic/BasicSourceAware;", "isApplicableToDebugStatement", "statement", "Lcom/intellij/sql/psi/SqlStatement;", "Companion", "intellij.database.dialects.oracle"})
public final class OraDebuggerFacade
implements SqlDebuggerFacade {
    private static final Lazy applicableStatements$delegate;
    @NotNull
    private static final OraDebuggerSettings settings;
    public static final Companion Companion;

    public boolean isApplicableToDebugStatement(@NotNull SqlStatement statement) {
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        return OraDebuggerFacade.Companion.getApplicableStatements().contains(PsiUtilBase.getElementType((PsiElement)((PsiElement)statement)));
    }

    public boolean isApplicableToDebugRoutine(@NotNull BasicSourceAware routine) {
        Intrinsics.checkParameterIsNotNull((Object)routine, (String)"routine");
        return routine instanceof OraRoutine && !(routine instanceof OraObjectTypeRoutine);
    }

    public boolean canDebug(@NotNull LocalDataSource dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        String problem = OraConnectionHelperKt.checkForProblems(dataSource);
        return problem == null;
    }

    @NotNull
    public SqlDebugController createController(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull DataRequest.OwnerEx consoleRequestOwner, boolean scriptIsMeaningful, @Nullable VirtualFile scriptVirtualFile, @Nullable RangeMarker scriptRangeMarker, @Nullable SearchPath searchPath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        Intrinsics.checkParameterIsNotNull((Object)consoleRequestOwner, (String)"consoleRequestOwner");
        return new OraDebugController(project, dataSource, consoleRequestOwner, scriptIsMeaningful, scriptVirtualFile, scriptRangeMarker, searchPath);
    }

    static {
        Companion = new Companion(null);
        applicableStatements$delegate = LazyKt.lazy((Function0)Companion.applicableStatements.2.INSTANCE);
        settings = new OraDebuggerSettings();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerFacade$Companion;", "", "()V", "applicableStatements", "", "Lcom/intellij/psi/tree/IElementType;", "getApplicableStatements", "()Ljava/util/Set;", "applicableStatements$delegate", "Lkotlin/Lazy;", "settings", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "getSettings$intellij_database_dialects_oracle", "()Lcom/intellij/database/dialects/oracle/debugger/OraDebuggerSettings;", "intellij.database.dialects.oracle"})
    public static final class Companion {
        private final Set<IElementType> getApplicableStatements() {
            Lazy lazy = applicableStatements$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Set)lazy.getValue();
        }

        @NotNull
        public final OraDebuggerSettings getSettings$intellij_database_dialects_oracle() {
            return settings;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

