/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OraUtils {
    OraUtils() {
    }

    @Nullable
    static DatabaseConnection getConnection(DataRequest.Context context) {
        if (context.producer instanceof JdbcEngine) {
            return ((JdbcEngine)context.producer).getCurrentConnection();
        }
        return null;
    }

    @NotNull
    static List<String> queryForStrings(@NotNull DatabaseConnection connection, @NotNull String query, int @NotNull [] placeholders, String ... params) throws SQLException {
        if (connection == null) {
            OraUtils.$$$reportNull$$$0(0);
        }
        if (query == null) {
            OraUtils.$$$reportNull$$$0(1);
        }
        if (placeholders == null) {
            OraUtils.$$$reportNull$$$0(2);
        }
        if (params == null) {
            OraUtils.$$$reportNull$$$0(3);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        StatementParameters parameters2 = new StatementParameters().placeholdersOffsets(placeholders);
        for (String param : params) {
            parameters2 = parameters2.text(param);
        }
        SmartStatements.poweredBy((DatabaseConnection)connection).parameterized(Configuration.sourced((SmartStatements.Source)SmartStatements.Source.SYSTEM)).noisy().execute((Object)parameters2.asData(query), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results(rset -> {
            while (rset.next()) {
                result2.add(rset.getString(1));
            }
        }));
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            OraUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "queryForStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryForStrings";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

