/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.OraNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.UnknownDomain;

public class OraDomains
extends DomainRegistry {
    private static final int MAX_CHAR = 2000;
    private static final int MAX_RAW = 2000;
    private static final int MAX_PRECISION = 38;
    private static final int MAX_FRACTION = 9;
    private static final int MAX_VARCHAR = 4000;

    public OraDomains() {
        this.add((Domain)new BinaryDomain("raw", ConversionPoint.BINARY, 2000L, 2000L, true));
        this.add((Domain)new BinaryDomain("blob", ConversionPoint.BLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BinaryDomain("long raw", ConversionPoint.BLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new BinaryDomain("urowid", ConversionPoint.BINARY_ID, 4000L));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new OraNumber2Domain("number", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new OraNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, 38, 38, true));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, (double)1.4E-45f, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("binary_float", ConversionPoint.SINGLE_PRECISION, (double)1.4E-45f, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FractionDomain("date", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 0, -1, false));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 9, -1, true));
        this.add((Domain)new TextDomain("clob", ConversionPoint.CLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new TextDomain("nclob", ConversionPoint.NTEXT, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new TextDomain("long", ConversionPoint.CLOB, Integer.MAX_VALUE, OperationSupport.SUPPORTS_NOTHING));
        this.add((Domain)new TextDomain("rowid", ConversionPoint.TEXT_ID, 2000L, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 4000L, TextDomain.Length.mandatory((long)4000L)));
        this.add((Domain)new TextDomain("varchar2", ConversionPoint.VARCHAR, 4000L, TextDomain.Length.mandatory((long)4000L)));
        this.add((Domain)new TextDomain("nvarchar2", ConversionPoint.NVARCHAR, 2000L, TextDomain.Length.mandatory((long)2000L)));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 2000L, 1L, true));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 1000L, 1L, true));
        this.add((Domain)new TextDomain("sys.xmltype", ConversionPoint.XML, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("xmltype", ConversionPoint.XML, Integer.MAX_VALUE, OperationSupport.SUPPORTS_LIKE_ONLY));
        this.add((Domain)new UnknownDomain("bfile"));
        this.add((Domain)new UnknownDomain("uritype"));
    }
}

