/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntroQueries;
import com.intellij.database.dialects.mysqlbase.generator.MysqlBaseNamingService;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseEvent;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoot;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseRoutine;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseSchema;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTable;
import com.intellij.database.dialects.mysqlbase.model.MysqlBaseTrigger;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.remote.jdba.core.Layouts;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import java.sql.Timestamp;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001:\rJKLMNOPQRSTUVB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J*\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u000eJ,\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u000eH\u0007J,\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\n0\u000eH\u0007J*\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u000eJ*\u0010!\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\n0\u000eJ*\u0010\"\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010$\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010'\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\n0\u000eJ*\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\n0\u000eJ\u0015\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010-J3\u0010.\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010/2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004\u00a2\u0006\u0002\u00104J\u0018\u00105\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u000206J\u0018\u00107\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u000208J\u0018\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020:J\u0018\u0010;\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020<J\u0018\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010>\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u000201J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010B\u001a\u00020\u0004*\u00020CH\u0002J\u000e\u0010D\u001a\u00020E*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010F\u001a\u00020E*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010G\u001a\u00020E*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010H\u001a\u00020E*\u0004\u0018\u00010\u0006H\u0002J\u000e\u0010I\u001a\u00020E*\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006W"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries;", "Lcom/intellij/database/dialects/base/introspector/BaseIntroQueries;", "()V", "collateIf", "", "r", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoot;", "collateOrLower", "name", "processCollations", "", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "action", "Lkotlin/Function1;", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Collation;", "processColumns", "sc", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseSchema;", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Column;", "processConstraintColumns", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$ConstraintColumn;", "processConstraints", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Constraint;", "processEventSources", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Event;", "processEvents", "processIndices", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$IndexColumn;", "processRoutineParams", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Parameter;", "processRoutineSources", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Routine;", "processRoutines", "processTablesAndViews", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Table;", "processTriggerSources", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Trigger;", "processTriggers", "processUsers", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$User;", "processViews", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$View;", "retrieveCasing", "", "(Lcom/intellij/database/layoutedQueries/DBTransaction;)Ljava/lang/Integer;", "retrieveDefaultEngines", "", "dbms", "Lcom/intellij/database/Dbms;", "engVar", "tmpEngVar", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/Dbms;Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "retrieveOneEventSource", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseEvent;", "retrieveOneRoutineSource", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseRoutine;", "retrieveOneTableSource", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTable;", "retrieveOneTriggerSource", "Lcom/intellij/database/dialects/mysqlbase/model/MysqlBaseTrigger;", "retrieveParametersTableExists", "retrieveSchedulerStatus", "retrieveSchemas", "", "Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Schema;", "fqName", "Lcom/intellij/database/model/basic/BasicNamedElement;", "hasCollate", "", "hasFunctionalIndices", "hasGeneratedExpression", "hasIndexComment", "hasOrderBy", "Collation", "Column", "Constraint", "ConstraintColumn", "Event", "IndexColumn", "Parameter", "Routine", "Schema", "Table", "Trigger", "User", "View", "intellij.database.dialects.mysqlbase"})
public final class MysqlBaseIntroQueries
extends BaseIntroQueries {
    public static final MysqlBaseIntroQueries INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Integer retrieveCasing(@NotNull DBTransaction transaction) {
        void $this$retrieveOne$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String query$iv = "select @@GLOBAL.lower_case_table_names";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (Integer)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, Integer.class, query$iv, parameters$iv);
    }

    @Nullable
    public final String[] retrieveDefaultEngines(@NotNull DBTransaction transaction, @NotNull Dbms dbms, @NotNull String engVar, @NotNull String tmpEngVar) {
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        Intrinsics.checkParameterIsNotNull((Object)engVar, (String)"engVar");
        Intrinsics.checkParameterIsNotNull((Object)tmpEngVar, (String)"tmpEngVar");
        Dbms dbms2 = dbms;
        if (Intrinsics.areEqual((Object)dbms2, (Object)Dbms.MEMSQL)) {
            int n = 2;
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                String string;
                int n3 = n2;
                int n4 = n2++;
                String[] stringArray3 = stringArray2;
                boolean bl = false;
                stringArray3[n4] = string = "MemSQL";
            }
            stringArray = stringArray2;
        } else {
            ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)2, String.class));
            Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(arrayOf(2, String::class.java))");
            stringArray = (String[])BaseIntroQueries.retrieve$default(this, transaction, resultLayout, "select @@" + engVar + ", @@" + tmpEngVar, null, 4, null);
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String retrieveSchedulerStatus(@NotNull DBTransaction transaction, @NotNull Dbms dbms) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        if (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MEMSQL)) {
            string = "ON";
        } else {
            void $this$retrieveOne$iv;
            void this_$iv;
            DBTransaction dBTransaction = transaction;
            BaseIntroQueries baseIntroQueries = this;
            String query$iv = "select @@event_scheduler";
            Object[] parameters$iv = null;
            boolean $i$f$retrieveOne = false;
            string = (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, String.class, query$iv, parameters$iv);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void processCollations(@NotNull DBTransaction transaction, @NotNull MysqlBaseRoot r, @NotNull Function1<? super Collation, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select collation_name, character_set_name,\n          is_default" + this.collateIf(r) + " = 'Yes' as is_default\n        from information_schema.collations\n      ";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Collation.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processUsers(@NotNull DBTransaction transaction, @NotNull MysqlBaseRoot r, @NotNull Function1<? super User, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select grantee from information_schema.user_privileges group by grantee";
        Object[] parameters$iv = null;
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, User.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Schema> retrieveSchemas(@NotNull DBTransaction transaction) {
        void query$iv;
        void $this$retrieveList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select schema_name, default_collation_name\n        from information_schema.schemata\n        order by if(schema() = schema_name, 1, 2), schema_name";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveList = false;
        return BaseIntroQueries.access$retrieveList((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveList$iv, Schema.class, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTablesAndViews(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Table, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select table_name, table_type, table_comment, engine, table_collation\n        from information_schema.tables\n        where table_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Table.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processIndices(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super IndexColumn, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          table_name,\n          index_name,\n          " + (this.hasIndexComment(sc2.getRoot()) ? "" : "null ") + "index_comment,\n          index_type,\n          non_unique,\n          column_name,\n          collation,\n          " + (this.hasFunctionalIndices(sc2.getRoot()) ? "" : "null ") + "expression\n        from information_schema.statistics\n        where table_schema = ? and\n              index_schema = ? and\n              index_name" + this.collateIf(sc2.getRoot()) + " <> 'PRIMARY'\n        order by\n          index_schema,\n          table_name,\n          index_name,\n          seq_in_index\n        ";
        Object[] parameters$iv = new String[]{sc2.getName(), sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, IndexColumn.class, (String)query$iv, parameters$iv, null, action);
    }

    private final String collateIf(MysqlBaseRoot r) {
        return this.hasCollate(r) ? " collate utf8_general_ci" : "";
    }

    private final String collateOrLower(String name2, MysqlBaseRoot r) {
        return this.hasCollate(r) ? name2 + " collate utf8_general_ci" : "lower(" + name2 + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Language(value="SQL")
    public final void processConstraints(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Constraint, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n        c.constraint_name,\n        c.table_name,\n        c.constraint_type,\n        r.match_option,\n        r.update_rule,\n        r.delete_rule\n      from information_schema.table_constraints c\n        left join information_schema.referential_constraints r on\n            r.constraint_schema   = c.constraint_schema\n        and r.constraint_name     = c.constraint_name\n      where c.table_schema = ?\n    ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Constraint.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    @Language(value="SQL")
    public final void processConstraintColumns(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super ConstraintColumn, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n        constraint_name,\n        table_name,\n        column_name,\n        referenced_table_schema,\n        referenced_table_name,\n        referenced_column_name\n      from information_schema.key_column_usage\n      where table_schema = ?\n      order by\n          table_name\n        , constraint_name\n        , ordinal_position\n    ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, ConstraintColumn.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutines(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Routine, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          routine_name,\n          routine_type,\n          routine_definition,\n          routine_comment,\n          dtd_identifier,\n          definer\n        from information_schema.routines\n        where routine_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Routine.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutineSources(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Routine, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select routine_name, routine_definition\n        from information_schema.routines\n        where routine_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Routine.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String retrieveParametersTableExists(@NotNull DBTransaction transaction, @NotNull MysqlBaseRoot r) {
        void query$iv;
        void $this$retrieveOne$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select table_name from information_schema.tables\n        where " + this.collateOrLower("table_schema", r) + " = 'information_schema'\n          and " + this.collateOrLower("table_name", r) + " = 'parameters'";
        Object[] parameters$iv = null;
        boolean $i$f$retrieveOne = false;
        return (String)BaseIntroQueries.access$retrieveOne((BaseIntroQueries)this_$iv, (DBTransaction)$this$retrieveOne$iv, String.class, (String)query$iv, parameters$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void processRoutineParams(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Parameter, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select specific_name,\n        ordinal_position,\n        parameter_name,\n        parameter_mode,\n        dtd_identifier\n      from information_schema.parameters\n      where specific_schema = ? and ordinal_position > 0\n      order by specific_name, ordinal_position\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Parameter.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processColumns(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Column, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n        ordinal_position,\n        column_name,\n        column_type,\n        column_default,\n        " + (this.hasGeneratedExpression(sc2.getRoot()) ? "" : "null ") + "generation_expression,\n        table_name,\n        column_comment,\n        is_nullable,\n        extra,\n        collation_name\n      from information_schema.columns\n      where table_schema = ?\n      order by table_name, ordinal_position\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Column.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processViews(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super View, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select table_name, view_definition, definer\n      from information_schema.views\n      where table_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, View.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTriggers(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Trigger, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          trigger_name,\n          event_object_table,\n          event_manipulation,\n          action_timing,\n          definer\n        from information_schema.triggers\n        where trigger_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Trigger.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processTriggerSources(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Trigger, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          trigger_name,\n          event_object_table,\n          action_statement\n        from information_schema.triggers\n        where trigger_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Trigger.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processEvents(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Event, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          event_name,\n          event_comment,\n          definer,\n          event_type = 'RECURRING' recurring,\n          interval_value,\n          interval_field,\n          cast(coalesce(starts, execute_at) as char) starts,\n          cast(ends as char) ends,\n          status,\n          on_completion = 'PRESERVE' preserve,\n          last_executed\n        from information_schema.events\n        where event_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Event.class, (String)query$iv, parameters$iv, null, action);
    }

    /*
     * WARNING - void declaration
     */
    public final void processEventSources(@NotNull DBTransaction transaction, @NotNull MysqlBaseSchema sc2, @NotNull Function1<? super Event, Unit> action) {
        void query$iv;
        void $this$processList$iv;
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)sc2, (String)"sc");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        DBTransaction dBTransaction = transaction;
        BaseIntroQueries baseIntroQueries = this;
        String string = "select\n          event_name,\n          event_definition\n        from information_schema.events\n        where event_schema = ?\n      ";
        Object[] parameters$iv = new String[]{sc2.getName()};
        boolean $i$f$processList = false;
        BaseIntroQueries.access$processList((BaseIntroQueries)this_$iv, (DBTransaction)$this$processList$iv, Event.class, (String)query$iv, parameters$iv, null, action);
    }

    @Nullable
    public final String retrieveOneRoutineSource(@NotNull DBTransaction transaction, @NotNull MysqlBaseRoutine r) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)6, String.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(arrayOf(6, String::class.java))");
        Object[] objectArray = (String[])BaseIntroQueries.retrieve$default(this, transaction, resultLayout, "show create " + (r.getRoutineKind() == DasRoutine.Kind.FUNCTION ? "function" : "procedure") + ' ' + this.fqName((BasicNamedElement)r), null, 4, null);
        return objectArray != null ? (String)ArraysKt.getOrNull((Object[])objectArray, (int)2) : null;
    }

    @Nullable
    public final String retrieveOneTriggerSource(@NotNull DBTransaction transaction, @NotNull MysqlBaseTrigger r) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)6, String.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(arrayOf(6, String::class.java))");
        Object[] objectArray = (String[])BaseIntroQueries.retrieve$default(this, transaction, resultLayout, "show create trigger " + this.fqName((BasicNamedElement)r), null, 4, null);
        return objectArray != null ? (String)ArraysKt.getOrNull((Object[])objectArray, (int)2) : null;
    }

    @Nullable
    public final String retrieveOneEventSource(@NotNull DBTransaction transaction, @NotNull MysqlBaseEvent r) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)7, String.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(arrayOf(7, String::class.java))");
        Object[] objectArray = (String[])BaseIntroQueries.retrieve$default(this, transaction, resultLayout, "show create event " + this.fqName((BasicNamedElement)r), null, 4, null);
        return objectArray != null ? (String)ArraysKt.getOrNull((Object[])objectArray, (int)3) : null;
    }

    @Nullable
    public final String retrieveOneTableSource(@NotNull DBTransaction transaction, @NotNull MysqlBaseTable r) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        ResultLayout resultLayout = Layouts.rowOf((RowLayout)Layouts.arrayOf((int)2, String.class));
        Intrinsics.checkExpressionValueIsNotNull((Object)resultLayout, (String)"rowOf(arrayOf(2, String::class.java))");
        Object[] objectArray = (String[])BaseIntroQueries.retrieve$default(this, transaction, resultLayout, "show create table " + this.fqName((BasicNamedElement)r), null, 4, null);
        return objectArray != null ? (String)ArraysKt.getOrNull((Object[])objectArray, (int)1) : null;
    }

    private final String fqName(@NotNull BasicNamedElement $this$fqName) {
        StringBuilder stringBuilder = new StringBuilder();
        BasicSchema basicSchema = $this$fqName.getSchema();
        if (basicSchema == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)basicSchema, (String)"schema!!");
        String string = basicSchema.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schema!!.name");
        StringBuilder stringBuilder2 = stringBuilder.append(MysqlBaseNamingService.INSTANCE.enquoteName(string)).append('.');
        String string2 = $this$fqName.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        return stringBuilder2.append(MysqlBaseNamingService.INSTANCE.enquoteName(string2)).toString();
    }

    private final boolean hasCollate(@Nullable MysqlBaseRoot $this$hasCollate) {
        MysqlBaseRoot mysqlBaseRoot = $this$hasCollate;
        return Intrinsics.areEqual((Object)(mysqlBaseRoot != null ? mysqlBaseRoot.getDbms() : null), (Object)Dbms.MEMSQL) ^ true;
    }

    private final boolean hasOrderBy(@Nullable MysqlBaseRoot $this$hasOrderBy) {
        MysqlBaseRoot mysqlBaseRoot = $this$hasOrderBy;
        return Intrinsics.areEqual((Object)(mysqlBaseRoot != null ? mysqlBaseRoot.getDbms() : null), (Object)Dbms.MEMSQL) ^ true;
    }

    private final boolean hasIndexComment(@Nullable MysqlBaseRoot $this$hasIndexComment) {
        MysqlBaseRoot mysqlBaseRoot;
        MysqlBaseRoot mysqlBaseRoot2 = $this$hasIndexComment;
        return Intrinsics.areEqual((Object)(mysqlBaseRoot2 != null ? mysqlBaseRoot2.getDbms() : null), (Object)Dbms.MEMSQL) || ((mysqlBaseRoot = $this$hasIndexComment) != null && (mysqlBaseRoot = mysqlBaseRoot.getServerVersion()) != null ? mysqlBaseRoot.isOrGreater(new int[]{5, 5}) : true);
    }

    private final boolean hasFunctionalIndices(@Nullable MysqlBaseRoot $this$hasFunctionalIndices) {
        MysqlBaseRoot mysqlBaseRoot;
        MysqlBaseRoot mysqlBaseRoot2 = $this$hasFunctionalIndices;
        return Intrinsics.areEqual((Object)(mysqlBaseRoot2 != null ? mysqlBaseRoot2.getDbms() : null), (Object)Dbms.MYSQL) && ((mysqlBaseRoot = $this$hasFunctionalIndices) != null && (mysqlBaseRoot = mysqlBaseRoot.getServerVersion()) != null ? mysqlBaseRoot.isOrGreater(new int[]{8, 0, 13}) : false);
    }

    private final boolean hasGeneratedExpression(@Nullable MysqlBaseRoot $this$hasGeneratedExpression) {
        MysqlBaseRoot mysqlBaseRoot;
        MysqlBaseRoot mysqlBaseRoot2;
        Dbms dbms;
        MysqlBaseRoot mysqlBaseRoot3 = $this$hasGeneratedExpression;
        Object object = dbms = mysqlBaseRoot3 != null ? mysqlBaseRoot3.getDbms() : null;
        return Intrinsics.areEqual((Object)dbms, (Object)Dbms.MEMSQL) ? false : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.MARIA) ? ((mysqlBaseRoot2 = $this$hasGeneratedExpression) != null && (mysqlBaseRoot2 = mysqlBaseRoot2.getServerVersion()) != null ? mysqlBaseRoot2.isOrGreater(new int[]{10, 2, 5}) : true) : ((mysqlBaseRoot = $this$hasGeneratedExpression) != null && (mysqlBaseRoot = mysqlBaseRoot.getServerVersion()) != null ? mysqlBaseRoot.isOrGreater(new int[]{5, 7}) : true));
    }

    private MysqlBaseIntroQueries() {
    }

    static {
        MysqlBaseIntroQueries mysqlBaseIntroQueries;
        INSTANCE = mysqlBaseIntroQueries = new MysqlBaseIntroQueries();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Collation;", "", "()V", "character_set_name", "", "collation_name", "is_default", "", "intellij.database.dialects.mysqlbase"})
    public static final class Collation {
        @JvmField
        @NotNull
        public String collation_name = "";
        @JvmField
        @Nullable
        public String character_set_name;
        @JvmField
        public boolean is_default;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$User;", "", "()V", "grantee", "", "intellij.database.dialects.mysqlbase"})
    public static final class User {
        @JvmField
        @NotNull
        public String grantee = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Schema;", "", "()V", "default_collation_name", "", "schema_name", "intellij.database.dialects.mysqlbase"})
    public static final class Schema {
        @JvmField
        @NotNull
        public String schema_name = "";
        @JvmField
        @Nullable
        public String default_collation_name;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Table;", "", "()V", "engine", "", "table_collation", "table_comment", "table_name", "table_type", "intellij.database.dialects.mysqlbase"})
    public static final class Table {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String table_type = "";
        @JvmField
        @Nullable
        public String table_comment;
        @JvmField
        @Nullable
        public String engine;
        @JvmField
        @Nullable
        public String table_collation;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$IndexColumn;", "", "()V", "collation", "", "column_name", "expression", "index_comment", "index_name", "index_type", "non_unique", "", "table_name", "intellij.database.dialects.mysqlbase"})
    public static final class IndexColumn {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String index_name = "";
        @JvmField
        @Nullable
        public String index_comment;
        @JvmField
        @Nullable
        public String index_type;
        @JvmField
        public boolean non_unique;
        @JvmField
        @Nullable
        public String column_name;
        @JvmField
        @Nullable
        public String expression;
        @JvmField
        @Nullable
        public String collation;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Constraint;", "", "()V", "constraint_name", "", "constraint_type", "delete_rule", "match_option", "table_name", "update_rule", "intellij.database.dialects.mysqlbase"})
    public static final class Constraint {
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String constraint_type = "";
        @JvmField
        @Nullable
        public String match_option;
        @JvmField
        @NotNull
        public String update_rule = "";
        @JvmField
        @NotNull
        public String delete_rule = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$ConstraintColumn;", "", "()V", "column_name", "", "constraint_name", "referenced_column_name", "referenced_table_name", "referenced_table_schema", "table_name", "intellij.database.dialects.mysqlbase"})
    public static final class ConstraintColumn {
        @JvmField
        @NotNull
        public String constraint_name = "";
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        @Nullable
        public String referenced_table_schema;
        @JvmField
        @Nullable
        public String referenced_table_name;
        @JvmField
        @Nullable
        public String referenced_column_name;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Routine;", "", "()V", "definer", "", "dtd_identifier", "routine_comment", "routine_definition", "routine_name", "routine_type", "intellij.database.dialects.mysqlbase"})
    public static final class Routine {
        @JvmField
        @NotNull
        public String routine_name = "";
        @JvmField
        @NotNull
        public String routine_type = "";
        @JvmField
        @Nullable
        public String routine_definition;
        @JvmField
        @Nullable
        public String routine_comment;
        @JvmField
        @NotNull
        public String dtd_identifier = "";
        @JvmField
        @Nullable
        public String definer;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Parameter;", "", "()V", "dtd_identifier", "", "ordinal_position", "", "parameter_mode", "parameter_name", "specific_name", "intellij.database.dialects.mysqlbase"})
    public static final class Parameter {
        @JvmField
        @NotNull
        public String specific_name = "";
        @JvmField
        public short ordinal_position;
        @JvmField
        @NotNull
        public String parameter_name = "";
        @JvmField
        @NotNull
        public String parameter_mode = "";
        @JvmField
        @NotNull
        public String dtd_identifier = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Column;", "", "()V", "collation_name", "", "column_comment", "column_default", "column_name", "column_type", "extra", "generation_expression", "is_nullable", "ordinal_position", "", "table_name", "intellij.database.dialects.mysqlbase"})
    public static final class Column {
        @JvmField
        public short ordinal_position;
        @JvmField
        @NotNull
        public String column_name = "";
        @JvmField
        @NotNull
        public String column_type = "";
        @JvmField
        @Nullable
        public String column_default;
        @JvmField
        @Nullable
        public String generation_expression;
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @Nullable
        public String column_comment;
        @JvmField
        @Nullable
        public String is_nullable;
        @JvmField
        @Nullable
        public String extra;
        @JvmField
        @Nullable
        public String collation_name;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$View;", "", "()V", "definer", "", "table_name", "view_definition", "intellij.database.dialects.mysqlbase"})
    public static final class View {
        @JvmField
        @NotNull
        public String table_name = "";
        @JvmField
        @Nullable
        public String view_definition;
        @JvmField
        @Nullable
        public String definer;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Trigger;", "", "()V", "action_statement", "", "action_timing", "definer", "event_manipulation", "event_object_table", "trigger_name", "intellij.database.dialects.mysqlbase"})
    public static final class Trigger {
        @JvmField
        @NotNull
        public String trigger_name = "";
        @JvmField
        @NotNull
        public String event_manipulation = "";
        @JvmField
        @NotNull
        public String event_object_table = "";
        @JvmField
        @Nullable
        public String action_statement;
        @JvmField
        @Nullable
        public String action_timing;
        @JvmField
        @Nullable
        public String definer;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dialects/mysqlbase/introspector/MysqlBaseIntroQueries$Event;", "", "()V", "definer", "", "ends", "event_comment", "event_definition", "event_name", "interval_field", "interval_value", "last_executed", "Ljava/sql/Timestamp;", "preserve", "", "Ljava/lang/Boolean;", "recurring", "starts", "status", "intellij.database.dialects.mysqlbase"})
    public static final class Event {
        @JvmField
        @NotNull
        public String event_name = "";
        @JvmField
        @Nullable
        public String event_comment;
        @JvmField
        @Nullable
        public String definer;
        @JvmField
        public boolean recurring;
        @JvmField
        @Nullable
        public String interval_value;
        @JvmField
        @Nullable
        public String interval_field;
        @JvmField
        @Nullable
        public String starts;
        @JvmField
        @Nullable
        public String ends;
        @JvmField
        @Nullable
        public String status;
        @JvmField
        @Nullable
        public Boolean preserve;
        @JvmField
        @Nullable
        public Timestamp last_executed;
        @JvmField
        @Nullable
        public String event_definition;
    }
}

