/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dialects.mssql.ui.LocalDbParamEditor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.Consumer;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalDbExecParamEditor
extends ParamEditorBase<JBTextField> {
    public LocalDbExecParamEditor(final @NotNull DataInterchange interchange) {
        if (interchange == null) {
            LocalDbExecParamEditor.$$$reportNull$$$0(0);
        }
        super((JComponent)new JBTextField(), interchange, TypesRegistry.ParamEditor.FieldSize.LARGE, "LocalDB executable:", new AnAction[]{new ParamEditorBase.FMChooseAction(new FileChooserDescriptor(true, false, false, false, false, false).withTitle("Select LocalDB Executable"))});
        this.addButton((AnAction)new DumbAwareAction("Refresh", "Rediscover LocalDB.exe location", AllIcons.Actions.Refresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                LocalDbExecParamEditor.this.updateLocalDBPath();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor$1", "actionPerformed"));
            }
        });
        interchange.addPersistentProperty("LOCAL_DB_EXECUTABLE");
        ((JBTextField)this.getEditorComponent()).addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                interchange.putProperty("LOCAL_DB_EXECUTABLE", StringUtil.nullize((String)((JBTextField)LocalDbExecParamEditor.this.getEditorComponent()).getText()));
            }
        });
        ((JBTextField)this.getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!((JBTextField)LocalDbExecParamEditor.this.getEditorComponent()).isFocusOwner()) {
                    interchange.putProperty("LOCAL_DB_EXECUTABLE", StringUtil.nullize((String)((JBTextField)LocalDbExecParamEditor.this.getEditorComponent()).getText()));
                }
                LocalDbExecParamEditor.this.fireChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor$3", "textChanged"));
            }
        });
        interchange.addPropertyChangeListener("LOCAL_DB_EXECUTABLE", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!((JBTextField)LocalDbExecParamEditor.this.getEditorComponent()).getText().equals(evt.getNewValue())) {
                    ((JBTextField)LocalDbExecParamEditor.this.getEditorComponent()).setText(StringUtil.notNullize((String)((String)evt.getNewValue())));
                }
            }
        }, (Disposable)this);
        this.updateLocalDBPath();
    }

    void updateLocalDBPath() {
        String val = this.getInterchange().getProperty("LOCAL_DB_EXECUTABLE");
        boolean newVal = false;
        if (StringUtil.isEmpty((String)val)) {
            val = LocalDbExecParamEditor.detectLocalDB();
            boolean bl = newVal = !StringUtil.isEmpty((String)val);
        }
        if (newVal) {
            this.getInterchange().putProperty("LOCAL_DB_EXECUTABLE", val);
        } else {
            this.getInterchange().forceUpdateProperty("LOCAL_DB_EXECUTABLE");
        }
    }

    @Nullable
    public static String detectLocalDB() {
        if (SystemInfo.isWindows) {
            String LOCAL_DB_ROOT = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server";
            for (String ver : WindowsRegistryUtil.readRegistryBranch((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server")) {
                File file;
                String path = WindowsRegistryUtil.readRegistryValue((String)("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Microsoft SQL Server\\" + ver + "\\Tools\\ClientSetup"), (String)"Path");
                if (path == null || !(file = new File(path, "SqlLocalDB.exe")).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = ((JBTextField)this.getEditorComponent()).getText();
        if (string == null) {
            LocalDbExecParamEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void setText(@NotNull String text) {
        if (text == null) {
            LocalDbExecParamEditor.$$$reportNull$$$0(2);
        }
        ((JBTextField)this.getEditorComponent()).setText(StringUtil.nullize((String)text));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interchange";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Factory
    implements TypesRegistry.TypeDescriptorFactory {
        Factory() {
        }

        public void createTypeDescriptor(@NotNull Consumer<? super TypesRegistry.TypeDescriptor> consumer) {
            if (consumer == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer.consume((Object)new TypesRegistry.BaseTypeDescriptor("localdb_pipe", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+#\\p{XDigit}+|" + Pattern.quote("<pipe name>"), "Instance"){

                @NotNull
                protected TypesRegistry.ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new LocalDbParamEditor(1.formatFieldCaption((String)caption), interchange);
                }

                @NotNull
                public Collection<TypesRegistry.ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
                    if (interchange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    List<LocalDbExecParamEditor> list = Collections.singletonList(new LocalDbExecParamEditor(interchange));
                    if (list == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "caption";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "interchange";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor$Factory$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor$Factory$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "createSatellites";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "createFieldImpl";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "createSatellites";
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/mssql/ui/LocalDbExecParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

