/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.model;

import com.intellij.database.dialects.mssql.model.MsAliasType;
import com.intellij.database.dialects.mssql.model.MsObjectEditorFactory;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTableType;
import com.intellij.database.dialects.mssql.model.MsTableTypeColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.DbObjectEditorFactory;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/mssql/model/MsModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "getObjectEditorFactory", "Lcom/intellij/database/schemaEditor/DbObjectEditorFactory;", "mustParticipateInInsert", "", "column", "Lcom/intellij/database/model/DasColumn;", "intellij.database.dialects.mssql"})
public final class MsModelHelper
extends ModelHelper {
    public boolean mustParticipateInInsert(@NotNull DasColumn column2) {
        Intrinsics.checkParameterIsNotNull((Object)column2, (String)"column");
        return (!(column2 instanceof MsStoredColumn) || !((MsStoredColumn)column2).isHidden()) && super.mustParticipateInInsert(column2);
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars);
        if (e instanceof MsTrigger) {
            vars.put("turn", "for");
        }
        if (e instanceof MsAliasType) {
            ((MsAliasType)e).setDataType(DataTypeFactory.of((String)"varchar"));
            vars.put("target_type", "varchar");
        }
        if (e instanceof MsTableType) {
            MsTableTypeColumn col = (MsTableTypeColumn)((MsTableType)e).getColumns().createNewOne();
            this.setTemplateName(col, "type_column");
            MsTableTypeColumn msTableTypeColumn = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)msTableTypeColumn, (String)"col");
            msTableTypeColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("type_columns", "type_column int");
        }
    }

    @NotNull
    public DbObjectEditorFactory getObjectEditorFactory() {
        return MsObjectEditorFactory.INSTANCE;
    }
}

