/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.mssql.TsqlDefinitionProviderBase;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.util.PairConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsDefinitionProvider
extends TsqlDefinitionProviderBase {
    public boolean isSupported(@NotNull DasObject object) {
        ObjectKind kind;
        if (object == null) {
            MsDefinitionProvider.$$$reportNull$$$0(0);
        }
        return (kind = object.getKind()) == ObjectKind.VIEW || kind == ObjectKind.ROUTINE || kind == ObjectKind.TRIGGER;
    }

    protected void fetchSources(@NotNull Iterable<? extends DasObject> objects, @NotNull DatabaseConnection connection, @NotNull PairConsumer<DasObject, Object> consumer) {
        if (objects == null) {
            MsDefinitionProvider.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            MsDefinitionProvider.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            MsDefinitionProvider.$$$reportNull$$$0(3);
        }
        try (ReusableSmartStatement statement = SmartStatements.poweredBy((DatabaseConnection)connection).parameterized().reuse("select object_definition(object_id(?))");){
            NamingService namingService = NamingServices.getNamingService((Dbms)Dbms.MSSQL);
            for (DasObject dasObject : objects) {
                String name2 = namingService.enquoteName(DasUtil.getSchema((DasObject)dasObject)) + "." + namingService.enquoteName(dasObject.getName());
                ParameterizedStatementDecoration data = new StatementParameters().text(name2).asDecoration();
                consumer.consume((Object)dasObject, statement.execute((Object)data, StandardResultsProcessors.FIRST_STRING).any());
            }
        }
    }

    @Override
    @Nullable
    protected String getCurrentDb(@NotNull DatabaseConnection connection) throws SQLException {
        DatabaseDialectEx dialect;
        ObjectPath current;
        if (connection == null) {
            MsDefinitionProvider.$$$reportNull$$$0(4);
        }
        return (current = SearchPath.getCurrent((SearchPath)(dialect = DbImplUtil.getDatabaseDialect((Dbms)Dbms.MSSQL)).tryToLoadSearchPath((DasDataSource)connection.getConnectionPoint().getDataSource(), connection))) == null ? null : current.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/MsDefinitionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSupported";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentDb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

