/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.ColumnRef;
import com.intellij.database.data.types.PredicateValue;
import com.intellij.database.data.types.PredicatesHelper;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.dialects.mongo.MongoDmlGenerator;
import com.intellij.database.dialects.mongo.MongoDmlGenerator$WhenMappings;
import com.intellij.database.dialects.mongo.MongoScriptUtilKt;
import com.intellij.database.model.DasTable;
import com.intellij.database.script.generator.dml.ColumnRefs;
import com.intellij.database.script.generator.dml.ColumnsOrderBy;
import com.intellij.database.script.generator.dml.CountAll;
import com.intellij.database.script.generator.dml.DmlGenerator;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlTaskWithTable;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.OrderBy;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.QueryColumns;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JP\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2 \u0010$\u001a\u001c\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u0016\u0018\u00010%j\u0004\u0018\u0001`(H\u0002J\u001e\u0010)\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020&0\u001fH\u0002J,\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006."}, d2={"Lcom/intellij/database/dialects/mongo/MongoDmlGenerator;", "Lcom/intellij/database/script/generator/dml/DmlGenerator;", "dbms", "Lcom/intellij/database/Dbms;", "(Lcom/intellij/database/Dbms;)V", "emptyWhereClause", "", "getEmptyWhereClause", "()Ljava/lang/String;", "countDocuments", "Lcom/intellij/database/script/generator/dml/DmlGenerator$Companion$Result;", "builder", "Lcom/intellij/database/util/DdlBuilder;", "query", "dbCollection", "collectionName", "generate", "task", "Lcom/intellij/database/script/generator/dml/DmlTask;", "generateSelect", "Lcom/intellij/database/script/generator/dml/SelectTask;", "produce", "", "orderBy", "Lcom/intellij/database/script/generator/dml/ColumnsOrderBy;", "Lcom/intellij/database/script/generator/dml/OrderBy;", "whereClause", "Lcom/intellij/database/script/generator/dml/PlainWhereClause;", "Lcom/intellij/database/script/generator/dml/ValuesWhereClause;", "Lcom/intellij/database/script/generator/dml/WhereClause;", "predicates", "", "Lcom/intellij/database/data/types/PredicatesHelper$PredicateProducer;", "op", "insertNewLines", "", "processor", "Lkotlin/Function2;", "Lcom/intellij/database/data/types/ColumnRef;", "Lcom/intellij/database/data/types/PredicateValue;", "Lcom/intellij/database/script/generator/dml/ColumnValueConsumer;", "selectColumns", "columns", "wrap", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.dialects.mongo"})
public final class MongoDmlGenerator
implements DmlGenerator {
    @NotNull
    private final String emptyWhereClause = "{}";
    private final Dbms dbms;

    @NotNull
    public String getEmptyWhereClause() {
        return this.emptyWhereClause;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DmlTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        DmlTask dmlTask = task;
        if (!(dmlTask instanceof SelectTask)) {
            throw (Throwable)new UnsupportedOperationException("Task " + task + " is unsupported");
        }
        return this.generateSelect(builder, (SelectTask)task);
    }

    private final DdlBuilder generateSelect(DdlBuilder builder, SelectTask task) {
        block4: {
            if (task.getTable() == null) {
                return builder;
            }
            DasTable dasTable = task.getTable();
            if (dasTable == null) {
                Intrinsics.throwNpe();
            }
            String string = dasTable.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"task.table!!.name");
            DdlBuilder ddlBuilder = this.dbCollection(builder, string).symbol(".").plain("find");
            Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"dbCollection(builder, ta\u2026symbol(\".\").plain(\"find\")");
            MongoScriptUtilKt.inParenth(ddlBuilder, (Function0<Unit>)((Function0)new Function0<Unit>(this, task, builder){
                final /* synthetic */ MongoDmlGenerator this$0;
                final /* synthetic */ SelectTask $task;
                final /* synthetic */ DdlBuilder $builder;

                public final void invoke() {
                    this.this$0.produce(this.$task.getWhereClause(), this.$builder, (DmlTask)this.$task);
                    QueryColumns columns = this.$task.getColumns();
                    if (columns instanceof ColumnRefs) {
                        Collection collection = ((ColumnRefs)columns).getColumns();
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            MongoDmlGenerator.access$selectColumns(this.this$0, this.$builder, ((ColumnRefs)columns).getColumns());
                        }
                    }
                }
                {
                    this.this$0 = mongoDmlGenerator;
                    this.$task = selectTask;
                    this.$builder = ddlBuilder;
                    super(0);
                }
            }));
            if (task.getLimit() > 0) {
                DdlBuilder ddlBuilder2 = builder.symbol(".").plain("limit");
                Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder2, (String)"builder.symbol(\".\").plain(\"limit\")");
                MongoScriptUtilKt.inParenth(ddlBuilder2, (Function0<Unit>)((Function0)new Function0<Unit>(builder, task){
                    final /* synthetic */ DdlBuilder $builder;
                    final /* synthetic */ SelectTask $task;

                    public final void invoke() {
                        this.$builder.number(this.$task.getLimit());
                    }
                    {
                        this.$builder = ddlBuilder;
                        this.$task = selectTask;
                        super(0);
                    }
                }));
            }
            if (task.getOffset() > 0) {
                DdlBuilder ddlBuilder3 = builder.symbol(".").plain("skip");
                Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder3, (String)"builder.symbol(\".\").plain(\"skip\")");
                MongoScriptUtilKt.inParenth(ddlBuilder3, (Function0<Unit>)((Function0)new Function0<Unit>(builder, task){
                    final /* synthetic */ DdlBuilder $builder;
                    final /* synthetic */ SelectTask $task;

                    public final void invoke() {
                        this.$builder.number(this.$task.getOffset());
                    }
                    {
                        this.$builder = ddlBuilder;
                        this.$task = selectTask;
                        super(0);
                    }
                }));
            }
            OrderBy orderBy = task.getOrderBy();
            if (orderBy == null) break block4;
            OrderBy orderBy2 = orderBy;
            boolean bl = false;
            boolean bl2 = false;
            OrderBy it = orderBy2;
            boolean bl3 = false;
            this.produce(it, builder);
        }
        return builder;
    }

    public void produce(@Nullable WhereClause whereClause, @NotNull DdlBuilder builder, @NotNull DmlTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        WhereClause whereClause2 = whereClause;
        if (whereClause2 instanceof ValuesWhereClause) {
            this.produce((ValuesWhereClause)whereClause, builder, task);
        } else if (whereClause2 instanceof PlainWhereClause) {
            this.produce((PlainWhereClause)whereClause, builder);
        } else if (whereClause2 instanceof PredicatesWhereClause) {
            List list = ((PredicatesWhereClause)whereClause).getPredicates();
            String string = ((PredicatesWhereClause)whereClause).getOp();
            DmlTask dmlTask = task;
            if (!(dmlTask instanceof DmlTaskWithTable)) {
                dmlTask = null;
            }
            DmlTaskWithTable dmlTaskWithTable = (DmlTaskWithTable)dmlTask;
            this.produce(builder, list, string, dmlTaskWithTable != null ? dmlTaskWithTable.getInsertNewLines() : false, (Function2<? super ColumnRef, ? super PredicateValue, Unit>)((PredicatesWhereClause)whereClause).getProcessor());
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)builder.symbol("{}"), (String)"builder.symbol(\"{}\")");
        }
    }

    private final void produce(PlainWhereClause whereClause, DdlBuilder builder) {
        if (!StringsKt.isBlank((CharSequence)whereClause.getFilter())) {
            builder.plain(whereClause.getFilter());
        }
    }

    private final void produce(ValuesWhereClause whereClause, DdlBuilder builder, DmlTask task) {
        if (!(task instanceof DmlTaskWithTable)) {
            return;
        }
        List predicates = whereClause.getPredicates(this.dbms, ((DmlTaskWithTable)task).getAlias(), ((DmlTaskWithTable)task).getSystem(), DmlTaskKt.isUpdate((DmlTask)task));
        this.produce(builder, predicates, whereClause.getOp(), ((DmlTaskWithTable)task).getInsertNewLines(), (Function2<? super ColumnRef, ? super PredicateValue, Unit>)whereClause.getProcessor());
    }

    private final void produce(DdlBuilder builder, List<PredicatesHelper.PredicateProducer> predicates, String op, boolean insertNewLines, Function2<? super ColumnRef, ? super PredicateValue, Unit> processor) {
        boolean newLines = insertNewLines && predicates.size() > 1;
        MongoScriptUtilKt.inCurly$default(builder, false, newLines, (Function0)new Function0<Unit>(predicates, op, builder, newLines, processor){
            final /* synthetic */ List $predicates;
            final /* synthetic */ String $op;
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ boolean $newLines;
            final /* synthetic */ Function2 $processor;

            public final void invoke() {
                boolean isOr;
                if (this.$predicates.isEmpty()) {
                    return;
                }
                boolean bl = isOr = Intrinsics.areEqual((Object)this.$op, (Object)"OR") && this.$predicates.size() > 1;
                if (isOr) {
                    this.$builder.plain("$or").symbol(":").space();
                }
                MongoScriptUtilKt.inBrackets(this.$builder, isOr, this.$newLines, (Function0<Unit>)((Function0)new Function0<Unit>(this, isOr){
                    final /* synthetic */ produce.1 this$0;
                    final /* synthetic */ boolean $isOr;

                    public final void invoke() {
                        boolean first2 = true;
                        for (PredicatesHelper.PredicateProducer predicate : this.this$0.$predicates) {
                            if (first2) {
                                first2 = false;
                            } else {
                                DdlBuilder ddlBuilder = this.this$0.$builder.symbol(",");
                                Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder.symbol(\",\")");
                                DmlUtilKt.space((DdlBuilder)ddlBuilder, (boolean)this.this$0.$newLines);
                            }
                            if (this.this$0.$processor != null) {
                                Iterable $this$forEach$iv = predicate.getColumnRefs();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ColumnRef it = (ColumnRef)element$iv;
                                    boolean bl = false;
                                    this.this$0.$processor.invoke((Object)it, (Object)predicate.getValue());
                                }
                            }
                            MongoScriptUtilKt.inCurly$default(this.this$0.$builder, this.$isOr, false, (Function0)new Function0<Unit>(this, predicate){
                                final /* synthetic */ produce.1 this$0;
                                final /* synthetic */ PredicatesHelper.PredicateProducer $predicate;

                                public final void invoke() {
                                    this.$predicate.getProduce().invoke((Object)this.this$0.this$0.$builder);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$predicate = predicateProducer;
                                    super(0);
                                }
                            }, 2, null);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$isOr = bl;
                        super(0);
                    }
                }));
            }
            {
                this.$predicates = list;
                this.$op = string;
                this.$builder = ddlBuilder;
                this.$newLines = bl;
                this.$processor = function2;
                super(0);
            }
        }, 1, null);
    }

    private final void produce(OrderBy orderBy, DdlBuilder builder) {
        block0: {
            OrderBy orderBy2 = orderBy;
            if (!(orderBy2 instanceof ColumnsOrderBy)) break block0;
            this.produce((ColumnsOrderBy)orderBy, builder);
        }
    }

    private final void selectColumns(DdlBuilder builder, List<? extends ColumnRef> columns) {
        builder.symbol(",").space();
        MongoScriptUtilKt.inCurly$default(builder, false, false, (Function0)new Function0<Unit>(this, columns, builder){
            final /* synthetic */ MongoDmlGenerator this$0;
            final /* synthetic */ List $columns;
            final /* synthetic */ DdlBuilder $builder;

            public final void invoke() {
                boolean bl;
                boolean first2;
                block8: {
                    first2 = true;
                    for (ColumnRef column2 : this.$columns) {
                        if (first2) {
                            first2 = false;
                        } else {
                            Intrinsics.checkExpressionValueIsNotNull((Object)this.$builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
                        }
                        this.$builder.literal(DbImplUtil.StringLiteralDecorator.PLAIN.decorate(column2.getName(), MongoDmlGenerator.access$getDbms$p(this.this$0))).symbol(":").space().number(1);
                    }
                    Iterable $this$any$iv = this.$columns;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            ColumnRef it = (ColumnRef)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)"_id", (Object)it.getName())) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    if (!first2) {
                        this.$builder.symbol(",").space();
                    }
                    this.$builder.literal("'_id'").symbol(":").space().number(0);
                }
            }
            {
                this.this$0 = mongoDmlGenerator;
                this.$columns = list;
                this.$builder = ddlBuilder;
                super(0);
            }
        }, 3, null);
    }

    private final void produce(ColumnsOrderBy orderBy, DdlBuilder builder) {
        builder.symbol(".").plain("sort");
        MongoScriptUtilKt.inParenth(builder, (Function0<Unit>)((Function0)new Function0<Unit>(this, builder, orderBy){
            final /* synthetic */ MongoDmlGenerator this$0;
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ ColumnsOrderBy $orderBy;

            public final void invoke() {
                MongoScriptUtilKt.inCurly$default(this.$builder, false, false, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ produce.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        boolean first2 = true;
                        Iterable $this$forEach$iv = this.this$0.$orderBy.getColumns();
                        boolean $i$f$forEach = false;
                        block4: for (T element$iv : $this$forEach$iv) {
                            void name2;
                            int n;
                            Pair $dstr$name$sortOrder = (Pair)element$iv;
                            boolean bl = false;
                            String string = (String)$dstr$name$sortOrder.component1();
                            RowSortOrder.Type sortOrder = (RowSortOrder.Type)$dstr$name$sortOrder.component2();
                            switch (MongoDmlGenerator$WhenMappings.$EnumSwitchMapping$0[sortOrder.ordinal()]) {
                                case 1: {
                                    n = 1;
                                    break;
                                }
                                case 2: {
                                    n = -1;
                                    break;
                                }
                                default: {
                                    continue block4;
                                }
                            }
                            int order = n;
                            if (first2) {
                                first2 = false;
                            } else {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.$builder.symbol(",").space(), (String)"builder.symbol(\",\").space()");
                            }
                            this.this$0.$builder.literal(DbImplUtil.StringLiteralDecorator.PLAIN.decorate((String)name2, MongoDmlGenerator.access$getDbms$p(this.this$0.this$0))).symbol(":").space().number(order);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 3, null);
            }
            {
                this.this$0 = mongoDmlGenerator;
                this.$builder = ddlBuilder;
                this.$orderBy = columnsOrderBy;
                super(0);
            }
        }));
    }

    private final DdlBuilder dbCollection(DdlBuilder builder, String collectionName) {
        DdlBuilder ddlBuilder = builder.plain("db").symbol(".").plain("getCollection");
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder.plain(\"db\").symb\u2026\").plain(\"getCollection\")");
        return MongoScriptUtilKt.inParenth(ddlBuilder, (Function0<Unit>)((Function0)new Function0<Unit>(this, builder, collectionName){
            final /* synthetic */ MongoDmlGenerator this$0;
            final /* synthetic */ DdlBuilder $builder;
            final /* synthetic */ String $collectionName;

            public final void invoke() {
                this.$builder.literal(DbImplUtil.StringLiteralDecorator.PLAIN.decorate(this.$collectionName, MongoDmlGenerator.access$getDbms$p(this.this$0)));
            }
            {
                this.this$0 = mongoDmlGenerator;
                this.$builder = ddlBuilder;
                this.$collectionName = string;
                super(0);
            }
        }));
    }

    @Nullable
    public DmlGenerator.Companion.Result wrap(@NotNull DdlBuilder builder, @Nullable String query, @NotNull Project project, @NotNull DmlTask task) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)task, (String)"task");
        if (query == null) {
            return null;
        }
        return task instanceof SelectTask && Intrinsics.areEqual((Object)((SelectTask)task).getColumns(), (Object)CountAll.INSTANCE) ? this.countDocuments(builder, query) : null;
    }

    private final DmlGenerator.Companion.Result countDocuments(DdlBuilder builder, String query) {
        if (!StringsKt.contains$default((CharSequence)query, (CharSequence)".find(", (boolean)false, (int)2, null)) {
            return null;
        }
        String newQuery = StringsKt.replace$default((String)query, (String)".find(", (String)".count(", (boolean)false, (int)4, null);
        builder.plain(newQuery);
        return (DmlGenerator.Companion.Result)new DmlGenerator.Companion.SimpleResult(builder);
    }

    public MongoDmlGenerator(@NotNull Dbms dbms) {
        Intrinsics.checkParameterIsNotNull((Object)dbms, (String)"dbms");
        this.dbms = dbms;
        this.emptyWhereClause = "{}";
    }

    public static final /* synthetic */ void access$selectColumns(MongoDmlGenerator $this, DdlBuilder builder, List columns) {
        $this.selectColumns(builder, columns);
    }

    public static final /* synthetic */ Dbms access$getDbms$p(MongoDmlGenerator $this) {
        return $this.dbms;
    }
}

