/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.domain.TextLikeDomain;

public class HiveDomains
extends DomainRegistry {
    private static final int VARCHAR_MAX_LENGTH = 65535;
    private static final int CHAR_MAX_LENGTH = 255;
    private static final int DECIMAL_MAX_SCALE = 38;
    private static final int DECIMAL_MAX_PRECISION = 38;

    public HiveDomains() {
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, (double)1.4E-45f, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, Double.MIN_VALUE, Double.MAX_VALUE));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.NUMBER, 38, 38, true));
        this.add((Domain)new Number2Domain("numeric", ConversionPoint.NUMBER, 38, 38, true));
        this.add((Domain)new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, Integer.MAX_VALUE));
        this.add((Domain)new FractionDomain("timestamp with local time zone", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, Integer.MAX_VALUE));
        this.add((Domain)new FractionDomain("timestamplocaltz", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, Integer.MAX_VALUE));
        this.add((Domain)new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add((Domain)new TextLikeDomain("interval_year_month", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new TextLikeDomain("interval_day_time", ConversionPoint.INTERVAL, PhysicalDomainType.UNKNOWN));
        this.add((Domain)new TextDomain("string", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 65535L, TextDomain.Length.mandatory((long)65535L)));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 255L, TextDomain.Length.mandatory((long)255L)));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add((Domain)new BinaryDomain("binary", ConversionPoint.VARBINARY, Integer.MAX_VALUE));
    }
}

