/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.greenplum.model;

import com.intellij.database.dialects.base.generator.ScriptGeneratorHelperKt;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTable;
import com.intellij.database.dialects.greenplum.model.GPlumExternalTableColumn;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.GPlumExternalTableFormat;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dialects/greenplum/model/GPlumModelHelper;", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.greenplum"})
public final class GPlumModelHelper
extends PgGPlumBaseModelHelper {
    public static final GPlumModelHelper INSTANCE;

    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            string = "EXTERNAL TABLE";
        } else {
            String string2 = super.getName(kind);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getName(kind)");
        }
        return string;
    }

    @Override
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars);
        if (e instanceof GPlumExternalTable) {
            GPlumExternalTableColumn col = (GPlumExternalTableColumn)((GPlumExternalTable)e).getColumns().createNewOne();
            this.setTemplateName((BasicModNamedElement)col, "col");
            GPlumExternalTableColumn gPlumExternalTableColumn = col;
            Intrinsics.checkExpressionValueIsNotNull((Object)gPlumExternalTableColumn, (String)"col");
            gPlumExternalTableColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("cols", "col int");
            ((GPlumExternalTable)e).setFormat(GPlumExternalTableFormat.PARQUET);
            String string = StringUtil.toLowerCase((String)GPlumExternalTableFormat.PARQUET.name());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.toLowerCase(G\u2026TableFormat.PARQUET.name)");
            vars.put("format", ScriptGeneratorHelperKt.getSqlString(string));
        }
    }

    private GPlumModelHelper() {
    }

    static {
        GPlumModelHelper gPlumModelHelper;
        INSTANCE = gPlumModelHelper = new GPlumModelHelper();
    }
}

