/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaModelHelper$WhenMappings;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaUser;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.ExaScriptType;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\nH\u0016J\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "", "vars", "", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getIcon", "Ljavax/swing/Icon;", "o", "Lcom/intellij/database/model/DasObject;", "getName", "kind", "Lcom/intellij/database/model/ObjectKind;", "intellij.database.dialects.exasol"})
public final class ExaModelHelper
extends ModelHelper {
    @NotNull
    public String getName(@NotNull ObjectKind kind) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        ObjectKind objectKind = kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.EXTERNAL_SCHEMA)) {
            string = "VIRTUAL SCHEMA";
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.FOREIGN_TABLE)) {
            string = "TABLE";
        } else {
            String string2 = super.getName(kind);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"super.getName(kind)");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public Icon getIcon(@NotNull DasObject o) {
        Icon icon;
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        DasObject dasObject = o;
        if (!(dasObject instanceof ExaScript)) {
            dasObject = null;
        }
        ExaScript exaScript = (ExaScript)dasObject;
        Object object = exaScript != null ? exaScript.getScriptType() : null;
        if (object != null) {
            switch (ExaModelHelper$WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
                case 1: {
                    icon = DatabaseIcons.Udf_script;
                    return icon;
                }
                case 2: {
                    icon = DatabaseIcons.Adapter_script;
                    return icon;
                }
                case 3: {
                    icon = DatabaseIcons.Scripting_script;
                    return icon;
                }
            }
        }
        icon = super.getIcon(o);
        return icon;
    }

    @NotNull
    public JBIterable<String> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkParameterIsNotNull(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)"Function");
            jBIterable = jBIterable2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"JBIterable.of(\"Function\")");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.SCRIPT)) {
            JBIterable jBIterable3 = JBIterable.of((Object[])new String[]{"Scripting Script", "UDF Script", "Adapter Script"});
            jBIterable = jBIterable3;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable3, (String)"JBIterable.of(\"Scripting\u2026cript\", \"Adapter Script\")");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable4, (String)"super.generationVariants(meta)");
        }
        return jBIterable;
    }

    /*
     * Unable to fully structure code
     */
    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull String variant, @NotNull Map<String, String> vars) {
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
            Intrinsics.checkParameterIsNotNull(vars, (String)"vars");
            super.fillPropertiesWithExamples(e, variant, vars);
            if (e instanceof ExaUser) {
                password = "new_password";
                ((ExaUser)e).setPassword(password);
                vars.put("password", password);
            }
            if (e instanceof ExaScript) {
                var4_4 = variant;
                switch (var4_4.hashCode()) {
                    case 372536724: {
                        if (!var4_4.equals("UDF Script")) ** break;
                        break;
                    }
                    case 897304316: {
                        if (!var4_4.equals("Adapter Script")) ** break;
                        ((ExaScript)e).setScriptType(ExaScriptType.ADAPTER);
                        break block7;
                    }
                }
                ((ExaScript)e).setScriptType(ExaScriptType.UDF);
                v0 = ((ExaScript)e).createOrGetReturnArgument();
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"e.createOrGetReturnArgument()");
                v0.setDataType(DataTypeFactory.of((String)"varchar"));
                vars.put("scalar", "scalar");
                vars.put("return", "varchar");
                break block7;
                ((ExaScript)e).setScriptType(ExaScriptType.SCRIPTING);
                vars.put("args", "arg1");
                vars.put("return", "table");
            }
        }
        if (e instanceof ExaVirtualSchema) {
            ((ExaVirtualSchema)e).setAdapterSchema("MY_SCHEMA");
            ((ExaVirtualSchema)e).setAdapterName("MY_ADAPTER");
            vars.put("adapter", "MY_SCHEMA.MY_ADAPTER");
        }
    }
}

