/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.exasol.model;

import com.intellij.database.dialects.exasol.model.ExaDescriptionService;
import com.intellij.database.dialects.exasol.model.ExaScript;
import com.intellij.database.dialects.exasol.model.ExaVirtualSchema;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dialects/exasol/model/ExaDescriptionService;", "Lcom/intellij/database/model/DescriptionService;", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeExaScript", "r", "Lcom/intellij/database/dialects/exasol/model/ExaScript;", "describeExaVirtualSchema", "s", "Lcom/intellij/database/dialects/exasol/model/ExaVirtualSchema;", "intellij.database.dialects.exasol"})
public final class ExaDescriptionService
extends DescriptionService {
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof ExaScript ? this.describeExaScript((ExaScript)e) : (basicElement instanceof ExaVirtualSchema ? this.describeExaVirtualSchema((ExaVirtualSchema)e) : super.content(e, context));
    }

    private final String describeExaScript(ExaScript r) {
        return "script " + StringUtil.toLowerCase((String)String.valueOf(r.getScriptType()));
    }

    private final String describeExaVirtualSchema(ExaVirtualSchema s) {
        StringBuilder stringBuilder = new StringBuilder().append("vschema using ").append(s.getAdapterSchema()).append('.').append(s.getAdapterName()).append(" props {");
        List<NameValue> list = s.getProperties();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"s.properties");
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)describeExaVirtualSchema.1.INSTANCE, (int)30, null)).toString();
    }
}

